/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.FwNetworkServiceGroup;
import com.sygate.scm.common.configobject.schema.FwProtocolContainer;
import com.sygate.scm.common.configobject.schema.RawEthernet;
import com.sygate.scm.common.configobject.schema.RawIcmp;
import com.sygate.scm.common.configobject.schema.RawIcmpv6;
import com.sygate.scm.common.configobject.schema.RawIp;
import com.sygate.scm.common.configobject.schema.RawTcp;
import com.sygate.scm.common.configobject.schema.RawUdp;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.firewall.logicobject.LabelObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.Utility;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ImageIcon;

public class ProtocolContainerObject
implements TableRow,
Comparable<ProtocolContainerObject>,
LabelObject {
    private static final long SYS_OBJ_ATTRIBUTE_MASK = 1L;
    protected FwProtocolContainer protocolContainer;
    private FwNetworkServiceGroup serviceGroup;
    private String type = "Custom";
    private boolean isReadOnly = false;

    public ProtocolContainerObject(FwProtocolContainer container) {
        this.protocolContainer = container;
    }

    public ProtocolContainerObject(FwProtocolContainer container, FwNetworkServiceGroup serviceGroup) {
        this.protocolContainer = container;
        this.serviceGroup = serviceGroup;
        if (this.isSystemType()) {
            this.type = "System";
        } else if (serviceGroup != null) {
            this.type = "Library";
        }
    }

    public ProtocolContainerObject() {
        this.protocolContainer = new FwProtocolContainer();
        this.protocolContainer.setOptContainerName("Custom");
    }

    public void addProtocolObject(ProtocolObject newObject) {
        this.addNewProtocolObject(newObject);
    }

    public void deleteProtocolObject(ProtocolObject newObject) {
        Object protocol = newObject.getProtocol();
        if (protocol instanceof RawTcp) {
            this.protocolContainer.removeRawTcp((RawTcp)protocol);
        } else if (protocol instanceof RawIp) {
            this.protocolContainer.removeRawIp((RawIp)protocol);
        } else if (protocol instanceof RawEthernet) {
            this.protocolContainer.removeRawEthernet((RawEthernet)protocol);
        } else if (protocol instanceof RawIcmp) {
            this.protocolContainer.removeRawIcmp((RawIcmp)protocol);
        } else if (protocol instanceof RawIcmpv6) {
            this.protocolContainer.removeRawIcmpv6((RawIcmpv6)protocol);
        } else if (protocol instanceof RawUdp) {
            this.protocolContainer.removeRawUdp((RawUdp)protocol);
        }
    }

    public void addNewProtocolObject(ProtocolObject newObject) {
        Object protocol = newObject.getProtocol();
        if (protocol instanceof RawTcp) {
            this.protocolContainer.addRawTcp((RawTcp)protocol);
        } else if (protocol instanceof RawIp) {
            this.protocolContainer.addRawIp((RawIp)protocol);
        } else if (protocol instanceof RawEthernet) {
            this.protocolContainer.addRawEthernet((RawEthernet)protocol);
        } else if (protocol instanceof RawIcmp) {
            this.protocolContainer.addRawIcmp((RawIcmp)protocol);
        } else if (protocol instanceof RawIcmpv6) {
            this.protocolContainer.addRawIcmpv6((RawIcmpv6)protocol);
        } else if (protocol instanceof RawUdp) {
            this.protocolContainer.addRawUdp((RawUdp)protocol);
        }
    }

    protected String getDescription() {
        StringBuffer sb = new StringBuffer();
        List<ProtocolObject> protObjects = this.getProtocolObjects();
        for (int i = 0; i < protObjects.size(); ++i) {
            ProtocolObject proObj = protObjects.get(i);
            if (i > 0) {
                sb.append(" ; ");
            }
            sb.append(proObj.getType());
            String content = proObj.getContent();
            if (content.length() != 0) {
                sb.append(":");
            }
            sb.append(proObj.getContent());
        }
        return sb.toString();
    }

    private List<ConfigObject> getAllProtocols() {
        ArrayList<ConfigObject> protocols = new ArrayList<ConfigObject>();
        if (this.protocolContainer != null) {
            protocols.addAll(this.protocolContainer.getRawTcp());
            protocols.addAll(this.protocolContainer.getRawIp());
            protocols.addAll(this.protocolContainer.getRawUdp());
            protocols.addAll(this.protocolContainer.getRawEthernet());
            protocols.addAll(this.protocolContainer.getRawIcmp());
            protocols.addAll(this.protocolContainer.getRawIcmpv6());
        }
        return protocols;
    }

    public FwProtocolContainer getProtocolContainer() {
        return this.protocolContainer;
    }

    public FwNetworkServiceGroup getServiceGroup() {
        return this.serviceGroup;
    }

    public void setServiceGroup(FwNetworkServiceGroup newServiceGroup) {
        this.serviceGroup = newServiceGroup;
        this.protocolContainer = this.serviceGroup.getFwProtocolContainer();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public void setName(String name) {
        this.protocolContainer.setOptContainerName(name);
    }

    public String getName() {
        return this.protocolContainer.getOptContainerName();
    }

    public List<ProtocolObject> getProtocolObjects() {
        ArrayList<ProtocolObject> protocol = new ArrayList<ProtocolObject>();
        for (ConfigObject configObject : this.getAllProtocols()) {
            protocol.add(new ProtocolObject(configObject));
        }
        return protocol;
    }

    public void setProtocolObject(int index, ProtocolObject newObject, ProtocolObject oldObject) {
        int idx = -1;
        Object protocol = oldObject.getProtocol();
        if (protocol instanceof RawTcp) {
            Vector allRawTcp = this.protocolContainer.getRawTcp();
            idx = allRawTcp.indexOf(protocol);
            if (newObject.getProtocol() instanceof RawTcp) {
                this.protocolContainer.setRawTcp(idx, (RawTcp)newObject.getProtocol());
            } else {
                this.protocolContainer.removeRawTcp((RawTcp)protocol);
                this.addNewProtocolObject(newObject);
            }
        } else if (protocol instanceof RawIp) {
            Vector allRawIp = this.protocolContainer.getRawIp();
            idx = allRawIp.indexOf(protocol);
            if (newObject.getProtocol() instanceof RawIp) {
                this.protocolContainer.setRawIp(idx, (RawIp)newObject.getProtocol());
            } else {
                this.protocolContainer.removeRawIp((RawIp)protocol);
                this.addNewProtocolObject(newObject);
            }
        } else if (protocol instanceof RawEthernet) {
            Vector allRawEthernet = this.protocolContainer.getRawEthernet();
            idx = allRawEthernet.indexOf(protocol);
            if (newObject.getProtocol() instanceof RawEthernet) {
                this.protocolContainer.setRawEthernet(idx, (RawEthernet)newObject.getProtocol());
            } else {
                this.protocolContainer.removeRawEthernet((RawEthernet)protocol);
                this.addNewProtocolObject(newObject);
            }
        } else if (protocol instanceof RawIcmp) {
            Vector allRawIcmp = this.protocolContainer.getRawIcmp();
            idx = allRawIcmp.indexOf(protocol);
            if (newObject.getProtocol() instanceof RawIcmp) {
                this.protocolContainer.setRawIcmp(idx, (RawIcmp)newObject.getProtocol());
            } else {
                this.protocolContainer.removeRawIcmp((RawIcmp)protocol);
                this.addNewProtocolObject(newObject);
            }
        } else if (protocol instanceof RawIcmpv6) {
            Vector allRawIcmp = this.protocolContainer.getRawIcmpv6();
            idx = allRawIcmp.indexOf(protocol);
            if (newObject.getProtocol() instanceof RawIcmpv6) {
                this.protocolContainer.setRawIcmpv6(idx, (RawIcmpv6)newObject.getProtocol());
            } else {
                this.protocolContainer.removeRawIcmpv6((RawIcmpv6)protocol);
                this.addNewProtocolObject(newObject);
            }
        } else if (protocol instanceof RawUdp) {
            Vector allRawUdp = this.protocolContainer.getRawUdp();
            idx = allRawUdp.indexOf(protocol);
            if (newObject.getProtocol() instanceof RawUdp) {
                this.protocolContainer.setRawUdp(idx, (RawUdp)newObject.getProtocol());
            } else {
                this.protocolContainer.removeRawUdp((RawUdp)protocol);
                this.addNewProtocolObject(newObject);
            }
        }
    }

    public boolean getSelected() {
        return Utility.getBooleanValue((Boolean)this.protocolContainer.getOptEnable(), (Boolean)this.protocolContainer.getDefEnable());
    }

    public void setSelected(boolean selected) {
        if (selected != this.getSelected()) {
            this.protocolContainer.setOptEnable(Boolean.valueOf(selected));
        }
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getName();
            }
            case 1: {
                return this.getDescription();
            }
            case 2: {
                return this.getSelected();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 2: {
                this.setSelected((Boolean)value);
                break;
            }
        }
    }

    public ProtocolContainerObject getClone() throws ConsoleException {
        try {
            byte[] copyArray = this.protocolContainer.getBytes();
            AbstractSchema copyProtocolContainer = AbstractSchema.readXML((byte[])copyArray);
            ProtocolContainerObject newObj = new ProtocolContainerObject((FwProtocolContainer)copyProtocolContainer);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    @Override
    public ImageIcon getIcon() {
        return ConsoleMain.serviceIcon;
    }

    public String toString() {
        if (this.protocolContainer == null) {
            return this.getDescription();
        }
        String containerName = this.protocolContainer.getOptContainerName();
        if (containerName == null || containerName.equals("")) {
            return this.getDescription();
        }
        return this.protocolContainer.getOptContainerName();
    }

    public boolean isSystemType() {
        if (this.serviceGroup == null) {
            return false;
        }
        Long lAttr = this.serviceGroup.getOptObjAttributes();
        if (lAttr == null) {
            lAttr = this.serviceGroup.getDefObjAttributes();
        }
        return lAttr == 1L;
    }

    public void setReadOnly(boolean readOnly) {
        this.isReadOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    @Override
    public int compareTo(ProtocolContainerObject o) {
        int ret = this.getName().compareTo(o.getName());
        if (ret != 0) {
            return ret;
        }
        ret = this.getDescription().compareTo(o.getDescription());
        return ret;
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public String getText() {
        return this.toString();
    }
}

