/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.logicobject;

import com.sygate.scm.common.configobject.schema.FwInterfaceContainer;
import com.sygate.scm.common.configobject.schema.FwNetworkInterface;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceGroup;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.firewall.logicobject.LabelObject;
import com.sygate.scm.util.GUIDGenerator;
import javax.swing.ImageIcon;

public class NetworkInterfaceGroupObject
implements TableRow,
LabelObject {
    public static final int INDEX_ID = 0;
    public static final int INDEX_NAME = 1;
    public static final int INDEX_DESCRIPTION = 2;
    private FwNetworkInterfaceGroup interfaceGroup;
    private FwInterfaceContainer container;
    private boolean isDirty = false;

    public NetworkInterfaceGroupObject(String name) {
        this.interfaceGroup = new FwNetworkInterfaceGroup();
        this.interfaceGroup.setId(new GUIDGenerator().getGUIDString());
        this.interfaceGroup.setName(name);
        FwInterfaceContainer container = new FwInterfaceContainer();
        this.interfaceGroup.setFwInterfaceContainer(container);
    }

    public NetworkInterfaceGroupObject(FwNetworkInterfaceGroup interfaceGroup) {
        this.interfaceGroup = interfaceGroup;
        this.container = interfaceGroup.getFwInterfaceContainer();
    }

    public void save() {
    }

    private FwNetworkInterface getNetworkInterface() {
        if (this.container != null) {
            return this.container.getFwNetworkInterface(0);
        }
        return null;
    }

    private FwInterfaceContainer getInterfaceContainer() {
        if (this.container == null) {
            this.container = new FwInterfaceContainer();
            FwNetworkInterface networkInterface = new FwNetworkInterface();
            networkInterface.setInclude(Boolean.valueOf(true));
            this.container.addFwNetworkInterface(networkInterface);
            this.interfaceGroup.setFwInterfaceContainer(this.container);
        }
        return this.container;
    }

    private Integer getInterfaceType(String type) {
        if (type == null) {
            return null;
        }
        if (type.equals("ALL")) {
            return FwNetworkInterface.ALL;
        }
        if (type.equals("PPTP")) {
            return FwNetworkInterface.PPTP;
        }
        if (type.equals("DUN")) {
            return FwNetworkInterface.DUN;
        }
        if (type.equals("ETHERNET")) {
            return FwNetworkInterface.ETHERNET;
        }
        if (type.equals("VPN")) {
            return FwNetworkInterface.VPN;
        }
        if (type.equals("VP_CHECKPOINT")) {
            return FwNetworkInterface.VP_CHECKPOINT;
        }
        if (type.equals("VP_CHECKPOINT")) {
            return FwNetworkInterface.VP_CHECKPOINT;
        }
        if (type.equals("VP_CISCO3000")) {
            return FwNetworkInterface.VP_CISCO3000;
        }
        if (type.equals("VP_NETSCREEN")) {
            return FwNetworkInterface.VP_NETSCREEN;
        }
        if (type.equals("VP_SAFENET")) {
            return FwNetworkInterface.VP_SAFENET;
        }
        if (type.equals("Wireless LAN")) {
            return FwNetworkInterface.WLAN;
        }
        return null;
    }

    private String getInterfaceType(Integer type) {
        if (type == null) {
            return "Custom";
        }
        if (type.equals(FwNetworkInterface.ALL)) {
            return "ALL";
        }
        if (type.equals(FwNetworkInterface.PPTP)) {
            return "PPTP";
        }
        if (type.equals(FwNetworkInterface.DUN)) {
            return "DUN";
        }
        if (type.equals(FwNetworkInterface.ETHERNET)) {
            return "ETHERNET";
        }
        if (type.equals(FwNetworkInterface.VPN)) {
            return "VPN";
        }
        if (type.equals(FwNetworkInterface.VP_CHECKPOINT)) {
            return "VP_CHECKPOINT";
        }
        if (type.equals(FwNetworkInterface.VP_CHECKPOINT)) {
            return "VP_CHECKPOINT";
        }
        if (type.equals(FwNetworkInterface.VP_CISCO3000)) {
            return "VP_CISCO3000";
        }
        if (type.equals(FwNetworkInterface.VP_NETSCREEN)) {
            return "VP_NETSCREEN";
        }
        if (type.equals(FwNetworkInterface.VP_SAFENET)) {
            return "VP_SAFENET";
        }
        if (type.equals(FwNetworkInterface.WLAN)) {
            return "Wireless LAN";
        }
        return null;
    }

    private void setDirty() {
        this.isDirty = true;
    }

    public FwNetworkInterfaceGroup getFwInterfaceGroup() {
        return this.interfaceGroup;
    }

    public String getName() {
        return this.interfaceGroup.getName();
    }

    public String getId() {
        return this.interfaceGroup.getId();
    }

    public void setName(String newName) {
        String currentName;
        if (newName != null && !(currentName = this.interfaceGroup.getName()).equals(newName)) {
            this.interfaceGroup.setName(newName);
            this.setDirty();
        }
    }

    public void setDisplayName(String newName) {
        this.interfaceGroup.setOptDisplayName(newName);
    }

    public String getDescription() {
        FwNetworkInterface networkInterface = this.getNetworkInterface();
        if (networkInterface != null) {
            return networkInterface.getOptNetworkInterfaceDescString();
        }
        return null;
    }

    public void setDescription(String desc) {
        FwNetworkInterface networkInterface = this.getNetworkInterface();
        if (networkInterface != null) {
            String currentDesc = networkInterface.getOptNetworkInterfaceDescString();
            if (currentDesc != null) {
                if (!currentDesc.equals(desc)) {
                    networkInterface.setOptNetworkInterfaceDescString(desc);
                }
            } else if (desc != null) {
                networkInterface.setOptNetworkInterfaceDescString(desc);
            }
            this.setDirty();
        }
    }

    public String toString() {
        return this.getName();
    }

    public void setType(String type) {
        FwNetworkInterface networkInterface = this.getInterfaceContainer().getFwNetworkInterface(0);
        Integer currentType = networkInterface.getOptNetworkInterfaceType();
        Integer newType = this.getInterfaceType(type);
        if (currentType != null) {
            if (!currentType.equals(newType)) {
                networkInterface.setOptNetworkInterfaceType(newType);
            }
        } else if (type != null) {
            networkInterface.setOptNetworkInterfaceType(newType);
        }
        this.setDirty();
    }

    public String getType() {
        FwNetworkInterface networkInterface = this.getInterfaceContainer().getFwNetworkInterface(0);
        Integer interfaceType = networkInterface.getOptNetworkInterfaceType();
        return this.getInterfaceType(interfaceType);
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    @Override
    public ImageIcon getIcon() {
        ImageIcon icon = ConsoleMain.anyIcon;
        String type = this.getType();
        if (type == null) {
            return icon;
        }
        if (type.equals("Custom")) {
            icon = ConsoleMain.custAdapterIcon;
        } else if (type.equals("ALL")) {
            icon = ConsoleMain.allAdaptersIcon;
        } else if (type.equals("PPTP")) {
            icon = ConsoleMain.wirelessAdapterIcon;
        } else if (type.equals("DUN")) {
            icon = ConsoleMain.dialupAdapterIcon;
        } else if (type.equals("ETHERNET")) {
            icon = ConsoleMain.ethernetAdapterIcon;
        } else if (type.equals("VPN")) {
            icon = ConsoleMain.vpnAdapterIcon;
        } else if (type.equals("VP_CHECKPOINT")) {
            icon = ConsoleMain.vpnAdapterIcon;
        } else if (type.equals("VP_CHECKPOINT")) {
            icon = ConsoleMain.vpnAdapterIcon;
        } else if (type.equals("VP_CISCO3000")) {
            icon = ConsoleMain.vpnAdapterIcon;
        } else if (type.equals("VP_NETSCREEN")) {
            icon = ConsoleMain.vpnAdapterIcon;
        } else if (type.equals("VP_SAFENET")) {
            icon = ConsoleMain.vpnAdapterIcon;
        } else if (type.equals("Wireless LAN")) {
            icon = ConsoleMain.wirelessAdapterIcon;
        }
        return icon;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.interfaceGroup.getId();
            }
            case 1: {
                return this.getText();
            }
            case 2: {
                return this.getDescription();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
        this.interfaceGroup = (FwNetworkInterfaceGroup)value;
    }

    public boolean isSystemObject() {
        Long objAttr = this.interfaceGroup.getOptObjAttributes();
        return objAttr != null && objAttr == 1L;
    }

    @Override
    public String getText() {
        return this.interfaceGroup.getOptDisplayName() == null ? this.interfaceGroup.getName() : this.interfaceGroup.getOptDisplayName();
    }
}

