/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.logicobject;

import com.sygate.scm.common.configobject.schema.FwNetworkInterface;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceGroup;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FirewallRuleObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FwNetworkInterfaceObject;
import com.sygate.scm.util.LoggerUtilities;

public class NetworkAdapterInterfaceObject
implements TableRow {
    public static final String GROUP_TYPE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "NetworkAdapterInterfaceObject.type.Group");
    public static final String INTERFACE_TYPE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "NetworkAdapterInterfaceObject.type.Interface");
    String type = "Group";
    String name = "";
    String id = null;
    String identification = null;
    Integer adapterType = null;
    FwNetworkInterface _networkInterface = null;
    boolean selected = false;

    public NetworkAdapterInterfaceObject() {
    }

    public NetworkAdapterInterfaceObject(FwNetworkInterfaceGroup interfaceGroup) {
        String string = this.name = interfaceGroup.getOptDisplayName() == null ? interfaceGroup.getName() : interfaceGroup.getOptDisplayName();
        if (interfaceGroup.getOptDescription() != null) {
            this.identification = interfaceGroup.getOptDescription();
        }
        this.id = interfaceGroup.getId();
    }

    public NetworkAdapterInterfaceObject(FwNetworkInterfaceObject inter) {
        this.name = inter.getOptName();
        this.identification = inter.getOptNetworkInterfaceDescString();
        try {
            this.adapterType = inter.getOptNetworkInterfaceType();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        this.selected = true;
        this._networkInterface = inter.getFwNetworkInterface();
        this._networkInterface.setOptEnable(Boolean.valueOf(true));
        this._networkInterface.setInclude(Boolean.valueOf(true));
    }

    public NetworkAdapterInterfaceObject(FwNetworkInterface interfac) {
        this.name = "";
        if (interfac.getOptNetworkInterfaceDescString() != null) {
            this.identification = interfac.getOptNetworkInterfaceDescString();
        }
        this.type = INTERFACE_TYPE;
        this._networkInterface = interfac;
        this._networkInterface.setInclude(Boolean.valueOf(true));
        this._networkInterface.setOptEnable(interfac.getOptEnable());
        if (interfac.getOptEnable() != null) {
            this.selected = interfac.getOptEnable();
        }
        try {
            this.adapterType = interfac.getOptNetworkInterfaceType();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    public FwNetworkInterface getNetworkInterface() {
        if (this._networkInterface != null) {
            return this._networkInterface;
        }
        FwNetworkInterface fwInterface = new FwNetworkInterface();
        fwInterface.setInclude(Boolean.valueOf(true));
        fwInterface.setOptEnable(Boolean.valueOf(this.selected));
        fwInterface.setOptNetworkInterfaceDescString(this.identification);
        try {
            fwInterface.setOptNetworkInterfaceType(this.adapterType);
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
        return fwInterface;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String tType) {
        this.type = tType;
    }

    public Integer getAdapterType() {
        return this.adapterType;
    }

    public void setAdapterType(Integer tType) {
        this.adapterType = tType;
    }

    public Boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean sel) {
        this.selected = sel;
        if (this._networkInterface != null) {
            this._networkInterface.setOptEnable(Boolean.valueOf(sel));
        }
    }

    public String getName() {
        return this.name;
    }

    public String getID() {
        return this.id;
    }

    public String getIdentification() {
        return this.identification;
    }

    public void setIdentification(String str) {
        this.identification = str;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.isSelected();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                if (!this.type.equals(GROUP_TYPE) && (this.identification == null || this.identification.equals(""))) {
                    return FirewallRuleObject.getInterfaceDisplay(this.adapterType);
                }
                return this.getIdentification();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 0: {
                this.setSelected((Boolean)value);
                break;
            }
        }
    }

    public boolean isCellEditable(int column) {
        switch (column) {
            case 0: {
                return true;
            }
        }
        return false;
    }
}

