/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.DnsDomain;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostEnableObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.LabelObject;
import com.sygate.scm.console.util.ConsoleException;
import javax.swing.ImageIcon;

public class HostObject
implements TableRow,
LabelObject {
    private static MessageResources MRS = MessageResources.getInstance();
    private static final String[] TYPES = new String[]{MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.MACAddress"), MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.IPAddress"), MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.IPRange"), MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.SubNet"), MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.DNSHost"), MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.DNSDomain"), "HostGroup", MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.LocalSubnet"), MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.IPv6Address"), MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.IPv6Range"), MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.IPv6Subnet")};
    public static final int MAC_ADDRESS = 0;
    public static final int IP_ADDRESS = 1;
    public static final int IP_RANGE = 2;
    public static final int SUB_NET = 3;
    public static final int DNS_HOST = 4;
    public static final int DNS_DOMAIN = 5;
    public static final int HOST_GROUP = 6;
    public static final int LOCAL_SUBNET = 7;
    public static final int IPV6_ADDRESS = 8;
    public static final int IPV6_RANGE = 9;
    public static final int IPV6_SUB_NET = 10;
    private Object address;
    private String direction;
    private String name;
    private String typeString;
    private boolean enable;
    private FwNetworkHostGroup networkHostGroup;

    public HostObject(Object address, String type, String direction) {
        this.address = address;
        this.typeString = type;
        this.direction = direction;
    }

    public HostObject(HostEnableObject eHost) {
        this.address = eHost.getAddress();
        this.typeString = eHost.getType();
        this.direction = eHost.getDirection();
        this.enable = eHost.getEnable();
        this.networkHostGroup = eHost.getNetworkHostGroup();
        if (this.networkHostGroup != null) {
            this.name = this.networkHostGroup.getName();
        }
    }

    public HostObject(boolean enable, Object address, String type, String direction) {
        this.address = address;
        this.typeString = type;
        this.direction = direction;
        this.enable = enable;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public void setEnable(boolean en) {
        this.enable = en;
    }

    public String getType() {
        return this.typeString;
    }

    public void setType(String newType) {
        this.typeString = newType;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String newDirection) {
        this.direction = newDirection;
    }

    public Object getAddress() {
        return this.address;
    }

    public int getTypeAsint() {
        for (int i = 0; i < TYPES.length; ++i) {
            if (!TYPES[i].equals(this.typeString)) continue;
            return i;
        }
        return 0;
    }

    public static String getTypeByIndex(int index) {
        int type_count = TYPES.length;
        if (index < 0 || index > type_count - 1) {
            return null;
        }
        return TYPES[index];
    }

    public static String[] getTypes() {
        return (String[])TYPES.clone();
    }

    public void setContent(String part1, String part2) {
        int type = this.getTypeAsint();
        switch (type) {
            case 0: {
                ((MacAddress)this.address).setContent(part1);
                break;
            }
            case 1: {
                ((IpAddress)this.address).setContent(part1);
                break;
            }
            case 2: {
                IpRange range = (IpRange)this.address;
                range.setStart(part1);
                range.setEnd(part2);
                break;
            }
            case 3: {
                SubNet subnet = (SubNet)this.address;
                subnet.setNetAddr(part1);
                subnet.setNetMask(part2);
                break;
            }
            case 4: {
                ((DnsHost)this.address).setContent(part1);
                break;
            }
            case 5: {
                ((DnsDomain)this.address).setContent(part1);
                break;
            }
            case 8: {
                ((Ipv6Address)this.address).setContent(part1);
                break;
            }
            case 9: {
                Ipv6Range v6range = (Ipv6Range)this.address;
                v6range.setStart(part1);
                v6range.setEnd(part2);
                break;
            }
            case 10: {
                ((Ipv6SubNet)this.address).setContent(part1);
                break;
            }
        }
    }

    public String getContent() {
        int type = this.getTypeAsint();
        switch (type) {
            case 0: {
                return ((MacAddress)this.address).getContent();
            }
            case 1: {
                return ((IpAddress)this.address).getContent();
            }
            case 2: {
                IpRange range = (IpRange)this.address;
                return range.getStart() + "-" + range.getEnd();
            }
            case 3: {
                SubNet subnet = (SubNet)this.address;
                String mask = MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.Mask");
                return "IP-" + subnet.getNetAddr() + ";" + mask + "-" + subnet.getNetMask();
            }
            case 4: {
                return ((DnsHost)this.address).getContent();
            }
            case 5: {
                return ((DnsDomain)this.address).getContent();
            }
            case 7: {
                return MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.LocalSubnet");
            }
            case 8: {
                return ((Ipv6Address)this.address).getContent();
            }
            case 9: {
                Ipv6Range v6Range = (Ipv6Range)this.address;
                return v6Range.getStart() + "-" + v6Range.getEnd();
            }
            case 10: {
                return ((Ipv6SubNet)this.address).getContent();
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getType();
            }
            case 1: {
                return this.getContent();
            }
        }
        return null;
    }

    public Class<String> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int index) {
    }

    public String toString() {
        int type = this.getTypeAsint();
        switch (type) {
            case 0: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 1: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 2: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 3: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 4: {
                return this.getDirection() + ":Host-" + this.getContent();
            }
            case 5: {
                return this.getDirection() + ":Domain-" + this.getContent();
            }
            case 6: {
                return this.getDirection() + ":" + this.getName();
            }
            case 7: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 8: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 9: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 10: {
                return this.getDirection() + ":" + this.getContent();
            }
        }
        return "";
    }

    @Override
    public ImageIcon getIcon() {
        return ConsoleMain.hostsIcon;
    }

    public HostObject getClone() throws ConsoleException {
        try {
            byte[] copyArray = ((ConfigObject)this.address).getBytes();
            AbstractSchema newAddress = AbstractSchema.readXML((byte[])copyArray);
            System.out.println("Copy Address:" + newAddress.getClass().getName());
            HostObject newObj = new HostObject(newAddress, this.getType(), this.getDirection());
            newObj.setName(this.getName());
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    @Override
    public String getText() {
        return this.toString();
    }
}

