/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.DnsDomain;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.LabelObject;
import com.sygate.scm.console.ui.policy.hostgroup.HostGroupObject;
import com.sygate.scm.console.util.ConsoleException;
import javax.swing.ImageIcon;

public class HostEnableObject
implements TableRow,
LabelObject {
    private static MessageResources MRS = MessageResources.getInstance();
    private Object address;
    private String direction;
    private String name;
    private String typeString;
    private boolean enable;
    private FwNetworkHostGroup networkHostGroup;
    private FwHostContainer fwHostContainer;

    public HostEnableObject(Object address, String type, String direction) {
        this.address = address;
        this.typeString = type;
        this.direction = direction;
    }

    public HostEnableObject(HostObject hObj) {
        this.address = hObj.getAddress();
        this.typeString = hObj.getType();
        this.direction = hObj.getDirection();
        this.enable = true;
    }

    public HostEnableObject(boolean enable, Object address, String type, String direction) {
        this.address = address;
        this.typeString = type;
        this.direction = direction;
        this.enable = enable;
    }

    public HostEnableObject(boolean enable, String name, String content, String direction) {
        this.address = content;
        this.name = name;
        this.direction = direction;
        this.enable = enable;
        this.typeString = HostObject.getTypeByIndex(6);
    }

    public HostEnableObject(HostGroupObject obj, int dir) {
        this.address = obj.getDescription();
        this.name = obj.getName();
        this.direction = HostEnableObject.getDirectionDesc(dir);
        this.enable = false;
        this.networkHostGroup = obj.getHostGroup();
        this.fwHostContainer = this.networkHostGroup.getFwHostContainer();
        this.typeString = HostObject.getTypeByIndex(6);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public FwNetworkHostGroup getNetworkHostGroup() {
        return this.networkHostGroup;
    }

    public void setName(FwNetworkHostGroup hostGroup) {
        this.networkHostGroup = hostGroup;
    }

    public String getType() {
        return this.typeString;
    }

    public void setType(String newType) {
        this.typeString = newType;
    }

    public boolean getEnable() {
        return this.enable;
    }

    public void setEnable(boolean trueFalse) {
        this.enable = trueFalse;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String newDirection) {
        this.direction = newDirection;
    }

    public Object getAddress() {
        return this.address;
    }

    public int getTypeAsint() {
        for (int i = 0; i < HostObject.getTypes().length; ++i) {
            if (!this.typeString.equals(HostObject.getTypeByIndex(i))) continue;
            return i;
        }
        return 0;
    }

    public void setContent(String part1, String part2) {
        int type = this.getTypeAsint();
        switch (type) {
            case 0: {
                ((MacAddress)this.address).setContent(part1);
                break;
            }
            case 1: {
                ((IpAddress)this.address).setContent(part1);
                break;
            }
            case 2: {
                IpRange range = (IpRange)this.address;
                range.setStart(part1);
                range.setEnd(part2);
                break;
            }
            case 3: {
                SubNet subnet = (SubNet)this.address;
                subnet.setNetAddr(part1);
                subnet.setNetMask(part2);
                break;
            }
            case 4: {
                ((DnsHost)this.address).setContent(part1);
                break;
            }
            case 5: {
                ((DnsDomain)this.address).setContent(part1);
                break;
            }
            case 8: {
                ((Ipv6Address)this.address).setContent(part1);
                break;
            }
            case 9: {
                Ipv6Range v6range = (Ipv6Range)this.address;
                v6range.setStart(part1);
                v6range.setEnd(part2);
                break;
            }
            case 10: {
                ((Ipv6SubNet)this.address).setContent(part1);
                break;
            }
        }
    }

    public String getContent() {
        int type = this.getTypeAsint();
        switch (type) {
            case 0: {
                return ((MacAddress)this.address).getContent();
            }
            case 1: {
                return ((IpAddress)this.address).getContent();
            }
            case 2: {
                IpRange range = (IpRange)this.address;
                return range.getStart() + "-" + range.getEnd();
            }
            case 3: {
                SubNet subnet = (SubNet)this.address;
                String mask = MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.Mask");
                return "IP-" + subnet.getNetAddr() + ";" + mask + "-" + subnet.getNetMask();
            }
            case 4: {
                return ((DnsHost)this.address).getContent();
            }
            case 5: {
                return ((DnsDomain)this.address).getContent();
            }
            case 6: {
                return (String)this.address;
            }
            case 7: {
                return MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.LocalSubnet");
            }
            case 8: {
                return ((Ipv6Address)this.address).getContent();
            }
            case 9: {
                Ipv6Range v6range = (Ipv6Range)this.address;
                return v6range.getStart() + "-" + v6range.getEnd();
            }
            case 10: {
                return ((Ipv6SubNet)this.address).getContent();
            }
        }
        return null;
    }

    @Override
    public Object getValueAt(int index) {
        switch (index) {
            case 0: {
                return this.getEnable();
            }
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getNewContent();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int index) {
        switch (index) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
        }
        return null;
    }

    private String getNewContent() {
        Object str = null;
        str = this.getType().equalsIgnoreCase(HostObject.getTypeByIndex(6)) || this.getType().equalsIgnoreCase(HostObject.getTypeByIndex(7)) ? this.getContent() : this.getType() + ":" + this.getContent();
        return str;
    }

    @Override
    public void setValueAt(Object value, int index) {
        switch (index) {
            case 0: {
                this.setEnable((Boolean)value);
                break;
            }
        }
    }

    public String toString() {
        int type = this.getTypeAsint();
        switch (type) {
            case 0: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 1: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 2: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 3: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 4: {
                return this.getDirection() + ":Host-" + this.getContent();
            }
            case 5: {
                return this.getDirection() + ":Domain-" + this.getContent();
            }
            case 7: {
                return this.getDirection() + ":" + this.getContent();
            }
            case 8: 
            case 9: 
            case 10: {
                return this.getDirection() + ":" + this.getContent();
            }
        }
        return "";
    }

    @Override
    public ImageIcon getIcon() {
        return ConsoleMain.hostsIcon;
    }

    public HostEnableObject getClone() throws ConsoleException {
        try {
            byte[] copyArray = ((ConfigObject)this.address).getBytes();
            AbstractSchema newAddress = AbstractSchema.readXML((byte[])copyArray);
            System.out.println("Copy Address:" + newAddress.getClass().getName());
            HostEnableObject newObj = new HostEnableObject(newAddress, this.getType(), this.getDirection());
            newObj.setName(this.getName());
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    @Override
    public String getText() {
        return this.toString();
    }

    public static String getDirectionDesc(int dir) {
        switch (dir) {
            case 0: {
                return MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostContainerObject.desc.Source");
            }
            case 1: {
                return MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostContainerObject.desc.Destination");
            }
            case 2: {
                return MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostContainerObject.desc.Local");
            }
            case 3: {
                return MRS.getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostContainerObject.desc.Remote");
            }
        }
        return null;
    }

    public FwHostContainer getFwHostContainer() {
        return this.fwHostContainer;
    }

    public void setFwHostContainer(FwHostContainer fwHostContainer) {
        this.fwHostContainer = fwHostContainer;
    }
}

