/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.logicobject;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.DnsDomain;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.LocalSubnet;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.util.ConsoleException;
import java.util.ArrayList;
import java.util.Vector;

public class HostContainerObject {
    public static final int SOURCE = 0;
    public static final int DESTINATION = 1;
    public static final int LOCAL = 2;
    public static final int REMOTE = 3;
    public static final int IPS = 4;
    public static final int P2P = 5;
    private FwHostContainer container;
    private int direction;
    private ArrayList<HostObject> allAddress;

    public HostContainerObject(FwHostContainer container, int direction) {
        this.container = container;
        this.direction = direction;
    }

    public void addHostObject(HostObject hostObject) {
        Object address = hostObject.getAddress();
        this.addAddress(address);
        this.getAllAddress().add(hostObject);
    }

    public void deleteHostObject(HostObject hostObject) {
        Object address = hostObject.getAddress();
        this.deleteAddress(address);
        this.getAllAddress().remove(hostObject);
    }

    private void addAddress(Object address) {
        if (address instanceof IpAddress) {
            this.container.addIpAddress((IpAddress)address);
        } else if (address instanceof IpRange) {
            this.container.addIpRange((IpRange)address);
        } else if (address instanceof MacAddress) {
            String content = ((MacAddress)address).getContent();
            this.container.addMacAddress((MacAddress)address);
            PolicyHandler.addMacAddress(content);
        } else if (address instanceof SubNet) {
            this.container.addSubNet((SubNet)address);
        } else if (address instanceof DnsDomain) {
            this.container.addDnsDomain((DnsDomain)address);
        } else if (address instanceof DnsHost) {
            this.container.addDnsHost((DnsHost)address);
        } else if (address instanceof LocalSubnet) {
            this.container.setOptLocalSubnet((LocalSubnet)address);
        } else if (address instanceof Ipv6Address) {
            this.container.addIpv6Address((Ipv6Address)address);
        } else if (address instanceof Ipv6Range) {
            this.container.addIpv6Range((Ipv6Range)address);
        } else if (address instanceof Ipv6SubNet) {
            this.container.addIpv6SubNet((Ipv6SubNet)address);
        }
    }

    private void setAddress(int index, Object oldAddress, Object newAddress) {
        this.deleteAddress(oldAddress);
        this.addAddress(newAddress);
    }

    private void deleteAddress(Object address) {
        if (address instanceof IpAddress) {
            this.container.removeIpAddress((IpAddress)address);
        } else if (address instanceof IpRange) {
            this.container.removeIpRange((IpRange)address);
        } else if (address instanceof MacAddress) {
            String content = ((MacAddress)address).getContent();
            this.container.removeMacAddress((MacAddress)address);
            PolicyHandler.deleteMacAddress(content);
        } else if (address instanceof SubNet) {
            this.container.removeSubNet((SubNet)address);
        } else if (address instanceof DnsDomain) {
            this.container.removeDnsDomain((DnsDomain)address);
        } else if (address instanceof DnsHost) {
            this.container.removeDnsHost((DnsHost)address);
        } else if (address instanceof LocalSubnet) {
            this.container.setOptLocalSubnet(null);
        } else if (address instanceof Ipv6Address) {
            this.container.removeIpv6Address((Ipv6Address)address);
        } else if (address instanceof Ipv6Range) {
            this.container.removeIpv6Range((Ipv6Range)address);
        } else if (address instanceof Ipv6SubNet) {
            this.container.removeIpv6SubNet((Ipv6SubNet)address);
        }
    }

    private void createHostObjects() {
        LocalSubnet localSubnet;
        Vector hostObjects = (Vector)Cast.cast(this.getMacAddress());
        if (hostObjects != null) {
            this.addHostObjects(hostObjects, HostObject.getTypeByIndex(0));
        }
        if ((hostObjects = (Vector)Cast.cast(this.getIpAddress())) != null) {
            this.addHostObjects(hostObjects, HostObject.getTypeByIndex(1));
        }
        if ((hostObjects = (Vector)Cast.cast(this.getIpRange())) != null) {
            this.addHostObjects(hostObjects, HostObject.getTypeByIndex(2));
        }
        if ((hostObjects = (Vector)Cast.cast(this.getSubNet())) != null) {
            this.addHostObjects(hostObjects, HostObject.getTypeByIndex(3));
        }
        if ((hostObjects = (Vector)Cast.cast(this.getDnsHost())) != null) {
            this.addHostObjects(hostObjects, HostObject.getTypeByIndex(4));
        }
        if ((hostObjects = (Vector)Cast.cast(this.getDnsDomain())) != null) {
            this.addHostObjects(hostObjects, HostObject.getTypeByIndex(5));
        }
        if ((localSubnet = this.getLocalSubnet()) != null) {
            Vector<LocalSubnet> vec = new Vector<LocalSubnet>();
            vec.add(localSubnet);
            this.addHostObjects(vec, HostObject.getTypeByIndex(7));
        }
        if (this.getIpv6Address() != null) {
            this.addHostObjects(this.getIpv6Address(), HostObject.getTypeByIndex(8));
        }
        if (this.getIpv6Range() != null) {
            this.addHostObjects(this.getIpv6Range(), HostObject.getTypeByIndex(9));
        }
        if (this.getSubNet() != null) {
            this.addHostObjects(this.getIpv6SubNet(), HostObject.getTypeByIndex(10));
        }
    }

    private void addHostObjects(Vector<? extends ConfigObject> addresses, String type) {
        if (addresses == null) {
            return;
        }
        for (int i = 0; i < addresses.size(); ++i) {
            this.getAllAddress().add(new HostObject(addresses.get(i), type, this.getDirectionDesc()));
            if (!MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostContainerObject.MACAddress").equals(type)) continue;
            MacAddress macAddress = (MacAddress)addresses.get(i);
            String content = macAddress.getContent();
            PolicyHandler.addMacAddress(content);
        }
    }

    public FwHostContainer getContainer() {
        return this.container;
    }

    public void setContainer(FwHostContainer newContainer) {
        this.container = newContainer;
    }

    public String getDirectionDesc() {
        switch (this.direction) {
            case 0: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostContainerObject.desc.Source");
            }
            case 1: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostContainerObject.desc.Destination");
            }
            case 2: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostContainerObject.desc.Local");
            }
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostContainerObject.desc.Remote");
            }
        }
        return null;
    }

    public int getDirection() {
        return this.direction;
    }

    public String getName() {
        return this.container.getOptContainerName();
    }

    public void setName(String newName) {
        this.container.setOptContainerName(newName);
    }

    public Vector<MacAddress> getMacAddress() {
        return this.container.getMacAddress();
    }

    public boolean getEnable() {
        Boolean val = this.container.getOptEnable();
        if (val != null) {
            return val;
        }
        return this.container.getDefEnable();
    }

    public void setEnable(boolean val) {
        this.container.setOptEnable(Boolean.valueOf(val));
    }

    public Vector<DnsDomain> getDnsDomain() {
        return this.container.getDnsDomain();
    }

    public LocalSubnet getLocalSubnet() {
        return this.container.getOptLocalSubnet();
    }

    public Vector<DnsHost> getDnsHost() {
        return this.container.getDnsHost();
    }

    public Vector<IpAddress> getIpAddress() {
        return this.container.getIpAddress();
    }

    public Vector<IpRange> getIpRange() {
        return this.container.getIpRange();
    }

    public Vector<SubNet> getSubNet() {
        return this.container.getSubNet();
    }

    public Vector<Ipv6Address> getIpv6Address() {
        return this.container.getIpv6Address();
    }

    public Vector<Ipv6Range> getIpv6Range() {
        return this.container.getIpv6Range();
    }

    public Vector<Ipv6SubNet> getIpv6SubNet() {
        return this.container.getIpv6SubNet();
    }

    public void setHostObject(int index, HostObject oldHostObject, HostObject newHostObject) {
        Object oldAddress = oldHostObject.getAddress();
        Object newAddress = newHostObject.getAddress();
        this.setAddress(index, oldAddress, newAddress);
        this.getAllAddress().set(index, newHostObject);
    }

    public boolean isAddLocalSubnetExisted() {
        return this.container.getOptLocalSubnet() != null;
    }

    public ArrayList<HostObject> getAllAddress() {
        if (this.allAddress == null) {
            this.allAddress = new ArrayList();
            this.createHostObjects();
        }
        return this.allAddress;
    }

    public void setAllAddress(ArrayList<HostObject> newAddresses) {
        this.allAddress = newAddresses;
    }

    public HostContainerObject getClone() throws ConsoleException {
        try {
            byte[] copyArray = this.container.getBytes();
            AbstractSchema hostContainerCopy = AbstractSchema.readXML((byte[])copyArray);
            System.out.println("Copy Host Container:" + hostContainerCopy.getClass().getName());
            HostContainerObject newObj = new HostContainerObject((FwHostContainer)hostContainerCopy, this.direction);
            return newObj;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }
}

