/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.ValidationException;
import com.sygate.scm.common.configobject.schema.Action;
import com.sygate.scm.common.configobject.schema.FirewallRule;
import com.sygate.scm.common.configobject.schema.FwApplicationTrigger;
import com.sygate.scm.common.configobject.schema.FwHostTrigger;
import com.sygate.scm.common.configobject.schema.FwInterfaceContainer;
import com.sygate.scm.common.configobject.schema.FwNetworkInterface;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceTrigger;
import com.sygate.scm.common.configobject.schema.FwScreenSaverTrigger;
import com.sygate.scm.common.configobject.schema.FwServiceTrigger;
import com.sygate.scm.common.configobject.schema.FwTimeTrigger;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.TriggerCondition;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.WashIDHandler;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.common.CopitableObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ActionObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ApplicationObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.NetworkInterfaceGroupObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolContainerObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ScheduleObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ScreenSaverObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.TriggerConditionObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.HashMap;

public class FirewallRuleObject
implements CopitableObject {
    private static final String[] SEVERITY = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.0.Critical"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.1.Critical"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.2.Critical"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.3.Critical"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.4.Major"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.5.Major"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.6.Major"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.7.Major"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.8.Major"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.9.Major"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.10.Minor"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.11.Minor"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.12.Info"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.13.Info"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.14.Info"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.15.Info")};
    public static final int LOCAL = 0;
    public static final int INHERITED = 1;
    public static final int NO_RULE_TYPE = 0;
    public static final int ENFORCED_RULE_TYPE = 1;
    public static final int BASELINE_RULE_TYPE = 2;
    private boolean enabled = true;
    private String name;
    private int no;
    private String severity = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.severity.5.Major");
    private String createdBy = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "FirewallRuleObject.GroupName");
    private String description;
    private Boolean useInAgent = false;
    private int type = 0;
    private int fwRuleType = 0;
    private FirewallRule rule;
    private TriggerConditionObject triggerConditionObject;
    private ActionObject actionObject;
    private ScreenSaverObject screenSaverObject;
    private int osPlatform = 1;

    public FirewallRuleObject() {
        this.initialize();
    }

    private void initialize() {
        this.rule = new FirewallRule();
        this.rule.setId(new GUIDGenerator().getGUIDString());
        TriggerCondition triggerCondition = new TriggerCondition();
        Action action = new Action();
        this.rule.setTriggerCondition(triggerCondition);
        this.rule.setAction(action);
        this.triggerConditionObject = new TriggerConditionObject(triggerCondition);
        this.actionObject = new ActionObject(action);
    }

    public FirewallRuleObject(FirewallRule rule) {
        this.rule = rule;
        this.triggerConditionObject = new TriggerConditionObject(rule.getTriggerCondition());
        this.actionObject = new ActionObject(rule.getAction());
        this.setName(rule.getName());
        this.setDescription(rule.getOptDescription());
        this.setSeverity(rule.getSeverity());
        Boolean enable = rule.getOptEnable();
        if (enable != null) {
            this.setEnabled(enable);
        }
    }

    public FirewallRuleObject(FirewallRule rule, String groupName) {
        this.rule = rule;
        this.triggerConditionObject = new TriggerConditionObject(rule.getTriggerCondition());
        this.actionObject = new ActionObject(rule.getAction());
        this.setName(rule.getName());
        this.setDescription(rule.getOptDescription());
        this.setSeverity(rule.getSeverity());
        Boolean enable = rule.getOptEnable();
        if (enable != null) {
            this.setEnabled(enable);
        }
        this.createdBy = groupName;
    }

    public void update() {
        if (this.isInherited()) {
            this.rule.setOptEnable(Boolean.valueOf(this.getEnabled()));
            return;
        }
        this.rule.setName(this.getName());
        this.rule.setOptDescription(this.getDescription());
        this.rule.setOptEnable(Boolean.valueOf(this.getEnabled()));
        this.rule.setSeverity(this.getSeverityAsLong());
    }

    public TriggerConditionObject getTriggerConditionObject() {
        if (this.triggerConditionObject == null) {
            this.triggerConditionObject = new TriggerConditionObject();
        }
        return this.triggerConditionObject;
    }

    public TriggerCondition getTriggerCondition() {
        return this.rule.getTriggerCondition();
    }

    public FwApplicationTrigger getApplicationTrigger() {
        return this.getTriggerConditionObject().getApplicationTrigger();
    }

    public void setApplicationTrigger(FwApplicationTrigger appTrigger) {
        this.getTriggerConditionObject().setApplicationTrigger(appTrigger);
    }

    public FwHostTrigger getHostTrigger() {
        return this.getTriggerConditionObject().getHostTrigger();
    }

    public void setHostTrigger(FwHostTrigger hostTrigger) {
        this.getTriggerConditionObject().setHostTrigger(hostTrigger);
    }

    public FwServiceTrigger getServiceTrigger() {
        return this.getTriggerConditionObject().getServiceTrigger();
    }

    public void setServiceTrigger(FwServiceTrigger serviceTrigger) {
        this.getTriggerConditionObject().setServiceTrigger(serviceTrigger);
    }

    public FwTimeTrigger getTimeTrigger() {
        return this.getTriggerConditionObject().getTimeTrigger();
    }

    public void setTimeTrigger(FwTimeTrigger timeTrigger) {
        this.getTriggerConditionObject().setTimeTrigger(timeTrigger);
    }

    public FwNetworkInterfaceTrigger getInterfaceTrigger() {
        return this.getTriggerConditionObject().getInterfaceTrigger();
    }

    public void setInterfaceTrigger(FwNetworkInterfaceTrigger interfaceTrigger) {
        this.getTriggerConditionObject().setInterfaceTrigger(interfaceTrigger);
    }

    public ArrayList<ApplicationObject> getApplications() {
        return this.triggerConditionObject.getApplicationObjects();
    }

    public void setApplications(ArrayList<ApplicationObject> newApplications) {
        this.triggerConditionObject.setApplicationObjects(newApplications);
    }

    public ArrayList<HostObject> getHosts() {
        return this.triggerConditionObject.getHostObjects();
    }

    public void setHosts(ArrayList<HostObject> newHosts) {
        this.triggerConditionObject.setHostObjects(newHosts);
    }

    public ArrayList<ProtocolContainerObject> getProtocolContainers() {
        return this.triggerConditionObject.getProtocolContainerObjects();
    }

    public void setProtocolContainers(ArrayList<ProtocolContainerObject> newProtocolContainers) {
        this.triggerConditionObject.setProtocolContainerObjects(newProtocolContainers);
    }

    public ArrayList<ScheduleObject> getSchedules() {
        return this.triggerConditionObject.getScheduleObjects();
    }

    public void setSchedules(ArrayList<ScheduleObject> newSchedules) {
        this.triggerConditionObject.setScheduleObjects(newSchedules);
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public int getNo() {
        return this.no;
    }

    public void setNo(int newNo) {
        this.no = newNo;
    }

    public String getSeverity() {
        return this.severity;
    }

    public static String[] getAllSeverity() {
        return (String[])SEVERITY.clone();
    }

    public static String getSeverity(int severity) {
        int slength = SEVERITY.length;
        if (severity < 0 || severity > slength - 1) {
            return null;
        }
        return SEVERITY[severity];
    }

    public int getSeverity(String severity) {
        int index = -1;
        for (int i = 0; i < SEVERITY.length; ++i) {
            if (!SEVERITY[i].equals(severity)) continue;
            index = i;
        }
        return index;
    }

    public Long getSeverityAsLong() {
        return this.getSeverity(this.getSeverity());
    }

    public void setSeverity(String newSeverity) {
        this.severity = newSeverity;
    }

    public void setSeverity(Long newSeverity) {
        if (newSeverity == null) {
            return;
        }
        int sevType = newSeverity.intValue();
        this.severity = SEVERITY[sevType];
    }

    public Boolean getUseInAgent() {
        return this.useInAgent;
    }

    public void setUseInAgent(Boolean value) {
        this.useInAgent = value;
    }

    public ArrayList<NetworkInterfaceGroupObject> getInterfaces() {
        return this.triggerConditionObject.getInterfaces();
    }

    public ArrayList<NetworkInterfaceGroupObject> getInterfacesForDisplayInTable() {
        Object type;
        DataobjectManager manager = DataobjectManager.getInstance();
        ArrayList<NetworkInterfaceGroupObject> arrList = new ArrayList<NetworkInterfaceGroupObject>();
        FwNetworkInterfaceTrigger trig = this.triggerConditionObject.getInterfaceTrigger();
        if (trig == null) {
            return arrList;
        }
        for (int i = 0; i < trig.getObjReferenceCount(); ++i) {
            ObjReference objRef = trig.getObjReference(i);
            String trgName = objRef.getName();
            type = null;
            String disName = null;
            try {
                FwNetworkInterface nic;
                FwNetworkInterfaceGroup nicGroup = manager.getFwNetworkInterfaceGroup(objRef.getTargetId());
                trgName = nicGroup.getName();
                disName = nicGroup.getOptDisplayName() == null ? nicGroup.getName() : nicGroup.getOptDisplayName();
                FwInterfaceContainer container = nicGroup.getFwInterfaceContainer();
                if (container != null && (nic = container.getFwNetworkInterface(0)) != null) {
                    type = nic.getOptNetworkInterfaceTypeValue();
                }
            }
            catch (ConsoleException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            catch (ValidationException ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            NetworkInterfaceGroupObject grpObj = new NetworkInterfaceGroupObject(trgName);
            grpObj.setType((String)type);
            grpObj.setDisplayName(disName);
            arrList.add(grpObj);
        }
        FwInterfaceContainer cont = trig.getOptFwInterfaceContainer();
        if (cont == null) {
            return arrList;
        }
        for (int i = 0; i < cont.getFwNetworkInterfaceCount(); ++i) {
            String str = cont.getFwNetworkInterface(i).getOptNetworkInterfaceDescString();
            if (str != null && str.equals("")) {
                try {
                    type = cont.getFwNetworkInterface(i).getOptNetworkInterfaceType();
                    str = FirewallRuleObject.getInterfaceDisplay((Integer)type);
                }
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    str = "PPTP";
                }
            }
            NetworkInterfaceGroupObject netwrkIntrfaceObj = new NetworkInterfaceGroupObject(str);
            if (!cont.getFwNetworkInterface(i).getOptEnable().booleanValue()) continue;
            arrList.add(netwrkIntrfaceObj);
        }
        return arrList;
    }

    public static String getInterfaceDisplay(Integer type) {
        String interfaceStr = "";
        interfaceStr = type == null ? "PPTP" : (type.equals(FwNetworkInterface.ALL) ? "All Adapters" : (type.equals(FwNetworkInterface.DUN) ? "Dial-up" : (type.equals(FwNetworkInterface.ETHERNET) ? "Ethernet" : (type.equals(FwNetworkInterface.VPN) ? "Any VPN" : "PPTP"))));
        return interfaceStr;
    }

    public void setInterfaces(ArrayList<NetworkInterfaceGroupObject> newInterfaces) {
        this.triggerConditionObject.setInterfaces(newInterfaces);
    }

    public ScreenSaverObject getScreenSaver() {
        if (this.screenSaverObject == null) {
            FwScreenSaverTrigger screenTrigger = this.getTriggerCondition().getOptFwScreenSaverTrigger();
            if (screenTrigger == null) {
                screenTrigger = new FwScreenSaverTrigger();
                this.getTriggerCondition().setOptFwScreenSaverTrigger(screenTrigger);
            }
            this.screenSaverObject = new ScreenSaverObject(screenTrigger);
        }
        return this.screenSaverObject;
    }

    public void setScreenSaver(ScreenSaverObject newScreenSaver) {
        this.screenSaverObject = newScreenSaver;
    }

    public ActionObject getAction() {
        return this.actionObject;
    }

    public void setAction(String newAction) {
        this.actionObject.setAction(newAction);
    }

    public ActionObject getTracking() {
        return this.actionObject;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String newCreatedBy) {
        this.createdBy = newCreatedBy;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void setFwRuleType(int newType) {
        this.fwRuleType = newType;
    }

    public int getFwRuleType() {
        return this.fwRuleType;
    }

    public void setType(int newType) {
        this.type = newType;
    }

    public int getType() {
        return this.type;
    }

    public boolean isInherited() {
        return this.type == 1;
    }

    public Object getValueAt(int row, int column) {
        switch (column) {
            case 0: {
                return row + 1;
            }
            case 1: {
                return this.getEnabled();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getAction();
            }
            case 4: {
                return this.getApplications();
            }
            case 5: {
                return this.getHosts();
            }
            case 6: {
                return this.getProtocolContainers();
            }
            case 7: {
                return this.getTracking();
            }
            case 8: {
                return this.getSeverity();
            }
            case 9: {
                return this.getInterfacesForDisplayInTable();
            }
            case 10: {
                return this.getSchedules();
            }
            case 11: {
                return this.getScreenSaver();
            }
            case 12: {
                return this.getCreatedBy();
            }
            case 13: {
                return this.getDescription();
            }
        }
        return null;
    }

    public Object getValueForMacAt(int row, int column) {
        switch (column) {
            case 0: {
                return row + 1;
            }
            case 1: {
                return this.getEnabled();
            }
            case 2: {
                return this.getName();
            }
            case 3: {
                return this.getAction();
            }
            case 4: {
                return this.getHosts();
            }
            case 5: {
                return this.getProtocolContainers();
            }
            case 6: {
                return this.getTracking();
            }
            case 7: {
                return this.getSeverity();
            }
            case 8: {
                return this.getCreatedBy();
            }
            case 9: {
                return this.getDescription();
            }
        }
        return null;
    }

    public void setValueAt(int row, int column, Object value) {
        switch (column) {
            case 0: {
                this.setNo((Integer)value);
                break;
            }
            case 1: {
                this.setEnabled((Boolean)value);
                break;
            }
            case 2: {
                this.setName((String)value);
                break;
            }
            case 3: {
                this.setAction((String)value);
                break;
            }
            case 4: {
                this.setApplications((ArrayList)Cast.cast((Object)value));
                break;
            }
            case 5: {
                this.setHosts((ArrayList)Cast.cast((Object)value));
                break;
            }
            case 6: {
                this.setProtocolContainers((ArrayList)Cast.cast((Object)value));
                break;
            }
            case 7: {
                break;
            }
            case 8: {
                this.setSeverity((String)value);
                break;
            }
            case 9: {
                this.setInterfaces((ArrayList)Cast.cast((Object)value));
                break;
            }
            case 10: {
                this.setSchedules((ArrayList)Cast.cast((Object)value));
                break;
            }
            case 11: {
                this.setScreenSaver((ScreenSaverObject)value);
                break;
            }
            case 12: {
                this.setCreatedBy((String)value);
                break;
            }
            case 13: {
                this.setDescription((String)value);
                break;
            }
        }
    }

    public void setValueForMacAt(int row, int column, Object value) {
        switch (column) {
            case 0: {
                this.setNo((Integer)value);
                break;
            }
            case 1: {
                this.setEnabled((Boolean)value);
                break;
            }
            case 2: {
                this.setName((String)value);
                break;
            }
            case 3: {
                this.setAction((String)value);
                break;
            }
            case 4: {
                this.setHosts((ArrayList)Cast.cast((Object)value));
                break;
            }
            case 5: {
                this.setProtocolContainers((ArrayList)Cast.cast((Object)value));
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                this.setSeverity((String)value);
                break;
            }
            case 8: {
                this.setCreatedBy((String)value);
                break;
            }
            case 9: {
                this.setDescription((String)value);
                break;
            }
        }
    }

    public boolean isCellEditable(int column, int osType) {
        switch (osType) {
            case 1: {
                return this.isWindowsRuleCellEditable(column);
            }
            case 2: {
                return this.isMacRuleCellEditable(column);
            }
        }
        return false;
    }

    private boolean isWindowsRuleCellEditable(int column) {
        if (LicenseObject.getInstance().isSBProduct() && this.rule.getOptRuleType() != null && !this.rule.getOptRuleType().equals("N")) {
            return false;
        }
        switch (column) {
            case 1: {
                return true;
            }
            case 2: {
                return !this.isInherited();
            }
            case 8: {
                return !this.isInherited();
            }
        }
        return false;
    }

    private boolean isMacRuleCellEditable(int column) {
        if (LicenseObject.getInstance().isSBProduct() && this.rule.getOptRuleType() != null && !this.rule.getOptRuleType().equals("N")) {
            return false;
        }
        switch (column) {
            case 1: {
                return true;
            }
            case 2: {
                return !this.isInherited();
            }
            case 7: {
                return !this.isInherited();
            }
        }
        return false;
    }

    public boolean isSecurityRule() {
        return this.rule.getOptRuleType() != null && !"N".equalsIgnoreCase(this.rule.getOptRuleType()) && !"B".equalsIgnoreCase(this.rule.getOptRuleType());
    }

    public boolean isBelowSecurityRule() {
        return "B".equalsIgnoreCase(this.rule.getOptRuleType());
    }

    public boolean isMediumSecurityRule() {
        return "M".equalsIgnoreCase(this.rule.getOptRuleType());
    }

    public boolean isLowSecurityRule() {
        return "L".equalsIgnoreCase(this.rule.getOptRuleType());
    }

    public boolean isHighSecurityRule() {
        return "H".equalsIgnoreCase(this.rule.getOptRuleType());
    }

    public boolean isNormalRule() {
        return this.rule.getOptRuleType() == null || "N".equalsIgnoreCase(this.rule.getOptRuleType());
    }

    public boolean hasName() {
        String name = this.getName();
        return name != null && name.trim().length() > 0;
    }

    public FirewallRule getFirewallRule() {
        return this.rule;
    }

    @Override
    public CopitableObject getPastedObject() throws ConsoleException {
        WashIDHandler washer = new WashIDHandler();
        HashMap<String, TopLevelObject> createdObj = new HashMap<String, TopLevelObject>();
        try {
            FirewallRule newRule = (FirewallRule)washer.duplicateObject((ConfigObject)this.rule, createdObj);
            FirewallRuleObject newRuleObject = new FirewallRuleObject(newRule);
            newRuleObject.setOsPlatform(this.getOsPlatform());
            return newRuleObject;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public String getRuleType() {
        return this.rule.getOptRuleType();
    }

    public void setRuleType(String ruleType) {
        this.rule.setOptRuleType(ruleType);
    }

    public int getOsPlatform() {
        return this.osPlatform;
    }

    public void setOsPlatform(int osPlatform) {
        this.osPlatform = osPlatform;
    }

    public boolean equals(Object obj) {
        if (obj instanceof FirewallRuleObject) {
            String ruleId = ((FirewallRuleObject)obj).rule.getId();
            return this.rule.getId().equals(ruleId);
        }
        return false;
    }

    public int hashCode() {
        return this.rule.getId().hashCode();
    }
}

