/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.logicobject;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.firewall.logicobject.LabelObject;
import com.sygate.scm.console.util.ConsoleException;
import javax.swing.ImageIcon;

public class ApplicationObject
implements TableRow,
LabelObject {
    private boolean selected = true;
    private Executable executable;
    private static final String MD5 = "MD5:";
    private static final String SHA = "SHA256:";

    public ApplicationObject() {
        this.initialize();
    }

    private void initialize() {
        this.executable = new Executable();
    }

    public ApplicationObject(Executable exec) {
        this.executable = exec;
        this.setName(exec.getOptFileName());
        this.setDescription(exec.getOptFileDescription());
        this.setVersion(exec.getOptVersion());
        this.setSize(exec.getOptFileSize());
        this.setLastModified(exec.getOptFileLastModifiedDate());
        this.setCheckSum(exec.getOptFileMd5Checksum());
        this.setSHACheckSum(exec.getOptFileSHA256Checksum());
    }

    public void delete() {
    }

    public String getName() {
        return this.executable.getOptFileName();
    }

    public void setName(String value) {
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        this.executable.setOptFileName(value);
    }

    public String getDescription() {
        return this.executable.getOptFileDescription();
    }

    public void setDescription(String value) {
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        this.executable.setOptFileDescription(value);
    }

    public String getVersion() {
        return this.executable.getOptVersion();
    }

    public void setVersion(String newValue) {
        String oldValue = this.getVersion();
        if (PolicyHandler.compareTwoObject(oldValue, newValue) != 0) {
            if (newValue == null || newValue.trim().length() == 0) {
                this.executable.setOptVersion(null);
                return;
            }
            this.executable.setOptVersion(newValue);
            return;
        }
    }

    public Long getSize() {
        return this.executable.getOptFileSize();
    }

    public void setSize(Long value) {
        if (value != null && value == -1L) {
            value = null;
        }
        this.executable.setOptFileSize(value);
    }

    public String getLastModified() {
        String dateModified = this.executable.getOptFileLastModifiedDate();
        String date = dateModified;
        if (date == null) {
            return date;
        }
        if (dateModified.trim().length() > 10) {
            date = dateModified.substring(0, 10);
        }
        return date;
    }

    public void setLastModified(String value) {
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        this.executable.setOptFileLastModifiedDate(value);
    }

    public String getCheckSum() {
        return this.executable.getOptFileMd5Checksum();
    }

    public String getCheckSumForEdit() {
        return this.executable.getOptFileMd5Checksum();
    }

    public void setCheckSum(String value) {
        if (value != null && value.trim().length() == 0) {
            value = null;
        }
        this.executable.setOptFileMd5Checksum(value);
    }

    public String getSHACheckSum() {
        if (this.executable.getOptFileSHA256Checksum() != null) {
            return SHA + this.executable.getOptFileSHA256Checksum();
        }
        return this.executable.getOptFileSHA256Checksum();
    }

    public String getSHACheckSumForEdit() {
        return this.executable.getOptFileSHA256Checksum();
    }

    public void setSHACheckSum(String value) {
        if (value != null && value.trim().length() == 0) {
            value = null;
        } else if (value != null && value.trim().length() != 0 && value.indexOf(SHA) != -1) {
            value = value.replaceAll(SHA, "");
        }
        this.executable.setOptFileSHA256Checksum(value);
    }

    public boolean getSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public Object getValueAt(int column) {
        switch (column) {
            case 1: {
                return this.getName();
            }
            case 2: {
                return this.getDescription();
            }
            case 3: {
                return this.getSize();
            }
            case 4: {
                return this.getLastModified();
            }
            case 5: {
                return this.getChecksumType();
            }
            case 6: {
                return this.getSelected();
            }
        }
        return null;
    }

    @Override
    public Class<?> getValueTypeAt(int column) {
        switch (column) {
            case 1: {
                return String.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return Long.class;
            }
            case 4: {
                return String.class;
            }
            case 5: {
                return String.class;
            }
            case 6: {
                return Boolean.class;
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object value, int column) {
        switch (column) {
            case 1: {
                this.setName((String)value);
                break;
            }
            case 2: {
                this.setDescription((String)value);
                break;
            }
            case 3: {
                this.setSize((Long)value);
                break;
            }
            case 4: {
                this.setLastModified((String)value);
                break;
            }
            case 5: {
                this.setCheckSum((String)value);
                break;
            }
            case 6: {
                this.setSelected((Boolean)value);
                break;
            }
        }
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public ImageIcon getIcon() {
        return ConsoleMain.applicationIcon;
    }

    public ApplicationObject getClone() throws ConsoleException {
        try {
            Executable newExecutable = (Executable)PolicyHandler.getCopyOfObj((ConfigObject)this.executable);
            ApplicationObject newObj = new ApplicationObject(newExecutable);
            return newObj;
        }
        catch (ConsoleException cex) {
            throw cex;
        }
        catch (Exception ex) {
            throw new ConsoleException(ex);
        }
    }

    public Executable getExecutable() {
        return this.executable;
    }

    @Override
    public String getText() {
        return this.toString();
    }

    private String getChecksumType() {
        if (this.executable.getOptFileMd5Checksum() != null) {
            return this.getCheckSum();
        }
        if (this.executable.getOptFileSHA256Checksum() != null) {
            return this.getSHACheckSum();
        }
        return null;
    }
}

