/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.logicobject;

import com.sygate.scm.common.configobject.schema.Action;
import com.sygate.scm.common.configobject.schema.LogProcess;
import com.sygate.scm.common.configobject.schema.PacketProcess;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.policy.firewall.logicobject.LabelObject;
import javax.swing.ImageIcon;

public class ActionObject
implements LabelObject {
    private Action action;
    private String packetString;

    public ActionObject(Action action) {
        this.action = action;
        PacketProcess packetProcess = action.getOptPacketProcess();
        LogProcess logProcess = action.getOptLogProcess();
        if (packetProcess == null) {
            packetProcess = new PacketProcess();
            packetProcess.setPacketProcess(PacketProcess.PASS);
            action.setOptPacketProcess(packetProcess);
        }
        if (logProcess == null) {
            logProcess = new LogProcess();
            action.setOptLogProcess(logProcess);
        }
    }

    private Integer getPacketAction(String actionString) {
        if (this.packetString == null) {
            return null;
        }
        if (this.packetString.equals("Ask")) {
            return PacketProcess.ASK;
        }
        if (this.packetString.equals("Allow")) {
            return PacketProcess.PASS;
        }
        if (this.packetString.equals("Block")) {
            return PacketProcess.DROP;
        }
        return null;
    }

    public String getPacketProcessString() {
        PacketProcess packetProcess = this.getPacketProcess();
        if (packetProcess == null) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ActionObject.action.Any");
        }
        String processString = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ActionObject.action.Any");
        Integer process = packetProcess.getPacketProcess();
        if (process.intValue() == PacketProcess.ASK.intValue()) {
            processString = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ActionObject.action.Ask");
        } else if (process.intValue() == PacketProcess.DROP.intValue()) {
            processString = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ActionObject.action.Drop");
        } else if (process.intValue() == PacketProcess.PASS.intValue()) {
            processString = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "ActionObject.action.Allow");
        }
        return processString;
    }

    public void setAction(String actionString) {
        this.packetString = actionString;
        PacketProcess packetProcess = this.getPacketProcess();
        if (packetProcess == null) {
            packetProcess = new PacketProcess();
            if (this.action == null) {
                this.action = new Action();
            }
        }
        packetProcess.setPacketProcess(this.getPacketAction(actionString));
        this.action.setOptPacketProcess(packetProcess);
    }

    public void setAlert(boolean alert) {
        LogProcess logProcess = this.getLogProcess();
        if (logProcess == null) {
            logProcess = new LogProcess();
            if (this.action == null) {
                this.action = new Action();
                this.action.setOptLogProcess(logProcess);
            }
        }
        logProcess.setOptAlert(Boolean.valueOf(alert));
    }

    public void setTrafficLog(boolean trafficLog) {
        LogProcess logProcess = this.getLogProcess();
        if (logProcess == null) {
            logProcess = new LogProcess();
            if (this.action == null) {
                this.action = new Action();
                this.action.setOptLogProcess(logProcess);
            }
        }
        logProcess.setOptLogEvent(Boolean.valueOf(trafficLog));
    }

    public void setPacketLog(boolean packetLog) {
        LogProcess logProcess = this.getLogProcess();
        if (logProcess == null) {
            logProcess = new LogProcess();
            if (this.action == null) {
                this.action = new Action();
                this.action.setOptLogProcess(logProcess);
            }
        }
        logProcess.setOptLogRawTraffic(Boolean.valueOf(packetLog));
    }

    public Boolean getTrafficLog() {
        LogProcess logProcess = this.getLogProcess();
        if (logProcess == null) {
            return false;
        }
        Boolean logEvent = logProcess.getOptLogEvent();
        if (logEvent == null) {
            return false;
        }
        return logEvent;
    }

    public Boolean getPacketLog() {
        LogProcess logProcess = this.getLogProcess();
        if (logProcess == null) {
            return false;
        }
        Boolean trafficLog = logProcess.getOptLogRawTraffic();
        if (trafficLog == null) {
            return false;
        }
        return trafficLog;
    }

    public Boolean getSendEmail() {
        LogProcess logProcess = this.getLogProcess();
        if (logProcess == null) {
            return false;
        }
        Boolean alert = logProcess.getOptAlert();
        if (alert == null) {
            return false;
        }
        return alert;
    }

    private LogProcess getLogProcess() {
        if (this.action == null) {
            return null;
        }
        return this.action.getOptLogProcess();
    }

    public PacketProcess getPacketProcess() {
        if (this.action == null) {
            return null;
        }
        return this.action.getOptPacketProcess();
    }

    public ImageIcon getActionIcon() {
        PacketProcess packetProcess = this.getPacketProcess();
        ImageIcon icon = ConsoleMain.anyIcon;
        if (packetProcess != null) {
            Integer process = packetProcess.getPacketProcess();
            if (process.intValue() == PacketProcess.PASS.intValue()) {
                icon = ConsoleMain.allowIcon;
            } else if (process.intValue() == PacketProcess.DROP.intValue()) {
                icon = ConsoleMain.blockIcon;
            } else if (process.intValue() == PacketProcess.ASK.intValue()) {
                icon = ConsoleMain.askIcon;
            }
            return icon;
        }
        return icon;
    }

    public ImageIcon getLogIcon() {
        LogProcess logProcess = this.getLogProcess();
        ImageIcon icon = ConsoleMain.noneIcon;
        if (logProcess != null) {
            Boolean alert = this.getSendEmail();
            Boolean traffic = this.getTrafficLog();
            Boolean packet = this.getPacketLog();
            if (alert.booleanValue()) {
                icon = ConsoleMain.anyIcon;
            } else if (traffic.booleanValue()) {
                icon = ConsoleMain.trafficAllIcon;
            } else if (packet.booleanValue()) {
                icon = ConsoleMain.packetIcon;
            }
            return icon;
        }
        return icon;
    }

    @Override
    public ImageIcon getIcon() {
        return this.getActionIcon();
    }

    @Override
    public String getText() {
        return this.getPacketProcessString();
    }
}

