/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.schema.RawTcp;
import com.sygate.scm.common.configobject.schema.RawUdp;
import com.sygate.scm.common.firewall.Port;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.firewall.PortNumberFactory;
import com.sygate.scm.console.ui.policy.firewall.dialog.PortNumberPopup;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class TCPProtocolPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] CONNECTION_INITIALIZATION = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.combo.Both"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.combo.Incoming"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.combo.Outgoing")};
    private static final String[] PACKET_DIRECTIONS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.combo.Both"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.combo.Incoming"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.combo.Outgoing")};
    private static final int INDEX_BOTH = 0;
    private static final int INDEX_INCOMING = 1;
    private static final int INDEX_OUTGOING = 2;
    private static final String PORT_VALIDATORS = "1234567890, -";
    private JComboBox<String> ConnectionInitializationCombo;
    private JComboBox<String> packetDirectionCombo;
    private JRadioButton sourceDestinationRadio;
    private JRadioButton localRemoteRadio;
    private JTextField sourcePortTextField;
    private JTextField destinationPortTextField;
    private JLabel sourcePortLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.SourcePort"));
    private JLabel destPortLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.DestinationPort"));
    private JLabel tcpSourcePortExLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.SampleSourceTcpPort"));
    private JLabel tcpDestPortExLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.SampleDestTcpPort"));
    private JLabel udpSourcePortExLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.SampleSourceUdpPort"));
    private JLabel udpDestPortExLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.SampleDestUdpPort"));
    private JButton sourcePortButton;
    private JButton destPortButton;
    private String type = "TCP";
    private ProtocolObject protocolObject;

    public TCPProtocolPanel() {
        this.init();
    }

    public TCPProtocolPanel(String newType) {
        this.type = newType;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.sourcePortLabel.setHorizontalAlignment(2);
        this.destPortLabel.setHorizontalAlignment(2);
        ButtonGroup group = new ButtonGroup();
        group.add(this.getSourceDestinationRadioButton());
        group.add(this.getLocalRemoteRadioButton());
        this.add((Component)this.getSourceDestinationRadioButton(), new GridBagConstraints(0, 0, 1, 1, 0.5, 1.0, 17, 0, new Insets(5, 50, 0, 0), 0, 0));
        this.add((Component)this.getLocalRemoteRadioButton(), new GridBagConstraints(1, 0, 1, 1, 0.5, 1.0, 10, 0, new Insets(5, 5, 0, 50), 0, 0));
        this.add((Component)this.sourcePortLabel, new GridBagConstraints(0, 2, 1, 1, 0.3, 1.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
        this.add((Component)this.getSourcePortTextField(), new GridBagConstraints(1, 2, 1, 1, 0.7, 1.0, 17, 2, new Insets(5, 0, 0, 0), 200, 0));
        this.add((Component)this.getSourcePortsButton(), new GridBagConstraints(2, 2, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 0, 50), 0, 0));
        this.add((Component)this.destPortLabel, new GridBagConstraints(0, 4, 1, 1, 0.3, 1.0, 17, 0, new Insets(5, 10, 0, 0), 20, 0));
        this.add((Component)this.getDestinationPortTextField(), new GridBagConstraints(1, 4, 1, 1, 0.7, 1.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.getDestPortsButton(), new GridBagConstraints(2, 4, 1, 1, 0.0, 1.0, 17, 0, new Insets(5, 5, 0, 50), 0, 0));
        this.getLocalRemoteRadioButton().setSelected(true);
        if (this.type.equals("UDP")) {
            this.add((Component)this.udpSourcePortExLabel, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.udpDestPortExLabel, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            JLabel packetDirectionLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.Direction"));
            this.add((Component)packetDirectionLabel, new GridBagConstraints(0, 5, 1, 1, 0.3, 1.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.add(this.getPacketDirectionCombo(), new GridBagConstraints(1, 5, 1, 1, 0.0, 1.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.getPacketDirectionCombo().setSelectedItem(PACKET_DIRECTIONS[0]);
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.title.UDPProtocol")), BorderFactory.createEmptyBorder(10, 20, 10, 20)));
        } else {
            this.add((Component)this.tcpSourcePortExLabel, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 0, 0), 100, 0));
            this.add((Component)this.tcpDestPortExLabel, new GridBagConstraints(1, 3, 2, 1, 1.0, 1.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            JLabel connectionLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.Direction"));
            this.getConnectionInitializationCombo().setSelectedItem(PACKET_DIRECTIONS[0]);
            this.add((Component)connectionLabel, new GridBagConstraints(0, 5, 1, 1, 0.3, 1.0, 17, 0, new Insets(5, 10, 0, 0), 0, 0));
            this.add(this.getConnectionInitializationCombo(), new GridBagConstraints(1, 5, 1, 1, 0.7, 1.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> this.add((Component)new JTextArea(""), new GridBagConstraints(0, 6, 3, 1, 1.0, 1.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0)));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.title.TCPProtocol")), BorderFactory.createEmptyBorder(10, 20, 10, 20)));
        }
    }

    public boolean updateValues() {
        String sourPort;
        Object protocol = this.getProtocolObject().getProtocol();
        String destPort = this.getDestinationPortTextField().getText().trim();
        if (destPort.length() == 0) {
            destPort = null;
        }
        if ((sourPort = this.getSourcePortTextField().getText().trim()).length() == 0) {
            sourPort = null;
        }
        if (protocol instanceof RawTcp) {
            RawTcp tcp = (RawTcp)protocol;
            if (this.getSourceDestinationRadioButton().isSelected()) {
                tcp.setOptDestinationPort(destPort);
                tcp.setOptSourcePort(sourPort);
                tcp.setOptLocalPort(null);
                tcp.setOptRemotePort(null);
            } else {
                tcp.setOptLocalPort(sourPort);
                tcp.setOptRemotePort(destPort);
                tcp.setOptDestinationPort(null);
                tcp.setOptSourcePort(null);
            }
            int connectionIndex = this.getConnectionInitializationCombo().getSelectedIndex();
            if (connectionIndex == 0) {
                tcp.setOptIncomingCall(null);
            } else if (connectionIndex == 1) {
                tcp.setOptIncomingCall(Boolean.valueOf(true));
            } else if (connectionIndex == 2) {
                tcp.setOptIncomingCall(Boolean.valueOf(false));
            }
        } else if (protocol instanceof RawUdp) {
            RawUdp udp = (RawUdp)protocol;
            if (this.getSourceDestinationRadioButton().isSelected()) {
                udp.setOptDestinationPort(destPort);
                udp.setOptSourcePort(sourPort);
                udp.setOptLocalPort(null);
                udp.setOptRemotePort(null);
            } else {
                udp.setOptLocalPort(sourPort);
                udp.setOptRemotePort(destPort);
                udp.setOptDestinationPort(null);
                udp.setOptSourcePort(null);
            }
            int directionIndex = this.getPacketDirectionCombo().getSelectedIndex();
            udp.setOptIncoming(null);
            if (directionIndex == 1) {
                udp.setOptIncomingCall(Boolean.TRUE);
            } else if (directionIndex == 2) {
                udp.setOptIncomingCall(Boolean.FALSE);
            } else {
                udp.setOptIncomingCall(null);
            }
        }
        return true;
    }

    private void setValues() {
        boolean isSourceOrDestination = false;
        boolean isLocalOrRemote = false;
        String sourcePort = null;
        String destPort = null;
        String localPort = null;
        String remotePort = null;
        String direction = null;
        String connectionInit = null;
        Object protocol = this.getProtocolObject().getProtocol();
        if (protocol instanceof RawTcp) {
            RawTcp tcp = (RawTcp)protocol;
            isSourceOrDestination = tcp.getOptSourcePort() != null || tcp.getOptDestinationPort() != null;
            isLocalOrRemote = tcp.getOptLocalPort() != null || tcp.getOptRemotePort() != null;
            sourcePort = tcp.getOptSourcePort();
            destPort = tcp.getOptDestinationPort();
            localPort = tcp.getOptLocalPort();
            remotePort = tcp.getOptRemotePort();
            Boolean incomingCall = tcp.getOptIncomingCall();
            connectionInit = incomingCall == null ? CONNECTION_INITIALIZATION[0] : (incomingCall.booleanValue() ? CONNECTION_INITIALIZATION[1] : CONNECTION_INITIALIZATION[2]);
        } else if (protocol instanceof RawUdp) {
            RawUdp udp = (RawUdp)protocol;
            isSourceOrDestination = udp.getOptSourcePort() != null || udp.getOptDestinationPort() != null;
            isLocalOrRemote = udp.getOptLocalPort() != null || udp.getOptRemotePort() != null;
            sourcePort = udp.getOptSourcePort();
            destPort = udp.getOptDestinationPort();
            localPort = udp.getOptLocalPort();
            remotePort = udp.getOptRemotePort();
            Boolean incoming = udp.getOptIncoming();
            Boolean incomingCall = udp.getOptIncomingCall();
            direction = incomingCall == null ? (incoming == null ? PACKET_DIRECTIONS[0] : (incoming.booleanValue() ? PACKET_DIRECTIONS[1] : PACKET_DIRECTIONS[2])) : (incomingCall != false ? PACKET_DIRECTIONS[1] : PACKET_DIRECTIONS[2]);
        }
        this.getLocalRemoteRadioButton().setSelected(isLocalOrRemote);
        this.getSourceDestinationRadioButton().setSelected(isSourceOrDestination);
        if (isSourceOrDestination) {
            this.getSourcePortTextField().setText(sourcePort);
            this.getDestinationPortTextField().setText(destPort);
        } else if (isLocalOrRemote) {
            this.getSourcePortTextField().setText(localPort);
            this.getDestinationPortTextField().setText(remotePort);
        }
        this.getPacketDirectionCombo().setSelectedItem(direction);
        this.getConnectionInitializationCombo().setSelectedItem(connectionInit);
    }

    private JComboBox<String> getConnectionInitializationCombo() {
        if (this.ConnectionInitializationCombo == null) {
            this.ConnectionInitializationCombo = new JComboBox<String>(CONNECTION_INITIALIZATION);
            this.ConnectionInitializationCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
        }
        return this.ConnectionInitializationCombo;
    }

    private JComboBox<String> getPacketDirectionCombo() {
        if (this.packetDirectionCombo == null) {
            this.packetDirectionCombo = new JComboBox<String>(PACKET_DIRECTIONS);
        }
        return this.packetDirectionCombo;
    }

    private JTextField getSourcePortTextField() {
        if (this.sourcePortTextField == null) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            doc.setValidator(PORT_VALIDATORS, true);
            this.sourcePortTextField = new JTextField();
            this.sourcePortTextField.setDocument(doc);
        }
        return this.sourcePortTextField;
    }

    private JTextField getDestinationPortTextField() {
        if (this.destinationPortTextField == null) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            doc.setValidator(PORT_VALIDATORS, true);
            this.destinationPortTextField = new JTextField();
            this.destinationPortTextField.setDocument(doc);
        }
        return this.destinationPortTextField;
    }

    private JRadioButton getSourceDestinationRadioButton() {
        if (this.sourceDestinationRadio == null) {
            this.sourceDestinationRadio = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.radio.SourceDest"));
            this.sourceDestinationRadio.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (TCPProtocolPanel.this.sourceDestinationRadio.isSelected()) {
                        TCPProtocolPanel.this.sourcePortLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.SourcePort"));
                        TCPProtocolPanel.this.destPortLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.DestPort"));
                    } else {
                        TCPProtocolPanel.this.sourcePortLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.LocalPort"));
                        TCPProtocolPanel.this.destPortLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.RemotePort"));
                    }
                }
            });
        }
        return this.sourceDestinationRadio;
    }

    private JRadioButton getLocalRemoteRadioButton() {
        if (this.localRemoteRadio == null) {
            this.localRemoteRadio = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.radio.LocalRemote"));
            this.localRemoteRadio.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    if (TCPProtocolPanel.this.sourceDestinationRadio.isSelected()) {
                        TCPProtocolPanel.this.sourcePortLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.SourcePort"));
                        TCPProtocolPanel.this.destPortLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.DestPort"));
                    } else {
                        TCPProtocolPanel.this.sourcePortLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.LocalPort"));
                        TCPProtocolPanel.this.destPortLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.label.RemotePort"));
                    }
                }
            });
        }
        return this.localRemoteRadio;
    }

    private JButton getSourcePortsButton() {
        if (this.sourcePortButton == null) {
            this.sourcePortButton = new JButton(UIText.get(1538));
            this.sourcePortButton.setFont(this.sourcePortButton.getFont().deriveFont(1));
            this.sourcePortButton.setMargin(new Insets(0, 0, 0, 0));
            this.sourcePortButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Vector<Port> ports = TCPProtocolPanel.this.getPortsList();
                    String sourcePorts = TCPProtocolPanel.this.getSourcePortTextField().getText().trim();
                    PortNumberPopup popup = new PortNumberPopup(ports, sourcePorts);
                    popup.setOkAction(TCPProtocolPanel.this.getPortPopupAction(popup, TCPProtocolPanel.this.getSourcePortTextField()));
                    popup.show(TCPProtocolPanel.this.sourcePortButton, e.getX(), e.getY());
                }
            });
        }
        return this.sourcePortButton;
    }

    private JButton getDestPortsButton() {
        if (this.destPortButton == null) {
            this.destPortButton = new JButton(UIText.get(1538));
            this.destPortButton.setFont(this.destPortButton.getFont().deriveFont(1));
            this.destPortButton.setMargin(new Insets(0, 0, 0, 0));
            this.destPortButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Vector<Port> ports = TCPProtocolPanel.this.getPortsList();
                    String selectedPorts = TCPProtocolPanel.this.getDestinationPortTextField().getText().trim();
                    PortNumberPopup popup = new PortNumberPopup(ports, selectedPorts);
                    popup.setOkAction(TCPProtocolPanel.this.getPortPopupAction(popup, TCPProtocolPanel.this.getDestinationPortTextField()));
                    popup.show(TCPProtocolPanel.this.destPortButton, e.getX(), e.getY());
                }
            });
        }
        return this.destPortButton;
    }

    private Vector<Port> getPortsList() {
        Vector<Port> ports = new Vector<Port>();
        try {
            ports = this.type.equals("UDP") ? PortNumberFactory.getUDPPorts() : PortNumberFactory.getTCPPorts();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return ports;
    }

    private Action getPortPopupAction(final PortNumberPopup popup, final JTextField portTextField) {
        return new AbstractAction(UIText.get(3584)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.setVisible(false);
                portTextField.setText(popup.getSelectedPorts());
                portTextField.requestFocus();
            }
        };
    }

    public void setObject(ProtocolObject protocolObject) {
        this.protocolObject = protocolObject;
        this.setValues();
    }

    public ProtocolObject getProtocolObject() {
        if (this.protocolObject == null) {
            if (this.type.equals("TCP")) {
                this.protocolObject = new ProtocolObject(new RawTcp());
            } else if (this.type.equals("UDP")) {
                this.protocolObject = new ProtocolObject(new RawUdp());
            }
        }
        return this.protocolObject;
    }

    public boolean isValidValues() {
        String portNumber1 = this.getSourcePortTextField().getText().trim();
        String portNumber2 = this.getDestinationPortTextField().getText().trim();
        try {
            PortNumberFactory.isValidPortString(portNumber1);
            PortNumberFactory.isValidPortString(portNumber2);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "TCPProtocolPanel.title.InvalidPortNumber"), 0);
            return false;
        }
        return true;
    }
}

