/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.FwNetworkServiceGroup;
import com.sygate.scm.common.configobject.schema.FwProtocolContainer;
import com.sygate.scm.common.configobject.schema.FwServiceTrigger;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.RawTcp;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServiceTypeHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.firewall.Handler.FirewallPolicyHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.ProtocolDialog;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolContainerObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.CheckBoxEditor;
import com.sygate.scm.console.ui.util.renderer.CheckBoxRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class ServiceListDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String[] TABLE_COLUMN_NAME = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.column.Enable"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.column.ServiceName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.column.Content")};
    private static final int[] TABLE_COLUMN_MAP = new int[]{2, 0, 1};
    private static final String DESCRIPTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.description.SelectServicesToTriggerFirewallRule");
    private JTable jTService;
    private Action addAction;
    private Action deleteAction;
    private Action editAction;
    private FwServiceTrigger serviceTrigger;
    private boolean isMacOsRulePanel = false;

    public ServiceListDialog(FwServiceTrigger serviceTrigger, boolean isMacPanel) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.title.ServiceList"), true);
        this.serviceTrigger = serviceTrigger;
        this.isMacOsRulePanel = isMacPanel;
        this.initialize();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_rules_service";
    }

    private void initialize() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getInnerPanel(), "Center");
        this.pack();
        this.setButtonEnabled();
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)new DescriptionTextArea(DESCRIPTION), "North");
        panel.add((Component)this.getTablePanel(), "Center");
        panel.add((Component)this.getButtonPanel(), "South");
        return panel;
    }

    private JPanel getTablePanel() {
        this.setDefaultCloseOperation(2);
        this.initialTable();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JScrollPane(this.jTService), "Center");
        panel.add((Component)this.getTableButtonPanel(), "South");
        return panel;
    }

    private JPanel getTableButtonPanel() {
        this.addAction = new AbstractAction(UIText.get(5)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                ServiceListDialog.this.addProtocol();
            }
        };
        this.deleteAction = new AbstractAction(UIText.get(769)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                ServiceListDialog.this.deleteService();
            }
        };
        this.editAction = new AbstractAction(UIText.get(1024)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                ServiceListDialog.this.editProtocol();
            }
        };
        JButton add = new JButton(this.addAction);
        JButton delete = new JButton(this.deleteAction);
        JButton edit = new JButton(this.editAction);
        JButton[] buttons = new JButton[]{add, edit, delete};
        ButtonPane serviceButtonPanel = new ButtonPane(buttons, 1);
        return serviceButtonPanel;
    }

    private void initialTable() {
        this.jTService = new StripesTable();
        SortableTableModel model = new SortableTableModel(TABLE_COLUMN_NAME, TABLE_COLUMN_MAP){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }
        };
        model.setDataVector(new Vector<TableRow>((Collection)Cast.cast(this.getProtocolContainers())));
        model.addMouseListenerToHeaderInTable(this.jTService);
        this.jTService.setModel(model);
        this.jTService.getSelectionModel().setSelectionMode(0);
        Dimension size = this.jTService.getPreferredScrollableViewportSize();
        this.jTService.setPreferredScrollableViewportSize(new Dimension(size.width, (this.jTService.getRowHeight() + this.jTService.getRowMargin()) * 5 * 2));
        this.jTService.setAutoResizeMode(0);
        this.jTService.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (!ev.getValueIsAdjusting()) {
                    ServiceListDialog.this.setButtonEnabled();
                }
            }
        });
        this.jTService.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                if (ev.getModifiers() == 4) {
                    int rowInt = ServiceListDialog.this.jTService.rowAtPoint(ev.getPoint());
                    ServiceListDialog.this.jTService.setRowSelectionInterval(rowInt, rowInt);
                    new ServiceListPopup().show(ev.getComponent(), ev.getX(), ev.getY());
                } else if (ev.getClickCount() == 2) {
                    ServiceListDialog.this.editProtocol();
                }
            }
        });
        TableColumn column = this.jTService.getColumnModel().getColumn(0);
        column.setCellRenderer(new CheckBoxRenderer(true));
        column.setCellEditor(new CheckBoxEditor(this.jTService){
            private static final long serialVersionUID = 1L;

            @Override
            protected void updateModel(TableModel tableModel, int selIndex) {
                ServiceListDialog.this.updateObject(tableModel, selIndex);
            }
        });
        UIUtilities.resizeColumns(this.jTService, new float[]{0.2f, 0.4f, 0.4f}, size.width);
    }

    private List<ProtocolContainerObject> getProtocolContainers() {
        ProtocolContainerObject protocolConObj;
        ArrayList<Object> pcObjs = new ArrayList();
        try {
            pcObjs = ServiceTypeHandler.getInstance().getServices();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        ArrayList<ProtocolContainerObject> pcContainer = new ArrayList<ProtocolContainerObject>();
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (int i = 0; i < pcObjs.size(); ++i) {
            protocolConObj = (ProtocolContainerObject)pcObjs.get(i);
            protocolConObj.setSelected(false);
            pcContainer.add(i, protocolConObj);
            map.put(protocolConObj.getName(), i);
        }
        pcObjs.clear();
        try {
            pcObjs = FirewallPolicyHandler.getProtocolContainerObjects(this.serviceTrigger, false);
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        int counter = 0;
        for (int i = 0; i < pcObjs.size(); ++i) {
            protocolConObj = (ProtocolContainerObject)pcObjs.get(i);
            String strName = protocolConObj.getName();
            if (StringUtilities.isEmpty((String)strName)) {
                boolean isEnabled = Utility.getBooleanValue((Boolean)protocolConObj.getProtocolContainer().getOptEnable(), (Boolean)protocolConObj.getProtocolContainer().getDefEnable());
                protocolConObj.setSelected(isEnabled);
                pcContainer.add(counter++, protocolConObj);
                continue;
            }
            int index = (Integer)map.get(protocolConObj.getName());
            if (index < 0) continue;
            ((ProtocolContainerObject)pcContainer.get(index + counter)).setSelected(true);
        }
        return pcContainer;
    }

    private void setButtonEnabled() {
        boolean isEnabled;
        int selIndex = this.jTService.getSelectedRow();
        boolean bl = isEnabled = selIndex != -1;
        if (isEnabled) {
            SortableTableModel model = (SortableTableModel)Cast.cast((Object)this.jTService.getModel());
            ProtocolContainerObject pcObject = (ProtocolContainerObject)model.getRow(selIndex);
            isEnabled = pcObject.getType().equals("Custom");
        }
        this.deleteAction.setEnabled(isEnabled);
        this.editAction.setEnabled(isEnabled);
    }

    private void addProtocol() {
        FwProtocolContainer protocolContainer = new FwProtocolContainer();
        ProtocolContainerObject obj = new ProtocolContainerObject(protocolContainer);
        RawTcp rawTcp = new RawTcp();
        ProtocolObject newProtocolObject = new ProtocolObject(rawTcp);
        ProtocolDialog dialog = new ProtocolDialog(this.isMacOsRulePanel);
        dialog.setObject(newProtocolObject);
        if (dialog.isOk()) {
            ProtocolObject protocolObject = dialog.getProtocolObject();
            obj.setName("");
            obj.addProtocolObject(protocolObject);
            if (!obj.isReadOnly()) {
                obj.getProtocolContainer().setOptEnable(Boolean.valueOf(true));
                this.serviceTrigger.addFwProtocolContainer(obj.getProtocolContainer());
                SortableTableModel model = (SortableTableModel)Cast.cast((Object)this.jTService.getModel());
                model.insertRow(0, obj);
                this.jTService.setRowSelectionInterval(0, 0);
            } else {
                this.addObjReference(obj);
            }
        }
    }

    private void editProtocol() {
        block4: {
            if (!this.editAction.isEnabled()) {
                return;
            }
            int index = this.jTService.getSelectedRow();
            SortableTableModel model = (SortableTableModel)Cast.cast((Object)this.jTService.getModel());
            ProtocolContainerObject pcObj = (ProtocolContainerObject)model.getRow(index);
            ProtocolObject oldPcObj = pcObj.getProtocolObjects().get(0);
            try {
                ProtocolObject protocolObjCopy = oldPcObj.getClone();
                ProtocolDialog dialog = new ProtocolDialog(this.isMacOsRulePanel);
                dialog.setObject(protocolObjCopy);
                if (dialog.isOk()) {
                    ProtocolObject newObject = dialog.getProtocolObject();
                    pcObj.setProtocolObject(index, newObject, oldPcObj);
                    this.serviceTrigger.setFwProtocolContainer(index, pcObj.getProtocolContainer());
                    model.setRow(index, pcObj);
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.title.ConsoleError"), 0);
                if (!ex.needRelogin()) break block4;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private void deleteService() {
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.message.ConfirmDeleteService");
        int result = UIUtilities.confirmYesNoOptionDialog(message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.title.DeleteService"));
        if (result == 0) {
            int index = this.jTService.getSelectedRow();
            SortableTableModel model = (SortableTableModel)Cast.cast((Object)this.jTService.getModel());
            ProtocolContainerObject pcObj = (ProtocolContainerObject)model.getRow(index);
            this.serviceTrigger.removeChild((AbstractSchema)pcObj.getProtocolContainer());
            model.removeRow(index);
            int count = this.jTService.getRowCount();
            if (index < count) {
                this.jTService.setRowSelectionInterval(index, index);
            } else if (index != 0) {
                this.jTService.setRowSelectionInterval(index - 1, index - 1);
            }
            this.setButtonEnabled();
        }
    }

    private void updateObject(TableModel tableModel, int selIndex) {
        SortableTableModel model = (SortableTableModel)Cast.cast((Object)tableModel);
        ProtocolContainerObject pcObj = (ProtocolContainerObject)model.getRow(selIndex);
        boolean isSelected = Utility.getBooleanValue((Boolean)pcObj.getProtocolContainer().getOptEnable(), (Boolean)pcObj.getProtocolContainer().getDefEnable());
        if (pcObj.getType().equals("Custom")) {
            pcObj.getProtocolContainer().setOptEnable(Boolean.valueOf(isSelected));
            pcObj.setSelected(isSelected);
            return;
        }
        if (isSelected) {
            this.addObjReference(pcObj);
        } else {
            FwNetworkServiceGroup serviceGroup = pcObj.getServiceGroup();
            String groupId = serviceGroup.getId();
            for (ObjReference ref : this.serviceTrigger.getObjReference()) {
                if (!ref.getTargetId().equals(groupId)) continue;
                this.serviceTrigger.removeObjReference(ref);
            }
        }
    }

    private void addObjReference(ProtocolContainerObject newObject) {
        FwNetworkServiceGroup serviceGroup = newObject.getServiceGroup();
        ObjReference ref = new ObjReference();
        ref.setName("ExternalServiceLink");
        ref.setTargetId(serviceGroup.getId());
        ref.setTargetType(serviceGroup.getObjectTypeName());
        this.serviceTrigger.addObjReference(ref);
    }

    public ArrayList<ProtocolContainerObject> getServiceContainers() {
        ArrayList<ProtocolContainerObject> svContainer = new ArrayList<ProtocolContainerObject>();
        SortableTableModel model = (SortableTableModel)Cast.cast((Object)this.jTService.getModel());
        Vector data = (Vector)Cast.cast(model.getDataVector());
        for (int i = 0; i < data.size(); ++i) {
            ProtocolContainerObject pcObj = (ProtocolContainerObject)data.get(i);
            if (!pcObj.getSelected()) continue;
            svContainer.add(pcObj);
        }
        return svContainer;
    }

    private class ServiceListPopup
    extends JPopupMenu {
        private static final long serialVersionUID = 1L;

        public ServiceListPopup() {
            this.add(ServiceListDialog.this.addAction);
            this.add(ServiceListDialog.this.deleteAction);
            this.add(ServiceListDialog.this.editAction);
        }
    }
}

