/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.FwNetworkServiceGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkServicePool;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.ObjectPool;
import com.sygate.scm.common.configobject.schema.RawTcp;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.firewall.dialog.ProtocolDialog;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolContainerObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ServiceDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String[] TABLE_COLUMN_NAME = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.column.ProtocolType"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.column.Content")};
    private JTextField jTFName = new JTextField(30);
    private SortableTableModel tableModel = new SortableTableModel();
    private JTable jTProtocol = new StripesTable(this.tableModel);
    private JButton jBAdd = new JButton(UIText.get(5));
    private JButton jBDelete = new JButton(UIText.get(769));
    private JButton jBEdit = new JButton(UIText.get(1024));
    private ProtocolContainerObject pcObj;

    public ServiceDialog(ProtocolContainerObject pcObj) {
        this(pcObj, false);
    }

    public ServiceDialog(ProtocolContainerObject pcObj, boolean isCheckPolicyEnforcement) {
        super(Manager.getFrame(), "", true);
        this.setTitle(this.createTitle(isCheckPolicyEnforcement));
        this.initialize(isCheckPolicyEnforcement);
        this.setData(pcObj);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    public ProtocolContainerObject getProtocolContainerObject() {
        return this.pcObj;
    }

    @Override
    protected boolean isValidate() {
        String newName = this.jTFName.getText().trim();
        boolean isValid = true;
        String message = "";
        if (newName.length() == 0) {
            message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.message.NameRequired");
            isValid = false;
        } else {
            try {
                if (this.isNameDuplicate(newName)) {
                    message = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.message.NamedServiceExists"), newName);
                    isValid = false;
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.title.ConsoleError"), 0);
                if (ex.needRelogin()) {
                    Manager.getFrame().showLoginPanel();
                }
                return false;
            }
        }
        if (!isValid) {
            JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.title.InvalidName"), 0);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ServiceDialog.this.jTFName.requestFocus();
                }
            });
            return false;
        }
        Vector<TableRow> protocols = this.tableModel.getDataVector();
        if (protocols.size() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.message.SpecifyProtocol"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.title.InvalidNetworkService"), 0);
            return false;
        }
        return true;
    }

    protected boolean isNameDuplicate(String newName) throws ConsoleException {
        SemDomain currentDomain = DataobjectManager.getInstance().getCurrentSemDomain();
        ObjectPool objectPool = currentDomain.getObjectPool();
        FwNetworkServicePool networkServicePool = objectPool.getOptFwNetworkServicePool();
        if (networkServicePool == null) {
            return false;
        }
        int serviceCount = networkServicePool.getObjReferenceCount();
        for (int i = 0; i < serviceCount; ++i) {
            String displayName;
            String type;
            ObjReference ref = networkServicePool.getObjReference(i);
            if (ref == null || (type = ref.getTargetType()) != null && !type.equals("FwNetworkServiceGroup")) continue;
            String targetId = ref.getTargetId();
            TopLevelObject serviceObj = DataobjectManager.getInstance().getObjectByGUID(type, targetId);
            if (serviceObj == null) continue;
            String name = ((FwNetworkServiceGroup)serviceObj).getName();
            String string = displayName = ((FwNetworkServiceGroup)serviceObj).getOptDisplayName() == null ? ((FwNetworkServiceGroup)serviceObj).getName() : ((FwNetworkServiceGroup)serviceObj).getOptDisplayName();
            if ((name == null || !name.equals(newName)) && (displayName == null || !displayName.equals(newName))) continue;
            FwNetworkServiceGroup currentServiceObj = this.pcObj.getServiceGroup();
            String currentTargetId = currentServiceObj.getId();
            return !currentTargetId.equals(targetId);
        }
        return false;
    }

    @Override
    protected void commit() {
        this.pcObj.setName(this.jTFName.getText().trim());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_network_services_add_network_services";
    }

    private void initialize(boolean isCheckPolicyEnforcement) {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getInnerPanel(), "Center");
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (isCheckPolicyEnforcement && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.jTFName.setEnabled(false);
            this.jTProtocol.setEnabled(false);
            this.jBAdd.setEnabled(false);
            this.jBEdit.setEnabled(false);
            this.jBDelete.setEnabled(false);
            this.jBOk.setEnabled(false);
        }
        this.pack();
        this.setButtonEnabled();
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.add((Component)this.getTopPanel(), "North");
        panel.add((Component)this.getTablePanel(), "Center");
        panel.add((Component)this.getButtonPanel(), "South");
        return panel;
    }

    private JPanel getTopPanel() {
        RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
        doc.setValidator("\"/\\*?<>|:", false);
        this.jTFName.setDocument(doc);
        JPanel panel = new JPanel(new BorderLayout(10, 0));
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.label.ServiceName")), "West");
        panel.add((Component)this.jTFName, "Center");
        return panel;
    }

    private JPanel getTablePanel() {
        this.initProtocolTable();
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.title.Protocols")), BorderFactory.createEmptyBorder(5, 5, 5, 5))));
        panel.add((Component)new JScrollPane(this.jTProtocol), "Center");
        panel.add((Component)this.getTableButtonsPanel(), "South");
        return panel;
    }

    private JPanel getTableButtonsPanel() {
        this.jBAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceDialog.this.addProtocol();
            }
        });
        this.jBDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceDialog.this.deleteProtocol();
            }
        });
        this.jBEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ServiceDialog.this.editProtocol();
            }
        });
        JPanel panel = new JPanel();
        UIUtilities.layoutButtonPanel(panel, new JButton[]{this.jBAdd, this.jBEdit, this.jBDelete}, 0, 4, true, false);
        return panel;
    }

    private void initProtocolTable() {
        this.tableModel.setColumnNames(TABLE_COLUMN_NAME);
        this.tableModel.addMouseListenerToHeaderInTable(this.jTProtocol);
        this.jTProtocol.setSelectionMode(0);
        Dimension size = this.jTProtocol.getPreferredScrollableViewportSize();
        this.jTProtocol.setPreferredScrollableViewportSize(new Dimension(size.width, (this.jTProtocol.getRowHeight() + this.jTProtocol.getRowMargin()) * 5 * 2));
        this.jTProtocol.setAutoResizeMode(0);
        this.jTProtocol.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ServiceDialog.this.setButtonEnabled();
            }
        });
        this.jTProtocol.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (ServiceDialog.this.jTProtocol.isEnabled() && e.getClickCount() == 2) {
                    ServiceDialog.this.editProtocol();
                }
            }
        });
        UIUtilities.resizeColumns(this.jTProtocol, new float[]{0.5f, 0.5f}, size.width);
    }

    private void setData(ProtocolContainerObject pcObj) {
        this.pcObj = pcObj;
        this.tableModel.setDataVector(new Vector<TableRow>(pcObj.getProtocolObjects()));
        this.jTFName.setText(pcObj.getName());
    }

    private void addProtocol() {
        RawTcp rawTcp = new RawTcp();
        ProtocolObject newProtocolObject = new ProtocolObject(rawTcp);
        ProtocolDialog dialog = new ProtocolDialog();
        dialog.setObject(newProtocolObject);
        if (dialog.isOk()) {
            ProtocolObject protocolObject = dialog.getProtocolObject();
            this.pcObj.addProtocolObject(protocolObject);
            this.tableModel.addRow(protocolObject);
            int rowCount = this.jTProtocol.getRowCount();
            this.jTProtocol.setRowSelectionInterval(rowCount - 1, rowCount - 1);
            this.setButtonEnabled();
        }
    }

    private void editProtocol() {
        block4: {
            int index = this.jTProtocol.getSelectedRow();
            if (index == -1) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.message.SelectProtocolForEdit"));
                return;
            }
            ProtocolObject protocolObject = (ProtocolObject)this.tableModel.getRow(index);
            try {
                ProtocolObject protocolObjCopy = protocolObject.getClone();
                ProtocolDialog dialog = new ProtocolDialog();
                dialog.setObject(protocolObjCopy);
                if (dialog.isOk()) {
                    ProtocolObject newObject = dialog.getProtocolObject();
                    this.pcObj.setProtocolObject(index, newObject, protocolObject);
                    this.tableModel.setRow(index, newObject);
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.title.ConsoleError"), 0);
                if (!ex.needRelogin()) break block4;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private void deleteProtocol() {
        int index = this.jTProtocol.getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.message.SelectProtocolForDelete"));
            return;
        }
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.message.ConfirmDeleteProtocol");
        int result = UIUtilities.confirmYesNoOptionDialog(message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.title.DeleteProtocol"));
        if (result == 0) {
            ProtocolObject protocolObject = (ProtocolObject)this.tableModel.getRow(index);
            this.pcObj.deleteProtocolObject(protocolObject);
            this.tableModel.removeRow(index);
            int count = this.jTProtocol.getRowCount();
            if (index < count) {
                this.jTProtocol.setRowSelectionInterval(index, index);
            } else if (index != 0) {
                this.jTProtocol.setRowSelectionInterval(index - 1, index - 1);
            }
            this.setButtonEnabled();
        }
    }

    private void setButtonEnabled() {
        boolean isEnabled = this.jTProtocol.isEnabled() && this.jTProtocol.getSelectedRowCount() > 0;
        this.jBDelete.setEnabled(isEnabled);
        this.jBEdit.setEnabled(isEnabled);
    }

    private String createTitle(boolean isCheckPolicyEnforcement) {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (isCheckPolicyEnforcement && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.readOnlyTitle");
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.title");
    }
}

