/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.FwNetworkServiceGroup;
import com.sygate.scm.common.configobject.schema.FwProtocolContainer;
import com.sygate.scm.common.configobject.schema.FwServiceTrigger;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.RawEthernet;
import com.sygate.scm.common.configobject.schema.RawIcmp;
import com.sygate.scm.common.configobject.schema.RawIcmpv6;
import com.sygate.scm.common.configobject.schema.RawIp;
import com.sygate.scm.common.configobject.schema.RawTcp;
import com.sygate.scm.common.configobject.schema.RawUdp;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.ServiceTypeHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.dialog.WizardListener;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.ConfigureRuleLoggingPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.FirewallRuleHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.ProtocolDialog;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolContainerObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.CheckBoxEditor;
import com.sygate.scm.console.ui.util.renderer.CheckBoxRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class SelectRuleNetworkServicePanel
extends JPanel
implements WizardPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] PROTOCOL_TYPES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.TCP"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.UDP"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.ICMP"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.ICMPv6"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.IP"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.Ethernet")};
    private static final String[] PROTOCOL_TYPES_MAC = new String[5];
    private static final String[] COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleNetworkServicePanel.column.Enable"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleNetworkServicePanel.column.ServiceName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleNetworkServicePanel.column.Communications")};
    private static final int[] COL_MAPPING = new int[]{2, 0, 1};
    private WizardPanel previousPanel = null;
    private WizardPanel nextPanel = null;
    private JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleNetworkServicePanel.label.DoYouWantToApplyToAllOrSelected"));
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton allNetworkServices = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleNetworkServicePanel.radio.AllNetworkServices"));
    private JRadioButton selectedNetworkServices = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleNetworkServicePanel.radio.SelectedApplications"));
    private JRadioButton selectedProtocolType = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleNetworkServicePanel.radio.SelectedProtocolType"));
    private JComboBox<String> protocolTypesCombo;
    private JPanel buttonPanel = null;
    private JButton addBtn = new JButton(UIText.get(5));
    private JButton deleteBtn = new JButton(UIText.get(769));
    private JButton editBtn = new JButton(UIText.get(1024));
    private FwServiceTrigger serviceTrigger;
    private ArrayList<ProtocolContainerObject> protocolContainers;
    private JScrollPane resultScrollPane = new JScrollPane();
    private JTable resultTable = null;
    private SortableTableModel resultModel = null;
    private boolean isMacOsRulePanel = false;

    public SelectRuleNetworkServicePanel(boolean isMacPanel) {
        this.isMacOsRulePanel = isMacPanel;
        System.arraycopy(PROTOCOL_TYPES, 0, PROTOCOL_TYPES_MAC, 0, 5);
        this.initialize();
    }

    private void initialize() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleNetworkServicePanel.title.ServiceInformation");
        String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleNetworkServicePanel.description.ServiceInformation");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        this.setLayout(new GridBagLayout());
        this.add((Component)headPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.initializeTable();
        ActionListener radioButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectRuleNetworkServicePanel.this.radioSelectionChanged();
            }
        };
        this.allNetworkServices.addActionListener(radioButtonActionListener);
        this.selectedNetworkServices.addActionListener(radioButtonActionListener);
        this.selectedProtocolType.addActionListener(radioButtonActionListener);
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectRuleNetworkServicePanel.this.addProtocol();
            }
        });
        this.deleteBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectRuleNetworkServicePanel.this.deleteService();
            }
        });
        this.editBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectRuleNetworkServicePanel.this.editProtocol();
            }
        });
        this.buttonPanel = UIUtilities.getButtonPanel(new JButton[]{this.addBtn, this.editBtn, this.deleteBtn}, 0, 4, true);
        this.allNetworkServices.setSelected(true);
        this.buttonGroup.add(this.allNetworkServices);
        this.buttonGroup.add(this.selectedNetworkServices);
        this.buttonGroup.add(this.selectedProtocolType);
        panel.add((Component)this.label, this.getGridBagConstaint(0, 0));
        panel.add((Component)this.allNetworkServices, this.getGridBagConstaint(0, 1));
        JPanel parentPanel = UIUtilities.getPanel(new JComponent[]{this.selectedProtocolType, this.getProtocolTypesCombo()}, 0);
        panel.add((Component)parentPanel, this.getGridBagConstaint(0, 2));
        panel.add((Component)this.selectedNetworkServices, this.getGridBagConstaint(0, 3));
        panel.add((Component)this.resultScrollPane, this.getGridBagConstaint(0, 4));
        panel.add((Component)this.buttonPanel, this.getGridBagConstaint(0, 5));
        this.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(40, 40, 0, 40), 0, 0));
        this.radioSelectionChanged();
        this.nextPanel = new ConfigureRuleLoggingPanel();
        this.nextPanel.setPreviousPanel(this);
    }

    public void addData() {
        FirewallRuleHandler firewallRuleHandler = FirewallRuleHandler.getInstance();
        if (this.allNetworkServices.isSelected()) {
            firewallRuleHandler.setServiceSelectionIndex(0);
        } else if (this.selectedNetworkServices.isSelected()) {
            firewallRuleHandler.setServiceSelectionIndex(3);
        } else if (this.selectedProtocolType.isSelected()) {
            firewallRuleHandler.setServiceSelectionIndex(2);
        }
        if (this.selectedNetworkServices.isSelected()) {
            firewallRuleHandler.setServiceTrigger(this.getServiceTrigger());
            firewallRuleHandler.setProtocolContainers(this.getProtocolContainers());
        } else if (this.selectedProtocolType.isSelected()) {
            FwProtocolContainer protocolContainer = new FwProtocolContainer();
            ProtocolContainerObject protocolContainerObj = new ProtocolContainerObject(protocolContainer);
            Object protocol = this.getRawProtocolObject();
            ProtocolObject protocolObject = new ProtocolObject(protocol);
            protocolContainerObj.setName("");
            protocolContainerObj.addProtocolObject(protocolObject);
            protocolContainerObj.getProtocolContainer().setOptEnable(Boolean.valueOf(true));
            FwServiceTrigger singleServiceTrigger = new FwServiceTrigger();
            singleServiceTrigger.addFwProtocolContainer(protocolContainerObj.getProtocolContainer());
            ArrayList<ProtocolContainerObject> singleProtocolContainer = new ArrayList<ProtocolContainerObject>(1);
            singleProtocolContainer.add(protocolContainerObj);
            firewallRuleHandler.setServiceTrigger(singleServiceTrigger);
            firewallRuleHandler.setProtocolContainers(singleProtocolContainer);
        }
    }

    @Override
    public void addListener(WizardListener listener) {
    }

    @Override
    public void removeListener(WizardListener listener) {
    }

    private void initializeTable() {
        this.resultTable = new StripesTable();
        this.resultModel = new SortableTableModel(){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int col) {
                return col == 0;
            }
        };
        this.resultModel.setColumnNames(COL_NAMES);
        this.resultModel.setColumnMapping(COL_MAPPING);
        this.resultModel.setEditMode(false);
        this.resultModel.setDataVector(new Vector<TableRow>(this.getAllProtocolContainers()));
        this.resultTable.setModel(this.resultModel);
        this.resultModel.addMouseListenerToHeaderInTable(this.resultTable);
        this.resultTable.setAutoResizeMode(4);
        this.resultTable.setShowGrid(true);
        UiUtilities.setupScrollPane((JScrollPane)this.resultScrollPane, (JTable)this.resultTable);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        this.resultScrollPane.setPreferredSize(new Dimension(300, 150));
        this.resultScrollPane.setMinimumSize(new Dimension(300, 150));
        float[] colSizes = new float[]{0.1f, 0.3f, 0.55f};
        int width = this.resultScrollPane.getWidth();
        if (width == 0) {
            width = 445;
        }
        UIUtilities.resizeColumns(this.resultTable, colSizes, width);
        this.resultTable.getSelectionModel().setSelectionMode(0);
        this.resultTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent ev) {
                if (!ev.getValueIsAdjusting()) {
                    SelectRuleNetworkServicePanel.this.setButtonEnabled();
                }
            }
        });
        this.resultTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                if (ev.getModifiers() == 4) {
                    int rowInt = SelectRuleNetworkServicePanel.this.resultTable.rowAtPoint(ev.getPoint());
                    SelectRuleNetworkServicePanel.this.resultTable.setRowSelectionInterval(rowInt, rowInt);
                } else if (ev.getClickCount() == 2) {
                    SelectRuleNetworkServicePanel.this.editProtocol();
                }
            }
        });
        TableColumn column = this.resultTable.getColumnModel().getColumn(0);
        column.setCellRenderer(new CheckBoxRenderer(true));
        column.setCellEditor(new CheckBoxEditor(this.resultTable){
            private static final long serialVersionUID = 1L;

            @Override
            protected void updateModel(TableModel tableModel, int selIndex) {
                SelectRuleNetworkServicePanel.this.updateObject(tableModel, selIndex);
            }
        });
        pane.add((Component)this.resultScrollPane, "Center");
    }

    private GridBagConstraints getGridBagConstaint(int gridX, int gridY) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = gridX;
        cons.gridy = gridY;
        int left = 2;
        int bottom = 2;
        cons.anchor = 17;
        cons.fill = 2;
        cons.weightx = 1.0;
        switch (gridY) {
            case 0: {
                bottom = 10;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                left += 10;
                break;
            }
            case 4: {
                cons.weighty = 1.0;
                cons.fill = 1;
                left += 30;
                break;
            }
            case 5: {
                left += 20;
                break;
            }
        }
        int right = 2;
        int top = 2;
        cons.insets = new Insets(top, left, bottom, right);
        return cons;
    }

    private FwServiceTrigger getServiceTrigger() {
        if (this.serviceTrigger == null) {
            this.serviceTrigger = new FwServiceTrigger();
        }
        return this.serviceTrigger;
    }

    private ArrayList<ProtocolContainerObject> getProtocolContainers() {
        this.protocolContainers = new ArrayList();
        Vector<TableRow> data = ((SortableTableModel)this.resultTable.getModel()).getDataVector();
        for (int i = 0; i < data.size(); ++i) {
            ProtocolContainerObject pcObj = (ProtocolContainerObject)data.get(i);
            if (!pcObj.getSelected() && (pcObj.getName() == null || pcObj.getName().length() != 0)) continue;
            this.protocolContainers.add(pcObj);
        }
        return this.protocolContainers;
    }

    private int getSelectedServicesCount() {
        int count = 0;
        Vector<TableRow> data = ((SortableTableModel)this.resultTable.getModel()).getDataVector();
        for (int i = 0; i < data.size(); ++i) {
            ProtocolContainerObject pcObj = (ProtocolContainerObject)data.get(i);
            if (!pcObj.getSelected()) continue;
            ++count;
        }
        return count;
    }

    private JComboBox<String> getProtocolTypesCombo() {
        if (this.protocolTypesCombo == null) {
            this.protocolTypesCombo = !this.isMacOsRulePanel ? new JComboBox<String>(PROTOCOL_TYPES) : new JComboBox<String>(PROTOCOL_TYPES_MAC);
            this.protocolTypesCombo.setBounds(150, 10, 200, 20);
        }
        return this.protocolTypesCombo;
    }

    private Object getRawProtocolObject() {
        RawTcp protocol;
        int selectedIndex = this.getProtocolTypesCombo().getSelectedIndex();
        switch (selectedIndex) {
            case 0: {
                RawTcp rawTcp = new RawTcp(true);
                rawTcp.setOptIncomingCall(null);
                protocol = rawTcp;
                break;
            }
            case 1: {
                RawUdp rawUdp = new RawUdp(true);
                rawUdp.setOptIncomingCall(null);
                protocol = rawUdp;
                break;
            }
            case 2: {
                RawIcmp rawIcmp = new RawIcmp(true);
                rawIcmp.setOptIncoming(null);
                protocol = rawIcmp;
                break;
            }
            case 3: {
                RawIcmpv6 rawIcmpv6 = new RawIcmpv6(true);
                rawIcmpv6.setOptIncoming(null);
                protocol = rawIcmpv6;
                break;
            }
            case 4: {
                RawIp rawIp = new RawIp(true);
                rawIp.setOptIncoming(null);
                protocol = rawIp;
                break;
            }
            case 5: {
                RawEthernet rawEthernet = new RawEthernet(true);
                rawEthernet.setOptIncoming(null);
                protocol = rawEthernet;
                break;
            }
            default: {
                protocol = null;
            }
        }
        return protocol;
    }

    private List<ProtocolContainerObject> getAllProtocolContainers() {
        ArrayList<Object> pcObjs = new ArrayList();
        try {
            pcObjs = ServiceTypeHandler.getInstance().getServices();
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        ArrayList<ProtocolContainerObject> pcContainer = new ArrayList<ProtocolContainerObject>();
        for (int i = 0; i < pcObjs.size(); ++i) {
            ProtocolContainerObject protocolConObj = (ProtocolContainerObject)pcObjs.get(i);
            protocolConObj.setSelected(false);
            pcContainer.add(i, protocolConObj);
        }
        return pcContainer;
    }

    private void radioSelectionChanged() {
        if (this.selectedNetworkServices.isSelected()) {
            this.resultTable.setEnabled(true);
            this.addBtn.setEnabled(true);
            this.deleteBtn.setEnabled(true);
            this.editBtn.setEnabled(true);
            this.getProtocolTypesCombo().setEnabled(false);
            this.setButtonEnabled();
        } else if (this.selectedProtocolType.isSelected()) {
            this.resultTable.setEnabled(false);
            this.addBtn.setEnabled(false);
            this.deleteBtn.setEnabled(false);
            this.editBtn.setEnabled(false);
            this.getProtocolTypesCombo().setEnabled(true);
        } else {
            this.resultTable.setEnabled(false);
            this.addBtn.setEnabled(false);
            this.deleteBtn.setEnabled(false);
            this.editBtn.setEnabled(false);
            this.getProtocolTypesCombo().setEnabled(false);
        }
    }

    private void setButtonEnabled() {
        boolean isEnabled;
        int selIndex = this.resultTable.getSelectedRow();
        boolean bl = isEnabled = selIndex != -1;
        if (isEnabled) {
            SortableTableModel model = (SortableTableModel)this.resultTable.getModel();
            ProtocolContainerObject pcObject = (ProtocolContainerObject)model.getRow(selIndex);
            isEnabled = pcObject.getType().equals("Custom");
        }
        this.deleteBtn.setEnabled(isEnabled);
        this.editBtn.setEnabled(isEnabled);
    }

    private void addProtocol() {
        FwProtocolContainer protocolContainer = new FwProtocolContainer();
        ProtocolContainerObject obj = new ProtocolContainerObject(protocolContainer);
        RawTcp rawTcp = new RawTcp();
        ProtocolObject newProtocolObject = new ProtocolObject(rawTcp);
        ProtocolDialog dialog = new ProtocolDialog(this.isMacOsRulePanel);
        dialog.setObject(newProtocolObject);
        if (dialog.isOk()) {
            ProtocolObject protocolObject = dialog.getProtocolObject();
            obj.setName("");
            obj.addProtocolObject(protocolObject);
            if (!obj.isReadOnly()) {
                obj.getProtocolContainer().setOptEnable(Boolean.valueOf(true));
                this.getServiceTrigger().addFwProtocolContainer(obj.getProtocolContainer());
                ((SortableTableModel)this.resultTable.getModel()).insertRow(0, obj);
                this.resultTable.setRowSelectionInterval(0, 0);
            } else {
                this.addObjReference(obj);
            }
        }
    }

    private void editProtocol() {
        block4: {
            if (!this.editBtn.isEnabled()) {
                return;
            }
            int index = this.resultTable.getSelectedRow();
            SortableTableModel model = (SortableTableModel)this.resultTable.getModel();
            ProtocolContainerObject pcObj = (ProtocolContainerObject)model.getRow(index);
            ProtocolObject oldPcObj = pcObj.getProtocolObjects().get(0);
            try {
                ProtocolObject protocolObjCopy = oldPcObj.getClone();
                ProtocolDialog dialog = new ProtocolDialog();
                dialog.setObject(protocolObjCopy);
                if (dialog.isOk()) {
                    ProtocolObject newObject = dialog.getProtocolObject();
                    pcObj.setProtocolObject(0, newObject, oldPcObj);
                    model.setRow(index, pcObj);
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.title.ConsoleError"), 0);
                if (!ex.needRelogin()) break block4;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private void deleteService() {
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.message.ConfirmDeleteService");
        int result = UIUtilities.confirmYesNoOptionDialog(message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.title.DeleteService"));
        if (result == 0) {
            int index = this.resultTable.getSelectedRow();
            SortableTableModel model = (SortableTableModel)this.resultTable.getModel();
            ProtocolContainerObject pcObj = (ProtocolContainerObject)model.getRow(index);
            this.getServiceTrigger().removeChild((AbstractSchema)pcObj.getProtocolContainer());
            model.removeRow(index);
            int count = this.resultTable.getRowCount();
            if (index < count) {
                this.resultTable.setRowSelectionInterval(index, index);
            } else if (index != 0) {
                this.resultTable.setRowSelectionInterval(index - 1, index - 1);
            }
            this.setButtonEnabled();
        }
    }

    private void updateObject(TableModel tableModel, int selIndex) {
        SortableTableModel model = (SortableTableModel)tableModel;
        ProtocolContainerObject pcObj = (ProtocolContainerObject)model.getRow(selIndex);
        boolean isSelected = Utility.getBooleanValue((Boolean)pcObj.getProtocolContainer().getOptEnable(), (Boolean)pcObj.getProtocolContainer().getDefEnable());
        if (pcObj.getType().equals("Custom")) {
            pcObj.getProtocolContainer().setOptEnable(Boolean.valueOf(isSelected));
            pcObj.setSelected(isSelected);
            return;
        }
        if (isSelected) {
            this.addObjReference(pcObj);
        } else {
            FwNetworkServiceGroup serviceGroup = pcObj.getServiceGroup();
            String groupId = serviceGroup.getId();
            Vector objReferences = this.getServiceTrigger().getObjReference();
            int count = objReferences.size();
            for (int i = 0; i < count; ++i) {
                ObjReference ref = (ObjReference)objReferences.get(i);
                if (!ref.getTargetId().equals(groupId)) continue;
                this.getServiceTrigger().removeObjReference(ref);
            }
        }
    }

    private void addObjReference(ProtocolContainerObject newObject) {
        FwNetworkServiceGroup serviceGroup = newObject.getServiceGroup();
        ObjReference ref = new ObjReference();
        ref.setName("ExternalServiceLink");
        ref.setTargetId(serviceGroup.getId());
        ref.setTargetType(serviceGroup.getObjectTypeName());
        this.getServiceTrigger().addObjReference(ref);
    }

    public boolean isValidData() {
        if (this.selectedNetworkServices.isSelected() && this.getSelectedServicesCount() == 0) {
            String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleNetworkServicePanel.message.SelectAtLeastOne");
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleNetworkServicePanel.message.title.Information");
            JOptionPane.showMessageDialog(Manager.getFrame(), message, title, 1);
            return false;
        }
        return true;
    }

    @Override
    public WizardPanel getNextPanel() {
        return this.nextPanel;
    }

    @Override
    public WizardPanel getPreviousPanel() {
        return this.previousPanel;
    }

    @Override
    public void setPreviousPanel(WizardPanel panel) {
        this.previousPanel = panel;
    }

    @Override
    public Dimension getWizardPreferredSize() {
        return this.getPreferredSize();
    }

    public void setProtocolContainers(ArrayList<ProtocolContainerObject> protocolContainers) {
        this.protocolContainers = protocolContainers;
    }

    public void setServiceTrigger(FwServiceTrigger serviceTrigger) {
        this.serviceTrigger = serviceTrigger;
    }
}

