/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.FwHostTrigger;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.RemoteHostTrigger;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.dialog.WizardListener;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.FirewallRuleHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostDialog;
import com.sygate.scm.console.ui.policy.firewall.dialog.SelectRuleNetworkServicePanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostContainerObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostEnableObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class SelectRuleHostPanel
extends JPanel
implements WizardPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.column.Host")};
    private static final int[] COL_MAPPING = new int[]{1};
    private WizardPanel previousPanel = null;
    private WizardPanel nextPanel = null;
    private boolean isSBE = LicenseObject.getInstance().isSBProduct();
    private JLabel label = new JLabel();
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton anyHost = null;
    private JRadioButton selectedHosts = null;
    private JButton addBtn = new JButton(UIText.get(5));
    private JButton removeBtn = new JButton(UIText.get(4354));
    private JTable resultTable = new StripesTable();
    private JScrollPane resultScrollPane = new JScrollPane();
    private SortableTableModel resultModel = new SortableTableModel();
    private HostContainerObject containerObject = null;
    private FwHostTrigger hostTrigger = null;
    private boolean isMacOsRulePanel = false;

    public SelectRuleHostPanel() {
        this(false);
    }

    public SelectRuleHostPanel(boolean isMacPanel) {
        this.isMacOsRulePanel = isMacPanel;
        this.initialize();
        this.containerObject = null;
        RemoteHostTrigger remoteTrigger = new RemoteHostTrigger();
        FwHostContainer remoteContainer = new FwHostContainer();
        remoteTrigger.addFwHostContainer(remoteContainer);
        this.hostTrigger = new FwHostTrigger();
        this.hostTrigger.setOptRemoteHostTrigger(remoteTrigger);
        this.containerObject = new HostContainerObject(remoteContainer, 3);
    }

    public void refresh() {
        if (this.isSBE) {
            if (FirewallRuleHandler.getInstance().getRuleAction() == 1) {
                this.label.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.label.DoYouWantToAllowToAllOrSelected.SBE"));
            } else if (FirewallRuleHandler.getInstance().getRuleAction() == 2) {
                this.label.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.label.DoYouWantToBlockToAllOrSelected.SBE"));
            } else {
                this.label.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.label.DoYouWantToAskToAllOrSelected.SBE"));
            }
        } else if (FirewallRuleHandler.getInstance().getRuleAction() == 1) {
            this.label.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.label.DoYouWantToAllowToAllOrSelected"));
        } else if (FirewallRuleHandler.getInstance().getRuleAction() == 2) {
            this.label.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.label.DoYouWantToBlockToAllOrSelected"));
        } else {
            this.label.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.label.DoYouWantToAskToAllOrSelected"));
        }
    }

    public void addData() {
        FirewallRuleHandler.getInstance().setApplyToSelectedHosts(this.selectedHosts.isSelected());
        if (this.selectedHosts.isSelected()) {
            FirewallRuleHandler.getInstance().removeAllHostObjects();
            FirewallRuleHandler.getInstance().addAllHostObjects((Collection)Cast.cast(this.resultModel.getDataVector()));
            FirewallRuleHandler.getInstance().setHostTrigger(this.hostTrigger);
        }
    }

    @Override
    public void addListener(WizardListener listener) {
    }

    @Override
    public void removeListener(WizardListener listener) {
    }

    private void initialize() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.title.HostInformation");
        String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.description.HostInformation");
        if (this.isSBE) {
            this.anyHost = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.radio.AnyHost.SBE"));
            this.selectedHosts = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.radio.SelectedHosts.SBE"));
        } else {
            this.anyHost = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.radio.AnyHost"));
            this.selectedHosts = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.radio.SelectedHosts"));
        }
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        this.setLayout(new GridBagLayout());
        this.add((Component)headPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.resultModel.setColumnNames(COL_NAMES);
        this.resultModel.setColumnMapping(COL_MAPPING);
        this.resultModel.setEditMode(false);
        this.resultTable.setModel(this.resultModel);
        this.resultModel.addMouseListenerToHeaderInTable(this.resultTable);
        this.resultTable.setAutoResizeMode(4);
        this.resultTable.setShowGrid(true);
        UiUtilities.setupScrollPane((JScrollPane)this.resultScrollPane, (JTable)this.resultTable);
        JPanel pane = new JPanel();
        pane.setLayout(new BorderLayout());
        this.resultScrollPane.setPreferredSize(new Dimension(180, 150));
        this.resultScrollPane.setMinimumSize(new Dimension(180, 150));
        float[] colSizes = new float[]{1.0f};
        int width = this.resultScrollPane.getWidth();
        if (width == 0) {
            width = 445;
        }
        UIUtilities.resizeColumns(this.resultTable, colSizes, width - 8);
        pane.add((Component)this.resultScrollPane, "Center");
        ActionListener radioButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectRuleHostPanel.this.radioSelectionChanged();
            }
        };
        this.anyHost.addActionListener(radioButtonActionListener);
        this.selectedHosts.addActionListener(radioButtonActionListener);
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectRuleHostPanel.this.addHost();
            }
        });
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                SelectRuleHostPanel.this.deleteHost();
            }
        });
        this.anyHost.setSelected(true);
        this.buttonGroup.add(this.anyHost);
        this.buttonGroup.add(this.selectedHosts);
        panel.add((Component)this.label, this.getGridBagConstaint(0, 0));
        panel.add((Component)this.anyHost, this.getGridBagConstaint(0, 1));
        panel.add((Component)this.selectedHosts, this.getGridBagConstaint(0, 2));
        panel.add((Component)this.resultScrollPane, this.getGridBagConstaint(0, 3));
        JPanel buttonPanel = UIUtilities.getButtonPanel(new JButton[]{this.addBtn, this.removeBtn}, 0, 4, true);
        panel.add((Component)buttonPanel, this.getGridBagConstaint(0, 4));
        this.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(40, 40, 0, 40), 0, 0));
        this.radioSelectionChanged();
        this.nextPanel = new SelectRuleNetworkServicePanel(this.isMacOsRulePanel);
        this.nextPanel.setPreviousPanel(this);
    }

    private void radioSelectionChanged() {
        if (this.selectedHosts.isSelected()) {
            this.resultTable.setEnabled(true);
            this.addBtn.setEnabled(true);
            this.removeBtn.setEnabled(true);
        } else {
            this.resultTable.setEnabled(false);
            this.addBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
        }
    }

    private void addHost() {
        HostDialog dialog;
        int direction = 3;
        HostObject newObject = new HostObject(new IpAddress(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.IPAddress"), HostEnableObject.getDirectionDesc(direction));
        int hostDialogType = 0;
        if (this.isMacOsRulePanel) {
            hostDialogType = 3;
        }
        if ((dialog = new HostDialog(newObject, hostDialogType)).isOk()) {
            this.containerObject.getAllAddress();
            HostObject hostObject = dialog.getObject();
            this.resultModel.addRow(hostObject);
            this.containerObject.addHostObject(hostObject);
        }
    }

    private void deleteHost() {
        int result;
        int[] rows = this.resultTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.SelectOneLineBeforeDeleteHost"));
            return;
        }
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.ConfirmDeleteHost");
        if (rows.length > 1) {
            message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.ConfirmDeleteMultiHosts");
        }
        if ((result = UIUtilities.confirmYesNoOptionDialog(message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.title.DeleteHost"))) == 0) {
            for (int index = 0; index < rows.length; ++index) {
                HostObject hostObj = (HostObject)this.resultModel.getRow(rows[index]);
                this.containerObject.deleteHostObject(hostObj);
            }
            this.refreshTable();
        }
    }

    private void refreshTable() {
        int len = this.resultModel.getRowCount();
        for (int i = len - 1; i >= 0; --i) {
            this.resultModel.removeRow(i);
        }
        ArrayList<HostObject> hosts = this.containerObject.getAllAddress();
        if (hosts != null) {
            ArrayList<HostObject> hostObjects = new ArrayList<HostObject>();
            for (HostObject hostObject : hosts) {
                hostObjects.add(hostObject);
            }
            this.resultModel.setDataVector(new Vector<TableRow>((Collection)Cast.cast(hostObjects)));
        }
        this.resultModel.sortTable(-1);
        if (this.resultTable.getRowCount() > 0) {
            this.resultTable.setRowSelectionInterval(0, 0);
        }
    }

    private GridBagConstraints getGridBagConstaint(int gridX, int gridY) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = gridX;
        cons.gridy = gridY;
        int left = 2;
        int bottom = 2;
        cons.anchor = 17;
        cons.fill = 2;
        cons.weightx = 1.0;
        switch (gridY) {
            case 0: {
                bottom = 10;
                break;
            }
            case 1: 
            case 2: {
                left += 10;
                break;
            }
            case 3: {
                cons.weighty = 1.0;
                cons.fill = 1;
                left += 30;
                break;
            }
            case 4: {
                left += 20;
                break;
            }
        }
        int right = 2;
        int top = 2;
        cons.insets = new Insets(top, left, bottom, right);
        return cons;
    }

    public boolean isValidData() {
        if (this.selectedHosts.isSelected() && this.resultModel.getDataVector().size() == 0) {
            String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.message.AddAtLeastOne");
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleHostPanel.message.title.Information");
            JOptionPane.showMessageDialog(Manager.getFrame(), message, title, 1);
            return false;
        }
        return true;
    }

    @Override
    public WizardPanel getNextPanel() {
        return this.nextPanel;
    }

    @Override
    public WizardPanel getPreviousPanel() {
        return this.previousPanel;
    }

    @Override
    public void setPreviousPanel(WizardPanel panel) {
        this.previousPanel = panel;
    }

    @Override
    public Dimension getWizardPreferredSize() {
        return this.getPreferredSize();
    }
}

