/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.common.configobject.schema.FwApplicationTrigger;
import com.sygate.scm.common.configobject.schema.SoApplicationContainer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.dialog.WizardListener;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.ApplicationDialog;
import com.sygate.scm.console.ui.policy.firewall.dialog.FirewallRuleHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.SelectRuleHostPanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ApplicationObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class SelectRuleApplicationPanel
extends JPanel
implements WizardPanel {
    private static final long serialVersionUID = 1L;
    private WizardPanel previousPanel = null;
    private WizardPanel nextPanel = null;
    private JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleApplicationPanel.label.DoYouWantToApplyToAllOrSelected"));
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton allApplications = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleApplicationPanel.radio.AllApplications"));
    private JRadioButton selectedApplications = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleApplicationPanel.radio.SelectedApplications"));
    private JPanel buttonPanel = null;
    private JButton addBtn = new JButton(UIText.get(5));
    private JButton removeBtn = new JButton(UIText.get(4354));
    private FwApplicationTrigger applicationTrigger = null;
    private SoApplicationContainer applicationContainer = null;
    private static final String[] COL_NAMES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleApplicationPanel.column.FileName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleApplicationPanel.column.Description")};
    private static final int[] COL_MAPPING = new int[]{1, 2};
    private JTable resultTable = new StripesTable();
    private JScrollPane resultScrollPane = new JScrollPane();
    private SortableTableModel resultModel = new SortableTableModel();

    public SelectRuleApplicationPanel() {
        this.initialize();
        this.applicationTrigger = new FwApplicationTrigger();
        this.applicationContainer = new SoApplicationContainer();
        this.applicationTrigger.setSoApplicationContainer(this.applicationContainer);
    }

    private void initialize() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleApplicationPanel.title.ApplicationInformation");
        String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleApplicationPanel.description.ApplicationInformation");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        this.setLayout(new GridBagLayout());
        this.add((Component)headPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.resultModel.setColumnNames(COL_NAMES);
        this.resultModel.setColumnMapping(COL_MAPPING);
        this.resultModel.setEditMode(false);
        this.resultTable.setModel(this.resultModel);
        this.resultModel.addMouseListenerToHeaderInTable(this.resultTable);
        this.resultTable.setAutoResizeMode(4);
        this.resultTable.setShowGrid(true);
        UiUtilities.setupScrollPane((JScrollPane)this.resultScrollPane, (JTable)this.resultTable);
        this.resultScrollPane.setPreferredSize(new Dimension(300, 150));
        this.resultScrollPane.setMinimumSize(new Dimension(300, 150));
        float[] colSizes = new float[]{0.6f, 0.38f};
        int width = this.resultScrollPane.getWidth();
        if (width == 0) {
            width = 445;
        }
        UIUtilities.resizeColumns(this.resultTable, colSizes, width);
        ActionListener radioButtonActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectRuleApplicationPanel.this.radioSelectionChanged();
            }
        };
        this.allApplications.addActionListener(radioButtonActionListener);
        this.selectedApplications.addActionListener(radioButtonActionListener);
        this.addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectRuleApplicationPanel.this.addApplication();
            }
        });
        this.removeBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectRuleApplicationPanel.this.deleteApplication();
            }
        });
        this.buttonPanel = UIUtilities.getButtonPanel(new JButton[]{this.addBtn, this.removeBtn}, 0, 4, true);
        this.allApplications.setSelected(true);
        this.buttonGroup.add(this.allApplications);
        this.buttonGroup.add(this.selectedApplications);
        panel.add((Component)this.label, this.getGridBagConstaint(0, 0));
        panel.add((Component)this.allApplications, this.getGridBagConstaint(0, 1));
        panel.add((Component)this.selectedApplications, this.getGridBagConstaint(0, 2));
        panel.add((Component)this.resultScrollPane, this.getGridBagConstaint(0, 3));
        panel.add((Component)this.buttonPanel, this.getGridBagConstaint(0, 4));
        this.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(40, 40, 0, 40), 0, 0));
        this.radioSelectionChanged();
        this.nextPanel = new SelectRuleHostPanel();
        this.nextPanel.setPreviousPanel(this);
    }

    public void addData() {
        FirewallRuleHandler.getInstance().setApplyToSelectedApplications(this.selectedApplications.isSelected());
        if (this.selectedApplications.isSelected()) {
            FirewallRuleHandler.getInstance().removeAllApplicationObjects();
            FirewallRuleHandler.getInstance().addAllApplicationObjects((Collection)Cast.cast(this.resultModel.getDataVector()));
            FirewallRuleHandler.getInstance().setApplicationTrigger(this.applicationTrigger);
        }
    }

    public boolean isValidData() {
        if (this.selectedApplications.isSelected() && this.resultModel.getDataVector().size() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleApplicationPanel.message.AddAtLeastOne"));
            return false;
        }
        return true;
    }

    private void radioSelectionChanged() {
        if (this.selectedApplications.isSelected()) {
            this.resultTable.setEnabled(true);
            this.addBtn.setEnabled(true);
            this.removeBtn.setEnabled(true);
        } else {
            this.resultTable.setEnabled(false);
            this.addBtn.setEnabled(false);
            this.removeBtn.setEnabled(false);
        }
    }

    private void addApplication() {
        ApplicationDialog dialog = new ApplicationDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.addApplicationDlgTitle"), true, null, false);
        ApplicationObject newObject = new ApplicationObject();
        dialog.setObject(newObject);
        dialog.setVisible(true);
        if (dialog.isOk()) {
            if (this.applicationExists(newObject, this.applicationContainer)) {
                return;
            }
            this.resultModel.addRow(newObject);
            Executable newExecutable = newObject.getExecutable();
            this.applicationContainer.addExecutable(newExecutable);
        }
    }

    public boolean applicationExists(ApplicationObject obj, SoApplicationContainer appContainer) {
        Executable exe = obj.getExecutable();
        for (Executable exe2 : appContainer.getExecutable()) {
            if (!PolicyHandler.compareTwoExecutableObj(exe2, exe)) continue;
            JOptionPane.showMessageDialog(this, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.error.AppAlreadyExists"), obj.getName()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.title.Error"), 0);
            return true;
        }
        return false;
    }

    private void deleteApplication() {
        int result;
        int[] rows = this.resultTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "SelectRuleApplicationPanel.SelectOneLineBeforeDeleteApplication"));
            return;
        }
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.ConfirmDeleteAppTrigger");
        if (rows.length > 1) {
            message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.ConfirmDeleteMultiAppTrigger");
        }
        if ((result = UIUtilities.confirmYesNoOptionDialog(message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.title.DeleteApp"))) == 0) {
            for (int index = 0; index < rows.length; ++index) {
                ApplicationObject appObj = (ApplicationObject)this.resultModel.getRow(rows[index]);
                Executable exec = appObj.getExecutable();
                this.applicationContainer.removeExecutable(exec);
            }
            this.refreshTable();
        }
    }

    private void refreshTable() {
        int len = this.resultModel.getRowCount();
        for (int i = len - 1; i >= 0; --i) {
            this.resultModel.removeRow(i);
        }
        Vector apps = this.applicationContainer.getExecutable();
        if (apps != null) {
            ArrayList<ApplicationObject> applicationObjects = new ArrayList<ApplicationObject>();
            for (int i = 0; i < apps.size(); ++i) {
                Executable exec = (Executable)apps.get(i);
                applicationObjects.add(new ApplicationObject(exec));
            }
            this.resultModel.setDataVector(new Vector<TableRow>((Collection)Cast.cast(applicationObjects)));
        }
        this.resultModel.sortTable(-1);
        if (this.resultTable.getRowCount() > 0) {
            this.resultTable.setRowSelectionInterval(0, 0);
        }
    }

    private GridBagConstraints getGridBagConstaint(int x, int y) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = x;
        cons.gridy = y;
        int left = 2;
        int right = 2;
        int top = 2;
        int bottom = 2;
        cons.anchor = 17;
        cons.fill = 2;
        cons.weightx = 1.0;
        switch (y) {
            case 0: {
                bottom = 10;
                break;
            }
            case 1: 
            case 2: {
                left += 10;
                break;
            }
            case 3: {
                cons.weighty = 1.0;
                cons.fill = 1;
                left += 30;
                break;
            }
            case 4: {
                left += 20;
                break;
            }
        }
        cons.insets = new Insets(top, left, bottom, right);
        return cons;
    }

    @Override
    public WizardPanel getNextPanel() {
        return this.nextPanel;
    }

    @Override
    public WizardPanel getPreviousPanel() {
        return this.previousPanel;
    }

    @Override
    public void setPreviousPanel(WizardPanel panel) {
        this.previousPanel = panel;
    }

    @Override
    public void addListener(WizardListener listener) {
    }

    @Override
    public void removeListener(WizardListener listener) {
    }

    @Override
    public Dimension getWizardPreferredSize() {
        return this.getPreferredSize();
    }
}

