/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.dialog.WizardListener;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.FirewallRuleHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.SelectRuleApplicationPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.SelectRuleHostPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.i18n.ConsoleMessageResourcesFile;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class SelectRuleActionPanel
extends JPanel
implements WizardPanel {
    private static final long serialVersionUID = 1L;
    private WizardPanel previousPanel = null;
    private WizardPanel nextPanel = null;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private static final MessageResourcesFile MSGRES = new ConsoleMessageResourcesFile("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog");
    private JRadioButton allowConnections = new JRadioButton(MSGRES.getString("SelectRuleActionPanel.radio.AllowConnections"));
    private JRadioButton blockConnections = new JRadioButton(MSGRES.getString("SelectRuleActionPanel.radio.BlockConnections"));
    private JRadioButton askConnections = new JRadioButton(MSGRES.getString("SelectRuleActionPanel.radio.AskConnections"));
    private JLabel label = new JLabel(MSGRES.getString("SelectRuleActionPanel.label.DoYouWantToAllowOrBlock"));
    private LicenseObject licenseObject = LicenseObject.getInstance();
    private boolean isMacRulePanel = false;

    public SelectRuleActionPanel(boolean isMacRulePanel) {
        this.isMacRulePanel = isMacRulePanel;
        this.initialize();
    }

    private void initialize() {
        String title = MSGRES.getString("SelectRuleActionPanel.title.SelectRuleAction");
        String content = MSGRES.getString("SelectRuleActionPanel.description.SelectRuleActionDesc");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        this.setLayout(new GridBagLayout());
        this.add((Component)headPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.allowConnections.setSelected(true);
        this.buttonGroup.add(this.allowConnections);
        this.buttonGroup.add(this.blockConnections);
        panel.add((Component)this.label, this.getGridBagConstaint(0, 0));
        panel.add((Component)this.allowConnections, this.getGridBagConstaint(0, 1));
        panel.add((Component)this.blockConnections, this.getGridBagConstaint(0, 2));
        if (LicenseObject.getInstance().isSBProduct() || this.isMacRulePanel) {
            panel.add(Box.createGlue(), this.getGridBagConstaint(0, 3));
        } else {
            this.buttonGroup.add(this.askConnections);
            panel.add((Component)this.askConnections, this.getGridBagConstaint(0, 3));
            panel.add(Box.createGlue(), this.getGridBagConstaint(0, 4));
        }
        this.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(40, 40, 0, 40), 0, 0));
        this.nextPanel = !this.licenseObject.isSBProduct() && !this.isMacRulePanel ? new SelectRuleApplicationPanel() : new SelectRuleHostPanel(this.isMacRulePanel);
        this.nextPanel.setPreviousPanel(this);
    }

    private GridBagConstraints getGridBagConstaint(int gridX, int gridY) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = gridX;
        cons.gridy = gridY;
        cons.anchor = 17;
        cons.fill = 2;
        cons.weightx = 1.0;
        int left = 2;
        int right = 2;
        int top = 2;
        int bottom = 2;
        switch (gridY) {
            case 0: {
                bottom = 10;
                break;
            }
            case 3: {
                if (!LicenseObject.getInstance().isSBProduct() && !this.isMacRulePanel) {
                    left += 10;
                    break;
                }
                cons.weighty = 1.0;
                cons.fill = 1;
                break;
            }
            case 4: {
                cons.weighty = 1.0;
                cons.fill = 1;
                break;
            }
            default: {
                left += 10;
            }
        }
        cons.insets = new Insets(top, left, bottom, right);
        return cons;
    }

    @Override
    public WizardPanel getNextPanel() {
        return this.nextPanel;
    }

    @Override
    public WizardPanel getPreviousPanel() {
        return this.previousPanel;
    }

    @Override
    public void setPreviousPanel(WizardPanel panel) {
        this.previousPanel = panel;
    }

    @Override
    public void addListener(WizardListener listener) {
    }

    @Override
    public void removeListener(WizardListener listener) {
    }

    @Override
    public Dimension getWizardPreferredSize() {
        return UIUtilities.getMaxDimension(this.getPreferredSize(), this.nextPanel.getWizardPreferredSize());
    }

    public void addData() {
        int ruleAction = this.allowConnections.isSelected() ? 1 : (this.blockConnections.isSelected() ? 2 : 3);
        FirewallRuleHandler.getInstance().setRuleAction(ruleAction);
    }
}

