/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.schema.FwTimeTrigger;
import com.sygate.scm.common.configobject.schema.SoTime;
import com.sygate.scm.common.configobject.schema.SoTimeContainer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.firewall.dialog.ScheduleDialog;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ScheduleObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class ScheduleListDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleListDialog.column.Exclude"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleListDialog.column.Time")};
    private static final float[] COL_SIZE = new float[]{0.2f, 0.8f};
    private JTable scheduleTable;
    private SortableTableModel model;
    private JPopupMenu schedulePopup;
    private JScrollPane scrollPane;
    private Action addAction;
    private Action deleteAction;
    private Action editAction;
    private JButton addButton;
    private JButton deleteButton;
    private JButton editButton;
    private JPanel scheduleButtonPanel;
    private JPanel scheduleListPanel;
    private ArrayList<ScheduleObject> schedules;
    private FwTimeTrigger timeTrigger;
    private SoTimeContainer timeContainer;

    public ScheduleListDialog(FwTimeTrigger timeTrigger) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleListDialog.title.ScheduleList"), true);
        this.timeTrigger = timeTrigger;
        this.init();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_rules_time";
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(500, 300));
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getScheduleListPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private JPanel getScheduleListPanel() {
        if (this.scheduleListPanel == null) {
            this.scheduleListPanel = new JPanel();
            this.scheduleListPanel.setLayout(new BorderLayout());
            JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleListDialog.label.SpecifyFirewallRuleSchedule"), 2);
            label.setBorder(BorderFactory.createEmptyBorder(10, 1, 0, 0));
            this.scheduleListPanel.add((Component)label, "North");
            this.scheduleListPanel.add((Component)this.getScrollPane(), "Center");
            this.scheduleListPanel.add((Component)this.getScheduleButtonPanel(), "South");
        }
        return this.scheduleListPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.getViewport().add(this.getScheduleTable());
        }
        UIUtilities.setTableColumnWidth(this.getScheduleTable(), COL_SIZE, (int)this.scrollPane.getPreferredSize().getWidth());
        return this.scrollPane;
    }

    private List<ScheduleObject> getSchedules() {
        if (this.schedules == null) {
            Vector soTimes;
            this.schedules = new ArrayList();
            if (this.timeTrigger == null) {
                this.timeTrigger = new FwTimeTrigger();
            }
            this.timeContainer = this.timeTrigger.getSoTimeContainer();
            if (this.timeContainer != null && (soTimes = this.timeContainer.getSoTime()) != null) {
                for (SoTime soTime : soTimes) {
                    ScheduleObject scheduleObject = new ScheduleObject(soTime);
                    this.schedules.add(scheduleObject);
                }
            }
        }
        return this.schedules;
    }

    private JTable getScheduleTable() {
        if (this.scheduleTable == null) {
            this.scheduleTable = new StripesTable();
            this.scheduleTable.setModel(this.getTableModel());
            this.scheduleTable.getSelectionModel().setSelectionMode(0);
            this.scheduleTable.getSelectionModel().addListSelectionListener(this.getTableSelectionListener());
            TableColumn column = this.scheduleTable.getColumnModel().getColumn(0);
            column.setCellRenderer(new ExclusiveCheckRenderer());
            JCheckBox checkBox = new JCheckBox();
            checkBox.setHorizontalAlignment(0);
            column.setCellEditor(new DefaultCellEditor(checkBox));
            this.scheduleTable.addMouseListener(this.getTableMouseListener());
            this.getTableModel().addMouseListenerToHeaderInTable(this.scheduleTable);
        }
        return this.scheduleTable;
    }

    private SortableTableModel getTableModel() {
        if (this.model == null) {
            this.model = new SortableTableModel(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int column) {
                    switch (column) {
                        case 0: {
                            return true;
                        }
                    }
                    return false;
                }
            };
            this.model.setColumnNames(columnNames);
            this.model.setDataVector(new Vector<TableRow>((Collection)Cast.cast(this.getSchedules())));
        }
        return this.model;
    }

    private ListSelectionListener getTableSelectionListener() {
        ListSelectionListener tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ScheduleListDialog.this.deleteButton.setEnabled(true);
                ScheduleListDialog.this.editButton.setEnabled(true);
            }
        };
        return tableSelectionListener;
    }

    private MouseListener getTableMouseListener() {
        MouseAdapter tableMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getModifiers() == 4) {
                    ScheduleListDialog.this.getSchedulePopup().show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getClickCount() == 2) {
                    ScheduleListDialog.this.editSchedule();
                }
            }
        };
        return tableMouseListener;
    }

    private JPopupMenu getSchedulePopup() {
        if (this.schedulePopup == null) {
            this.schedulePopup = new JPopupMenu();
            this.schedulePopup.add(this.addAction);
            this.schedulePopup.add(this.deleteAction);
            this.schedulePopup.add(this.editAction);
        }
        return this.schedulePopup;
    }

    private void addSchedule() {
        this.timeContainer = this.timeTrigger.getSoTimeContainer();
        if (this.timeContainer == null) {
            this.timeContainer = new SoTimeContainer();
            this.timeTrigger.setSoTimeContainer(this.timeContainer);
        }
        ScheduleObject scheduleObject = new ScheduleObject();
        ScheduleDialog dialog = new ScheduleDialog();
        dialog.setObject(scheduleObject);
        if (!dialog.isCancelled()) {
            SoTime soTime = scheduleObject.getSoTime();
            this.timeContainer.addSoTime(soTime);
            this.getTableModel().addRow(scheduleObject);
        }
    }

    private void deleteSchedule() {
        int index = this.getScheduleTable().getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleListDialog.message.SelectScheduleToDelete"));
            return;
        }
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleListDialog.message.ConfirmDeleteSchedule");
        int result = UIUtilities.confirmYesNoOptionDialog(message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleListDialog.title.DeleteSchedule"));
        if (result == 0) {
            ScheduleObject scheduleObject = (ScheduleObject)this.getTableModel().getRow(index);
            SoTime time = scheduleObject.getSoTime();
            this.timeContainer.removeSoTime(time);
            this.getTableModel().removeRow(index);
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
    }

    private void editSchedule() {
        block4: {
            int index = this.getScheduleTable().getSelectedRow();
            if (index == -1) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleListDialog.message.SelectScheduleToEdit"));
                return;
            }
            ScheduleObject scheduleObject = (ScheduleObject)this.getTableModel().getRow(index);
            try {
                ScheduleObject scheduleObjectCopy = scheduleObject.getClone();
                ScheduleDialog dialog = new ScheduleDialog();
                dialog.setObject(scheduleObjectCopy);
                if (!dialog.isCancelled()) {
                    SoTime newTime = scheduleObjectCopy.getSoTime();
                    this.timeContainer.setSoTime(index, newTime);
                    this.getTableModel().setRow(index, scheduleObjectCopy);
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleListDialog.title.ConsoleError"), 0);
                if (!ex.needRelogin()) break block4;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private JPanel getScheduleButtonPanel() {
        if (this.scheduleButtonPanel == null) {
            this.addAction = new AbstractAction(UIText.get(5)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScheduleListDialog.this.addSchedule();
                }
            };
            this.deleteAction = new AbstractAction(UIText.get(769)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScheduleListDialog.this.deleteSchedule();
                }
            };
            this.editAction = new AbstractAction(UIText.get(1024)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ScheduleListDialog.this.editSchedule();
                }
            };
            this.addButton = new JButton(this.addAction);
            this.deleteButton = new JButton(this.deleteAction);
            this.deleteButton.setEnabled(false);
            this.editButton = new JButton(this.editAction);
            this.editButton.setEnabled(false);
            JButton[] buttons = new JButton[]{this.addButton, this.editButton, this.deleteButton};
            this.scheduleButtonPanel = new ButtonPane(buttons, 1);
        }
        return this.scheduleButtonPanel;
    }

    public boolean isCancel() {
        return !this.isOk;
    }

    public ArrayList<ScheduleObject> getNewSchedules() {
        if (this.getTableModel().getDataVector().size() > 0) {
            return new ArrayList<ScheduleObject>((Collection)Cast.cast(this.getTableModel().getDataVector()));
        }
        return null;
    }

    public static class ExclusiveCheckRenderer
    implements TableCellRenderer {
        private JCheckBox check = new JCheckBox();

        public ExclusiveCheckRenderer() {
            this.check.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Boolean boolValue = (Boolean)value;
            if (boolValue == null) {
                this.check.setSelected(false);
            } else {
                this.check.setSelected(boolValue);
            }
            if (isSelected) {
                this.check.setForeground(table.getSelectionForeground());
                this.check.setBackground(table.getSelectionBackground());
            } else {
                this.check.setBackground(table.getBackground());
                this.check.setForeground(table.getForeground());
            }
            this.check.setFont(table.getFont());
            return this.check;
        }
    }
}

