/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.firewall.dialog.TimeTokenizer;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ScheduleObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.TimeSpinner1;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;

public class ScheduleDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static DateFormatSymbols symbols = new DateFormatSymbols();
    private static final String[] months = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.combo.MonthsAll"), symbols.getMonths()[0], symbols.getMonths()[1], symbols.getMonths()[2], symbols.getMonths()[3], symbols.getMonths()[4], symbols.getMonths()[5], symbols.getMonths()[6], symbols.getMonths()[7], symbols.getMonths()[8], symbols.getMonths()[9], symbols.getMonths()[10], symbols.getMonths()[11]};
    private String timePattern = MessageResources.getInstance().getString("com.sygate.scm.util.util", "timePatternFull");
    private TimeSpinner1 startSpinner;
    private TimeSpinner1 endSpinner;
    private boolean hasHour;
    private boolean hasMinute;
    private boolean hasSecond;
    private boolean hasAmpm;
    private String hourPattern;
    private BorderLayout borderLayout1 = new BorderLayout(0, 3);
    private BorderLayout borderLayout2 = new BorderLayout();
    private GridBagLayout gridBagLayout1 = new GridBagLayout();
    private GridBagLayout gridBagLayout2 = new GridBagLayout();
    private JPanel emptyPanel = new JPanel();
    private JPanel timePanel = new JPanel();
    private JPanel dayPanel = new JPanel();
    private JLabel nameLabel = new JLabel();
    private JLabel startTimeLabel = new JLabel();
    private JLabel endTimeLabel = new JLabel();
    private JLabel monthLabel = new JLabel();
    private JLabel colonLabel1 = new JLabel();
    private JLabel colonLabel2 = new JLabel();
    private JLabel colonLabel3 = new JLabel();
    private JLabel colonLabel4 = new JLabel();
    private JTextField nameField = new JTextField();
    private JComboBox<String> monthCbx = new JComboBox<String>(months);
    private JRadioButton everydayChk = new JRadioButton();
    private JRadioButton weekendChk = new JRadioButton();
    private JRadioButton weekdayChk = new JRadioButton();
    private JRadioButton specifydayChk = new JRadioButton();
    private JCheckBox sundayChk = new JCheckBox();
    private JCheckBox mondayChk = new JCheckBox();
    private JCheckBox tuesdayChk = new JCheckBox();
    private JCheckBox wednesdayChk = new JCheckBox();
    private JCheckBox thursdayChk = new JCheckBox();
    private JCheckBox fridayChk = new JCheckBox();
    private JCheckBox saturdayChk = new JCheckBox();
    private JSeparator sp1 = new JSeparator();
    private JSeparator sp2 = new JSeparator();
    private ScheduleObject scheduleObject;

    public ScheduleDialog() {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.title.AddSchedule"), true);
        this.init();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_rules_time_add";
    }

    @Override
    protected boolean isValidate() {
        if (!(!this.specifydayChk.isSelected() || this.sundayChk.isSelected() || this.mondayChk.isSelected() || this.tuesdayChk.isSelected() || this.wednesdayChk.isSelected() || this.thursdayChk.isSelected() || this.fridayChk.isSelected() || this.saturdayChk.isSelected())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceDialog.message.SpecifyDays"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.message.InvalidDays"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        String startTime = this.getTimeFromSpinner(this.startSpinner);
        String endTime = this.getTimeFromSpinner(this.endSpinner);
        this.scheduleObject.setStartDate(this.getStartDate());
        this.scheduleObject.setStartDayOfWeek(this.getStartDayOfWeek());
        this.scheduleObject.setStartTime(startTime);
        this.scheduleObject.setEndTime(endTime);
        this.scheduleObject.setTimeLast(this.getTimeLast(startTime, endTime));
        this.scheduleObject.setInclude(true);
    }

    private void init() {
        this.parseTimePattern(this.timePattern);
        this.setDefaultCloseOperation(2);
        this.nameLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.label.Name"));
        this.startTimeLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.label.StartTime"));
        this.endTimeLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.label.EndTime"));
        this.monthLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.label.Month") + ":");
        this.colonLabel1.setText(":");
        this.colonLabel2.setText(":");
        this.colonLabel3.setText(":");
        this.colonLabel4.setText(":");
        this.everydayChk.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.check.EveryDay"));
        this.weekendChk.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.check.Weekends"));
        this.weekdayChk.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.check.Weekdays"));
        this.specifydayChk.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.check.SpecifyDays"));
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.everydayChk);
        btnGroup.add(this.weekendChk);
        btnGroup.add(this.weekdayChk);
        btnGroup.add(this.specifydayChk);
        this.sundayChk.setText(symbols.getWeekdays()[1]);
        this.mondayChk.setText(symbols.getWeekdays()[2]);
        this.tuesdayChk.setText(symbols.getWeekdays()[3]);
        this.wednesdayChk.setText(symbols.getWeekdays()[4]);
        this.thursdayChk.setText(symbols.getWeekdays()[5]);
        this.fridayChk.setText(symbols.getWeekdays()[6]);
        this.saturdayChk.setText(symbols.getWeekdays()[7]);
        this.sp1.setBounds(new Rectangle(45, 35, 235, 2));
        this.sp2.setBounds(new Rectangle(255, 75, 35, 2));
        this.timePanel.setLayout(this.gridBagLayout1);
        this.timePanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.title.TimePeriod")), BorderFactory.createEmptyBorder(0, 15, 15, 10)));
        this.timePanel.add((Component)this.startTimeLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.timePanel.add((Component)this.startSpinner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 150), 0, 0));
        this.timePanel.add((Component)this.endTimeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.timePanel.add((Component)this.endSpinner, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 0, 0, 150), 0, 0));
        this.dayPanel.setLayout(this.gridBagLayout2);
        this.dayPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.title.MonthsDays")), BorderFactory.createEmptyBorder(0, 10, 10, 10)));
        this.dayPanel.add((Component)this.monthLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add(this.monthCbx, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add((Component)this.sp1, new GridBagConstraints(0, 1, 0, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        this.dayPanel.add((Component)this.everydayChk, new GridBagConstraints(0, 2, 1, 1, 0.3, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add((Component)this.weekendChk, new GridBagConstraints(1, 2, 1, 1, 0.3, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add((Component)this.weekdayChk, new GridBagConstraints(2, 2, 1, 1, 0.3, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add((Component)this.specifydayChk, new GridBagConstraints(3, 2, 1, 1, 0.3, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add((Component)this.sp2, new GridBagConstraints(0, 3, 0, 1, 0.0, 0.0, 10, 1, new Insets(5, 0, 5, 0), 0, 0));
        int iFirstDay = Utility.getCalendarInstance().getFirstDayOfWeek() - 1;
        this.dayPanel.add((Component)this.sundayChk, new GridBagConstraints((0 - iFirstDay + 7) % 7 % 4, 4 + (0 - iFirstDay + 7) % 7 / 4, 1, 1, 0.3, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add((Component)this.mondayChk, new GridBagConstraints((1 - iFirstDay + 7) % 7 % 4, 4 + (1 - iFirstDay + 7) % 7 / 4, 1, 1, 0.3, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add((Component)this.tuesdayChk, new GridBagConstraints((2 - iFirstDay + 7) % 7 % 4, 4 + (2 - iFirstDay + 7) % 7 / 4, 1, 1, 0.3, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add((Component)this.wednesdayChk, new GridBagConstraints((3 - iFirstDay + 7) % 7 % 4, 4 + (3 - iFirstDay + 7) % 7 / 4, 1, 1, 0.3, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add((Component)this.thursdayChk, new GridBagConstraints((4 - iFirstDay + 7) % 7 % 4, 4 + (4 - iFirstDay + 7) % 7 / 4, 1, 1, 0.3, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add((Component)this.fridayChk, new GridBagConstraints((5 - iFirstDay + 7) % 7 % 4, 4 + (5 - iFirstDay + 7) % 7 / 4, 1, 1, 0.3, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dayPanel.add((Component)this.saturdayChk, new GridBagConstraints((6 - iFirstDay + 7) % 7 % 4, 4 + (6 - iFirstDay + 7) % 7 / 4, 1, 1, 0.3, 0.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.emptyPanel.setLayout(this.borderLayout1);
        this.emptyPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.emptyPanel.add((Component)this.timePanel, "North");
        this.emptyPanel.add((Component)this.dayPanel, "South");
        this.getContentPane().setLayout(this.borderLayout2);
        this.getContentPane().add((Component)this.emptyPanel, "North");
        this.getContentPane().add((Component)this.getButtonPanel(), "Center");
        this.pack();
        this.everydayChk.addActionListener(this.getActionListener());
        this.weekendChk.addActionListener(this.getActionListener());
        this.weekdayChk.addActionListener(this.getActionListener());
        this.specifydayChk.addActionListener(this.getActionListener());
        UiUtilities.centerComponent((Component)this);
    }

    private void setValues() {
        String startDate;
        this.nameField.setText(this.scheduleObject.getName());
        int startHour = Utility.convertHourFrom_H_Pattern((int)0, (String)this.hourPattern);
        int startMinute = 0;
        int startSecond = 0;
        int startAmpm = 0;
        int endHour = Utility.convertHourFrom_H_Pattern((int)0, (String)this.hourPattern);
        int endMinute = 0;
        int endSecond = 0;
        int endAmpm = 0;
        String startTime = this.scheduleObject.getStartTime();
        Integer lastTime = this.scheduleObject.getTimeLast();
        if (startTime != null) {
            TimeTokenizer tk = new TimeTokenizer(startTime);
            int startHourOfDay = Integer.parseInt(tk.getHours());
            if (this.hasAmpm) {
                startAmpm = Utility.getAmpmFrom_H_Pattern((int)startHourOfDay, (String)this.hourPattern);
            }
            if (this.hasHour) {
                startHour = Utility.convertHourFrom_H_Pattern((int)startHourOfDay, (String)this.hourPattern);
            }
            if (this.hasMinute) {
                startMinute = Integer.parseInt(tk.getMinutes());
            }
            if (this.hasSecond) {
                startSecond = Integer.parseInt(tk.getSeconds());
            }
            Calendar cal = Utility.getCalendarInstance();
            cal.set(11, startHourOfDay);
            cal.set(12, startMinute);
            cal.set(13, startSecond);
            if (lastTime != null) {
                cal.add(13, lastTime);
            }
            int endHourOfDay = cal.get(11);
            if (this.hasAmpm) {
                endAmpm = Utility.getAmpmFrom_H_Pattern((int)endHourOfDay, (String)this.hourPattern);
            }
            if (this.hasHour) {
                endHour = Utility.convertHourFrom_H_Pattern((int)endHourOfDay, (String)this.hourPattern);
            }
            if (this.hasMinute) {
                endMinute = cal.get(12);
            }
            if (this.hasSecond) {
                endSecond = cal.get(13);
            }
        }
        this.startSpinner.setHour(startHour);
        this.startSpinner.setMinute(startMinute);
        this.startSpinner.setSecond(startSecond);
        if (this.hasAmpm) {
            this.startSpinner.setAmpm(startAmpm);
        }
        this.endSpinner.setHour(endHour);
        this.endSpinner.setMinute(endMinute);
        this.endSpinner.setSecond(endSecond);
        if (this.hasAmpm) {
            this.endSpinner.setAmpm(endAmpm);
        }
        if ((startDate = this.scheduleObject.getStartDate()) != null) {
            String month = startDate.substring(0, 2);
            if (month.equals("*") || month.equals("*/")) {
                this.monthCbx.setSelectedIndex(0);
            } else {
                int monthIndex = Integer.parseInt(month);
                this.monthCbx.setSelectedIndex(monthIndex);
            }
        }
        String startDayOfWeek = this.scheduleObject.getStartDayOfWeek();
        this.enableDays(false);
        HashSet<String> daySet = new HashSet<String>();
        if (startDayOfWeek != null) {
            StringTokenizer st = new StringTokenizer(startDayOfWeek, ",");
            while (st.hasMoreTokens()) {
                daySet.add(st.nextToken());
            }
        }
        if (startDayOfWeek == null || daySet.size() == 7) {
            this.everydayChk.setSelected(true);
        } else if (daySet.size() == 5 && !daySet.contains("0") && !daySet.contains("6")) {
            this.weekdayChk.setSelected(true);
        } else if (daySet.size() == 2 && daySet.contains("0") && daySet.contains("6")) {
            this.weekendChk.setSelected(true);
        } else {
            this.specifydayChk.setSelected(true);
            this.enableDays(true);
            StringTokenizer st = new StringTokenizer(startDayOfWeek, ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (token.equals("0")) {
                    this.sundayChk.setSelected(true);
                    continue;
                }
                if (token.equals("1")) {
                    this.mondayChk.setSelected(true);
                    continue;
                }
                if (token.equals("2")) {
                    this.tuesdayChk.setSelected(true);
                    continue;
                }
                if (token.equals("3")) {
                    this.wednesdayChk.setSelected(true);
                    continue;
                }
                if (token.equals("4")) {
                    this.thursdayChk.setSelected(true);
                    continue;
                }
                if (token.equals("5")) {
                    this.fridayChk.setSelected(true);
                    continue;
                }
                if (!token.equals("6")) continue;
                this.saturdayChk.setSelected(true);
            }
        }
    }

    private ActionListener getActionListener() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JRadioButton check = (JRadioButton)e.getSource();
                String action = check.getActionCommand();
                if (action.equals(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ScheduleDialog.action.SpecifyDays"))) {
                    ScheduleDialog.this.enableDays(check.isSelected());
                } else {
                    ScheduleDialog.this.enableDays(!check.isSelected());
                }
            }
        };
        return actionListener;
    }

    private void enableDays(boolean enable) {
        this.sundayChk.setEnabled(enable);
        this.mondayChk.setEnabled(enable);
        this.tuesdayChk.setEnabled(enable);
        this.wednesdayChk.setEnabled(enable);
        this.thursdayChk.setEnabled(enable);
        this.fridayChk.setEnabled(enable);
        this.saturdayChk.setEnabled(enable);
        this.sundayChk.setSelected(false);
        this.mondayChk.setSelected(false);
        this.tuesdayChk.setSelected(false);
        this.wednesdayChk.setSelected(false);
        this.thursdayChk.setSelected(false);
        this.fridayChk.setSelected(false);
        this.saturdayChk.setSelected(false);
    }

    private String getStartDate() {
        return this.getMonth() + "/*/*";
    }

    private String getTimeFromSpinner(TimeSpinner1 spinner) {
        int hour = 0;
        int minute = 0;
        int second = 0;
        int ampm = -1;
        if (this.hasHour) {
            hour = spinner.getHour();
            if (this.hasAmpm) {
                ampm = spinner.getAmpm();
            }
            hour = Utility.convertHourTo_H_Pattern((int)hour, (String)this.hourPattern, (int)ampm);
        }
        if (this.hasMinute) {
            minute = spinner.getMinute();
        }
        if (this.hasSecond) {
            second = spinner.getSecond();
        }
        Object strHour = Integer.toString(hour);
        Object strMinute = Integer.toString(minute);
        Object strSecond = Integer.toString(second);
        if (hour <= 0) {
            strHour = "0" + (String)strHour;
        }
        if (minute <= 0) {
            strMinute = "0" + (String)strMinute;
        }
        if (second <= 0) {
            strSecond = "0" + (String)strSecond;
        }
        String endTime = (String)strHour + ":" + (String)strMinute + ":" + (String)strSecond;
        return endTime;
    }

    private int getTimeLast(String strStartTime, String strEndTime) {
        TimeTokenizer tk = new TimeTokenizer(strStartTime);
        int startTime = Integer.parseInt(tk.getHours()) * 60 * 60 + Integer.parseInt(tk.getMinutes()) * 60 + Integer.parseInt(tk.getSeconds());
        tk = new TimeTokenizer(strEndTime);
        int endTime = Integer.parseInt(tk.getHours()) * 60 * 60 + Integer.parseInt(tk.getMinutes()) * 60 + Integer.parseInt(tk.getSeconds());
        int timeLast = endTime - startTime;
        if (timeLast <= 0) {
            timeLast += 86400;
        }
        return timeLast;
    }

    private void parseTimePattern(String timePattern) {
        this.startSpinner = new TimeSpinner1(timePattern);
        this.endSpinner = new TimeSpinner1(timePattern);
        if (timePattern.indexOf("h") != -1) {
            this.hourPattern = "h";
            this.hasHour = true;
        }
        if (timePattern.indexOf("H") != -1) {
            this.hourPattern = "H";
            this.hasHour = true;
        }
        if (timePattern.indexOf("k") != -1) {
            this.hourPattern = "k";
            this.hasHour = true;
        }
        if (timePattern.indexOf("K") != -1) {
            this.hourPattern = "K";
            this.hasHour = true;
        }
        if (timePattern.indexOf("m") != -1) {
            this.hasMinute = true;
        }
        if (timePattern.indexOf("s") != -1) {
            this.hasSecond = true;
        }
        if (timePattern.indexOf("a") != -1) {
            this.hasAmpm = true;
        }
    }

    public void setObject(ScheduleObject scheduleObject) {
        this.scheduleObject = scheduleObject;
        this.setValues();
        this.setVisible(true);
    }

    public String getDlgName() {
        return this.nameField.getText().trim();
    }

    public String getMonth() {
        int selectedIndex = this.monthCbx.getSelectedIndex();
        switch (selectedIndex) {
            case 0: {
                return "*";
            }
            case 1: {
                return "0" + selectedIndex;
            }
            case 2: {
                return "0" + selectedIndex;
            }
            case 3: {
                return "0" + selectedIndex;
            }
            case 4: {
                return "0" + selectedIndex;
            }
            case 5: {
                return "0" + selectedIndex;
            }
            case 6: {
                return "0" + selectedIndex;
            }
            case 7: {
                return "0" + selectedIndex;
            }
            case 8: {
                return "0" + selectedIndex;
            }
            case 9: {
                return "0" + selectedIndex;
            }
            case 10: {
                return "" + selectedIndex;
            }
            case 11: {
                return "" + selectedIndex;
            }
            case 12: {
                return "" + selectedIndex;
            }
        }
        return "*";
    }

    public String getStartDayOfWeek() {
        if (this.weekdayChk.isSelected()) {
            return "1,2,3,4,5";
        }
        if (this.weekendChk.isSelected()) {
            return "6,0";
        }
        if (this.everydayChk.isSelected()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        if (this.sundayChk.isSelected()) {
            sb.append("0");
        }
        if (this.mondayChk.isSelected()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append("1");
        }
        if (this.tuesdayChk.isSelected()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append("2");
        }
        if (this.wednesdayChk.isSelected()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append("3");
        }
        if (this.thursdayChk.isSelected()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append("4");
        }
        if (this.fridayChk.isSelected()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append("5");
        }
        if (this.saturdayChk.isSelected()) {
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append("6");
        }
        return sb.toString();
    }

    public boolean isCancelled() {
        return !this.isOk;
    }
}

