/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.dialog.WizardListener;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.FirewallRuleHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.SelectRuleActionPanel;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.HTMLUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RuleWizardWelcomePanel
extends JPanel
implements WizardPanel {
    private static final long serialVersionUID = 1L;
    private String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "RuleWizardWelcomePanel.title.CreateRuleWizardWelcome");
    private JLabel headingLbl = new JLabel();
    private JPanel headrPanel = new JPanel();
    private WizardPanel previousPanel = null;
    private WizardPanel nextPanel = null;
    private JLabel label1;
    private JLabel nameLabel = null;
    private JTextField nameField = null;
    private DescriptionTextArea descArea1 = new DescriptionTextArea(" " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "RuleWizardWelcomePanel.description.CreateRuleWizard1"));
    private DescriptionTextArea descArea2 = new DescriptionTextArea(" " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "RuleWizardWelcomePanel.description.CreateRuleWizard2"));
    private DescriptionTextArea descArea3 = new DescriptionTextArea(" " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "RuleWizardWelcomePanel.description.CreateRuleWizard3"));

    public RuleWizardWelcomePanel(boolean isMacRulePanel) {
        this.initPanel(isMacRulePanel);
    }

    private void initPanel(boolean isMacRulePanel) {
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(625, 405));
        this.headingLbl.setHorizontalAlignment(2);
        this.headingLbl.setHorizontalTextPosition(2);
        this.headingLbl.setText(this.title);
        this.headrPanel.setLayout(new BorderLayout());
        this.headrPanel.add((Component)this.headingLbl, "West");
        StringBuffer labelTitle = new StringBuffer(300);
        labelTitle.append("<HTML><span ").append(HTMLUtilities.HTML_TITLE_FONT_STYLE).append("\">").append(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "RuleWizardWelcomePanel.label.CreateRuleWizardWelcome")).append("</span></HTML>");
        this.label1 = new HtmlEnabledJLabel(labelTitle.toString());
        this.add((Component)this.headrPanel, new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 2, 2, 2), 0, 0));
        this.add((Component)this.label1, new GridBagConstraints(0, 1, 3, 1, 1.0, 0.0, 17, 2, new Insets(10, 8, 2, 2), 0, 0));
        this.add((Component)this.descArea1, new GridBagConstraints(0, 2, 3, 1, 1.0, 0.0, 17, 2, new Insets(40, 8, 2, 2), 0, 0));
        this.add((Component)this.descArea3, new GridBagConstraints(0, 3, 3, 1, 1.0, 0.0, 17, 2, new Insets(25, 8, 2, 2), 0, 0));
        JPanel parentPanel = UIUtilities.getPanel(new JComponent[]{this.getRuleNameLabel(), this.getRuleNameField()}, 0);
        this.add((Component)parentPanel, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 5, 0, 20), 0, 0));
        this.add((Component)this.descArea2, new GridBagConstraints(0, 5, 3, 1, 1.0, 0.0, 17, 2, new Insets(60, 8, 2, 2), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 17, 2, new Insets(100, 8, 2, 2), 0, 0));
        this.nextPanel = new SelectRuleActionPanel(isMacRulePanel);
        this.nextPanel.setPreviousPanel(this);
    }

    @Override
    public WizardPanel getNextPanel() {
        return this.nextPanel;
    }

    @Override
    public WizardPanel getPreviousPanel() {
        return this.previousPanel;
    }

    @Override
    public void setPreviousPanel(WizardPanel panel) {
        this.previousPanel = panel;
    }

    @Override
    public void addListener(WizardListener listener) {
    }

    @Override
    public void removeListener(WizardListener listener) {
    }

    @Override
    public Dimension getWizardPreferredSize() {
        Dimension dim = this.getPreferredSize();
        dim.setSize(dim.getWidth() + 50.0, dim.getHeight());
        return UIUtilities.getMaxDimension(dim, this.nextPanel.getWizardPreferredSize());
    }

    public void addData() {
        FirewallRuleHandler.getInstance().setFireWallRuleName(this.getRuleNameField().getText().trim());
    }

    public boolean isValidData() {
        return this.validateRuleName(this.getRuleNameField().getText());
    }

    private boolean validateRuleName(String ruleName) {
        if ((ruleName = ruleName.trim()).length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "RuleWizardWelcomePanel.message.RuleNameFieldEmpty"));
            this.getRuleNameField().requestFocus();
            return false;
        }
        if (this.doesNameExist(ruleName)) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "RuleWizardWelcomePanel.message.RuleNameAlreadyInUse");
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "RuleWizardWelcomePanel.message.title.error");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, title, 0);
            this.getRuleNameField().requestFocus();
            return false;
        }
        return true;
    }

    private boolean doesNameExist(String ruleName) {
        return FirewallRuleHandler.getInstance().getFirewallRulesModel().isNameExisting(ruleName, -1);
    }

    private JLabel getRuleNameLabel() {
        if (this.nameLabel == null) {
            this.nameLabel = new JLabel();
            this.nameLabel.setText(" " + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "RuleWizardWelcomePanel.label.RuleName"));
            this.nameLabel.setHorizontalAlignment(4);
            this.nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        }
        return this.nameLabel;
    }

    private JTextField getRuleNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
            RestrictedPlainDocument doc = new RestrictedPlainDocument(256);
            doc.setValidator("\"/\\*?<>|:^'", false);
            this.nameField.setDocument(doc);
            this.nameField.setText(FirewallRuleHandler.getInstance().getFireWallRuleName());
        }
        return this.nameField;
    }
}

