/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.DestinationHostTrigger;
import com.sygate.scm.common.configobject.schema.DnsDomain;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.LocalSubnet;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.RemoteHostTrigger;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostTriggerPanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostEnableObject;
import java.util.Vector;

public class RemoteDestinationHostListTriggerPanel
extends HostTriggerPanel {
    private static final long serialVersionUID = 1L;
    private RemoteHostTrigger remote;
    private DestinationHostTrigger destination;

    public RemoteDestinationHostListTriggerPanel(DestinationHostTrigger sourceHostTrigger, int direction, boolean isMacPanel) {
        this((Vector<AbstractSchema>)sourceHostTrigger.getChildren(), direction, isMacPanel);
        this.destination = sourceHostTrigger;
    }

    public RemoteDestinationHostListTriggerPanel(Vector<AbstractSchema> hostObjList, int direction, boolean isMacPanel) {
        super(hostObjList, direction, isMacPanel);
    }

    @Override
    protected void set(ConfigObject obj, int direction) {
        RemoteHostTrigger sourceTrigger = (RemoteHostTrigger)obj;
        this.set(sourceTrigger.getChildren(), direction);
    }

    @Override
    protected void addHost(HostEnableObject hostObject) {
        boolean conOrobjRef = false;
        if (hostObject.getNetworkHostGroup() != null) {
            conOrobjRef = true;
        }
        FwHostContainer container = new FwHostContainer();
        ObjReference ref = new ObjReference();
        if (conOrobjRef) {
            FwNetworkHostGroup hostGroup = hostObject.getNetworkHostGroup();
            ref.setName(hostGroup.getName());
            ref.setTargetId(hostGroup.getId());
            ref.setTargetType(hostGroup.getObjectTypeName());
        } else {
            container.setOptEnable(Boolean.valueOf(hostObject.getEnable()));
            Object address = hostObject.getAddress();
            this.addAddress(container, address);
            hostObject.setFwHostContainer(container);
        }
        if (this.getDirection() == 3) {
            if (this.remote == null) {
                return;
            }
            if (conOrobjRef) {
                this.remote.addObjReference(ref);
            } else {
                this.remote.addFwHostContainer(container);
            }
        } else if (this.getDirection() == 1) {
            if (this.destination == null) {
                return;
            }
            if (conOrobjRef) {
                this.destination.addObjReference(ref);
            } else {
                this.destination.addFwHostContainer(container);
            }
        }
    }

    @Override
    protected void deleteHost(HostEnableObject hostObject) {
        boolean conOrobjRef = false;
        if (hostObject.getNetworkHostGroup() != null) {
            conOrobjRef = true;
        }
        if (this.getDirection() == 3) {
            if (this.remote == null) {
                return;
            }
            if (conOrobjRef) {
                for (int i = 0; i < this.remote.getObjReferenceCount(); ++i) {
                    ObjReference ref = this.remote.getObjReference(i);
                    if (!ref.getTargetId().equals(hostObject.getNetworkHostGroup().getId())) continue;
                    this.remote.removeObjReference(ref);
                }
            } else {
                hostObject.getFwHostContainer().removeChild((AbstractSchema)((ConfigObject)hostObject.getAddress()));
                if (hostObject.getFwHostContainer().getChildren().size() == 0) {
                    this.remote.removeFwHostContainer(hostObject.getFwHostContainer());
                }
            }
        } else if (this.getDirection() == 1) {
            if (this.destination == null) {
                return;
            }
            if (conOrobjRef) {
                for (int i = 0; i < this.destination.getObjReferenceCount(); ++i) {
                    ObjReference ref = this.destination.getObjReference(i);
                    if (!ref.getTargetId().equals(hostObject.getNetworkHostGroup().getId())) continue;
                    this.destination.removeObjReference(ref);
                }
            } else {
                hostObject.getFwHostContainer().removeChild((AbstractSchema)((ConfigObject)hostObject.getAddress()));
                if (hostObject.getFwHostContainer().getChildren().size() == 0) {
                    this.destination.removeFwHostContainer(hostObject.getFwHostContainer());
                }
            }
        }
    }

    private void addAddress(FwHostContainer container, Object address) {
        if (address instanceof IpAddress) {
            container.addIpAddress((IpAddress)address);
        } else if (address instanceof IpRange) {
            container.addIpRange((IpRange)address);
        } else if (address instanceof MacAddress) {
            String content = ((MacAddress)address).getContent();
            container.addMacAddress((MacAddress)address);
            PolicyHandler.addMacAddress(content);
        } else if (address instanceof SubNet) {
            container.addSubNet((SubNet)address);
        } else if (address instanceof DnsDomain) {
            container.addDnsDomain((DnsDomain)address);
        } else if (address instanceof DnsHost) {
            container.addDnsHost((DnsHost)address);
        } else if (address instanceof LocalSubnet) {
            container.setOptLocalSubnet((LocalSubnet)address);
        } else if (address instanceof Ipv6Address) {
            container.addIpv6Address((Ipv6Address)address);
        } else if (address instanceof Ipv6Range) {
            container.addIpv6Range((Ipv6Range)address);
        } else if (address instanceof Ipv6SubNet) {
            container.addIpv6SubNet((Ipv6SubNet)address);
        }
    }

    @Override
    public void setRemoteDestination(RemoteHostTrigger remote, DestinationHostTrigger destination) {
        this.remote = remote;
        this.destination = destination;
    }

    @Override
    public void setDirection(int dir) {
        if (dir == 3) {
            int i;
            for (i = 0; i < this.destination.getObjReferenceCount(); ++i) {
                this.remote.addObjReference(this.destination.getObjReference(i));
            }
            for (i = 0; i < this.destination.getFwHostContainerCount(); ++i) {
                this.remote.addFwHostContainer(this.destination.getFwHostContainer(i));
            }
            this.destination.clear();
        } else if (dir == 1) {
            int i;
            for (i = 0; i < this.remote.getObjReferenceCount(); ++i) {
                this.destination.addObjReference(this.remote.getObjReference(i));
            }
            for (i = 0; i < this.remote.getFwHostContainerCount(); ++i) {
                this.destination.addFwHostContainer(this.remote.getFwHostContainer(i));
            }
            this.remote.clear();
        }
        super.setDirection(dir);
    }
}

