/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.schema.RawEthernet;
import com.sygate.scm.common.configobject.schema.RawIcmp;
import com.sygate.scm.common.configobject.schema.RawIcmpv6;
import com.sygate.scm.common.configobject.schema.RawIp;
import com.sygate.scm.common.configobject.schema.RawTcp;
import com.sygate.scm.common.configobject.schema.RawUdp;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.firewall.dialog.EthernetProtocolPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.ICMPProtocolPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.ICMPv6ProtocolPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.TCPProtocolPanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolObject;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ProtocolDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String[] PROTOCOL_TYPES = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.TCP"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.UDP"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.ICMP"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.ICMPv6"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.IP"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.combo.Protocol.Ethernet")};
    private static final String[] PROTOCOL_TYPES_MAC = new String[5];
    private JComboBox<String> protocolTypesCombo;
    private TCPProtocolPanel tcpPanel;
    private TCPProtocolPanel udpPanel;
    private EthernetProtocolPanel ethernetPanel;
    private EthernetProtocolPanel ipPanel;
    private ICMPProtocolPanel icmpPanel;
    private ICMPv6ProtocolPanel icmpv6Panel;
    private JPanel topPanel;
    private JPanel showingPanel;
    private ProtocolObject protocolObject;
    private boolean isMacOsRulePanel = false;

    public ProtocolDialog() {
        this(false);
    }

    public ProtocolDialog(boolean isMacPanel) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.title.Protocol"), true);
        this.isMacOsRulePanel = isMacPanel;
        System.arraycopy(PROTOCOL_TYPES, 0, PROTOCOL_TYPES_MAC, 0, 5);
        this.init();
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getTopPanel(), "North");
        this.getContentPane().add((Component)this.getTCPPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.showingPanel = this.getTCPPanel();
        this.pack();
        this.setResizable(false);
        UiUtilities.centerComponent((Component)this);
    }

    public void setObject(ProtocolObject newProtocolObject) {
        this.protocolObject = newProtocolObject;
        this.setValues();
        this.setVisible(true);
    }

    private void setValues() {
        Object protocol = this.protocolObject.getProtocol();
        String type = this.protocolObject.getType();
        this.getProtocolTypesCombo().setSelectedItem(type);
        if (protocol instanceof RawTcp) {
            this.getTCPPanel().setObject(this.protocolObject);
        } else if (protocol instanceof RawUdp) {
            this.getUDPPanel().setObject(this.protocolObject);
        } else if (protocol instanceof RawIp) {
            this.getIPPanel().setObject(this.protocolObject);
        } else if (protocol instanceof RawEthernet) {
            this.getEthernetPanel().setObject(this.protocolObject);
        } else if (protocol instanceof RawIcmp) {
            this.getICMPPanel().setObject(this.protocolObject);
        } else if (protocol instanceof RawIcmpv6) {
            this.getICMPv6Panel().setObject(this.protocolObject);
        }
    }

    private JPanel getTopPanel() {
        if (this.topPanel == null) {
            this.topPanel = new JPanel();
            this.topPanel.setLayout(new GridBagLayout());
            JLabel typeLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ProtocolDialog.label.Protocol"));
            typeLabel.setBounds(100, 10, 70, 20);
            this.topPanel.add((Component)typeLabel, new GridBagConstraints(0, 0, 1, 1, 0.3, 1.0, 13, 0, new Insets(10, 10, 5, 5), 0, 0));
            this.topPanel.add(this.getProtocolTypesCombo(), new GridBagConstraints(1, 0, 1, 1, 0.7, 1.0, 17, 2, new Insets(10, 0, 5, 100), 0, 0));
        }
        return this.topPanel;
    }

    private TCPProtocolPanel getTCPPanel() {
        if (this.tcpPanel == null) {
            this.tcpPanel = new TCPProtocolPanel();
        }
        return this.tcpPanel;
    }

    private TCPProtocolPanel getUDPPanel() {
        if (this.udpPanel == null) {
            this.udpPanel = new TCPProtocolPanel("UDP");
        }
        return this.udpPanel;
    }

    private EthernetProtocolPanel getIPPanel() {
        if (this.ipPanel == null) {
            this.ipPanel = new EthernetProtocolPanel("IP");
        }
        return this.ipPanel;
    }

    private EthernetProtocolPanel getEthernetPanel() {
        if (this.ethernetPanel == null) {
            this.ethernetPanel = new EthernetProtocolPanel();
        }
        return this.ethernetPanel;
    }

    private ICMPProtocolPanel getICMPPanel() {
        if (this.icmpPanel == null) {
            this.icmpPanel = new ICMPProtocolPanel();
        }
        return this.icmpPanel;
    }

    private ICMPv6ProtocolPanel getICMPv6Panel() {
        if (this.icmpv6Panel == null) {
            this.icmpv6Panel = new ICMPv6ProtocolPanel();
        }
        return this.icmpv6Panel;
    }

    private JComboBox<String> getProtocolTypesCombo() {
        if (this.protocolTypesCombo == null) {
            this.protocolTypesCombo = !this.isMacOsRulePanel ? new JComboBox<String>(PROTOCOL_TYPES) : new JComboBox<String>(PROTOCOL_TYPES_MAC);
            this.protocolTypesCombo.setBounds(150, 10, 200, 20);
            this.protocolTypesCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent ev) {
                    ProtocolDialog.this.resetPanels();
                }
            });
        }
        return this.protocolTypesCombo;
    }

    private void resetPanels() {
        int selectedIndex = this.getProtocolTypesCombo().getSelectedIndex();
        this.getContentPane().remove(this.showingPanel);
        switch (selectedIndex) {
            case 0: {
                this.showingPanel = this.getTCPPanel();
                break;
            }
            case 1: {
                this.showingPanel = this.getUDPPanel();
                break;
            }
            case 2: {
                this.showingPanel = this.getICMPPanel();
                break;
            }
            case 3: {
                this.showingPanel = this.getICMPv6Panel();
                break;
            }
            case 4: {
                this.showingPanel = this.getIPPanel();
                break;
            }
            case 5: {
                this.showingPanel = this.getEthernetPanel();
                break;
            }
            default: {
                this.showingPanel = new JPanel();
            }
        }
        this.getContentPane().add((Component)this.showingPanel, "Center");
        this.validate();
        this.repaint();
    }

    public ProtocolObject getProtocolObject() {
        int selectedIndex = this.getProtocolTypesCombo().getSelectedIndex();
        switch (selectedIndex) {
            case 0: {
                return this.getTCPPanel().getProtocolObject();
            }
            case 1: {
                return this.getUDPPanel().getProtocolObject();
            }
            case 2: {
                return this.getICMPPanel().getProtocolObject();
            }
            case 3: {
                return this.getICMPv6Panel().getProtocolObject();
            }
            case 4: {
                return this.getIPPanel().getProtocolObject();
            }
            case 5: {
                return this.getEthernetPanel().getProtocolObject();
            }
        }
        return null;
    }

    @Override
    protected void commit() {
        int selectedIndex = this.getProtocolTypesCombo().getSelectedIndex();
        switch (selectedIndex) {
            case 0: {
                this.getTCPPanel().updateValues();
                break;
            }
            case 1: {
                this.getUDPPanel().updateValues();
                break;
            }
            case 2: {
                this.getICMPPanel().updateValues();
                break;
            }
            case 3: {
                this.getICMPv6Panel().updateValues();
                break;
            }
            case 4: {
                this.getIPPanel().updateValues();
                break;
            }
            case 5: {
                this.getEthernetPanel().updateValues();
                break;
            }
        }
    }

    @Override
    protected boolean isValidate() {
        int selectedIndex = this.getProtocolTypesCombo().getSelectedIndex();
        switch (selectedIndex) {
            case 0: {
                return this.getTCPPanel().isValidValues();
            }
            case 1: {
                return this.getUDPPanel().isValidValues();
            }
            case 2: {
                return this.getICMPPanel().isValidTypeAndCode();
            }
            case 3: {
                return this.getICMPv6Panel().isValidTypeAndCode();
            }
            case 4: {
                return this.getIPPanel().isValidProtocol();
            }
            case 5: {
                return this.getEthernetPanel().isValidProtocol();
            }
        }
        return false;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_network_services_add_network_services_add";
    }
}

