/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.firewall.Port;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.firewall.PortNumberFactory;
import com.sygate.scm.console.ui.util.renderer.ChkListCellRenderer;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;

public class PortNumberPopup
extends JPopupMenu {
    private static final long serialVersionUID = 1L;
    private LinkedList<Port> portsList = new LinkedList();
    private List<String> singlePorts = new ArrayList<String>();
    private List<String> rangePorts = new ArrayList<String>();
    private JButton okButton;
    private Action okAction;
    private String selectedPortsString;
    private boolean checkBoxItem = true;
    JList<Object> osList = new JList();
    DefaultListModel<Object> osListModel = new DefaultListModel();

    public PortNumberPopup(Vector<Port> ports, String selectedPortsString) {
        this.portsList.addAll(ports);
        this.selectedPortsString = selectedPortsString;
        this.parsePortListStr(this.singlePorts, this.rangePorts);
        this.init();
    }

    public PortNumberPopup(Vector<Port> ports, String selectedPortsString, boolean checkBox) {
        this.checkBoxItem = checkBox;
        this.portsList.addAll(ports);
        this.selectedPortsString = selectedPortsString;
        this.init();
    }

    private void init() {
        try {
            this.setPortNumbers();
            this.setPreferredSize(new Dimension(345, 150));
            if (this.checkBoxItem) {
                this.osList.setCellRenderer(new ChkListCellRenderer());
            } else {
                this.osList.setCellRenderer(new RadioListCellRenderer());
            }
            this.osListModel = new DefaultListModel();
            ButtonGroup buttonGroup = new ButtonGroup();
            for (int i = 0; i < this.portsList.size(); ++i) {
                if (this.checkBoxItem) {
                    JCheckBox cBox = new JCheckBox(this.portsList.get(i).toString(), this.portsList.get(i).isSelected());
                    cBox.setBackground(this.osList.getBackground());
                    this.osListModel.addElement(cBox);
                    continue;
                }
                JRadioButton rBtn = new JRadioButton(this.portsList.get(i).toString(), this.portsList.get(i).isSelected());
                rBtn.setBackground(this.osList.getBackground());
                buttonGroup.add(rBtn);
                this.osListModel.addElement(rBtn);
            }
            this.osList.setModel(this.osListModel);
            this.osList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int index = PortNumberPopup.this.osList.locationToIndex(e.getPoint());
                    if (index != -1) {
                        if (PortNumberPopup.this.checkBoxItem) {
                            JCheckBox cBox = (JCheckBox)PortNumberPopup.this.osList.getModel().getElementAt(index);
                            cBox.doClick();
                            PortNumberPopup.this.portsList.get(index).setSelected(cBox.isSelected());
                        } else {
                            JRadioButton rBtn = (JRadioButton)PortNumberPopup.this.osList.getModel().getElementAt(index);
                            rBtn.setSelected(true);
                            for (int i = 0; i < PortNumberPopup.this.portsList.size(); ++i) {
                                PortNumberPopup.this.portsList.get(i).setSelected(false);
                            }
                            PortNumberPopup.this.portsList.get(index).setSelected(rBtn.isSelected());
                        }
                        PortNumberPopup.this.osList.updateUI();
                    }
                }
            });
            JPanel tablePanel = new JPanel();
            tablePanel.setLayout(new BorderLayout());
            JScrollPane scroll = new JScrollPane();
            scroll.getViewport().add(this.osList);
            tablePanel.add((Component)scroll, "Center");
            tablePanel.add((Component)this.getOkButton(), "South");
            this.add(tablePanel);
        }
        catch (BadFormatException be) {
            JOptionPane.showMessageDialog(Manager.getFrame(), be.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "PortNumberPopup.title.InvalidPortNumber"), 0);
        }
    }

    private void setPortNumbers() throws BadFormatException {
        if (this.selectedPortsString.indexOf("-") > 0) {
            for (String rangePortStr : this.rangePorts) {
                String minPortStr = rangePortStr.substring(0, rangePortStr.indexOf(45)).trim();
                String maxPortStr = rangePortStr.substring(rangePortStr.indexOf(45) + 1, rangePortStr.length()).trim();
                try {
                    for (Object e : this.portsList) {
                        Port port = (Port)e;
                        port.setSelectedInRange(minPortStr, maxPortStr);
                    }
                }
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                    return;
                }
            }
        }
        Vector<Port> selectedPorts = PortNumberFactory.getPortsForString(this.selectedPortsString);
        int count = selectedPorts.size();
        for (int i = 0; i < count; ++i) {
            Port port = selectedPorts.get(i);
            int index = this.portsList.indexOf(port);
            if (index >= 0) {
                this.portsList.get(index).setSelected(true);
                continue;
            }
            this.portsList.add(0, port);
            port.setSelected(true);
        }
    }

    private JButton getOkButton() {
        if (this.okButton == null) {
            this.okButton = new JButton(UIText.get(3584));
            Font font = this.okButton.getFont().deriveFont(1);
            this.okButton.setFont(font);
        }
        return this.okButton;
    }

    public void setCheckBoxItem(boolean checkOrRadio) {
        this.checkBoxItem = checkOrRadio;
    }

    public void setOkAction(Action newOKAction) {
        this.okAction = newOKAction;
        if (this.okAction == null) {
            this.okAction = new AbstractAction(UIText.get(3584)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    PortNumberPopup.this.setVisible(false);
                }
            };
        }
        this.getOkButton().setAction(this.okAction);
    }

    public String getSelectedPorts() {
        ArrayList<String> ports = new ArrayList<String>();
        for (int i = 0; i < this.portsList.size(); ++i) {
            Port port = this.portsList.get(i);
            if (!port.isSelected()) continue;
            ports.add(port.getNumber().toString());
        }
        return this.getPortChanges(ports);
    }

    private String getPortChanges(List<String> ports) {
        StringBuffer result = new StringBuffer();
        ArrayList<String> removedPorts = new ArrayList<String>(this.singlePorts);
        removedPorts.removeAll(ports);
        if (this.checkBoxItem) {
            StringTokenizer portItem = new StringTokenizer(this.selectedPortsString, ",");
            while (portItem.hasMoreTokens()) {
                String portStr = portItem.nextToken();
                if (removedPorts.contains(portStr)) continue;
                if (result.length() > 0) {
                    result.append(",");
                }
                result.append(portStr);
            }
        }
        for (String portStr : ports) {
            if (this.singlePorts.contains(portStr)) continue;
            boolean found = false;
            for (String rangePortStr : this.rangePorts) {
                if (!this.isBetweenPortRange(rangePortStr, portStr)) continue;
                found = true;
                break;
            }
            if (found) continue;
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(portStr);
        }
        return result.toString();
    }

    private void parsePortListStr(List<String> singlePorts, List<String> rangePorts) {
        if (this.selectedPortsString.contains(",")) {
            StringTokenizer allPorts = new StringTokenizer(this.selectedPortsString, ",");
            while (allPorts.hasMoreTokens()) {
                this.parsePortStr(singlePorts, rangePorts, allPorts.nextToken().trim());
            }
        } else {
            this.parsePortStr(singlePorts, rangePorts, this.selectedPortsString);
        }
    }

    private void parsePortStr(List<String> singlePorts, List<String> rangePorts, String portStr) {
        if (portStr.contains("-")) {
            rangePorts.add(portStr);
        } else {
            singlePorts.add(portStr);
        }
    }

    private boolean isBetweenPortRange(String portRange, String port) {
        String[] portEdges;
        if (portRange.contains("-") && (portEdges = portRange.split("-")).length == 2) {
            Port checkPort = new Port(port, "");
            return checkPort.inRange((Object)portEdges[0], (Object)portEdges[1]);
        }
        return false;
    }

    private static class RadioListCellRenderer
    extends JRadioButton
    implements ListCellRenderer<Object> {
        private static final long serialVersionUID = 1L;

        public RadioListCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            return (JRadioButton)value;
        }
    }
}

