/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JScrollPane;

public class PopupList
extends JDialog {
    private static final long serialVersionUID = 5136139685146308731L;
    private ArrayList<String> items;
    private JList<String> itemsList;
    private String selectedItem;

    public PopupList(JDialog parent, String title, ArrayList<String> items, String item) {
        super(parent, title, true);
        this.items = items;
        this.selectedItem = item;
        this.init();
    }

    private void init() {
        JScrollPane scroll = new JScrollPane();
        scroll.getViewport().add(this.getItemsList());
        this.getContentPane().add(scroll);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PopupList.this.selectedItem = PopupList.this.getItemsList().getSelectedValue();
            }
        });
        this.setSize(150, 150);
    }

    private JList<String> getItemsList() {
        if (this.itemsList == null) {
            this.itemsList = new JList<String>(new Vector<String>(this.items));
            this.itemsList.setSelectedValue(this.selectedItem, true);
            this.itemsList.setSelectionMode(0);
            this.itemsList.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getClickCount() == 2) {
                        PopupList.this.selectedItem = PopupList.this.itemsList.getSelectedValue();
                        PopupList.this.dispose();
                    }
                }
            });
        }
        return this.itemsList;
    }

    public Object getSelectedItem() {
        return this.selectedItem;
    }
}

