/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.FwInterfaceContainer;
import com.sygate.scm.common.configobject.schema.FwNetworkInterface;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceTrigger;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.firewall.NetworkInterfaceHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.CustomAdapterDialog;
import com.sygate.scm.console.ui.policy.firewall.dialog.ScheduleListDialog;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FirewallRuleObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FwNetworkInterfaceObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.NetworkAdapterInterfaceObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.NetworkInterfaceGroupObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;

public class NetworkAdapterPanel
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.column.Enabled"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.column.AdapterName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.column.NetInterfaceId")};
    private JTable serviceTable;
    private SortableTableModel model;
    private JPopupMenu servicePopup;
    private JScrollPane scrollPane;
    private Action addAction;
    private Action deleteAction;
    private Action editAction;
    private JButton addButton;
    private JButton deleteButton;
    private JButton editButton;
    private JRadioButton allAdapterRadioBtn = null;
    private JRadioButton followingAdapterRadioBtn = null;
    HashMap<String, Integer> map = new HashMap();
    HashMap<Object, NetworkInterfaceGroupObject> groupMap = new HashMap();
    private JPanel serviceButtonPanel;
    private JPanel serviceListPanel;
    private FwNetworkInterfaceTrigger interfaceTrigger;
    FirewallRuleObject ruleObject;

    public NetworkAdapterPanel(FirewallRuleObject rObject, FwNetworkInterfaceTrigger interfacTrigger) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.title.NetworkAdapter"), true);
        this.interfaceTrigger = interfacTrigger;
        this.ruleObject = rObject;
        this.init();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_rules_interface";
    }

    @Override
    protected void commit() {
        if (this.interfaceTrigger == null) {
            this.interfaceTrigger = new FwNetworkInterfaceTrigger();
        }
        this.cleanObjRefFromTrigger();
        boolean alladapterSelected = this.getAllAdapterRadioBtn().isSelected();
        if (alladapterSelected) {
            NetworkInterfaceGroupObject gObject = this.groupMap.get(0);
            this.updateReferenceToTrigger(gObject);
        }
        Vector tempList = (Vector)Cast.cast(this.getTableModel().getDataVector());
        for (int i = 0; i < tempList.size(); ++i) {
            NetworkAdapterInterfaceObject obj = (NetworkAdapterInterfaceObject)tempList.get(i);
            String tName = obj.getName();
            if (tName == null) {
                tName = "";
            }
            if (!alladapterSelected && obj.isSelected().booleanValue() && !tName.equals("")) {
                NetworkInterfaceGroupObject gObject = this.groupMap.get(obj.getID());
                this.updateReferenceToTrigger(gObject);
                continue;
            }
            if (!tName.equals("")) continue;
            if (alladapterSelected) {
                obj.getNetworkInterface().setOptEnable(Boolean.valueOf(false));
            }
            this.updateTriggerInterfaceContainer(obj);
        }
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getServiceListPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
        int width = Math.max(this.getWidth(), 500);
        this.setSize(new Dimension(width, 300));
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private JRadioButton getAllAdapterRadioBtn() {
        if (this.allAdapterRadioBtn == null) {
            this.allAdapterRadioBtn = new JRadioButton();
            this.allAdapterRadioBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.radio.ApplyRuleToAllAdapters"));
            this.allAdapterRadioBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetworkAdapterPanel.this.allAdapterCheckedAction();
                }
            });
        }
        return this.allAdapterRadioBtn;
    }

    private void allAdapterCheckedAction() {
        UIUtilities.setContainerStatus(this.getScrollPane(), !this.allAdapterRadioBtn.isSelected());
        this.getServiceTable().setEnabled(false);
        UIUtilities.setContainerStatus(this.getServiceButtonPanel(), false);
        this.addAction.setEnabled(false);
        this.getServiceTable().setBackground(UIColorUtilities.DISABLED_BACKGROUND);
    }

    private JRadioButton getFollowingAdapterRadioBtn() {
        if (this.followingAdapterRadioBtn == null) {
            this.followingAdapterRadioBtn = new JRadioButton();
            this.followingAdapterRadioBtn.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.radio.ApplyRuleToFollowingAdapters"));
            this.followingAdapterRadioBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UIUtilities.setContainerStatus(NetworkAdapterPanel.this.getScrollPane(), NetworkAdapterPanel.this.followingAdapterRadioBtn.isSelected());
                    NetworkAdapterPanel.this.addAction.setEnabled(true);
                    NetworkAdapterPanel.this.addButton.setEnabled(true);
                    NetworkAdapterPanel.this.getServiceTable().setEnabled(true);
                    NetworkAdapterPanel.this.getServiceTable().setBackground(UIColorUtilities.ENABLED_BACKGROUND_LIGHT);
                }
            });
        }
        return this.followingAdapterRadioBtn;
    }

    private JPanel getServiceListPanel() {
        if (this.serviceListPanel == null) {
            JPanel rPanel = new JPanel();
            rPanel.setLayout(new BoxLayout(rPanel, 1));
            rPanel.add(this.getAllAdapterRadioBtn());
            rPanel.add(this.getFollowingAdapterRadioBtn());
            ButtonGroup bGroup = new ButtonGroup();
            bGroup.add(this.allAdapterRadioBtn);
            bGroup.add(this.followingAdapterRadioBtn);
            this.followingAdapterRadioBtn.setSelected(true);
            this.serviceListPanel = new JPanel();
            this.serviceListPanel.setLayout(new BorderLayout());
            this.serviceListPanel.add((Component)rPanel, "North");
            this.serviceListPanel.add((Component)this.getScrollPane(), "Center");
            this.serviceListPanel.add((Component)this.getServiceButtonPanel(), "South");
            this.serviceListPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }
        return this.serviceListPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.getViewport().add(this.getServiceTable());
        }
        return this.scrollPane;
    }

    private JTable getServiceTable() {
        if (this.serviceTable == null) {
            this.serviceTable = new StripesTable();
            this.serviceTable.setModel(this.getTableModel());
            this.serviceTable.setAutoResizeMode(0);
            this.serviceTable.getColumn(this.serviceTable.getColumnName(0)).setMinWidth(50);
            this.serviceTable.getColumn(this.serviceTable.getColumnName(1)).setMinWidth(145);
            this.serviceTable.getColumn(this.serviceTable.getColumnName(2)).setMinWidth(250);
            this.serviceTable.getSelectionModel().setSelectionMode(0);
            this.serviceTable.getSelectionModel().addListSelectionListener(this.getTableSelectionListener());
            this.serviceTable.addMouseListener(this.getTableMouseListener());
            this.getTableModel().addMouseListenerToHeaderInTable(this.serviceTable);
            TableColumn column = this.serviceTable.getColumnModel().getColumn(0);
            column.setCellRenderer(new ScheduleListDialog.ExclusiveCheckRenderer());
            JCheckBox checkBox = new JCheckBox();
            checkBox.setHorizontalAlignment(0);
            column.setCellEditor(new DefaultCellEditor(checkBox));
            checkBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetworkAdapterPanel.this.onCheck(e);
                }
            });
        }
        return this.serviceTable;
    }

    private SortableTableModel getTableModel() {
        if (this.model == null) {
            this.model = new SortableTableModel(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int col) {
                    if (col == 0) {
                        return true;
                    }
                    return super.isCellEditable(row, col);
                }
            };
            this.model.setColumnNames(columnNames);
            Vector networkGroup = (Vector)Cast.cast(this.getTableData());
            this.model.setDataVector(networkGroup);
        }
        return this.model;
    }

    private List<NetworkInterfaceGroupObject> getNetworkInterfaceGroups() {
        return NetworkInterfaceHandler.getInstance().getInterfaceGroups();
    }

    private Vector<NetworkAdapterInterfaceObject> getTableData() {
        NetworkAdapterInterfaceObject tObj;
        List<NetworkInterfaceGroupObject> tempObjectsArr = this.getNetworkInterfaceGroups();
        Vector<NetworkAdapterInterfaceObject> arrList = new Vector<NetworkAdapterInterfaceObject>();
        for (int i = 0; i < tempObjectsArr.size(); ++i) {
            NetworkInterfaceGroupObject object = tempObjectsArr.get(i);
            tObj = new NetworkAdapterInterfaceObject(object.getFwInterfaceGroup());
            tObj.setIdentification(object.getDescription());
            if (i > 0) {
                arrList.add(tObj);
                this.map.put(object.getFwInterfaceGroup().getId(), i);
                this.groupMap.put(tObj.getID(), object);
                continue;
            }
            this.groupMap.put(0, object);
        }
        int startIndex = 0;
        if (this.interfaceTrigger != null && this.interfaceTrigger.getObjReferenceCount() > 0 && this.interfaceTrigger.getObjReference(0).getName().equals("All Adapters")) {
            this.allAdapterRadioBtn.setSelected(true);
            UIUtilities.setContainerStatus(this.getScrollPane(), false);
            UIUtilities.setContainerStatus(this.getServiceButtonPanel(), false);
            startIndex = 1;
            this.allAdapterCheckedAction();
        } else {
            UIUtilities.setContainerStatus(this.getServiceButtonPanel(), true);
            this.editAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
        }
        if (this.interfaceTrigger == null) {
            return arrList;
        }
        for (int i = startIndex; i < this.interfaceTrigger.getObjReferenceCount(); ++i) {
            String id = this.interfaceTrigger.getObjReference(i).getTargetId();
            if (!this.map.containsKey(id)) continue;
            Integer in = this.map.get(id);
            arrList.get(in - 1).setSelected(true);
        }
        FwInterfaceContainer cont = this.interfaceTrigger.getOptFwInterfaceContainer();
        if (cont != null) {
            Vector vecInt = cont.getFwNetworkInterface();
            for (int i = 0; i < vecInt.size(); ++i) {
                FwNetworkInterface net = (FwNetworkInterface)vecInt.get(i);
                tObj = new NetworkAdapterInterfaceObject(net);
                arrList.add(tObj);
            }
        }
        return arrList;
    }

    private ListSelectionListener getTableSelectionListener() {
        ListSelectionListener tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (lsm.isSelectionEmpty()) {
                    return;
                }
                NetworkAdapterInterfaceObject obj = (NetworkAdapterInterfaceObject)NetworkAdapterPanel.this.getTableModel().getRow(lsm.getMinSelectionIndex());
                if (obj.getType().equals("Group")) {
                    NetworkAdapterPanel.this.deleteButton.setEnabled(false);
                    NetworkAdapterPanel.this.editButton.setEnabled(false);
                    NetworkAdapterPanel.this.deleteAction.setEnabled(false);
                    NetworkAdapterPanel.this.editAction.setEnabled(false);
                } else {
                    NetworkAdapterPanel.this.deleteButton.setEnabled(true);
                    NetworkAdapterPanel.this.editButton.setEnabled(true);
                    NetworkAdapterPanel.this.deleteAction.setEnabled(true);
                    NetworkAdapterPanel.this.editAction.setEnabled(true);
                }
            }
        };
        return tableSelectionListener;
    }

    private MouseListener getTableMouseListener() {
        MouseAdapter tableMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!NetworkAdapterPanel.this.getServiceTable().isEnabled()) {
                    return;
                }
                int rowNumber = NetworkAdapterPanel.this.getServiceTable().rowAtPoint(e.getPoint());
                int selectedRow = NetworkAdapterPanel.this.getServiceTable().getSelectedRow();
                if ((e.getModifiers() & 0x10) != 0 && selectedRow == -1) {
                    NetworkAdapterPanel.this.deleteButton.setEnabled(false);
                    NetworkAdapterPanel.this.editButton.setEnabled(false);
                    NetworkAdapterPanel.this.deleteAction.setEnabled(false);
                    NetworkAdapterPanel.this.editAction.setEnabled(false);
                }
                if (e.getModifiers() == 4) {
                    NetworkAdapterPanel.this.getServiceTable().setRowSelectionInterval(rowNumber, rowNumber);
                    NetworkAdapterPanel.this.getServicePopup().show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getClickCount() == 2) {
                    NetworkAdapterPanel.this.editProtocol();
                }
            }
        };
        return tableMouseListener;
    }

    private JPopupMenu getServicePopup() {
        if (this.servicePopup == null) {
            this.servicePopup = new JPopupMenu();
            this.servicePopup.add(this.addAction);
            this.servicePopup.add(this.deleteAction);
            this.servicePopup.add(this.editAction);
        }
        return this.servicePopup;
    }

    private List<String> createIdentificationArray() {
        ArrayList<String> arr = new ArrayList<String>();
        for (int i = 0; i < this.getTableModel().getRowCount(); ++i) {
            NetworkAdapterInterfaceObject interfaceRowObject = (NetworkAdapterInterfaceObject)this.getTableModel().getRow(i);
            if (interfaceRowObject.getType().equals("Group")) continue;
            arr.add(interfaceRowObject.getIdentification().trim());
        }
        return arr;
    }

    private void editProtocol() {
        int index = this.getServiceTable().getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.message.SelectLineBeforeEdit"));
            return;
        }
        NetworkAdapterInterfaceObject interfaceRowObject = (NetworkAdapterInterfaceObject)this.getTableModel().getRow(index);
        if (interfaceRowObject.getType().equals("Group")) {
            return;
        }
        try {
            FwNetworkInterfaceObject obj = new FwNetworkInterfaceObject();
            obj.setOptNetworkInterfaceDescString(interfaceRowObject.getIdentification());
            obj.setOptNetworkInterfaceType(interfaceRowObject.getAdapterType());
            obj.setType("Interface");
            CustomAdapterDialog dlg = new CustomAdapterDialog(obj, this.createIdentificationArray(), false, true);
            if (dlg.isOk()) {
                interfaceRowObject = new NetworkAdapterInterfaceObject(obj);
                interfaceRowObject.setSelected(true);
                interfaceRowObject.setType("Interface");
                this.getTableModel().setRow(index, interfaceRowObject);
            }
            dlg.dispose();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void deleteService() {
        int index = this.getServiceTable().getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.message.SelectLineBeforeDeleteService"));
            return;
        }
        NetworkAdapterInterfaceObject groupObject = (NetworkAdapterInterfaceObject)this.getTableModel().getRow(index);
        if (!groupObject.getType().equals("Interface")) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.message.GroupCannotBeDeleted"));
            return;
        }
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.message.ConfirmDeleteInterface");
        int result = UIUtilities.deleteOptionDialog(message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "NetworkAdapterPanel.title.ConfirmDeleteInterface"));
        if (result == 0) {
            FwNetworkInterface obj = groupObject.getNetworkInterface();
            if (this.interfaceTrigger != null && this.interfaceTrigger.getOptFwInterfaceContainer() != null) {
                this.interfaceTrigger.getOptFwInterfaceContainer().removeChild((AbstractSchema)obj);
            }
            this.getTableModel().removeRow(index);
        }
    }

    private JPanel getServiceButtonPanel() {
        if (this.serviceButtonPanel == null) {
            this.addAction = new AbstractAction(UIText.get(5)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetworkAdapterPanel.this.addInterface();
                }
            };
            this.deleteAction = new AbstractAction(UIText.get(769)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetworkAdapterPanel.this.deleteService();
                    NetworkAdapterPanel.this.deleteButton.setEnabled(false);
                }
            };
            this.editAction = new AbstractAction(UIText.get(1024)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    NetworkAdapterPanel.this.editProtocol();
                }
            };
            this.addButton = new JButton(this.addAction);
            this.deleteButton = new JButton(this.deleteAction);
            this.deleteButton.setEnabled(false);
            this.editButton = new JButton(this.editAction);
            this.editButton.setEnabled(false);
            JButton[] buttons = new JButton[]{this.addButton, this.editButton, this.deleteButton};
            this.serviceButtonPanel = new ButtonPane(buttons, 1);
        }
        return this.serviceButtonPanel;
    }

    private void addInterface() {
        FwNetworkInterfaceObject obj = new FwNetworkInterfaceObject();
        CustomAdapterDialog dlg = new CustomAdapterDialog(obj, this.createIdentificationArray(), false);
        if (dlg.isOk()) {
            obj = dlg.getNetworkInterfaceObject();
            NetworkAdapterInterfaceObject xx = new NetworkAdapterInterfaceObject(obj);
            xx.setType("Interface");
            this.getTableModel().addRow(xx);
            int rowSel = this.getServiceTable().getRowCount() - 1;
            this.getServiceTable().setRowSelectionInterval(rowSel, rowSel);
            int rowH = this.getServiceTable().getRowHeight();
            int y = rowH * rowSel;
            this.getServiceTable().scrollRectToVisible(new Rectangle(0, y, this.getServiceTable().getWidth(), this.getServiceTable().getRowHeight()));
        }
        dlg.dispose();
    }

    private void onCheck(ActionEvent e) {
        int index = this.getServiceTable().getSelectedRow();
        if (index == -1) {
            return;
        }
        boolean selected = ((JCheckBox)e.getSource()).isSelected();
        NetworkAdapterInterfaceObject obj = (NetworkAdapterInterfaceObject)this.getTableModel().getRow(index);
        if (obj.getType().equals("Interface")) {
            obj.setSelected(selected);
        }
    }

    private void cleanObjRefFromTrigger() {
        for (ObjReference ref : this.interfaceTrigger.getObjReference()) {
            this.interfaceTrigger.removeObjReference(ref);
        }
        FwInterfaceContainer cont = this.interfaceTrigger.getOptFwInterfaceContainer();
        if (cont != null) {
            for (FwNetworkInterface interf : cont.getFwNetworkInterface()) {
                cont.removeFwNetworkInterface(interf);
            }
        }
        this.ruleObject.getInterfaces().clear();
    }

    private void updateReferenceToTrigger(NetworkInterfaceGroupObject groupObject) {
        ObjReference ref = new ObjReference();
        ref.setTargetId(groupObject.getFwInterfaceGroup().getId());
        ref.setTargetType(groupObject.getFwInterfaceGroup().getObjectTypeName());
        ref.setName(groupObject.getName());
        this.interfaceTrigger.addObjReference(ref);
        this.ruleObject.getInterfaces().add(groupObject);
    }

    private void updateTriggerInterfaceContainer(NetworkAdapterInterfaceObject obj) {
        FwInterfaceContainer cont = this.interfaceTrigger.getOptFwInterfaceContainer();
        if (cont == null) {
            cont = new FwInterfaceContainer();
        }
        cont.addFwNetworkInterface(obj.getNetworkInterface());
        this.interfaceTrigger.setOptFwInterfaceContainer(cont);
    }

    public FwNetworkInterfaceTrigger getInterfaceTrigger() {
        return this.interfaceTrigger;
    }

    public boolean isCancelled() {
        return !this.isOk;
    }
}

