/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.DnsDomain;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.LocalHostTrigger;
import com.sygate.scm.common.configobject.schema.LocalSubnet;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SourceHostTrigger;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostTriggerPanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostEnableObject;
import java.util.Vector;

public class LocalSourceHostListTriggerPanel
extends HostTriggerPanel {
    private static final long serialVersionUID = 1L;
    private LocalHostTrigger local;
    private SourceHostTrigger source;

    public LocalSourceHostListTriggerPanel(SourceHostTrigger sourceHostTrigger, int direction, boolean isMacPanel) {
        this((Vector<AbstractSchema>)sourceHostTrigger.getChildren(), direction, isMacPanel);
        this.source = sourceHostTrigger;
    }

    public LocalSourceHostListTriggerPanel(Vector<AbstractSchema> hostObjList, int direction, boolean isMacPanel) {
        super(hostObjList, direction, isMacPanel);
    }

    @Override
    protected void set(ConfigObject obj, int direction) {
        SourceHostTrigger sourctTrigger = (SourceHostTrigger)obj;
        this.set(sourctTrigger.getChildren(), direction);
    }

    @Override
    protected void addHost(HostEnableObject hostObject) {
        boolean conOrobjRef = false;
        if (hostObject.getNetworkHostGroup() != null) {
            conOrobjRef = true;
        }
        FwHostContainer container = new FwHostContainer();
        ObjReference ref = new ObjReference();
        if (conOrobjRef) {
            FwNetworkHostGroup hostGroup = hostObject.getNetworkHostGroup();
            ref.setName(hostGroup.getName());
            ref.setTargetId(hostGroup.getId());
            ref.setTargetType(hostGroup.getObjectTypeName());
        } else {
            container.setOptEnable(Boolean.valueOf(hostObject.getEnable()));
            Object address = hostObject.getAddress();
            this.addAddress(container, address);
            hostObject.setFwHostContainer(container);
        }
        if (this.getDirection() == 2) {
            if (this.local == null) {
                return;
            }
            if (conOrobjRef) {
                this.local.addObjReference(0, ref);
            } else {
                this.local.addFwHostContainer(0, container);
            }
        } else if (this.getDirection() == 0) {
            if (this.source == null) {
                return;
            }
            if (conOrobjRef) {
                this.source.addObjReference(0, ref);
            } else {
                this.source.addFwHostContainer(0, container);
            }
        }
    }

    @Override
    protected void deleteHost(HostEnableObject hostObject) {
        boolean conOrobjRef = false;
        if (hostObject.getNetworkHostGroup() != null) {
            conOrobjRef = true;
        }
        if (this.getDirection() == 2) {
            if (this.local == null) {
                return;
            }
            if (conOrobjRef) {
                for (int i = 0; i < this.local.getObjReferenceCount(); ++i) {
                    ObjReference ref = this.local.getObjReference(i);
                    if (!ref.getTargetId().equals(hostObject.getNetworkHostGroup().getId())) continue;
                    this.local.removeObjReference(ref);
                }
            } else {
                hostObject.getFwHostContainer().removeChild((AbstractSchema)((ConfigObject)hostObject.getAddress()));
                if (hostObject.getFwHostContainer().getChildren().size() == 0) {
                    this.local.removeFwHostContainer(hostObject.getFwHostContainer());
                }
            }
        } else if (this.getDirection() == 0) {
            if (this.source == null) {
                return;
            }
            if (conOrobjRef) {
                for (int i = 0; i < this.source.getObjReferenceCount(); ++i) {
                    ObjReference ref = this.source.getObjReference(i);
                    if (!ref.getTargetId().equals(hostObject.getNetworkHostGroup().getId())) continue;
                    this.source.removeObjReference(ref);
                }
            } else {
                hostObject.getFwHostContainer().removeChild((AbstractSchema)((ConfigObject)hostObject.getAddress()));
                if (hostObject.getFwHostContainer().getChildren().size() == 0) {
                    this.source.removeFwHostContainer(hostObject.getFwHostContainer());
                }
            }
        }
    }

    private void addAddress(FwHostContainer container, Object address) {
        if (address instanceof IpAddress) {
            container.addIpAddress((IpAddress)address);
        } else if (address instanceof IpRange) {
            container.addIpRange((IpRange)address);
        } else if (address instanceof MacAddress) {
            String content = ((MacAddress)address).getContent();
            container.addMacAddress((MacAddress)address);
            PolicyHandler.addMacAddress(content);
        } else if (address instanceof SubNet) {
            container.addSubNet((SubNet)address);
        } else if (address instanceof DnsDomain) {
            container.addDnsDomain((DnsDomain)address);
        } else if (address instanceof DnsHost) {
            container.addDnsHost((DnsHost)address);
        } else if (address instanceof LocalSubnet) {
            container.setOptLocalSubnet((LocalSubnet)address);
        } else if (address instanceof Ipv6Address) {
            container.addIpv6Address((Ipv6Address)address);
        } else if (address instanceof Ipv6Range) {
            container.addIpv6Range((Ipv6Range)address);
        } else if (address instanceof Ipv6SubNet) {
            container.addIpv6SubNet((Ipv6SubNet)address);
        }
    }

    @Override
    public void setLocalSource(LocalHostTrigger local, SourceHostTrigger source) {
        this.local = local;
        this.source = source;
    }

    @Override
    public void setDirection(int dir) {
        if (dir == 2) {
            int i;
            for (i = 0; i < this.source.getObjReferenceCount(); ++i) {
                this.local.addObjReference(this.source.getObjReference(i));
            }
            for (i = 0; i < this.source.getFwHostContainerCount(); ++i) {
                this.local.addFwHostContainer(this.source.getFwHostContainer(i));
            }
            this.source.clear();
        } else if (dir == 0) {
            int i;
            for (i = 0; i < this.local.getObjReferenceCount(); ++i) {
                this.source.addObjReference(this.local.getObjReference(i));
            }
            for (i = 0; i < this.local.getFwHostContainerCount(); ++i) {
                this.source.addFwHostContainer(this.local.getFwHostContainer(i));
            }
            this.local.clear();
        }
        super.setDirection(dir);
    }
}

