/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.schema.RawIcmpv6;
import com.sygate.scm.common.firewall.Port;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.firewall.PortNumberFactory;
import com.sygate.scm.console.ui.policy.firewall.dialog.PortNumberPopup;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolObject;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ICMPv6ProtocolPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] PACKET_DIRECTIONS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.PacketDirectionBoth"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.PacketDirectionIncoming"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.PacketDirectionOutgoing")};
    private static final int INDEX_BOTH = 0;
    private static final int INDEX_INCOMING = 1;
    private static final int INDEX_OUTGOING = 2;
    private static final int MAX_VALUE = 255;
    private static final String PORT_VALIDATORS = "1234567890,\"-";
    private JComboBox<String> packetDirectionCombo;
    private JTextField icmpTypeTextField;
    private JTextField icmpCodeTextField;
    private JButton icmpTypesButton;
    private JLabel icmpTypeLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.label.ICMPv6Type"));
    private JLabel icmpCodeLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.label.ICMPv6Code"));
    private JLabel packetDirectionLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.label.PacketDirection"));
    private JLabel icmpTypeExLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.label.SampleICMPType"));
    private JLabel icmpCodeExLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.label.SampleICMPCode"));
    private JLabel icmpv6HardCodeLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.label.Hardcode.ICMPv6Code"));
    private ProtocolObject protocolObject;

    public ICMPv6ProtocolPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        this.icmpTypeExLabel.setBounds(140, 15, 200, 20);
        this.icmpTypeLabel.setBounds(55, 37, 135, 20);
        this.icmpTypeLabel.setHorizontalAlignment(2);
        this.getICMPTypeTextField().setBounds(140, 37, 200, 20);
        this.getICMPTypesButton().setBounds(341, 37, 20, 20);
        this.icmpCodeExLabel.setBounds(140, 62, 200, 20);
        this.icmpCodeLabel.setBounds(55, 84, 135, 20);
        this.icmpCodeLabel.setHorizontalAlignment(2);
        this.getICMPCodeTextField().setBounds(140, 84, 200, 20);
        this.packetDirectionLabel.setBounds(55, 109, 135, 20);
        this.packetDirectionLabel.setHorizontalAlignment(2);
        this.getPacketDirectionCombo().setBounds(140, 109, 200, 20);
        this.getPacketDirectionCombo().setSelectedItem(PACKET_DIRECTIONS[0]);
        this.add((Component)this.icmpv6HardCodeLabel, new GridBagConstraints(1, 0, 5, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.icmpTypeExLabel, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.icmpTypeLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 40, 0, 20), 0, 0));
        this.add((Component)this.getICMPTypeTextField(), new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.getICMPTypesButton(), new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 50), 0, 0));
        this.add((Component)this.icmpCodeExLabel, new GridBagConstraints(1, 3, 1, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.icmpCodeLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 40, 0, 20), 0, 0));
        this.add((Component)this.getICMPCodeTextField(), new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)this.packetDirectionLabel, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 40, 0, 20), 0, 0));
        this.add(this.getPacketDirectionCombo(), new GridBagConstraints(1, 5, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        this.add(Box.createGlue(), new GridBagConstraints(0, 6, 3, 1, 1.0, 1.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.title.ICMPv6Protocol")), BorderFactory.createEmptyBorder(10, 20, 10, 20)));
    }

    public boolean updateValues() {
        RawIcmpv6 protocol = (RawIcmpv6)this.getProtocolObject().getProtocol();
        String type = this.getICMPTypeTextField().getText().trim();
        String code = this.getICMPCodeTextField().getText().trim();
        protocol.setOptIcmpv6Code(code.length() == 0 ? null : code);
        protocol.setOptIcmpv6Type(type.length() == 0 ? null : type);
        int directionIndex = this.getPacketDirectionCombo().getSelectedIndex();
        if (directionIndex == 0) {
            protocol.setOptIncoming(null);
        } else if (directionIndex == 1) {
            protocol.setOptIncoming(Boolean.valueOf(true));
        } else if (directionIndex == 2) {
            protocol.setOptIncoming(Boolean.valueOf(false));
        }
        return true;
    }

    private void setValues() {
        RawIcmpv6 protocol = (RawIcmpv6)this.getProtocolObject().getProtocol();
        Boolean incoming = protocol.getOptIncoming();
        String direction = PACKET_DIRECTIONS[0];
        if (incoming != null) {
            direction = incoming != false ? PACKET_DIRECTIONS[1] : PACKET_DIRECTIONS[2];
        }
        String type = protocol.getOptIcmpv6Type();
        String code = protocol.getOptIcmpv6Code();
        this.getPacketDirectionCombo().setSelectedItem(direction);
        this.getICMPTypeTextField().setText(type);
        this.getICMPCodeTextField().setText(code);
    }

    private JComboBox<String> getPacketDirectionCombo() {
        if (this.packetDirectionCombo == null) {
            this.packetDirectionCombo = new JComboBox<String>(PACKET_DIRECTIONS);
            this.packetDirectionCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
        }
        return this.packetDirectionCombo;
    }

    private JTextField getICMPTypeTextField() {
        if (this.icmpTypeTextField == null) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            doc.setValidator(PORT_VALIDATORS, true);
            this.icmpTypeTextField = new JTextField();
            this.icmpTypeTextField.setDocument(doc);
        }
        return this.icmpTypeTextField;
    }

    private JTextField getICMPCodeTextField() {
        if (this.icmpCodeTextField == null) {
            RestrictedPlainDocument doc = new RestrictedPlainDocument(255);
            doc.setValidator(PORT_VALIDATORS, true);
            this.icmpCodeTextField = new JTextField();
            this.icmpCodeTextField.setDocument(doc);
        }
        return this.icmpCodeTextField;
    }

    private JButton getICMPTypesButton() {
        if (this.icmpTypesButton == null) {
            this.icmpTypesButton = new JButton(UIText.get(1538));
            this.icmpTypesButton.setFont(this.icmpTypesButton.getFont().deriveFont(1));
            this.icmpTypesButton.setMargin(new Insets(0, 0, 0, 0));
            this.icmpTypesButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Vector<Port> ports = ICMPv6ProtocolPanel.this.getPortsList();
                    String selectedIcmpTypes = ICMPv6ProtocolPanel.this.getICMPTypeTextField().getText();
                    PortNumberPopup popup = new PortNumberPopup(ports, selectedIcmpTypes);
                    popup.setOkAction(ICMPv6ProtocolPanel.this.getPortPopupAction(popup, ICMPv6ProtocolPanel.this.getICMPTypeTextField()));
                    popup.show(ICMPv6ProtocolPanel.this.icmpTypesButton, e.getX(), e.getY());
                }
            });
        }
        return this.icmpTypesButton;
    }

    private Vector<Port> getPortsList() {
        Vector<Port> ports = new Vector();
        try {
            ports = PortNumberFactory.getICMPv6Types();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return ports;
    }

    private Action getPortPopupAction(final PortNumberPopup popup, final JTextField portTextField) {
        return new AbstractAction(UIText.get(3584)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.setVisible(false);
                portTextField.setText(popup.getSelectedPorts());
                portTextField.requestFocus();
            }
        };
    }

    public void setObject(ProtocolObject protocolObject) {
        this.protocolObject = protocolObject;
        this.setValues();
    }

    public ProtocolObject getProtocolObject() {
        if (this.protocolObject == null) {
            this.protocolObject = new ProtocolObject(new RawIcmpv6());
        }
        return this.protocolObject;
    }

    public boolean isValidTypeAndCode() {
        String icmpType = this.getICMPTypeTextField().getText();
        String icmpCode = this.getICMPCodeTextField().getText();
        StringBuilder valueHolder = new StringBuilder();
        boolean validType = PortNumberFactory.isValidProtocolString(icmpType, valueHolder, 255);
        if (!validType) {
            String invalidToken = valueHolder.toString();
            String message = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.error.InvalidICMPType"), invalidToken);
            JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.title.InvalidICMPType"), 0);
            return false;
        }
        boolean validCode = PortNumberFactory.isValidProtocolString(icmpCode, valueHolder, 255);
        if (!validCode) {
            String invalidToken = valueHolder.toString();
            String message = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.error.InvalidICMPCode"), invalidToken);
            JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ICMPProtocolPanel.title.InvalidICMPCode"), 0);
            return false;
        }
        return true;
    }
}

