/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.DestinationHostTrigger;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.LocalHostTrigger;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.RemoteHostTrigger;
import com.sygate.scm.common.configobject.schema.SourceHostTrigger;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.HostGroupHandler;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostDialog;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostIPAddressTypeHelper;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostEnableObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.ui.policy.hostgroup.HostGroupObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.CheckBoxEditor;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;

public class HostTriggerPanel
extends JPanel {
    private static final long serialVersionUID = 257585203077933964L;
    private static final ArrayList<HostEnableObject> hostWithIPAddressCache = new ArrayList();
    private static final String[] columnNames = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.column.LabelEnable"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.column.LabelName"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.column.LabelContent")};
    private JTable hostTable;
    private SortableTableModel model;
    private transient ListSelectionListener tableSelectionListener;
    private transient MouseListener tableMouseListener;
    private JPopupMenu hostPopup;
    private JScrollPane scrollPane;
    private Action addAction;
    private Action deleteAction;
    private Action editAction;
    private JButton addButton;
    private JButton deleteButton;
    private JButton editButton;
    private JPanel hostButtonPanel;
    private JPanel southPanel;
    private JPanel hostListPanel;
    private JLabel descLabel;
    private transient ArrayList<HostEnableObject> hostObjects;
    private transient ArrayList<HostEnableObject> hostGroupList;
    private int direction;
    HashMap<String, String> objRefMap;
    public transient HashMap<String, HostEnableObject> objRefs;
    private ArrayList<Object> objList;
    private float[] TABLE_COLUMN_WIDTH = new float[]{0.15f, 0.4f, 0.45f};
    private HostIPAddressTypeHelper.HostIPAddressConstraintEnum ipAddressContraint = HostIPAddressTypeHelper.HostIPAddressConstraintEnum.IPv4Only;
    private boolean isMacOsPanel = false;

    public HostTriggerPanel(Vector<AbstractSchema> hostObjList, int direction, boolean isMacPanel) {
        this(hostObjList, direction, HostIPAddressTypeHelper.HostIPAddressConstraintEnum.None, isMacPanel);
    }

    public HostTriggerPanel(Vector<AbstractSchema> hostObjList, int direction, HostIPAddressTypeHelper.HostIPAddressConstraintEnum ipAddressContraint) {
        this(hostObjList, direction, ipAddressContraint, false);
    }

    public HostTriggerPanel(Vector<AbstractSchema> hostObjList, int direction, HostIPAddressTypeHelper.HostIPAddressConstraintEnum ipAddressContraint, boolean isMacPanel) {
        this.ipAddressContraint = ipAddressContraint;
        this.isMacOsPanel = isMacPanel;
        this.set(hostObjList, direction);
        this.init();
    }

    public static void resetHostWithIPAddressCache() {
        hostWithIPAddressCache.clear();
    }

    public void set(Vector<AbstractSchema> hostObjList, int direction) {
        if (this.hostObjects == null) {
            this.hostObjects = new ArrayList();
        } else {
            this.hostObjects.clear();
        }
        this.direction = direction;
        if (hostObjList != null) {
            if (this.objRefMap == null) {
                this.objRefMap = new HashMap();
            }
            for (AbstractSchema obj : hostObjList) {
                if (obj instanceof FwHostContainer) {
                    FwHostContainer container = (FwHostContainer)obj;
                    this.hostObjects.addAll(this.createHostEnableObjects(container));
                    continue;
                }
                ObjReference oRef = (ObjReference)obj;
                this.objRefMap.put(oRef.getTargetId(), oRef.getTargetId());
            }
        }
        if (this.model != null) {
            this.setDataIntoTableModel();
            this.model.fireTableDataChanged();
            if (this.hostTable.getRowCount() > 0) {
                this.hostTable.setRowSelectionInterval(0, 0);
            }
        }
    }

    protected void set(ConfigObject obj, int direction) {
    }

    protected void addHost(HostEnableObject hostObject) {
    }

    protected void deleteHost(HostEnableObject obj) {
    }

    protected void doHostTypeChanged(HostEnableObject oldHost, HostEnableObject newHost) {
        if (oldHost.getFwHostContainer() != null) {
            FwHostContainer container = oldHost.getFwHostContainer();
            container.removeChild((AbstractSchema)oldHost.getAddress());
            container.addChild((AbstractSchema)newHost.getAddress());
            newHost.setFwHostContainer(container);
        }
    }

    private void setButtonEnabled() {
        boolean isEnabled;
        int selIndex = this.hostTable.getSelectedRow();
        boolean bl = isEnabled = selIndex != -1;
        if (isEnabled) {
            SortableTableModel model = (SortableTableModel)this.hostTable.getModel();
            HostEnableObject hObject = (HostEnableObject)model.getRow(selIndex);
            boolean bl2 = isEnabled = hObject.getNetworkHostGroup() == null;
        }
        if (this.deleteButton != null) {
            this.deleteButton.setEnabled(isEnabled);
        }
        if (this.editButton != null) {
            this.editButton.setEnabled(isEnabled);
        }
        if (this.deleteAction != null) {
            this.deleteAction.setEnabled(isEnabled);
        }
        if (this.editAction != null) {
            this.editAction.setEnabled(isEnabled);
        }
    }

    private void setDataIntoTableModel() {
        Vector<TableRow> hostGroupVector = new Vector<TableRow>(this.hostObjects);
        hostGroupVector.addAll(this.getHostGroup());
        for (TableRow obj : hostGroupVector) {
            HostEnableObject hostEnableObject;
            if (!(obj instanceof HostEnableObject) || !(hostEnableObject = (HostEnableObject)obj).getEnable() || HostIPAddressTypeHelper.getIPAddressType(hostEnableObject) == HostIPAddressTypeHelper.IPAddressTypeEnum.NoIP) continue;
            this.updateHostObjectCache(hostEnableObject, true);
        }
        this.model.setDataVector(hostGroupVector);
        if (this.hostTable.getRowCount() > 0) {
            this.hostTable.setRowSelectionInterval(0, 0);
        }
    }

    private ArrayList<HostEnableObject> createHostEnableObjects(FwHostContainer container) {
        int i;
        boolean enable = true;
        if (container.getOptEnable() != null) {
            enable = container.getOptEnable();
        }
        HostEnableObject obj = null;
        ArrayList<HostEnableObject> listOfObj = new ArrayList<HostEnableObject>();
        if (container.getMacAddress() != null && container.getMacAddress().size() > 0) {
            for (i = 0; i < container.getMacAddress().size(); ++i) {
                obj = new HostEnableObject(enable, container.getMacAddress().get(i), HostObject.getTypeByIndex(0), HostEnableObject.getDirectionDesc(this.direction));
                listOfObj.add(obj);
            }
        }
        if (container.getIpAddress() != null && container.getIpAddress().size() > 0) {
            for (i = 0; i < container.getIpAddress().size(); ++i) {
                obj = new HostEnableObject(enable, container.getIpAddress().get(i), HostObject.getTypeByIndex(1), HostEnableObject.getDirectionDesc(this.direction));
                listOfObj.add(obj);
            }
        }
        if (container.getIpRange() != null && container.getIpRange().size() > 0) {
            for (i = 0; i < container.getIpRange().size(); ++i) {
                obj = new HostEnableObject(enable, container.getIpRange().get(i), HostObject.getTypeByIndex(2), HostEnableObject.getDirectionDesc(this.direction));
                listOfObj.add(obj);
            }
        }
        if (container.getSubNet() != null && container.getSubNet().size() > 0) {
            for (i = 0; i < container.getSubNet().size(); ++i) {
                obj = new HostEnableObject(enable, container.getSubNet().get(i), HostObject.getTypeByIndex(3), HostEnableObject.getDirectionDesc(this.direction));
                listOfObj.add(obj);
            }
        }
        if (container.getDnsHost() != null && container.getDnsHost().size() > 0) {
            for (i = 0; i < container.getDnsHost().size(); ++i) {
                obj = new HostEnableObject(enable, container.getDnsHost().get(i), HostObject.getTypeByIndex(4), HostEnableObject.getDirectionDesc(this.direction));
                listOfObj.add(obj);
            }
        }
        if (container.getDnsDomain() != null && container.getDnsDomain().size() > 0) {
            for (i = 0; i < container.getDnsDomain().size(); ++i) {
                obj = new HostEnableObject(enable, container.getDnsDomain().get(i), HostObject.getTypeByIndex(5), HostEnableObject.getDirectionDesc(this.direction));
                listOfObj.add(obj);
            }
        }
        if (container.getOptLocalSubnet() != null) {
            obj = new HostEnableObject(enable, container.getOptLocalSubnet(), HostObject.getTypeByIndex(7), HostEnableObject.getDirectionDesc(this.direction));
            listOfObj.add(obj);
        }
        if (container.getIpv6Address() != null && container.getIpv6Address().size() > 0) {
            for (i = 0; i < container.getIpv6Address().size(); ++i) {
                obj = new HostEnableObject(enable, container.getIpv6Address().get(i), HostObject.getTypeByIndex(8), HostEnableObject.getDirectionDesc(this.direction));
                listOfObj.add(obj);
            }
        }
        if (container.getIpv6Range() != null && container.getIpv6Range().size() > 0) {
            for (i = 0; i < container.getIpv6Range().size(); ++i) {
                obj = new HostEnableObject(enable, container.getIpv6Range().get(i), HostObject.getTypeByIndex(9), HostEnableObject.getDirectionDesc(this.direction));
                listOfObj.add(obj);
            }
        }
        if (container.getIpv6SubNet() != null && container.getIpv6SubNet().size() > 0) {
            for (i = 0; i < container.getIpv6SubNet().size(); ++i) {
                obj = new HostEnableObject(enable, container.getIpv6SubNet().get(i), HostObject.getTypeByIndex(10), HostEnableObject.getDirectionDesc(this.direction));
                listOfObj.add(obj);
            }
        }
        listOfObj.trimToSize();
        for (i = 0; i < listOfObj.size(); ++i) {
            HostEnableObject hostEnableObject = listOfObj.get(i);
            hostEnableObject.setFwHostContainer(container);
        }
        return listOfObj;
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHostListPanel(), "Center");
        this.setButtonEnabled();
    }

    private JPanel getHostListPanel() {
        if (this.hostListPanel == null) {
            this.hostListPanel = new JPanel();
            this.hostListPanel.setLayout(new BorderLayout());
            String description = this.getDescription();
            if (description != null) {
                this.descLabel = new JLabel(description, 2);
                this.descLabel.setBorder(BorderFactory.createEmptyBorder(10, 1, 0, 0));
                this.hostListPanel.add((Component)this.descLabel, "North");
            }
            this.hostListPanel.add((Component)this.getScrollPane(), "Center");
            this.hostListPanel.add((Component)this.getSouthPanel(), "South");
        }
        return this.hostListPanel;
    }

    private String getDescription() {
        switch (this.direction) {
            case 0: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.DescriptionSource");
            }
            case 1: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.DescriptionDestination");
            }
            case 2: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.DescriptionLocal");
            }
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.DescriptionRemote");
            }
            case 4: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.DescriptionIps");
            }
            case 5: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.DescriptionP2P");
            }
        }
        return null;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane(22, 31);
            this.scrollPane.getViewport().add(this.getHostTable());
        }
        return this.scrollPane;
    }

    private JTable getHostTable() {
        if (this.hostTable == null) {
            this.hostTable = new StripesTable();
            this.hostTable.setModel(this.getTableModel());
            UIUtilities.setTableColumnWidth(this.hostTable, this.TABLE_COLUMN_WIDTH, (int)this.hostTable.getPreferredScrollableViewportSize().getWidth());
            this.hostTable.getSelectionModel().setSelectionMode(0);
            this.hostTable.getSelectionModel().addListSelectionListener(this.getTableSelectionListener());
            this.hostTable.addMouseListener(this.getTableMouseListener());
            this.getTableModel().addMouseListenerToHeaderInTable(this.hostTable);
            TableColumn column = this.hostTable.getColumnModel().getColumn(0);
            column.setCellRenderer(new HostTableCheckBoxRenderer(false));
            column.setCellEditor(new CheckBoxEditor(this.hostTable){
                private static final long serialVersionUID = 1L;

                @Override
                protected void updateModel(TableModel tableModel, int selIndex) {
                    HostTriggerPanel.this.updateObject(tableModel, selIndex);
                }
            });
            if (this.hostTable.getRowCount() > 0) {
                this.hostTable.setRowSelectionInterval(0, 0);
            }
        }
        return this.hostTable;
    }

    private void updateObject(TableModel tableModel, int selIndex) {
        SortableTableModel model = (SortableTableModel)tableModel;
        HostEnableObject hostEnableObject = (HostEnableObject)model.getRow(selIndex);
        if (hostEnableObject.getEnable()) {
            if (this.isHostValid(hostEnableObject)) {
                this.addHost(hostEnableObject);
                this.updateHostObjectCache(hostEnableObject, true);
            } else {
                hostEnableObject.setEnable(false);
            }
        } else {
            this.deleteHost(hostEnableObject);
            this.updateHostObjectCache(hostEnableObject, false);
        }
        this.model.fireTableDataChanged();
    }

    private SortableTableModel getTableModel() {
        if (this.model == null) {
            this.model = new SortableTableModel(){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean isCellEditable(int row, int col) {
                    HostEnableObject hObject = (HostEnableObject)HostTriggerPanel.this.model.getRow(row);
                    return col == 0 && hObject.getNetworkHostGroup() != null;
                }
            };
            this.model.setColumnNames(columnNames);
            this.setDataIntoTableModel();
        }
        return this.model;
    }

    private ListSelectionListener getTableSelectionListener() {
        if (this.tableSelectionListener == null) {
            this.tableSelectionListener = new ListSelectionListener(){

                @Override
                public void valueChanged(ListSelectionEvent ev) {
                    if (!ev.getValueIsAdjusting()) {
                        HostTriggerPanel.this.setButtonEnabled();
                    }
                }
            };
        }
        return this.tableSelectionListener;
    }

    private MouseListener getTableMouseListener() {
        if (this.tableMouseListener == null) {
            this.tableMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent ev) {
                    int colNumber = HostTriggerPanel.this.getHostTable().columnAtPoint(ev.getPoint());
                    int rowNumber = HostTriggerPanel.this.getHostTable().rowAtPoint(ev.getPoint());
                    if (ev.getModifiers() == 4) {
                        HostTriggerPanel.this.getHostTable().setRowSelectionInterval(rowNumber, rowNumber);
                        HostTriggerPanel.this.getHostTable().setColumnSelectionInterval(colNumber, colNumber);
                        HostTriggerPanel.this.getHostPopup().show(ev.getComponent(), ev.getX(), ev.getY());
                    } else if (ev.getClickCount() == 2) {
                        HostTriggerPanel.this.editHost();
                    }
                }
            };
        }
        return this.tableMouseListener;
    }

    private List<HostEnableObject> getHostGroup() {
        if (this.hostGroupList == null) {
            this.hostGroupList = new ArrayList();
        } else {
            this.hostGroupList.clear();
        }
        try {
            for (HostGroupObject obj : HostGroupHandler.getInstance().getHostGroupsFromDB()) {
                HostEnableObject eObj = new HostEnableObject(obj, this.direction);
                if (this.objRefMap.get(obj.getHostGroup().getId()) != null) {
                    eObj.setEnable(true);
                }
                this.hostGroupList.add(eObj);
            }
        }
        catch (ConsoleException ex) {
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ServiceListDialog.title.ConsoleError"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return this.hostGroupList;
    }

    private JPopupMenu getHostPopup() {
        if (this.hostPopup == null) {
            this.hostPopup = new JPopupMenu();
            this.hostPopup.add(this.addAction);
            this.hostPopup.add(this.deleteAction);
            this.hostPopup.add(this.editAction);
        }
        this.setButtonEnabled();
        return this.hostPopup;
    }

    private void addHost() {
        HostDialog dialog;
        HostObject newObject = new HostObject(new IpAddress(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.IPAddress"), HostEnableObject.getDirectionDesc(this.direction));
        int hostDialogType = 2;
        if (this.direction == 4) {
            hostDialogType = 1;
        } else if (this.direction == 5) {
            hostDialogType = 4;
        }
        if (this.isMacOsPanel) {
            hostDialogType = 3;
        }
        if ((dialog = new HostDialog(newObject, hostDialogType)).isOk()) {
            HostObject hostObject = dialog.getObject();
            if (hostObject.getTypeAsint() == 7 && this.isLocalSubnetExisted()) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.LocalSubnetWarning"));
                return;
            }
            HostEnableObject eObj = new HostEnableObject(hostObject);
            eObj.setEnable(true);
            if (this.isHostValid(eObj)) {
                this.addHostObjects(eObj);
            }
        }
    }

    private boolean isAllowedIPAddressType(HostEnableObject newHostObject) {
        HostIPAddressTypeHelper.IPAddressTypeEnum newType = HostIPAddressTypeHelper.getIPAddressType(newHostObject);
        if (newType == HostIPAddressTypeHelper.IPAddressTypeEnum.NoIP) {
            return true;
        }
        if (this.ipAddressContraint.isForbiddenMixedBetweenHosts()) {
            if (HostIPAddressTypeHelper.getIPAddressType(newHostObject) == HostIPAddressTypeHelper.IPAddressTypeEnum.Mixed) {
                return false;
            }
            HostIPAddressTypeHelper.IPAddressTypeEnum existingType = HostIPAddressTypeHelper.getIPAddressType(hostWithIPAddressCache);
            if (existingType != HostIPAddressTypeHelper.IPAddressTypeEnum.NoIP && existingType != newType) {
                return false;
            }
        } else if (this.ipAddressContraint.isIPv4Only() && newType != HostIPAddressTypeHelper.IPAddressTypeEnum.IPv4Only) {
            return false;
        }
        return true;
    }

    private void updateHostObjectCache(HostEnableObject hostObject, boolean add) {
        if (add) {
            if (hostObject.getEnable() && HostIPAddressTypeHelper.getIPAddressType(hostObject) != HostIPAddressTypeHelper.IPAddressTypeEnum.NoIP) {
                hostWithIPAddressCache.add(hostObject);
            }
        } else {
            hostWithIPAddressCache.remove(hostObject);
        }
    }

    private void addHostObjects(HostEnableObject eObj) {
        if (this.isHostValid(eObj)) {
            this.hostObjects.add(eObj);
            this.getTableModel().insertRow(0, eObj);
            this.addHost(eObj);
            this.hostTable.setRowSelectionInterval(0, 0);
        }
    }

    private boolean isHostValid(HostEnableObject hostObject) {
        if (!this.isAllowedIPAddressType(hostObject)) {
            if (this.ipAddressContraint.isForbiddenMixedBetweenHosts()) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.hostIPAddressWarning"));
            }
            if (this.ipAddressContraint.isIPv4Only()) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.notAllowIPv6InIPSPolicy"));
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isLocalSubnetExisted() {
        List list = (List)Cast.cast(this.getTableModel().getAllRows());
        if (list != null) {
            for (HostEnableObject obj : list) {
                if (obj.getTypeAsint() != 7) continue;
                return true;
            }
        }
        return false;
    }

    private void deleteHost() {
        int index = this.getHostTable().getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.error.SelectBeforeDeleteHost"));
            return;
        }
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.ConfirmDeleteHost");
        int result = UIUtilities.confirmYesNoOptionDialog(message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.title.DeleteHost"));
        if (result == 0) {
            HostEnableObject hostObject = (HostEnableObject)this.getTableModel().getDataVector().get(index);
            this.getTableModel().removeRow(index);
            int count = this.hostTable.getRowCount();
            if (index < count) {
                this.hostTable.setRowSelectionInterval(index, index);
            } else if (index != 0) {
                this.hostTable.setRowSelectionInterval(index - 1, index - 1);
            }
            this.deleteHost(hostObject);
            this.setButtonEnabled();
        }
    }

    private void editHost() {
        HostDialog dialog;
        int hostDialogType;
        int index = this.getHostTable().getSelectedRow();
        if (index == -1) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.SelectBeforeEditHost"));
            return;
        }
        HostEnableObject hostEnableObj = (HostEnableObject)this.getTableModel().getRow(index);
        if (hostEnableObj.getNetworkHostGroup() != null) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostTriggerPanel.error.HostGroupCantEdit"));
            return;
        }
        boolean enableHost = hostEnableObj.getEnable();
        HostObject hObj = new HostObject(hostEnableObj.getAddress(), hostEnableObj.getType(), hostEnableObj.getDirection());
        int originalType = hObj.getTypeAsint();
        int n = hostDialogType = this.direction == 4 || this.direction == 5 ? 1 : 2;
        if (this.isMacOsPanel) {
            hostDialogType = 3;
        }
        if ((dialog = new HostDialog(hObj, hostDialogType, false)).isOk()) {
            HostObject newHostObject = dialog.getObject();
            if (newHostObject.getTypeAsint() == 7 && this.isLocalSubnetExisted() && originalType != 7) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.LocalSubnetWarning"));
                return;
            }
            if (originalType == 7 && newHostObject.getTypeAsint() == 7) {
                return;
            }
            this.getTableModel().removeRow(index);
            HostEnableObject eObj = new HostEnableObject(newHostObject);
            eObj.setEnable(enableHost);
            if (this.isHostTypechanged(hostEnableObj, eObj)) {
                this.doHostTypeChanged(hostEnableObj, eObj);
            }
            this.getTableModel().insertRow(index, eObj);
            this.moveToRow(index);
        }
    }

    private boolean isHostTypechanged(HostEnableObject oldHost, HostEnableObject newHost) {
        return !oldHost.getType().equals(newHost.getType());
    }

    private JPanel getHostButtonPanel() {
        if (this.hostButtonPanel == null) {
            this.addAction = new AbstractAction(UIText.get(5)){
                private static final long serialVersionUID = -128046622949695946L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    HostTriggerPanel.this.addHost();
                }
            };
            this.deleteAction = new AbstractAction(UIText.get(769)){
                private static final long serialVersionUID = -5512221478350334182L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    HostTriggerPanel.this.deleteHost();
                }
            };
            this.editAction = new AbstractAction(UIText.get(1024)){
                private static final long serialVersionUID = 6770651767326893761L;

                @Override
                public void actionPerformed(ActionEvent ev) {
                    HostTriggerPanel.this.editHost();
                }
            };
            this.addButton = new JButton(this.addAction);
            this.deleteButton = new JButton(this.deleteAction);
            this.deleteButton.setEnabled(false);
            this.editButton = new JButton(this.editAction);
            this.editButton.setEnabled(false);
            JButton[] buttons = new JButton[]{this.addButton, this.editButton, this.deleteButton};
            this.hostButtonPanel = new ButtonPane(buttons, 1);
        }
        return this.hostButtonPanel;
    }

    private JPanel getSouthPanel() {
        if (this.southPanel == null) {
            this.southPanel = new JPanel();
            this.southPanel.setLayout(new GridBagLayout());
            this.southPanel.add((Component)this.getHostButtonPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
            DescriptionTextArea warning = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.DescriptionIpsWarning"));
            if (this.direction == 5) {
                warning = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.notAllowIPv6InIPSPolicy"));
            }
            this.southPanel.add((Component)warning, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        }
        return this.southPanel;
    }

    private void moveToRow(int row) {
        this.getHostTable().setRowSelectionInterval(row, row);
        Rectangle cellRect = this.getHostTable().getCellRect(row, 0, false);
        if (cellRect != null) {
            this.getHostTable().scrollRectToVisible(cellRect);
        }
    }

    public void setLocalSource(LocalHostTrigger local, SourceHostTrigger source) {
    }

    public void setRemoteDestination(RemoteHostTrigger remote, DestinationHostTrigger destination) {
    }

    public ArrayList<HostEnableObject> getHostObjects() {
        Vector vHostEnable = (Vector)Cast.cast(this.getTableModel().getDataVector());
        ArrayList<HostEnableObject> aHost = new ArrayList<HostEnableObject>();
        if (vHostEnable != null) {
            for (HostEnableObject eObj : vHostEnable) {
                if (eObj.getNetworkHostGroup() != null) {
                    if (!eObj.getEnable()) continue;
                    aHost.add(eObj);
                    continue;
                }
                aHost.add(eObj);
            }
        }
        return aHost;
    }

    public HashMap<String, HostEnableObject> getAllObjRefs() {
        Vector vecHostEnable = (Vector)Cast.cast(this.getTableModel().getDataVector());
        this.objRefs = new HashMap();
        if (vecHostEnable != null) {
            for (HostEnableObject enableObj : vecHostEnable) {
                if (enableObj.getNetworkHostGroup() == null || !enableObj.getEnable()) continue;
                this.objRefs.put(enableObj.getNetworkHostGroup().getId(), enableObj);
            }
        }
        return this.objRefs;
    }

    public ArrayList<Object> getAllObjs() {
        Vector vecHostEnable = (Vector)Cast.cast(this.getTableModel().getDataVector());
        this.objList = new ArrayList();
        if (vecHostEnable != null) {
            for (int i = 0; i < vecHostEnable.size(); ++i) {
                HostEnableObject enableObj = (HostEnableObject)vecHostEnable.get(i);
                if (enableObj.getNetworkHostGroup() != null) continue;
                this.objList.add(enableObj.getAddress());
            }
        }
        return this.objList;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setHostTrigger() {
    }

    public void setDirection(int dir) {
        this.direction = dir;
        this.setBorder(BorderFactory.createTitledBorder(HostEnableObject.getDirectionDesc(dir)));
        this.descLabel.setText(this.getDescription());
    }

    public void setArrayList(Vector<ConfigObject> children, int dir) {
        this.direction = dir;
        this.hostObjects.clear();
        for (int i = 0; i < children.size(); ++i) {
            Object hObj = children.get(i);
            if (hObj instanceof FwHostContainer) {
                hObj = ((FwHostContainer)hObj).getChildren().get(0);
            }
            if (!(hObj instanceof HostObject)) continue;
            ((HostObject)hObj).setDirection(HostEnableObject.getDirectionDesc(this.direction));
            this.hostObjects.add(new HostEnableObject((HostObject)hObj));
        }
        this.setBorder(BorderFactory.createTitledBorder(HostEnableObject.getDirectionDesc(dir)));
        this.descLabel.setText(this.getDescription());
    }

    public Vector<HostObject> getAllHostObjects() {
        Vector vHostEnable = (Vector)Cast.cast(this.getTableModel().getDataVector());
        Vector<HostObject> vHost = new Vector<HostObject>();
        if (vHostEnable != null) {
            for (int i = 0; i < vHostEnable.size(); ++i) {
                HostEnableObject eObj = (HostEnableObject)vHostEnable.get(i);
                eObj.setDirection(HostEnableObject.getDirectionDesc(this.direction));
                if (eObj.getNetworkHostGroup() != null) {
                    if (!eObj.getEnable()) continue;
                    vHost.add(new HostObject(eObj));
                    continue;
                }
                vHost.add(new HostObject(eObj));
            }
        }
        return vHost;
    }

    public static class HostTableCheckBoxRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = -8246105839197919641L;
        private boolean isEditable;

        public HostTableCheckBoxRenderer(boolean isEditable) {
            this.isEditable = isEditable;
            super.setEnabled(isEditable);
            this.setHorizontalAlignment(0);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            SortableTableModel model;
            TableRow modelData;
            if (table.isEnabled() && (modelData = (model = (SortableTableModel)table.getModel()).getRow(row)) instanceof HostEnableObject) {
                boolean bl = this.isEditable = ((HostEnableObject)modelData).getNetworkHostGroup() != null;
                if (this.isEditable) {
                    super.setEnabled(this.isEditable);
                    if (isSelected) {
                        this.setForeground(table.getSelectionForeground());
                        super.setBackground(table.getSelectionBackground());
                    } else {
                        this.setForeground(table.getForeground());
                        this.setBackground(UIColorUtilities.TABLE_EDITABLE_CELL_BG_COLOR);
                    }
                } else {
                    super.setEnabled(false);
                    if (isSelected) {
                        this.setForeground(table.getSelectionForeground());
                        super.setBackground(table.getSelectionBackground());
                    } else {
                        this.setForeground(table.getForeground());
                        this.setBackground(table.getBackground());
                    }
                }
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }
}

