/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.DestinationHostTrigger;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.FwHostTrigger;
import com.sygate.scm.common.configobject.schema.LocalHostTrigger;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.RemoteHostTrigger;
import com.sygate.scm.common.configobject.schema.SourceHostTrigger;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostTriggerPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.LocalSourceHostListTriggerPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.RemoteDestinationHostListTriggerPanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.ui.util.DialogBase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HostListDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private JPanel hostListPanel;
    private JPanel typePanel;
    private HostTriggerPanel sourceContainerPanel;
    private HostTriggerPanel destContainerPanel;
    private JRadioButton sourceDestButton;
    private JRadioButton localRemoteButton;
    private FwHostTrigger hostTrigger;
    private LocalHostTrigger localTrigger;
    private RemoteHostTrigger remoteTrigger;
    private SourceHostTrigger sourceTrigger;
    private DestinationHostTrigger destinationTrigger;
    private boolean isMacOsRulePanel = false;

    public HostListDialog(FwHostTrigger hostTrigger, boolean isMacPanel) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostListDialog.title.HostList"), true);
        this.hostTrigger = hostTrigger;
        this.isMacOsRulePanel = isMacPanel;
        HostTriggerPanel.resetHostWithIPAddressCache();
        this.init();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_rules_host";
    }

    int getSizeOfHosts(Vector<AbstractSchema> hostV) {
        int size = 0;
        for (int i = 0; i < hostV.size(); ++i) {
            AbstractSchema obj = hostV.get(i);
            if (obj instanceof ObjReference) {
                ++size;
                continue;
            }
            if (!(obj instanceof FwHostContainer)) continue;
            size += ((FwHostContainer)obj).getChildren().size();
        }
        return size;
    }

    LocalHostTrigger getLocalTrigger() {
        if (this.localTrigger == null) {
            this.localTrigger = this.hostTrigger.getOptLocalHostTrigger();
            if (this.localTrigger == null) {
                this.localTrigger = new LocalHostTrigger();
                this.hostTrigger.setOptLocalHostTrigger(this.localTrigger);
            }
        }
        return this.localTrigger;
    }

    RemoteHostTrigger getRemoteTrigger() {
        if (this.remoteTrigger == null) {
            this.remoteTrigger = this.hostTrigger.getOptRemoteHostTrigger();
            if (this.remoteTrigger == null) {
                this.remoteTrigger = new RemoteHostTrigger();
                this.hostTrigger.setOptRemoteHostTrigger(this.remoteTrigger);
            }
        }
        return this.remoteTrigger;
    }

    SourceHostTrigger getSourceTrigger() {
        if (this.sourceTrigger == null) {
            this.sourceTrigger = this.hostTrigger.getOptSourceHostTrigger();
            if (this.sourceTrigger == null) {
                this.sourceTrigger = new SourceHostTrigger();
                this.hostTrigger.setOptSourceHostTrigger(this.sourceTrigger);
            }
        }
        return this.sourceTrigger;
    }

    DestinationHostTrigger getDestinationTrigger() {
        if (this.destinationTrigger == null) {
            this.destinationTrigger = this.hostTrigger.getOptDestinationHostTrigger();
            if (this.destinationTrigger == null) {
                this.destinationTrigger = new DestinationHostTrigger();
                this.hostTrigger.setOptDestinationHostTrigger(this.destinationTrigger);
            }
        }
        return this.destinationTrigger;
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getTopPanel(), "North");
        this.getContentPane().add((Component)this.getHostListPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(550, 500));
        this.setValues();
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private void setValues() {
        int sourceHosts = 0;
        if (this.hostTrigger == null) {
            this.getLocalRemoteButton().setSelected(true);
            return;
        }
        if (this.hostTrigger.getOptSourceHostTrigger() != null) {
            sourceHosts = this.getSizeOfHosts(this.hostTrigger.getOptSourceHostTrigger().getChildren());
        }
        int destHosts = 0;
        if (this.hostTrigger.getOptDestinationHostTrigger() != null) {
            destHosts = this.getSizeOfHosts(this.hostTrigger.getOptDestinationHostTrigger().getChildren());
        }
        if (sourceHosts > 0 || destHosts > 0) {
            this.getSourceDestButton().setSelected(true);
            this.getSourceContainerPanel().set(this.hostTrigger.getOptSourceHostTrigger().getChildren(), 0);
            this.getDestContainerPanel().set(this.hostTrigger.getOptDestinationHostTrigger().getChildren(), 1);
        } else {
            this.getLocalRemoteButton().setSelected(true);
            this.getSourceContainerPanel().set(this.hostTrigger.getOptLocalHostTrigger().getChildren(), 2);
            this.getDestContainerPanel().set(this.hostTrigger.getOptRemoteHostTrigger().getChildren(), 3);
        }
    }

    private JPanel getTopPanel() {
        if (this.typePanel == null) {
            this.typePanel = new JPanel();
            JPanel radioPanel = new JPanel();
            ButtonGroup group = new ButtonGroup();
            group.add(this.getSourceDestButton());
            group.add(this.getLocalRemoteButton());
            radioPanel.setLayout(new BoxLayout(radioPanel, 0));
            radioPanel.add(Box.createHorizontalGlue());
            radioPanel.add(this.getSourceDestButton());
            radioPanel.add(this.getLocalRemoteButton());
            radioPanel.setPreferredSize(new Dimension(500, 25));
            this.typePanel.setLayout(new BoxLayout(this.typePanel, 1));
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(0));
            JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostListDialog.label.ListHostsThatTriggerRule"));
            label.setHorizontalAlignment(2);
            panel.add(label);
            this.typePanel.add(panel);
            this.typePanel.add(radioPanel);
        }
        return this.typePanel;
    }

    private JRadioButton getSourceDestButton() {
        if (this.sourceDestButton == null) {
            this.sourceDestButton = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostListDialog.radio.SourceDestination"));
            this.sourceDestButton.setPreferredSize(new Dimension(250, 25));
            this.sourceDestButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ev) {
                    HostListDialog.this.setPanels();
                }
            });
        }
        return this.sourceDestButton;
    }

    private JRadioButton getLocalRemoteButton() {
        if (this.localRemoteButton == null) {
            this.localRemoteButton = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostListDialog.radio.LocalRemote"));
            this.localRemoteButton.setPreferredSize(new Dimension(250, 25));
            this.localRemoteButton.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent ev) {
                    HostListDialog.this.setPanels();
                }
            });
        }
        return this.localRemoteButton;
    }

    private JPanel getHostListPanel() {
        if (this.hostListPanel == null) {
            this.hostListPanel = new JPanel();
            this.hostListPanel.setLayout(new BoxLayout(this.hostListPanel, 1));
            this.hostListPanel.add(this.getSourceContainerPanel());
            this.hostListPanel.add(this.getDestContainerPanel());
        }
        return this.hostListPanel;
    }

    private HostTriggerPanel getSourceContainerPanel() {
        if (this.sourceContainerPanel == null) {
            this.sourceContainerPanel = new LocalSourceHostListTriggerPanel(this.getSourceTrigger(), 0, this.isMacOsRulePanel);
            this.sourceContainerPanel.setLocalSource(this.getLocalTrigger(), this.getSourceTrigger());
            this.sourceContainerPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostListDialog.title.Source")));
            this.sourceContainerPanel.setPreferredSize(new Dimension(500, 200));
        }
        return this.sourceContainerPanel;
    }

    private HostTriggerPanel getDestContainerPanel() {
        if (this.destContainerPanel == null) {
            this.destContainerPanel = new RemoteDestinationHostListTriggerPanel(this.getDestinationTrigger(), 1, this.isMacOsRulePanel);
            this.destContainerPanel.setRemoteDestination(this.getRemoteTrigger(), this.getDestinationTrigger());
            this.destContainerPanel.setBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostListDialog.title.Destination")));
            this.destContainerPanel.setPreferredSize(new Dimension(500, 200));
        }
        return this.destContainerPanel;
    }

    private void setPanels() {
        if (this.getLocalRemoteButton().isSelected()) {
            this.getSourceContainerPanel().setDirection(2);
            this.getDestContainerPanel().setDirection(3);
        } else if (this.getSourceDestButton().isSelected()) {
            this.getSourceContainerPanel().setDirection(0);
            this.getDestContainerPanel().setDirection(1);
        }
        this.invalidate();
        this.validate();
        this.repaint();
    }

    public ArrayList<HostObject> getNewHostObjects() {
        ArrayList<HostObject> list = new ArrayList<HostObject>();
        list.addAll(this.getSourceContainerPanel().getAllHostObjects());
        list.addAll(this.getDestContainerPanel().getAllHostObjects());
        return list;
    }

    public boolean isCancel() {
        return !this.isOk;
    }
}

