/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostEnableObject;
import java.util.ArrayList;

public class HostIPAddressTypeHelper {
    public static IPAddressTypeEnum getIPAddressType(HostEnableObject hostObject) {
        boolean hasIPv4 = false;
        boolean hasIPv6 = false;
        FwHostContainer container = hostObject.getFwHostContainer();
        if (container != null) {
            if (container.getIpv6AddressCount() > 0 || container.getIpv6RangeCount() > 0 || container.getIpv6SubNetCount() > 0) {
                hasIPv6 = true;
            } else if (container.getIpAddressCount() > 0 || container.getIpRangeCount() > 0 || container.getSubNetCount() > 0) {
                hasIPv4 = true;
            }
        } else {
            Object address = hostObject.getAddress();
            if (address instanceof Ipv6Address || address instanceof Ipv6Range || address instanceof Ipv6SubNet) {
                hasIPv6 = true;
            } else if (address instanceof IpAddress || address instanceof IpRange || address instanceof SubNet) {
                hasIPv4 = true;
            }
        }
        return HostIPAddressTypeHelper.buildIPAddressType(hasIPv4, hasIPv6);
    }

    public static IPAddressTypeEnum getIPAddressType(ArrayList<HostEnableObject> allHostWithIPAddress) {
        boolean hasIPv4 = false;
        boolean hasIPv6 = false;
        for (HostEnableObject host : allHostWithIPAddress) {
            IPAddressTypeEnum type = HostIPAddressTypeHelper.getIPAddressType(host);
            if (type == IPAddressTypeEnum.IPv4Only) {
                hasIPv4 = true;
                continue;
            }
            if (type == IPAddressTypeEnum.IPv6Only) {
                hasIPv6 = true;
                continue;
            }
            if (type != IPAddressTypeEnum.Mixed) continue;
            hasIPv4 = true;
            hasIPv6 = true;
        }
        return HostIPAddressTypeHelper.buildIPAddressType(hasIPv4, hasIPv6);
    }

    public static IPAddressTypeEnum buildIPAddressType(boolean hasIPv4, boolean hasIPv6) {
        IPAddressTypeEnum type = IPAddressTypeEnum.NoIP;
        type = hasIPv4 && hasIPv6 ? IPAddressTypeEnum.Mixed : (hasIPv4 ? IPAddressTypeEnum.IPv4Only : (hasIPv6 ? IPAddressTypeEnum.IPv6Only : IPAddressTypeEnum.NoIP));
        return type;
    }

    public static enum IPAddressTypeEnum {
        NoIP(0),
        IPv4Only(0),
        IPv6Only(0),
        Mixed(3);

        private final int mode;

        private IPAddressTypeEnum(int value) {
            this.mode = value;
        }

        public boolean isMixedIPv4v6() {
            return this.mode == IPAddressTypeEnum.Mixed.mode;
        }

        public boolean hasIPAddress() {
            return this.mode != IPAddressTypeEnum.NoIP.mode;
        }
    }

    public static enum HostIPAddressConstraintEnum {
        IPv4Only(0),
        ForbiddenMixedBetweenHosts(2),
        None(4);

        private final int mode;

        private HostIPAddressConstraintEnum(int value) {
            this.mode = value;
        }

        public boolean isForbiddenMixedBetweenHosts() {
            return this.mode == HostIPAddressConstraintEnum.ForbiddenMixedBetweenHosts.mode;
        }

        public boolean isIPv4Only() {
            return this.mode == HostIPAddressConstraintEnum.IPv4Only.mode;
        }

        public boolean isNone() {
            return this.mode == HostIPAddressConstraintEnum.None.mode;
        }
    }
}

