/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.schema.DnsDomain;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.FwUnregulatedHosts;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.LocalSubnet;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostIPAddressTypeHelper;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostTriggerPanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostEnableObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class HostGroupDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private JPanel jPanel = null;
    private HostTriggerPanel hostPanel;
    private FwUnregulatedHosts _unregulatedHosts;
    HashMap<String, ObjReference> objRefMap = new HashMap();
    private int direction = 4;

    public HostGroupDialog(JFrame parent, String title, boolean modal, FwUnregulatedHosts hostContainerObject) {
        super(parent, title, modal);
        this._unregulatedHosts = hostContainerObject;
        this.init();
    }

    public HostGroupDialog(JFrame parent, String title, boolean modal, FwUnregulatedHosts hostContainerObject, int direction) {
        super(parent, title, modal);
        this._unregulatedHosts = hostContainerObject;
        this.direction = direction;
        this.init();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_intrusion_prevention_excluded_hosts";
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.setContentPane(this.getJPanel());
        this.pack();
        UiUtilities.centerComponent((Component)this);
        if (this.isReadOnly()) {
            UIUtilities.setContainerStatus(this.hostPanel, false);
            this.resetOKButton(false);
        }
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new BorderLayout());
            this.jPanel.add((Component)this.getHostPanel(), "Center");
            this.jPanel.add((Component)this.getButtonPanel(), "South");
            this.jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        return this.jPanel;
    }

    private JPanel getHostPanel() {
        if (this.hostPanel == null) {
            this.hostPanel = new HostTriggerPanel((Vector<AbstractSchema>)this._unregulatedHosts.getChildren(), this.direction, HostIPAddressTypeHelper.HostIPAddressConstraintEnum.None);
            this.hostPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostGroupDialog.title.HostList")));
            HostTriggerPanel.resetHostWithIPAddressCache();
        }
        return this.hostPanel;
    }

    public FwUnregulatedHosts getUnregulatedHosts() {
        FwHostContainer container = this._unregulatedHosts.getOptFwHostContainer();
        HashMap<String, ObjReference> oldObjRefMap = new HashMap<String, ObjReference>();
        for (int i = 0; i < this._unregulatedHosts.getObjReferenceCount(); ++i) {
            oldObjRefMap.put(this._unregulatedHosts.getObjReference(i).getTargetId(), this._unregulatedHosts.getObjReference(i));
        }
        HashMap<String, HostEnableObject> newObjRefMap = this.hostPanel.getAllObjRefs();
        for (HostEnableObject eObj : newObjRefMap.values()) {
            FwNetworkHostGroup hostGroup = eObj.getNetworkHostGroup();
            if (hostGroup == null || oldObjRefMap.containsKey(hostGroup.getId())) continue;
            ObjReference ref = new ObjReference();
            ref.setName(hostGroup.getName());
            ref.setTargetId(hostGroup.getId());
            ref.setTargetType(hostGroup.getObjectTypeName());
            ref.setOptEnable(Boolean.valueOf(eObj.getEnable()));
            this._unregulatedHosts.addObjReference(ref);
        }
        for (ObjReference ref : oldObjRefMap.values()) {
            if (newObjRefMap.containsKey(ref.getTargetId())) continue;
            this._unregulatedHosts.removeObjReference(ref);
        }
        ArrayList<Object> newObjList = this.hostPanel.getAllObjs();
        Vector v = container.getChildren();
        for (Object address : newObjList) {
            if (v.contains(address)) {
                this.updateAddress(container, address);
                continue;
            }
            this.addAddress(container, address);
        }
        for (Object address : v) {
            if (newObjList.contains(address)) continue;
            this.deleteAddress(container, address);
        }
        this._unregulatedHosts.setOptFwHostContainer(container);
        return this._unregulatedHosts;
    }

    private void deleteAddress(FwHostContainer container, Object address) {
        if (address instanceof IpAddress) {
            container.removeIpAddress((IpAddress)address);
        } else if (address instanceof IpRange) {
            container.removeIpRange((IpRange)address);
        } else if (address instanceof MacAddress) {
            container.removeMacAddress((MacAddress)address);
        } else if (address instanceof SubNet) {
            container.removeSubNet((SubNet)address);
        } else if (address instanceof DnsDomain) {
            container.removeDnsDomain((DnsDomain)address);
        } else if (address instanceof DnsHost) {
            container.removeDnsHost((DnsHost)address);
        } else if (address instanceof Ipv6Address) {
            container.removeIpv6Address((Ipv6Address)address);
        } else if (address instanceof Ipv6Range) {
            container.removeIpv6Range((Ipv6Range)address);
        } else if (address instanceof Ipv6SubNet) {
            container.removeIpv6SubNet((Ipv6SubNet)address);
        }
    }

    private void updateAddress(FwHostContainer container, Object address) {
        int index = 0;
        if (address instanceof IpAddress) {
            index = container.getIpAddress().indexOf(address);
            container.setChild(index, (AbstractSchema)((IpAddress)address));
        } else if (address instanceof IpRange) {
            index = container.getIpRange().indexOf(address);
            container.setChild(index, (AbstractSchema)((IpRange)address));
        } else if (address instanceof MacAddress) {
            index = container.getMacAddress().indexOf(address);
            container.setChild(index, (AbstractSchema)((MacAddress)address));
        } else if (address instanceof SubNet) {
            index = container.getSubNet().indexOf(address);
            container.setChild(index, (AbstractSchema)((SubNet)address));
        } else if (address instanceof DnsDomain) {
            index = container.getDnsDomain().indexOf(address);
            container.setChild(index, (AbstractSchema)((DnsDomain)address));
        } else if (address instanceof DnsHost) {
            index = container.getDnsHost().indexOf(address);
            container.setChild(index, (AbstractSchema)((DnsHost)address));
        } else if (address instanceof Ipv6Address) {
            index = container.getIpv6Address().indexOf(address);
            container.setChild(index, (AbstractSchema)((Ipv6Address)address));
        } else if (address instanceof Ipv6Range) {
            index = container.getIpv6Range().indexOf(address);
            container.setChild(index, (AbstractSchema)((Ipv6Range)address));
        } else if (address instanceof Ipv6SubNet) {
            index = container.getIpv6SubNet().indexOf(address);
            container.setChild(index, (AbstractSchema)((Ipv6SubNet)address));
        }
    }

    private void addAddress(FwHostContainer container, Object address) {
        if (address instanceof IpAddress) {
            container.addIpAddress((IpAddress)address);
        } else if (address instanceof IpRange) {
            container.addIpRange((IpRange)address);
        } else if (address instanceof MacAddress) {
            container.addMacAddress((MacAddress)address);
        } else if (address instanceof SubNet) {
            container.addSubNet((SubNet)address);
        } else if (address instanceof DnsDomain) {
            container.addDnsDomain((DnsDomain)address);
        } else if (address instanceof DnsHost) {
            container.addDnsHost((DnsHost)address);
        } else if (address instanceof LocalSubnet) {
            container.setOptLocalSubnet((LocalSubnet)address);
        } else if (address instanceof Ipv6Address) {
            container.addIpv6Address((Ipv6Address)address);
        } else if (address instanceof Ipv6Range) {
            container.addIpv6Range((Ipv6Range)address);
        } else if (address instanceof Ipv6SubNet) {
            container.addIpv6SubNet((Ipv6SubNet)address);
        }
    }
}

