/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.schema.DnsDomain;
import com.sygate.scm.common.configobject.schema.DnsHost;
import com.sygate.scm.common.configobject.schema.IpAddress;
import com.sygate.scm.common.configobject.schema.IpRange;
import com.sygate.scm.common.configobject.schema.Ipv6Address;
import com.sygate.scm.common.configobject.schema.Ipv6Range;
import com.sygate.scm.common.configobject.schema.Ipv6SubNet;
import com.sygate.scm.common.configobject.schema.LocalSubnet;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.configobject.schema.SubNet;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.PopupList;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.IPField;
import com.sygate.scm.console.ui.util.IPv6Field;
import com.sygate.scm.console.ui.util.IPv6RangePane;
import com.sygate.scm.console.ui.util.IPv6SubnetPane;
import com.sygate.scm.console.ui.util.IpRangePane;
import com.sygate.scm.console.ui.util.MacField;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.SubnetPane;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class HostDialog
extends DialogBase {
    public static final int TYPE_GENERAL = 0;
    public static final int TYPE_IPS_EXCLUDED_HOST = 1;
    public static final int TYPE_IPS_WITH_LOCAL_SUBNET = 2;
    public static final int TYPE_MAC = 3;
    public static final int TYPE_P2P = 4;
    public static final String INVALID_IP_ADDRESS = "0.0.0.0";
    private static final long serialVersionUID = -6633079570724301195L;
    private static final String[] ALL_DIRECTIONS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.DirectionLocal"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.DirectionRemote"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.DirectionSource"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.DirectionDestination")};
    private int dialogType;
    private JComboBox<String> ipVerCombo;
    private static int ID_IP_TYPE_V4 = 0;
    private static int ID_IP_TYPE_V6 = 1;
    private JComboBox<String> typeCombo;
    private static final String[] IP_VERSIONS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.combo.Ipv4Text"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.combo.Ipv6Text")};
    private JPanel innerPanel = null;
    private JPanel comboPanel = null;
    private JPanel displayPanel;
    private CardLayout displayPanelLayout;
    private ArrayList<JLabel> labels;
    private MacField macField;
    private IPField ipField;
    private IpRangePane ipRangePane;
    private SubnetPane subNetPane;
    private JTextField dnsHostTxtField;
    private JTextField dnsDomainTxtField;
    private IPv6Field ipv6Field;
    private IPv6RangePane ipv6RangePane;
    private IPv6SubnetPane ipv6SubnetPane;
    private JButton listButton;
    private HostObject hostObject;
    private boolean isCancel = true;
    private static final String ID_DNSDOMAIN = "DNS_DOMAIN";
    private static final String ID_DNSHOST = "DNS_HOST";
    private static final String ID_IPADDR = "IP_ADDR";
    private static final String ID_IPRANGE = "IP_RANGE";
    private static final String ID_MACADDR = "MAC_ADDR";
    private static final String ID_SUBNET = "SUBNET";
    private static final String ID_LOCAL_SUBNET = "LOCALSUBNET";
    private static final String ID_IPV6ADDR = "IPV6_ADDR";
    private static final String ID_IPV6RANGE = "IPV6_RANGE";
    private static final String ID_IPV6SUBNET = "IPV6_SUBNET";
    private static final int DEFAULT_TEXTFIELD_WIDTH = 120;
    private static final int DEFAULT_IPV6_TEXTFIELD_WIDTH = 280;
    private static final int DEFAULT_TEXTFIELD_HEIGHT = 28;
    private String[] hostTypes;

    public HostDialog() {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.AddHost"), true);
        this.hostObject = new HostObject(new MacAddress(), HostObject.getTypeByIndex(0), ALL_DIRECTIONS[0]);
        this.init();
    }

    public HostDialog(HostObject obj, int hostDialogType) {
        this(obj, hostDialogType, true);
    }

    public HostDialog(HostObject obj, int hostDialogType, boolean openingForAdd) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.AddHost"), true);
        if (!openingForAdd) {
            this.setTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.Host"));
        }
        this.hostObject = obj;
        this.dialogType = hostDialogType;
        switch (hostDialogType) {
            case 1: 
            case 4: {
                this.hostTypes = new String[3];
                this.hostTypes[0] = HostObject.getTypeByIndex(1);
                this.hostTypes[1] = HostObject.getTypeByIndex(2);
                this.hostTypes[2] = HostObject.getTypeByIndex(3);
                break;
            }
            case 2: {
                this.hostTypes = new String[7];
                this.hostTypes[0] = HostObject.getTypeByIndex(0);
                this.hostTypes[1] = HostObject.getTypeByIndex(1);
                this.hostTypes[2] = HostObject.getTypeByIndex(2);
                this.hostTypes[3] = HostObject.getTypeByIndex(3);
                this.hostTypes[4] = HostObject.getTypeByIndex(4);
                this.hostTypes[5] = HostObject.getTypeByIndex(5);
                this.hostTypes[6] = HostObject.getTypeByIndex(7);
                break;
            }
            case 3: {
                this.hostTypes = new String[4];
                this.hostTypes[0] = HostObject.getTypeByIndex(1);
                this.hostTypes[1] = HostObject.getTypeByIndex(2);
                this.hostTypes[2] = HostObject.getTypeByIndex(3);
                this.hostTypes[3] = HostObject.getTypeByIndex(4);
                break;
            }
            default: {
                this.hostTypes = new String[6];
                System.arraycopy(HostObject.getTypes(), 0, this.hostTypes, 0, 6);
            }
        }
        Arrays.sort(this.hostTypes);
        this.init();
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_host_groups_add_host_group";
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.labels = new ArrayList();
        this.getContentPane().setLayout(new BorderLayout());
        this.ipVerCombo = new JComboBox<String>(IP_VERSIONS);
        this.typeCombo = new JComboBox<String>(this.hostTypes);
        String description = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.description.Host");
        this.innerPanel = new JPanel(new BorderLayout(10, 10));
        this.innerPanel.setBorder(BorderFactory.createEmptyBorder(10, 30, 10, 30));
        this.innerPanel.add((Component)new JLabel(description), "North");
        this.innerPanel.add((Component)this.getComboPanel(), "Center");
        this.innerPanel.add((Component)this.getDisplayPanel(), "South");
        this.getContentPane().add((Component)this.innerPanel, "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.typeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                HostDialog.this.typeChanged();
            }
        });
        this.ipVerCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                HostDialog.this.typeChanged();
            }
        });
        UIUtilities.fitJComponent(this.labels.toArray(new JComponent[0]));
        this.setValues();
        this.pack();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public void typeChanged() {
        int index = this.getHostObjectTypeFromComboSelections();
        if (index != this.hostObject.getTypeAsint()) {
            this.hostObject = (HostObject)this.getNewHostObject();
            this.updateDisplay();
        }
    }

    public void setObject(HostObject obj) {
        this.hostObject = obj;
        this.updateDisplay();
    }

    private void setValues() {
        Object address = this.hostObject.getAddress();
        this.typeCombo.setSelectedIndex(this.getAddressTypeComboIndex(this.hostObject.getType()));
        this.ipVerCombo.setSelectedIndex(this.getIpVerComboIndex(this.hostObject.getType()));
        int type = this.getHostObjectTypeFromComboSelections();
        this.typeChanged();
        switch (type) {
            case 0: {
                String content = ((MacAddress)address).getContent();
                this.macField.setText(content);
                break;
            }
            case 1: {
                String ipContent = ((IpAddress)address).getContent();
                this.ipField.setText(ipContent);
                break;
            }
            case 2: {
                String start = ((IpRange)address).getStart();
                String end = ((IpRange)address).getEnd();
                this.ipRangePane.setFromIP(start);
                this.ipRangePane.setToIP(end);
                break;
            }
            case 3: {
                String ipAddress = ((SubNet)address).getNetAddr();
                String mask = ((SubNet)address).getNetMask();
                this.subNetPane.setIPAddress(ipAddress);
                this.subNetPane.setMaskAddress(mask);
                break;
            }
            case 4: {
                String domainContent = ((DnsHost)address).getContent();
                this.dnsHostTxtField.setText(domainContent);
                break;
            }
            case 5: {
                String hostContent = ((DnsDomain)address).getContent();
                this.dnsDomainTxtField.setText(hostContent);
                break;
            }
            case 8: {
                String ipv6Address = ((Ipv6Address)address).getContent();
                this.ipv6Field.setText(ipv6Address);
                break;
            }
            case 9: {
                String ipv6Start = ((Ipv6Range)address).getStart();
                String ipv6End = ((Ipv6Range)address).getEnd();
                System.out.println("Start:" + ipv6Start + "  End:" + ipv6End);
                this.ipv6RangePane.setFromIP(ipv6Start);
                this.ipv6RangePane.setToIP(ipv6End);
                break;
            }
            case 10: {
                String ipv6Subnet = ((Ipv6SubNet)address).getContent();
                this.ipv6SubnetPane.setText(ipv6Subnet);
                break;
            }
        }
    }

    private JPanel getComboPanel() {
        if (this.comboPanel == null) {
            this.comboPanel = new JPanel();
        }
        JLabel typeLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.label.Type"));
        this.comboPanel.setLayout(new BorderLayout(20, 10));
        this.comboPanel.add((Component)typeLabel, "West");
        this.labels.add(typeLabel);
        this.comboPanel.add(this.getTypeCombo(), "Center");
        if (this.dialogType != 4) {
            this.comboPanel.add(this.getIpVerCombo(), "East");
        }
        try {
            if (this.hostObject == null) {
                this.typeCombo.setSelectedIndex(0);
                this.ipVerCombo.setSelectedIndex(ID_IP_TYPE_V4);
            } else {
                this.typeCombo.setSelectedIndex(this.getAddressTypeComboIndex(this.hostObject.getType()));
                this.ipVerCombo.setSelectedIndex(this.getIpVerComboIndex(this.hostObject.getType()));
            }
        }
        catch (Exception exp) {
            LoggerUtilities.logException((Throwable)exp);
        }
        return this.comboPanel;
    }

    private JPanel getDisplayPanel() {
        if (this.displayPanel == null) {
            this.displayPanel = new JPanel();
            this.displayPanelLayout = new CardLayout();
            this.displayPanel.setLayout(this.displayPanelLayout);
            this.displayPanel.add((Component)this.getMacField(), ID_MACADDR);
            this.displayPanel.add((Component)this.getIPField(), ID_IPADDR);
            this.displayPanel.add((Component)this.getIPRangePane(), ID_IPRANGE);
            this.displayPanel.add((Component)this.getSubNetPane(), ID_SUBNET);
            this.displayPanel.add((Component)this.getDNSHost(), ID_DNSHOST);
            this.displayPanel.add((Component)this.getDNSDomain(), ID_DNSDOMAIN);
            this.displayPanel.add((Component)this.getLocalSubnetPane(), ID_LOCAL_SUBNET);
            this.displayPanel.add((Component)this.getIPv6Field(), ID_IPV6ADDR);
            this.displayPanel.add((Component)this.getIPv6RangePane(), ID_IPV6RANGE);
            this.displayPanel.add((Component)this.getIPv6SubNetPane(), ID_IPV6SUBNET);
        }
        this.updateDisplay();
        return this.displayPanel;
    }

    private JPanel getLocalSubnetPane() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel subnetPanel = new JPanel(new BorderLayout());
        panel.add((Component)subnetPanel, "North");
        DescriptionTextArea textarea = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.LocalSubnet.Description"), 30);
        subnetPanel.add(textarea);
        return panel;
    }

    private void updateDisplay() {
        int type = this.getHostObjectTypeFromComboSelections();
        this.ipVerCombo.setEnabled(true);
        switch (type) {
            case 0: {
                this.displayPanelLayout.show(this.displayPanel, ID_MACADDR);
                this.ipVerCombo.setVisible(false);
                break;
            }
            case 1: {
                this.displayPanelLayout.show(this.displayPanel, ID_IPADDR);
                this.ipVerCombo.setVisible(true);
                break;
            }
            case 2: {
                this.displayPanelLayout.show(this.displayPanel, ID_IPRANGE);
                this.ipVerCombo.setVisible(true);
                break;
            }
            case 3: {
                this.displayPanelLayout.show(this.displayPanel, ID_SUBNET);
                this.ipVerCombo.setVisible(true);
                break;
            }
            case 4: {
                this.displayPanelLayout.show(this.displayPanel, ID_DNSHOST);
                this.ipVerCombo.setVisible(false);
                break;
            }
            case 5: {
                this.displayPanelLayout.show(this.displayPanel, ID_DNSDOMAIN);
                this.ipVerCombo.setVisible(false);
                break;
            }
            case 7: {
                this.displayPanelLayout.show(this.displayPanel, ID_LOCAL_SUBNET);
                this.ipVerCombo.setVisible(false);
                break;
            }
            case 8: {
                this.displayPanelLayout.show(this.displayPanel, ID_IPV6ADDR);
                this.ipVerCombo.setVisible(true);
                break;
            }
            case 9: {
                this.displayPanelLayout.show(this.displayPanel, ID_IPV6RANGE);
                this.ipVerCombo.setVisible(true);
                break;
            }
            case 10: {
                this.displayPanelLayout.show(this.displayPanel, ID_IPV6SUBNET);
                this.ipVerCombo.setVisible(true);
                break;
            }
            default: {
                this.displayWarning();
            }
        }
        this.setValues();
    }

    private JComboBox<String> getTypeCombo() {
        if (this.typeCombo == null) {
            this.typeCombo = new JComboBox<String>(this.hostTypes);
        }
        return this.typeCombo;
    }

    private JComboBox<String> getIpVerCombo() {
        if (this.ipVerCombo == null) {
            this.ipVerCombo = new JComboBox<String>(IP_VERSIONS);
        }
        return this.ipVerCombo;
    }

    private JPanel getMacField() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel macPanel = new JPanel(new BorderLayout());
        panel.add((Component)macPanel, "North");
        JPanel northPanel = new JPanel(new BorderLayout(20, 10));
        macPanel.add((Component)northPanel, "North");
        JLabel spacer = new JLabel("");
        northPanel.add((Component)spacer, "West");
        this.labels.add(spacer);
        JLabel sampleLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "MainTrustedHostPanel.label.Sample.MACAddress"));
        northPanel.add((Component)sampleLabel, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout(20, 10));
        macPanel.add((Component)centerPanel, "Center");
        JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "MainTrustedHostPanel.label.MACAddress"));
        label.setVerticalAlignment(0);
        label.setVerticalTextPosition(0);
        centerPanel.add((Component)label, "West");
        this.labels.add(label);
        JPanel fieldPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.add((Component)fieldPanel, "Center");
        this.macField = new MacField();
        this.macField.setPreferredSize(new Dimension(120, 28));
        this.macField.setMinimumSize(new Dimension(120, 28));
        fieldPanel.add((Component)this.macField, "Center");
        fieldPanel.add((Component)this.getListButton(), "East");
        return panel;
    }

    private JPanel getIPField() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel ipPanel = new JPanel(new BorderLayout());
        panel.add((Component)ipPanel, "North");
        JPanel northPanel = new JPanel(new BorderLayout(20, 10));
        ipPanel.add((Component)northPanel, "North");
        JLabel spacer = new JLabel("");
        northPanel.add((Component)spacer, "West");
        this.labels.add(spacer);
        JLabel sampleLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "MainTrustedHostPanel.label.Sample.IPAddress"));
        northPanel.add((Component)sampleLabel, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout(20, 10));
        ipPanel.add((Component)centerPanel, "Center");
        JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "MainTrustedHostPanel.label.IPAddress"));
        label.setVerticalAlignment(0);
        label.setVerticalTextPosition(0);
        centerPanel.add((Component)label, "West");
        this.labels.add(label);
        JPanel fieldPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.add((Component)fieldPanel, "Center");
        this.ipField = new IPField();
        this.ipField.setPreferredSize(new Dimension(120, 28));
        this.ipField.setMinimumSize(new Dimension(120, 28));
        fieldPanel.add((Component)this.ipField, "Center");
        return panel;
    }

    private JPanel getIPv6Field() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel ipPanel = new JPanel(new BorderLayout());
        panel.add((Component)ipPanel, "North");
        JPanel northPanel = new JPanel(new BorderLayout(20, 10));
        ipPanel.add((Component)northPanel, "North");
        JLabel spacer = new JLabel("");
        northPanel.add((Component)spacer, "West");
        this.labels.add(spacer);
        JLabel sampleLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "MainTrustedHostPanel.label.Sample.IPv6Address"));
        northPanel.add((Component)sampleLabel, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout(20, 10));
        ipPanel.add((Component)centerPanel, "Center");
        JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "MainTrustedHostPanel.label.IPv6Address"));
        label.setVerticalAlignment(0);
        label.setVerticalTextPosition(0);
        centerPanel.add((Component)label, "West");
        this.labels.add(label);
        JPanel fieldPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.add((Component)fieldPanel, "Center");
        this.ipv6Field = new IPv6Field(false);
        this.ipv6Field.setPreferredSize(new Dimension(280, 28));
        this.ipv6Field.setMinimumSize(new Dimension(280, 28));
        fieldPanel.add((Component)this.ipv6Field, "Center");
        return panel;
    }

    private JPanel getIPRangePane() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel ipPanel = new JPanel(new BorderLayout());
        panel.add((Component)ipPanel, "North");
        this.ipRangePane = new IpRangePane();
        this.ipRangePane.setBorder(null);
        ipPanel.add((Component)this.ipRangePane, "Center");
        this.labels.add(this.ipRangePane.getStartLabel());
        this.labels.add(this.ipRangePane.getEndLabel());
        this.ipRangePane.getStartLabel().setPreferredSize(new JLabel(this.ipRangePane.getStartLabel().getText()).getPreferredSize());
        this.ipRangePane.getEndLabel().setPreferredSize(new JLabel(this.ipRangePane.getEndLabel().getText()).getPreferredSize());
        return panel;
    }

    private JPanel getIPv6RangePane() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel ipPanel = new JPanel(new BorderLayout());
        panel.add((Component)ipPanel, "North");
        this.ipv6RangePane = new IPv6RangePane();
        this.ipv6RangePane.setBorder(null);
        ipPanel.add((Component)this.ipv6RangePane, "Center");
        this.labels.add(this.ipv6RangePane.getStartLabel());
        this.labels.add(this.ipv6RangePane.getEndLabel());
        this.ipv6RangePane.getStartLabel().setPreferredSize(new JLabel(this.ipv6RangePane.getStartLabel().getText()).getPreferredSize());
        this.ipv6RangePane.getEndLabel().setPreferredSize(new JLabel(this.ipv6RangePane.getEndLabel().getText()).getPreferredSize());
        return panel;
    }

    private JPanel getSubNetPane() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel subnetPanel = new JPanel(new BorderLayout());
        panel.add((Component)subnetPanel, "North");
        this.subNetPane = new SubnetPane();
        this.subNetPane.setBorder(null);
        subnetPanel.add((Component)this.subNetPane, "Center");
        this.labels.add(this.subNetPane.getIpLabel());
        this.labels.add(this.subNetPane.getMaskLabel());
        this.subNetPane.getIpLabel().setPreferredSize(new JLabel(this.subNetPane.getIpLabel().getText()).getPreferredSize());
        this.subNetPane.getMaskLabel().setPreferredSize(new JLabel(this.subNetPane.getMaskLabel().getText()).getPreferredSize());
        return panel;
    }

    private JPanel getIPv6SubNetPane() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel ipv6SubnetPanel = new JPanel(new BorderLayout());
        panel.add((Component)ipv6SubnetPanel, "North");
        this.ipv6SubnetPane = new IPv6SubnetPane();
        this.ipv6SubnetPane.setBorder(null);
        ipv6SubnetPanel.add((Component)this.ipv6SubnetPane, "Center");
        this.labels.add(this.ipv6SubnetPane.getIpLabel());
        this.ipv6SubnetPane.getIpLabel().setPreferredSize(new JLabel(this.ipv6SubnetPane.getIpLabel().getText()).getPreferredSize());
        return panel;
    }

    private JPanel getDNSHost() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel dnsPanel = new JPanel(new BorderLayout());
        panel.add((Component)dnsPanel, "North");
        JPanel northPanel = new JPanel(new BorderLayout(20, 10));
        dnsPanel.add((Component)northPanel, "North");
        JLabel spacer = new JLabel("");
        northPanel.add((Component)spacer, "West");
        this.labels.add(spacer);
        JLabel sampleLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "MainTrustedHostPanel.label.Sample.DNSHost"));
        northPanel.add((Component)sampleLabel, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout(20, 10));
        dnsPanel.add((Component)centerPanel, "Center");
        JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "MainTrustedHostPanel.label.DNSHost"));
        label.setVerticalAlignment(0);
        label.setVerticalTextPosition(0);
        centerPanel.add((Component)label, "West");
        this.labels.add(label);
        JPanel fieldPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.add((Component)fieldPanel, "Center");
        this.dnsHostTxtField = new JTextField();
        RestrictedPlainDocument doc = new RestrictedPlainDocument(1024);
        this.dnsHostTxtField.setDocument(doc);
        this.dnsHostTxtField.setPreferredSize(new Dimension(120, 28));
        this.dnsHostTxtField.setMinimumSize(new Dimension(120, 28));
        fieldPanel.add((Component)this.dnsHostTxtField, "Center");
        return panel;
    }

    private JPanel getDNSDomain() {
        JPanel panel = new JPanel(new BorderLayout());
        JPanel dnsPanel = new JPanel(new BorderLayout());
        panel.add((Component)dnsPanel, "North");
        JPanel northPanel = new JPanel(new BorderLayout(20, 10));
        dnsPanel.add((Component)northPanel, "North");
        JLabel spacer = new JLabel("");
        northPanel.add((Component)spacer, "West");
        this.labels.add(spacer);
        JLabel sampleLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "MainTrustedHostPanel.label.Sample.DNSDomain"));
        northPanel.add((Component)sampleLabel, "Center");
        JPanel centerPanel = new JPanel(new BorderLayout(20, 10));
        dnsPanel.add((Component)centerPanel, "Center");
        JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "MainTrustedHostPanel.label.DNSDomain"));
        label.setVerticalAlignment(0);
        label.setVerticalTextPosition(0);
        centerPanel.add((Component)label, "West");
        this.labels.add(label);
        JPanel fieldPanel = new JPanel(new BorderLayout(5, 5));
        centerPanel.add((Component)fieldPanel, "Center");
        this.dnsDomainTxtField = new JTextField();
        RestrictedPlainDocument doc = new RestrictedPlainDocument(1024);
        this.dnsDomainTxtField.setDocument(doc);
        this.dnsDomainTxtField.setPreferredSize(new Dimension(120, 28));
        this.dnsDomainTxtField.setMinimumSize(new Dimension(120, 28));
        fieldPanel.add((Component)this.dnsDomainTxtField, "Center");
        return panel;
    }

    private void displayWarning() {
        JLabel lbl = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.label.NoTypeSelected"));
        this.displayPanel.removeAll();
        this.displayPanel.setLayout(new GridBagLayout());
        this.displayPanel.add(lbl);
    }

    private JButton getListButton() {
        if (this.listButton == null) {
            this.listButton = new JButton(UIText.get(1538));
            this.listButton.setFont(this.listButton.getFont().deriveFont(1));
            this.listButton.setMargin(new Insets(0, 0, 0, 0));
            this.listButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    String macAddress = HostDialog.this.macField.getText();
                    PopupList popup = new PopupList(HostDialog.this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.menu.MACAddressSingleOrPlural"), HostDialog.this.getExistingMacAddresses(), macAddress);
                    Point pnt = HostDialog.this.listButton.getLocationOnScreen();
                    popup.setLocation(pnt.x, pnt.y + HostDialog.this.listButton.getSize().height);
                    popup.setVisible(true);
                    if (popup.getSelectedItem() != null && ((String)popup.getSelectedItem()).length() != 0) {
                        HostDialog.this.macField.setText((String)popup.getSelectedItem());
                    }
                }
            });
        }
        this.listButton.setVisible(!this.getExistingMacAddresses().isEmpty());
        return this.listButton;
    }

    private ArrayList<String> getExistingMacAddresses() {
        Set<String> macAddressSet = PolicyHandler.getMacAddresses();
        return new ArrayList<String>(macAddressSet);
    }

    private void setContent() {
        int selectedIndex = this.getHostObjectTypeFromComboSelections();
        if (selectedIndex < 0) {
            return;
        }
        switch (selectedIndex) {
            case 0: {
                this.hostObject.setContent(this.macField.getText(), "");
                break;
            }
            case 1: {
                this.hostObject.setContent(this.ipField.getText(), "");
                break;
            }
            case 2: {
                String fromIp = this.ipRangePane.getFromIP();
                String toIp = this.ipRangePane.getToIP();
                this.hostObject.setContent(fromIp, toIp);
                break;
            }
            case 3: {
                String ipAddr = this.subNetPane.getIPAddress();
                String mask = this.subNetPane.getMaskAddress();
                this.hostObject.setContent(ipAddr, mask);
                break;
            }
            case 4: {
                this.hostObject.setContent(this.dnsHostTxtField.getText(), "");
                break;
            }
            case 5: {
                this.hostObject.setContent(this.dnsDomainTxtField.getText(), "");
                break;
            }
            case 8: {
                this.hostObject.setContent(this.ipv6Field.getText(), "");
                break;
            }
            case 9: {
                String fromIPv6 = this.ipv6RangePane.getFromIP();
                String toIPv6 = this.ipv6RangePane.getToIP();
                this.hostObject.setContent(fromIPv6, toIPv6);
                break;
            }
            case 10: {
                this.hostObject.setContent(this.ipv6SubnetPane.getText(), "");
                break;
            }
        }
    }

    private Object getNewHostObject() {
        int selectedIndex = this.getHostObjectTypeFromComboSelections();
        if (selectedIndex < 0) {
            return null;
        }
        String direction = this.hostObject.getDirection();
        String typeStr = HostObject.getTypeByIndex(selectedIndex);
        switch (selectedIndex) {
            case 0: {
                this.hostObject = new HostObject(new MacAddress(), typeStr, direction);
                return this.hostObject;
            }
            case 1: {
                this.hostObject = new HostObject(new IpAddress(), typeStr, direction);
                return this.hostObject;
            }
            case 2: {
                this.hostObject = new HostObject(new IpRange(), typeStr, direction);
                return this.hostObject;
            }
            case 3: {
                this.hostObject = new HostObject(new SubNet(), typeStr, direction);
                return this.hostObject;
            }
            case 4: {
                this.hostObject = new HostObject(new DnsHost(), typeStr, direction);
                return this.hostObject;
            }
            case 5: {
                this.hostObject = new HostObject(new DnsDomain(), typeStr, direction);
                return this.hostObject;
            }
            case 7: {
                this.hostObject = new HostObject(new LocalSubnet(), typeStr, direction);
                return this.hostObject;
            }
            case 8: {
                this.hostObject = new HostObject(new Ipv6Address(), typeStr, direction);
                return this.hostObject;
            }
            case 9: {
                this.hostObject = new HostObject(new Ipv6Range(), typeStr, direction);
                return this.hostObject;
            }
            case 10: {
                this.hostObject = new HostObject(new Ipv6SubNet(), typeStr, direction);
                return this.hostObject;
            }
        }
        return null;
    }

    public boolean isCancel() {
        return this.isCancel;
    }

    private boolean isValidValue() {
        int selectedIndex = this.getHostObjectTypeFromComboSelections();
        switch (selectedIndex) {
            case 0: {
                if (!this.macField.isValid()) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.error.InvalidMACAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidMACAddress"), 0);
                    return false;
                }
                return true;
            }
            case 1: {
                if (!this.ipField.isValid() || INVALID_IP_ADDRESS.equals(this.ipField.getText())) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.error.InvalidIPAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidIPAddress"), 0);
                    return false;
                }
                return true;
            }
            case 2: {
                if (!this.ipRangePane.isValidValue()) {
                    String message = this.ipRangePane.getErrorMessage();
                    JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidIPRange"), 0);
                    this.ipRangePane.requestFocus();
                    return false;
                }
                if (INVALID_IP_ADDRESS.equals(this.ipRangePane.getFromIP())) {
                    JOptionPane.showMessageDialog(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.error.InvalidStartIPAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidIPAddress"), 0);
                    this.ipRangePane.requestFocus();
                    return false;
                }
                if (INVALID_IP_ADDRESS.equals(this.ipRangePane.getToIP())) {
                    JOptionPane.showMessageDialog(Manager.frame, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.error.InvalidEndIPAddress"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidIPAddress"), 0);
                    this.ipRangePane.requestFocus();
                    return false;
                }
                return true;
            }
            case 3: {
                if (!this.subNetPane.isValidValue()) {
                    String message = this.subNetPane.getErrorMessage();
                    JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidSubnet"), 0);
                    return false;
                }
                return true;
            }
            case 4: {
                if (this.dnsHostTxtField.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.error.HostNameEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidDNSHostname"), 0);
                    return false;
                }
                return true;
            }
            case 5: {
                if (this.dnsDomainTxtField.getText().trim().length() == 0) {
                    JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.error.DomainNameEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidDNSDomainName"), 0);
                    return false;
                }
                return true;
            }
            case 8: {
                if (!this.ipv6Field.isValidValue()) {
                    JOptionPane.showMessageDialog(Manager.frame, this.ipv6Field.getErrorMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidIPv6Address"), 0);
                    this.ipv6Field.requestFocus();
                    return false;
                }
                return true;
            }
            case 9: {
                if (!this.ipv6RangePane.isValidValue()) {
                    String message = this.ipv6RangePane.getErrorMessage();
                    JOptionPane.showMessageDialog(Manager.frame, message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidIPv6Range"), 0);
                    this.ipv6RangePane.requestFocus();
                    return false;
                }
                return true;
            }
            case 10: {
                if (!this.ipv6SubnetPane.isValidValue()) {
                    String message = this.ipv6SubnetPane.getErrorMessage();
                    JOptionPane.showMessageDialog(Manager.frame, message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostDialog.title.InvalidIPv6Subnet"), 0);
                    this.ipv6SubnetPane.requestFocus();
                    return false;
                }
                return true;
            }
        }
        return true;
    }

    private boolean updateObject() {
        this.setContent();
        this.hostObject.setType(this.getHostObjectType());
        if (this.getHostObjectTypeFromComboSelections() == 0) {
            this.listButton.setVisible(!this.getExistingMacAddresses().isEmpty());
        }
        return true;
    }

    public HostObject getObject() {
        return this.hostObject;
    }

    @Override
    protected boolean isValidate() {
        return this.isValidValue();
    }

    @Override
    protected void commit() {
        this.updateObject();
    }

    private String getHostObjectType() {
        int hostObjectTypeIndex = this.getHostObjectTypeFromComboSelections();
        return HostObject.getTypeByIndex(hostObjectTypeIndex);
    }

    private int getHostObjectTypeFromComboSelections() {
        String str = (String)this.typeCombo.getSelectedItem();
        String ipType = (String)this.ipVerCombo.getSelectedItem();
        return this.getHostObjectTypeIndex(str, ipType);
    }

    private int getHostObjectTypeIndex(String str, String ipType) {
        if (str.equals(HostObject.getTypeByIndex(1))) {
            if (ipType.equalsIgnoreCase(IP_VERSIONS[ID_IP_TYPE_V6])) {
                str = HostObject.getTypeByIndex(8);
            }
        } else if (str.equals(HostObject.getTypeByIndex(2))) {
            if (ipType.equalsIgnoreCase(IP_VERSIONS[ID_IP_TYPE_V6])) {
                str = HostObject.getTypeByIndex(9);
            }
        } else if (str.equals(HostObject.getTypeByIndex(3)) && ipType.equalsIgnoreCase(IP_VERSIONS[ID_IP_TYPE_V6])) {
            str = HostObject.getTypeByIndex(10);
        }
        int indx = 0;
        for (String str1 : HostObject.getTypes()) {
            if (str.equalsIgnoreCase(str1)) break;
            ++indx;
        }
        return indx;
    }

    private int getAddressTypeComboIndex(String strHostObjectType) {
        if (strHostObjectType.equals(HostObject.getTypeByIndex(8))) {
            strHostObjectType = HostObject.getTypeByIndex(1);
        } else if (strHostObjectType.equals(HostObject.getTypeByIndex(9))) {
            strHostObjectType = HostObject.getTypeByIndex(2);
        } else if (strHostObjectType.equals(HostObject.getTypeByIndex(10))) {
            strHostObjectType = HostObject.getTypeByIndex(3);
        }
        int indx = 0;
        for (String str1 : this.hostTypes) {
            if (strHostObjectType.equalsIgnoreCase(str1)) break;
            ++indx;
        }
        return indx;
    }

    private int getIpVerComboIndex(String strHostObjectType) {
        if (strHostObjectType.equals(HostObject.getTypeByIndex(8)) || strHostObjectType.equals(HostObject.getTypeByIndex(9)) || strHostObjectType.equals(HostObject.getTypeByIndex(10))) {
            return ID_IP_TYPE_V6;
        }
        if (strHostObjectType.equals(HostObject.getTypeByIndex(1)) || strHostObjectType.equals(HostObject.getTypeByIndex(2)) || strHostObjectType.equals(HostObject.getTypeByIndex(3))) {
            return ID_IP_TYPE_V4;
        }
        return ID_IP_TYPE_V4;
    }
}

