/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.MacAddress;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostDialog;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostContainerObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class HostContainerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.column.LabelType"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.column.LabelContent")};
    private JTable hostTable;
    private SortableTableModel model;
    JPopupMenu hostPopup;
    private JScrollPane scrollPane;
    private Action addAction;
    private Action deleteAction;
    private Action editAction;
    JButton addButton;
    private JButton deleteButton;
    private JButton editButton;
    private JPanel hostButtonPanel;
    private JPanel hostListPanel;
    private JLabel descLabel;
    private HostContainerObject containerObject;
    private ArrayList<HostObject> hostObjects;

    public HostContainerPanel(FwHostContainer container, int direction) {
        this.containerObject = new HostContainerObject(container, direction);
        this.init();
    }

    private void init() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.getHostListPanel(), "Center");
    }

    private JPanel getHostListPanel() {
        if (this.hostListPanel == null) {
            this.hostListPanel = new JPanel();
            this.hostListPanel.setLayout(new BorderLayout());
            String description = this.getDescription();
            if (description != null) {
                this.descLabel = new JLabel(description, 2);
                this.descLabel.setBorder(BorderFactory.createEmptyBorder(10, 1, 0, 0));
                this.hostListPanel.add((Component)this.descLabel, "North");
            }
            this.hostListPanel.add((Component)this.getScrollPane(), "Center");
            this.hostListPanel.add((Component)this.getHostButtonPanel(), "South");
            this.hostListPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }
        return this.hostListPanel;
    }

    private String getDescription() {
        switch (this.containerObject.getDirection()) {
            case 0: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.DescriptionSource");
            }
            case 1: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.DescriptionDestination");
            }
            case 2: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.DescriptionLocal");
            }
            case 3: {
                return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.DescriptionRemote");
            }
        }
        return null;
    }

    private List<HostObject> getHostObjects() {
        if (this.hostObjects == null) {
            this.hostObjects = this.containerObject == null ? new ArrayList() : this.containerObject.getAllAddress();
        }
        return this.hostObjects;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.getViewport().add(this.getHostTable());
        }
        return this.scrollPane;
    }

    JTable getHostTable() {
        if (this.hostTable == null) {
            this.hostTable = new StripesTable();
            this.hostTable.setAutoResizeMode(0);
            this.hostTable.setModel(this.getTableModel());
            this.hostTable.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.hostTable.getColumnModel().getColumn(0).setMinWidth(150);
            this.hostTable.getColumnModel().getColumn(1).setPreferredWidth(321);
            this.hostTable.getColumnModel().getColumn(1).setMinWidth(321);
            this.hostTable.getSelectionModel().setSelectionMode(0);
            this.hostTable.getSelectionModel().addListSelectionListener(this.getTableSelectionListener());
            this.hostTable.addMouseListener(this.getTableMouseListener());
            this.getTableModel().addMouseListenerToHeaderInTable(this.hostTable);
        }
        return this.hostTable;
    }

    private SortableTableModel getTableModel() {
        if (this.model == null) {
            this.model = new SortableTableModel();
            this.model.setColumnNames(columnNames);
            this.model.setDataVector(new Vector<TableRow>((Collection)Cast.cast(this.getHostObjects())));
        }
        return this.model;
    }

    private ListSelectionListener getTableSelectionListener() {
        ListSelectionListener tableSelectionListener = new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                HostContainerPanel.this.deleteButton.setEnabled(true);
                HostContainerPanel.this.editButton.setEnabled(true);
            }
        };
        return tableSelectionListener;
    }

    private MouseListener getTableMouseListener() {
        MouseAdapter tableMouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int colNumber = HostContainerPanel.this.getHostTable().columnAtPoint(e.getPoint());
                int rowNumber = HostContainerPanel.this.getHostTable().rowAtPoint(e.getPoint());
                if (e.getModifiers() == 4) {
                    HostContainerPanel.this.getHostTable().setRowSelectionInterval(rowNumber, rowNumber);
                    HostContainerPanel.this.getHostTable().setColumnSelectionInterval(colNumber, colNumber);
                    HostContainerPanel.this.getHostPopup().show(e.getComponent(), e.getX(), e.getY());
                } else if (e.getClickCount() == 2) {
                    HostContainerPanel.this.editHost();
                }
            }
        };
        return tableMouseListener;
    }

    JPopupMenu getHostPopup() {
        if (this.hostPopup == null) {
            this.hostPopup = new JPopupMenu();
            if (this.getAllHostObjects().size() < ScmProperties.getHostGroupMaxCountAllowed()) {
                this.hostPopup.add(this.addAction);
            }
            this.hostPopup.add(this.deleteAction);
            this.hostPopup.add(this.editAction);
        }
        return this.hostPopup;
    }

    void addHost() {
        String direction = this.containerObject.getDirectionDesc();
        HostObject newObject = new HostObject(new MacAddress(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "HostObject.type.MACAddress"), direction);
        HostDialog dialog = new HostDialog(newObject, 0);
        if (dialog.isOk()) {
            HostObject hostObject = dialog.getObject();
            this.containerObject.addHostObject(hostObject);
            this.getTableModel().addRow(hostObject);
            int rowCount = this.getTableModel().getRowCount();
            this.moveToRow(rowCount - 1);
        }
        this.setAddButtonStatus();
    }

    void deleteHost() {
        String title;
        ConsoleLogger.log("Delete a host, index: " + this.getHostTable().getSelectedRow());
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.error.SelectBeforeDeleteHost");
        if (this.getHostTable().getSelectedRow() == -1) {
            JOptionPane.showMessageDialog(this, message);
            return;
        }
        message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.ConfirmDeleteHost");
        if (UIUtilities.confirmYesNoOptionDialog(message, title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.title.DeleteHost")) == 0) {
            this.containerObject.deleteHostObject((HostObject)this.getTableModel().getDataVector().get(this.getHostTable().getSelectedRow()));
            this.getTableModel().removeRow(this.getHostTable().getSelectedRow());
            this.deleteButton.setEnabled(false);
            this.editButton.setEnabled(false);
        }
        this.setAddButtonStatus();
    }

    void setAddButtonStatus() {
        if (this.getAllHostObjects().size() >= ScmProperties.getHostGroupMaxCountAllowed()) {
            ConsoleLogger.log("setAddButtonStatus, Disable button Add, has total host " + this.getAllHostObjects().size() + ", allowed max size: " + ScmProperties.getHostGroupMaxCountAllowed());
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
    }

    private void editHost() {
        block4: {
            int index = this.getHostTable().getSelectedRow();
            if (index == -1) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.SelectBeforeEditHost"));
                return;
            }
            HostObject hostObj = (HostObject)this.getTableModel().getRow(index);
            try {
                HostObject hostObjCopy = hostObj.getClone();
                HostDialog dialog = new HostDialog(hostObjCopy, 0, false);
                if (dialog.isOk()) {
                    this.getTableModel().removeRow(index);
                    HostObject newHostObject = dialog.getObject();
                    this.containerObject.setHostObject(index, hostObj, newHostObject);
                    this.getTableModel().insertRow(index, newHostObject);
                    this.moveToRow(index);
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "HostContainerPanel.title.ConsoleError"), 0);
                if (!ex.needRelogin()) break block4;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private JPanel getHostButtonPanel() {
        if (this.hostButtonPanel == null) {
            this.addAction = new AbstractAction(UIText.get(5)){
                private static final long serialVersionUID = 2768587695050533656L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    HostContainerPanel.this.addHost();
                }
            };
            this.deleteAction = new AbstractAction(UIText.get(769)){
                private static final long serialVersionUID = -5827343117747873309L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    HostContainerPanel.this.deleteHost();
                }
            };
            this.editAction = new AbstractAction(UIText.get(1024)){
                private static final long serialVersionUID = -663548992929399910L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    HostContainerPanel.this.editHost();
                }
            };
            this.addButton = new JButton(this.addAction);
            this.setAddButtonStatus();
            this.deleteButton = new JButton(this.deleteAction);
            this.deleteButton.setEnabled(false);
            this.editButton = new JButton(this.editAction);
            this.editButton.setEnabled(false);
            JButton[] buttons = new JButton[]{this.addButton, this.editButton, this.deleteButton};
            this.hostButtonPanel = new ButtonPane(buttons, 1);
        }
        return this.hostButtonPanel;
    }

    private void moveToRow(int row) {
        this.getHostTable().setRowSelectionInterval(row, row);
        Rectangle cellRect = this.getHostTable().getCellRect(row, 0, false);
        if (cellRect != null) {
            this.getHostTable().scrollRectToVisible(cellRect);
        }
    }

    public void setHostContainer(FwHostContainer newContainer, int direction) {
        if (this.containerObject.getDirection() != direction) {
            FwHostContainer currentContainer = this.containerObject.getContainer();
            Vector children = (Vector)Cast.cast((Object)currentContainer.getChildren());
            Vector newContainerChildren = (Vector)Cast.cast((Object)newContainer.getChildren());
            int newChildCount = newContainerChildren.size();
            for (ConfigObject child : children) {
                if (newChildCount == 0) {
                    newContainer.addChild((AbstractSchema)child);
                } else {
                    newContainer.setChild((AbstractSchema)child);
                }
                currentContainer.removeChild((AbstractSchema)child);
            }
        }
        this.containerObject = new HostContainerObject(newContainer, direction);
        this.getTableModel().setDataVector(new Vector<TableRow>(this.containerObject.getAllAddress()));
        this.getTableModel().fireTableDataChanged();
        this.setBorder(BorderFactory.createTitledBorder(this.containerObject.getDirectionDesc()));
        this.descLabel.setText(this.getDescription());
    }

    public Vector<TableRow> getAllHostObjects() {
        return this.getTableModel().getDataVector();
    }
}

