/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.MetadataAttributes;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.FwAntiAppHijacking;
import com.sygate.scm.common.configobject.schema.FwAntiIpSpoofing;
import com.sygate.scm.common.configobject.schema.FwAntiMacSpoofing;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.FwOsFingerprintMasq;
import com.sygate.scm.common.configobject.schema.FwSmartArp;
import com.sygate.scm.common.configobject.schema.FwSmartDhcp;
import com.sygate.scm.common.configobject.schema.FwSmartDns;
import com.sygate.scm.common.configobject.schema.FwSmartSmcTraffic;
import com.sygate.scm.common.configobject.schema.FwSmartWins;
import com.sygate.scm.common.configobject.schema.FwStealthModeBrowsing;
import com.sygate.scm.common.configobject.schema.SecuritySetting;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AbstractUIObject;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.AppliablePolicyPool;
import com.sygate.scm.console.logicobject.FirewallPolicyObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.BasePolicyDialog;
import com.sygate.scm.console.ui.policy.PolicyHelper;
import com.sygate.scm.console.ui.policy.PolicyTabPanel;
import com.sygate.scm.console.ui.policy.common.PolicyInt;
import com.sygate.scm.console.ui.policy.firewall.AdvancedSettingPanel;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulePanel;
import com.sygate.scm.console.ui.policy.firewall.FirewallSettingsPanel;
import com.sygate.scm.console.ui.policy.firewall.Handler.FirewallPolicyHandler;
import com.sygate.scm.console.ui.policy.firewall.MacAdvancedSettingPanel;
import com.sygate.scm.console.ui.policy.firewall.MacFirewallRulePanel;
import com.sygate.scm.console.ui.policy.firewall.MacSmartTrafficFilterPanel;
import com.sygate.scm.console.ui.policy.firewall.PeerToPeerSettingPanel;
import com.sygate.scm.console.ui.policy.firewall.SmartTrafficFilterPanel;
import com.sygate.scm.console.ui.policy.firewall.WindowsFirewallRulePanel;
import com.sygate.scm.console.ui.policy.firewall.WindowsSettingPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.FwPolicyTabPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.GUIDGenerator;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class FwPolicyDialog
extends BasePolicyDialog {
    private static final long serialVersionUID = 6400381903545631802L;
    private WindowsFirewallRulePanel winFirewallRulePanel;
    private FirewallSettingsPanel firewallSettingsPanel;
    private SmartTrafficFilterPanel smartTrafficFilterPanel;
    private AdvancedSettingPanel advancedSettingPanel;
    private WindowsSettingPanel windowsSettingPanel;
    private PeerToPeerSettingPanel p2pSettingPanel;
    private MacFirewallRulePanel macFirewallRulePanel;
    private MacSmartTrafficFilterPanel macSmartTrafficFilterPanel;
    private MacAdvancedSettingPanel macAdvancedSettingPanel;
    private FwFirewallPolicy fwPolicy;
    private FirewallRuleSystem fwRuleSystem;
    private FirewallRuleSystem macFwRuleSystem;
    private final Map<String, TopLevelObject> newObjList = new HashMap<String, TopLevelObject>();

    public FwPolicyDialog(String name, GroupPolicyObject gpObj, Boolean ... isLocal) {
        super(43, name, gpObj, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "FwPolicyDialog.title"), true, isLocal);
    }

    public FwPolicyDialog(AbstractUIObject pool) {
        this(pool, false);
    }

    public FwPolicyDialog(AbstractUIObject pool, boolean isCheckPolicyEnforcement) {
        super(43, pool, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "FwPolicyDialog.title"), isCheckPolicyEnforcement, true);
    }

    @Override
    public PolicyInt createNewPolicy(AppliablePolicyPool pool) {
        this.setNewPolicy(true);
        FwFirewallPolicy policy = this.createFwPolicy();
        FirewallPolicyObject fwObj = new FirewallPolicyObject((TopLevelObject)policy);
        List<String> nameList = pool.getAllName();
        String newName = PolicyHandler.adjustName(fwObj.getName(), nameList, 255);
        if (newName != null) {
            fwObj.setName(newName);
        }
        fwObj.addNewObj((TopLevelObject)policy);
        fwObj.addNewObj(this.newObjList);
        this.newObjList.clear();
        this.fwPolicy = policy;
        this.setValues();
        return fwObj;
    }

    @Override
    public PolicyInt createNewPolicy(TopLevelObject schema) {
        FwFirewallPolicy policy;
        this.fwPolicy = policy = (FwFirewallPolicy)schema;
        this.fwRuleSystem = policy.getOptFirewallRuleSystem();
        this.macFwRuleSystem = FirewallPolicyHandler.getMacFwFirewallPolicy(policy).getOptFirewallRuleSystem();
        this.setValues();
        FirewallPolicyObject fwObj = new FirewallPolicyObject((TopLevelObject)policy);
        return fwObj;
    }

    @Override
    protected JPanel getSubTitlePanel() {
        if (this.subTitlePanel == null) {
            this.subTitlePanel = super.getSubTitlePanel();
        }
        return this.subTitlePanel;
    }

    @Override
    protected void commit() {
        String curMode;
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.fwPolicy.setName(this.getOverviewPanel().getPolicyName());
        this.fwPolicy.setOptDescription(this.getOverviewPanel().getPolicyDesc());
        this.fwPolicy.setOptEnable(Boolean.valueOf(LicenseObject.getInstance().isSBProduct() ? this.getFirewallSettingsPanel().isPolicyEnabled() : this.getOverviewPanel().isPolicyEnabled()));
        boolean modeChanged = false;
        if (LicenseObject.getInstance().isSBProduct() && !(curMode = this.getFirewallSettingsPanel().getMode()).equals(this.fwPolicy.getOptMode())) {
            this.fwPolicy.setOptMode(curMode);
            modeChanged = true;
        }
        this.getWindowsFirewallRulePanel().updateValues();
        this.getWindowsSettingsPanel().updateSettings();
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.getAdvancedSettingPanel().updateSecuritySettings();
            this.getMacAdvancedSettingPanel().updateSecuritySettings();
            this.getSmartTrafficFilterPanel().updateSecuritySettings();
            this.getMacSmartTrafficFilterPanel().updateSecuritySettings();
            if (this.getPeertoPeerSettingPanel() != null) {
                this.getPeertoPeerSettingPanel().updateSecuritySettings();
            }
        }
        this.getMacFirewallRulePanel().updateValues();
        FirewallRuleSystem newWinRuleSystem = null;
        FirewallRuleSystem newMacRuleSystem = null;
        if (LicenseObject.getInstance().isSBProduct()) {
            if (this.getFirewallSettingsPanel().isAdvanceModeSelected()) {
                newWinRuleSystem = this.getWindowsFirewallRulePanel().getFirewallRuleSystem();
            } else if (modeChanged) {
                try {
                    FwFirewallPolicy refFwPolicy = PolicyHandler.getDefaultFirewallPolicy(null);
                    newWinRuleSystem = refFwPolicy.getOptFirewallRuleSystem();
                }
                catch (Exception ex) {
                    LoggerUtilities.logException((Throwable)ex);
                }
            }
        } else {
            newWinRuleSystem = this.getWindowsFirewallRulePanel().getFirewallRuleSystem();
            newMacRuleSystem = this.getMacFirewallRulePanel().getFirewallRuleSystem();
        }
        if (newWinRuleSystem != null) {
            this.fwPolicy.setOptFirewallRuleSystem(newWinRuleSystem);
        } else {
            System.out.println("Windows FireWall RuleSystem is not found");
        }
        if (newMacRuleSystem != null) {
            FirewallPolicyHandler.getMacFwFirewallPolicy(this.fwPolicy).setOptFirewallRuleSystem(newMacRuleSystem);
        } else {
            System.out.println("Mac FireWall RuleSystem is not found");
        }
        this.setCursor(Cursor.getDefaultCursor());
        if (LicenseObject.getInstance().isSBProduct()) {
            PolicyHelper.refreshSerialNumber();
        }
    }

    @Override
    protected boolean isValidate() {
        boolean isValid = this.isValidName((TopLevelObject)this.fwPolicy, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "FwPolicyDialog.nameIsARequirementFiled"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "FwPolicyDialog.theNameHasBeenUsed"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "FwPolicyDialog.invalidName"));
        if (isValid) {
            if (this.getPeertoPeerSettingPanel() == null) {
                return false;
            }
            isValid = this.getPeertoPeerSettingPanel().isValidate();
            if (!isValid || this.getWindowsFirewallRulePanel() == null) {
                return false;
            }
            isValid = this.getWindowsFirewallRulePanel().isValidate();
            if (!isValid || this.getAdvancedSettingPanel() == null) {
                return false;
            }
            isValid = this.getAdvancedSettingPanel().isValidate();
            if (isValid && this.getMacAdvancedSettingPanel() != null) {
                isValid = this.getMacAdvancedSettingPanel().isValidate();
            } else {
                return false;
            }
        }
        return isValid;
    }

    @Override
    protected PolicyTabPanel createTabPanel() {
        FwPolicyTabPanel panel = new FwPolicyTabPanel(this, "<html>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "FwPolicyDialog.FirewallPolicy") + "</html>", "firewall_policy_32.png");
        panel.putClientProperty("cssClass", "fwPolicyDialogPanel");
        return panel;
    }

    @Override
    protected void addPolicyEditorPanels(JPanel mainPanel) {
        super.addPolicyEditorPanels(mainPanel);
        if (LicenseObject.getInstance().isSBProduct()) {
            mainPanel.add((Component)this.getFirewallSettingsPanel(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "FwPolicyTabPanel.Settings"));
        } else {
            mainPanel.add((Component)this.getWindowsFirewallRulePanel(), "Windows Rules");
            mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getSmartTrafficFilterPanel()), "Windows Built-in Rules");
            mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getAdvancedSettingPanel()), "Windows Protection and Stealth");
            mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getWindowsSettingsPanel()), "Windows OS Integration");
            if (this.getPeertoPeerSettingPanel() != null) {
                mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getPeertoPeerSettingPanel()), "Windows OS P2P Auth");
            }
            mainPanel.add((Component)this.getMacFirewallRulePanel(), "Macintosh Rules");
            mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getMacSmartTrafficFilterPanel()), "Macintosh Built-in Rules");
            mainPanel.add((Component)UIUtilities.createScrollPaneWithoutBoard(this.getMacAdvancedSettingPanel()), "Macintosh Protection");
        }
    }

    @Override
    protected Container[] readOnlyContainers() {
        return new Container[]{this.getOverviewPanel(), this.getWindowsFirewallRulePanel(), this.getSmartTrafficFilterPanel(), this.getWindowsSettingsPanel(), this.getAdvancedSettingPanel(), this.getPeertoPeerSettingPanel(), this.getMacFirewallRulePanel(), this.getMacAdvancedSettingPanel(), this.getMacSmartTrafficFilterPanel()};
    }

    private FwFirewallPolicy createFwPolicy() {
        try {
            if (this.fwPolicy == null) {
                this.fwPolicy = PolicyHandler.getDefaultFirewallPolicy(this.newObjList);
            }
            if (this.fwPolicy == null) {
                this.fwPolicy = new FwFirewallPolicy();
                String guidString = new GUIDGenerator().getGUIDString();
                this.fwPolicy.setId(guidString);
                this.fwPolicy.setOptCreator(AdminObject.retrieveCurrentAdminObject().getName());
                this.fwRuleSystem = new FirewallRuleSystem();
                this.fwPolicy.setOptFirewallRuleSystem(this.fwRuleSystem);
                SecuritySetting ss = new SecuritySetting();
                ss.setOptFwAntiMacSpoofing(new FwAntiMacSpoofing());
                ss.setOptFwAntiIpSpoofing(new FwAntiIpSpoofing());
                ss.setOptFwAntiAppHijacking(new FwAntiAppHijacking());
                ss.setOptFwStealthModeBrowsing(new FwStealthModeBrowsing());
                ss.setOptFwOsFingerprintMasq(new FwOsFingerprintMasq());
                ss.setOptFwSmartArp(new FwSmartArp());
                ss.setOptFwSmartDhcp(new FwSmartDhcp());
                ss.setOptFwSmartDns(new FwSmartDns());
                ss.setOptFwSmartSmcTraffic(new FwSmartSmcTraffic());
                ss.setOptFwSmartWins(new FwSmartWins());
                this.fwPolicy.setSecuritySetting(ss);
                this.macFwRuleSystem = new FirewallRuleSystem();
                FirewallPolicyHandler.getMacFwFirewallPolicy(this.fwPolicy).setOptFirewallRuleSystem(this.macFwRuleSystem);
                SecuritySetting macSecSett = new SecuritySetting();
                FwSmartDhcp fwSmartDhcp = new FwSmartDhcp();
                fwSmartDhcp.setOptEnable(fwSmartDhcp.getDefEnable());
                macSecSett.setOptFwSmartDhcp(fwSmartDhcp);
                FwSmartDns fwSmartDns = new FwSmartDns();
                fwSmartDns.setOptEnable(fwSmartDns.getDefEnable());
                macSecSett.setOptFwSmartDns(fwSmartDns);
                FwAntiMacSpoofing fwAntiMacSpoofing = new FwAntiMacSpoofing();
                fwAntiMacSpoofing.setOptEnable(fwAntiMacSpoofing.getDefEnable());
                macSecSett.setOptFwAntiMacSpoofing(fwAntiMacSpoofing);
                FirewallPolicyHandler.getMacFwFirewallPolicy(this.fwPolicy).setSecuritySetting(macSecSett);
                MetadataAttributes metAttr = new MetadataAttributes();
                this.fwPolicy.setMetadataAttributes(metAttr);
            }
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
            JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "FwPolicyDialog.error"), 0);
            Manager.getFrame().showLoginPanel();
        }
        return this.fwPolicy;
    }

    private void setValues() {
        this.getOverviewPanel().setObject(new FirewallPolicyObject((TopLevelObject)this.fwPolicy));
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.getWindowsFirewallRulePanel().setFirewallPolicy(this.fwPolicy);
            this.getAdvancedSettingPanel().setSecuritySetting(this.fwPolicy.getSecuritySetting());
            this.getWindowsSettingsPanel().setSecuritySetting(this.fwPolicy.getSecuritySetting());
            this.getSmartTrafficFilterPanel().setSecuritySetting(this.fwPolicy.getSecuritySetting());
            this.getMacAdvancedSettingPanel().setSecuritySetting(this.fwPolicy.getSecuritySetting());
            this.getMacSmartTrafficFilterPanel().setSecuritySetting(this.fwPolicy.getSecuritySetting());
            if (this.getPeertoPeerSettingPanel() != null) {
                this.getPeertoPeerSettingPanel().setSecuritySetting(this.fwPolicy.getSecuritySetting());
            }
            this.getOverviewPanel().setPolicyEnabled(Utility.getBooleanValue((Boolean)this.fwPolicy.getOptEnable(), (Boolean)this.fwPolicy.getDefEnable()));
            SecuritySetting macSecuritySetting = FirewallPolicyHandler.getMacFwFirewallPolicy(this.fwPolicy).getSecuritySetting();
            this.getMacFirewallRulePanel().setFirewallPolicy(this.fwPolicy);
            this.getMacAdvancedSettingPanel().setSecuritySetting(macSecuritySetting);
            this.getMacSmartTrafficFilterPanel().setSecuritySetting(macSecuritySetting);
        } else {
            this.getFirewallSettingsPanel().getFirewallrulePanel().setFirewallPolicy(this.fwPolicy);
            this.getFirewallSettingsPanel().setEnableChk(Utility.getBooleanValue((Boolean)this.fwPolicy.getOptEnable(), (Boolean)this.fwPolicy.getDefEnable()));
            this.getFirewallSettingsPanel().setMode();
            this.winFirewallRulePanel = (WindowsFirewallRulePanel)this.getFirewallSettingsPanel().getFirewallrulePanel();
            this.macFirewallRulePanel = (MacFirewallRulePanel)this.getFirewallSettingsPanel().getFirewallrulePanel();
        }
    }

    private FirewallRulePanel getWindowsFirewallRulePanel() {
        if (this.winFirewallRulePanel == null) {
            this.winFirewallRulePanel = new WindowsFirewallRulePanel(this.groupPolicyObject, this.locationName);
        }
        return this.winFirewallRulePanel;
    }

    private FirewallRulePanel getMacFirewallRulePanel() {
        if (this.macFirewallRulePanel == null) {
            this.macFirewallRulePanel = new MacFirewallRulePanel(this.groupPolicyObject, this.locationName);
        }
        return this.macFirewallRulePanel;
    }

    private FirewallSettingsPanel getFirewallSettingsPanel() {
        if (this.firewallSettingsPanel == null) {
            this.firewallSettingsPanel = new FirewallSettingsPanel(this.groupPolicyObject, this.locationName);
        }
        return this.firewallSettingsPanel;
    }

    private SmartTrafficFilterPanel getSmartTrafficFilterPanel() {
        if (this.smartTrafficFilterPanel == null) {
            this.smartTrafficFilterPanel = new SmartTrafficFilterPanel();
        }
        return this.smartTrafficFilterPanel;
    }

    private MacSmartTrafficFilterPanel getMacSmartTrafficFilterPanel() {
        if (this.macSmartTrafficFilterPanel == null) {
            this.macSmartTrafficFilterPanel = new MacSmartTrafficFilterPanel();
        }
        return this.macSmartTrafficFilterPanel;
    }

    private MacAdvancedSettingPanel getMacAdvancedSettingPanel() {
        if (this.macAdvancedSettingPanel == null) {
            this.macAdvancedSettingPanel = new MacAdvancedSettingPanel();
        }
        return this.macAdvancedSettingPanel;
    }

    private AdvancedSettingPanel getAdvancedSettingPanel() {
        if (this.advancedSettingPanel == null) {
            this.advancedSettingPanel = new AdvancedSettingPanel();
        }
        return this.advancedSettingPanel;
    }

    private WindowsSettingPanel getWindowsSettingsPanel() {
        if (this.windowsSettingPanel == null) {
            this.windowsSettingPanel = new WindowsSettingPanel();
        }
        return this.windowsSettingPanel;
    }

    private PeerToPeerSettingPanel getPeertoPeerSettingPanel() {
        if (!LicenseObject.getInstance().isSBProduct() && !LicenseObject.getInstance().isSNACOnlyProduct() && this.p2pSettingPanel == null) {
            this.p2pSettingPanel = new PeerToPeerSettingPanel();
        }
        return this.p2pSettingPanel;
    }
}

