/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.schema.BaselineFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.EnforcedFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.FirewallRule;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.firewall.dialog.ExportPanel;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.RootPaneContainer;

public class ExportDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    private JPanel topPanel = new JPanel();
    private JPanel buttonPanel;
    private ExportPanel enforcedRulePanel;
    private ExportPanel baselineRulePanel;
    private JButton expBtn = new JButton(UIText.get(1030));
    private JButton cancelBtn = new JButton(UIText.get(512));
    private boolean isCanceled = true;
    private EnforcedFirewallRuleArray enforcedRuleArray;
    private BaselineFirewallRuleArray baselineRuleArray;
    private EnforcedFirewallRuleArray expEnforcedRuleArray;
    private BaselineFirewallRuleArray expBaselineRuleArray;

    public ExportDialog(String title) {
        super(Manager.getFrame(), title, true);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    public void setValue(EnforcedFirewallRuleArray enforcedRuleArray, BaselineFirewallRuleArray baselineRuleArray) {
        this.enforcedRuleArray = enforcedRuleArray;
        this.baselineRuleArray = baselineRuleArray;
        this.updatePanel();
    }

    public EnforcedFirewallRuleArray getExpEnforcedRuleArray() {
        return this.expEnforcedRuleArray;
    }

    public BaselineFirewallRuleArray getExpBaselineRuleArray() {
        return this.expBaselineRuleArray;
    }

    public boolean isCanceled() {
        return this.isCanceled;
    }

    private void jbInit() throws Exception {
        this.setDefaultCloseOperation(2);
        this.setSize(new Dimension(440, 600));
    }

    private void updatePanel() {
        Vector<String> enforcedRuleNames = new Vector<String>();
        for (int i = 0; i < this.enforcedRuleArray.getFirewallRuleCount(); ++i) {
            enforcedRuleNames.add(this.enforcedRuleArray.getFirewallRule(i).getName());
        }
        Vector<String> baselineRuleNames = new Vector<String>();
        for (int i = 0; i < this.baselineRuleArray.getFirewallRuleCount(); ++i) {
            baselineRuleNames.add(this.baselineRuleArray.getFirewallRule(i).getName());
        }
        this.enforcedRulePanel = new ExportPanel(enforcedRuleNames);
        this.baselineRulePanel = new ExportPanel(baselineRuleNames);
        this.enforcedRulePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ExportDialog.title.EnforcedRules")));
        this.baselineRulePanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ExportDialog.title.BaselineRules")));
        this.topPanel.setLayout(new BoxLayout(this.topPanel, 1));
        this.topPanel.add(this.enforcedRulePanel);
        this.topPanel.add(this.baselineRulePanel);
        this.expBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!ExportDialog.this.expBtnActionPerformed()) {
                    return;
                }
                ExportDialog.this.isCanceled = false;
                ExportDialog.this.dispose();
            }
        });
        this.cancelBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ExportDialog.this.isCanceled = true;
                ExportDialog.this.dispose();
            }
        });
        JButton[] buttons = new JButton[]{this.expBtn, this.cancelBtn};
        this.buttonPanel = new ButtonPane(buttons, 4);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.topPanel, "Center");
        this.getContentPane().add((Component)this.buttonPanel, "South");
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.expBtn);
        UiUtilities.centerComponent((Component)this);
    }

    private boolean expBtnActionPerformed() {
        FirewallRule fwRule;
        int i;
        Hashtable<String, String> expEnforcedRules = this.enforcedRulePanel.getExportRules();
        Hashtable<String, String> expBaselineRules = this.baselineRulePanel.getExportRules();
        this.expEnforcedRuleArray = new EnforcedFirewallRuleArray();
        this.expBaselineRuleArray = new BaselineFirewallRuleArray();
        for (i = 0; i < this.enforcedRuleArray.getFirewallRuleCount(); ++i) {
            fwRule = this.enforcedRuleArray.getFirewallRule(i);
            if (!expEnforcedRules.containsKey(fwRule.getName())) continue;
            this.expEnforcedRuleArray.addFirewallRule(fwRule);
        }
        for (i = 0; i < this.baselineRuleArray.getFirewallRuleCount(); ++i) {
            fwRule = this.baselineRuleArray.getFirewallRule(i);
            if (!expBaselineRules.containsKey(fwRule.getName())) continue;
            this.expBaselineRuleArray.addFirewallRule(fwRule);
        }
        if (this.expEnforcedRuleArray.getFirewallRuleCount() == 0 && this.expBaselineRuleArray.getFirewallRuleCount() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ExportDialog.error.NoExportRulesSelected"));
            return false;
        }
        return true;
    }
}

