/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.schema.RawEthernet;
import com.sygate.scm.common.configobject.schema.RawIp;
import com.sygate.scm.common.firewall.Port;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.RestrictedPlainDocument;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.firewall.PortNumberFactory;
import com.sygate.scm.console.ui.policy.firewall.dialog.PortNumberPopup;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolObject;
import com.sygate.scm.console.ui.util.HexNumberDocument;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class EthernetProtocolPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int MAX_NUMBER = 65535;
    private static final String[] PACKET_DIRECTIONS = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.combo.PacketDirectionBoth"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.combo.PacketDirectionIncoming"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.combo.PacketDirectionOutgoing")};
    private static final int INDEX_BOTH = 0;
    private static final int INDEX_INCOMING = 1;
    private static final int INDEX_OUTGOING = 2;
    private String type = "Ethernet";
    private JTextField protocolNumberTextField;
    private JComboBox<String> packetDirectionCombo;
    private JCheckBox allowFragmentedPacketsCheck;
    private JButton ipPortsButton;
    private JButton ethernetPortsButton = null;
    private JLabel protocolNumberLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.label.ProtocolType"));
    private JLabel packetDirectionLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.label.ProtocolDirection"));
    private JTextArea descArea = null;
    private ProtocolObject protocolObject;

    public EthernetProtocolPanel() {
        this.init();
    }

    public EthernetProtocolPanel(String newType) {
        this.type = newType;
        this.init();
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        JLabel sampleLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.label.Sample"));
        this.descArea = new JTextArea();
        this.descArea.setWrapStyleWord(true);
        this.descArea.setLineWrap(true);
        this.descArea.setBackground(this.getBackground());
        this.protocolNumberLabel.setHorizontalAlignment(2);
        this.packetDirectionLabel.setHorizontalAlignment(2);
        this.getPacketDirectionCombo().setSelectedItem(PACKET_DIRECTIONS[0]);
        if (this.type.equals("IP")) {
            this.descArea.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.IPTypeDescription"));
            RestrictedPlainDocument doc = new RestrictedPlainDocument(65535);
            doc.setValidator("1234567890,-", true);
            this.getProtocolNumberTextField().setDocument((Document)doc);
            this.add((Component)sampleLabel, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.protocolNumberLabel, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.getProtocolNumberTextField(), new GridBagConstraints(1, 1, 1, 1, 0.7, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.packetDirectionLabel, new GridBagConstraints(0, 2, 1, 1, 0.3, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add(this.getPacketDirectionCombo(), new GridBagConstraints(1, 2, 1, 1, 0.7, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.getAllowFragmentedPacketsCheck(), new GridBagConstraints(1, 3, 1, 1, 0.7, 0.0, 17, 2, new Insets(5, -5, 0, 0), 0, 0));
            this.add((Component)this.getIPPortsButton(), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 50), 0, 0));
            this.add(Box.createGlue(), new GridBagConstraints(0, 4, 3, 1, 1.0, 1.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.IPProtocol")), BorderFactory.createEmptyBorder(10, 20, 10, 20)));
        } else {
            this.getProtocolNumberTextField().setDocument(new HexNumberDocument(65535L));
            this.descArea.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.ProtocolTypeDescription"));
            sampleLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.label.NumberSample"));
            this.add((Component)sampleLabel, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.protocolNumberLabel, new GridBagConstraints(0, 1, 1, 1, 0.3, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.getProtocolNumberTextField(), new GridBagConstraints(1, 1, 1, 1, 0.7, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.packetDirectionLabel, new GridBagConstraints(0, 2, 1, 1, 0.3, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.add(this.getPacketDirectionCombo(), new GridBagConstraints(1, 2, 1, 1, 0.7, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.add((Component)this.getEthernetPortsButton(), new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 50), 0, 0));
            this.add(Box.createGlue(), new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0));
            this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.EthernetProtocol")), BorderFactory.createEmptyBorder(10, 20, 10, 20)));
        }
    }

    public boolean checkValidityForHexValue() {
        boolean valid = true;
        return valid;
    }

    public boolean updateValues() {
        Object protocol = this.getProtocolObject().getProtocol();
        if (protocol instanceof RawIp) {
            RawIp rawIp = (RawIp)protocol;
            String protocolNumber = this.getProtocolNumberTextField().getText();
            if (protocolNumber != null && protocolNumber.trim().length() == 0) {
                protocolNumber = null;
            }
            rawIp.setOptProtocolNumber(protocolNumber);
            rawIp.setOptFollowingFragment(Boolean.valueOf(this.getAllowFragmentedPacketsCheck().isSelected()));
            int directionIndex = this.getPacketDirectionCombo().getSelectedIndex();
            if (directionIndex == 0) {
                rawIp.setOptIncoming(null);
            } else if (directionIndex == 1) {
                rawIp.setOptIncoming(Boolean.valueOf(true));
            } else if (directionIndex == 2) {
                rawIp.setOptIncoming(Boolean.valueOf(false));
            }
        } else if (protocol instanceof RawEthernet) {
            RawEthernet rawEthernet = (RawEthernet)protocol;
            Long protocolNumber = this.toLong(this.getProtocolNumberTextField().getText());
            rawEthernet.setOptProtocolNumber(protocolNumber);
            int directionIndex = this.getPacketDirectionCombo().getSelectedIndex();
            if (directionIndex == 0) {
                rawEthernet.setOptIncoming(null);
            } else if (directionIndex == 1) {
                rawEthernet.setOptIncoming(Boolean.valueOf(true));
            } else if (directionIndex == 2) {
                rawEthernet.setOptIncoming(Boolean.valueOf(false));
            }
        }
        return true;
    }

    private void setValues() {
        Object protocol = this.getProtocolObject().getProtocol();
        if (protocol instanceof RawIp) {
            Boolean allowFragment;
            RawIp rawIp = (RawIp)protocol;
            String protocolNumber = rawIp.getOptProtocolNumber();
            Boolean incoming = rawIp.getOptIncoming();
            String direction = PACKET_DIRECTIONS[0];
            if (incoming != null) {
                direction = incoming != false ? PACKET_DIRECTIONS[1] : PACKET_DIRECTIONS[2];
            }
            if ((allowFragment = rawIp.getOptFollowingFragment()) == null) {
                this.getAllowFragmentedPacketsCheck().setSelected(false);
            }
            if (allowFragment != null) {
                this.getAllowFragmentedPacketsCheck().setSelected(allowFragment);
            }
            this.getProtocolNumberTextField().setText(protocolNumber);
            this.getPacketDirectionCombo().setSelectedItem(direction);
        } else if (protocol instanceof RawEthernet) {
            RawEthernet rawEthernet = (RawEthernet)protocol;
            Long protocolNumber = rawEthernet.getOptProtocolNumber();
            Boolean incoming = rawEthernet.getOptIncoming();
            String direction = PACKET_DIRECTIONS[0];
            if (incoming != null) {
                direction = incoming != false ? PACKET_DIRECTIONS[1] : PACKET_DIRECTIONS[2];
            }
            if (protocolNumber != null) {
                this.getProtocolNumberTextField().setText("0x" + Long.toHexString(protocolNumber));
            }
            this.getPacketDirectionCombo().setSelectedItem(direction);
        }
    }

    private JTextField getProtocolNumberTextField() {
        if (this.protocolNumberTextField == null) {
            this.protocolNumberTextField = new JTextField();
        }
        return this.protocolNumberTextField;
    }

    private JComboBox<String> getPacketDirectionCombo() {
        if (this.packetDirectionCombo == null) {
            this.packetDirectionCombo = new JComboBox<String>(PACKET_DIRECTIONS);
            this.packetDirectionCombo.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                }
            });
        }
        return this.packetDirectionCombo;
    }

    private JCheckBox getAllowFragmentedPacketsCheck() {
        if (this.allowFragmentedPacketsCheck == null) {
            this.allowFragmentedPacketsCheck = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.checkbox.ApplyToFragmentedPacketsOnly"));
        }
        return this.allowFragmentedPacketsCheck;
    }

    private JButton getIPPortsButton() {
        if (this.ipPortsButton == null) {
            this.ipPortsButton = new JButton(UIText.get(1538));
            this.ipPortsButton.setFont(this.ipPortsButton.getFont().deriveFont(1));
            this.ipPortsButton.setMargin(new Insets(0, 0, 0, 0));
            this.ipPortsButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Vector<Port> ports = EthernetProtocolPanel.this.getPortsList();
                    String selectedProtocols = EthernetProtocolPanel.this.getProtocolNumberTextField().getText();
                    PortNumberPopup popup = new PortNumberPopup(ports, selectedProtocols);
                    popup.setOkAction(EthernetProtocolPanel.this.getPortPopupAction(popup, EthernetProtocolPanel.this.getProtocolNumberTextField()));
                    popup.show(EthernetProtocolPanel.this.ipPortsButton, e.getX(), e.getY());
                }
            });
        }
        return this.ipPortsButton;
    }

    private JButton getEthernetPortsButton() {
        if (this.ethernetPortsButton == null) {
            this.ethernetPortsButton = new JButton(UIText.get(1538));
            this.ethernetPortsButton.setFont(this.ethernetPortsButton.getFont().deriveFont(1));
            this.ethernetPortsButton.setMargin(new Insets(0, 0, 0, 0));
            this.ethernetPortsButton.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    Vector<Port> ports = EthernetProtocolPanel.this.getPortsList();
                    String selectedProtocols = EthernetProtocolPanel.this.getProtocolNumberTextField().getText();
                    if (selectedProtocols.startsWith("0x") || selectedProtocols.startsWith("0X")) {
                        int intVal = Integer.parseInt(selectedProtocols.substring(2, selectedProtocols.length()), 16);
                        selectedProtocols = Integer.toString(intVal);
                    }
                    PortNumberPopup popup = new PortNumberPopup(ports, selectedProtocols, false);
                    popup.setOkAction(EthernetProtocolPanel.this.getPortPopupAction(popup, EthernetProtocolPanel.this.getProtocolNumberTextField()));
                    popup.show(EthernetProtocolPanel.this.ethernetPortsButton, e.getX(), e.getY());
                }
            });
        }
        return this.ethernetPortsButton;
    }

    private Vector<Port> getPortsList() {
        Vector<Port> ports = new Vector<Port>();
        try {
            ports = this.type.equals("IP") ? PortNumberFactory.getIPPorts() : PortNumberFactory.getEthernetPorts();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return ports;
    }

    private Action getPortPopupAction(final PortNumberPopup popup, final JTextField portTextField) {
        return new AbstractAction(UIText.get(3584)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                popup.setVisible(false);
                portTextField.setText(popup.getSelectedPorts());
                portTextField.requestFocus();
            }
        };
    }

    private Long toLong(String value) {
        try {
            if (value.startsWith("0x") || value.startsWith("0X")) {
                String newValue = value.substring(2);
                return Long.valueOf(newValue, 16);
            }
            return Long.valueOf(value);
        }
        catch (Exception ignore) {
            return null;
        }
    }

    public void setObject(ProtocolObject protocolObject) {
        this.protocolObject = protocolObject;
        this.setValues();
    }

    public ProtocolObject getProtocolObject() {
        if (this.protocolObject == null) {
            this.protocolObject = this.type.equals("IP") ? new ProtocolObject(new RawIp()) : new ProtocolObject(new RawEthernet());
        }
        return this.protocolObject;
    }

    public boolean isValidProtocol() {
        String protocolString = this.getProtocolNumberTextField().getText();
        boolean valid = true;
        StringBuilder valueHolder = new StringBuilder();
        if (this.type.equals("Ethernet")) {
            if (protocolString == null || protocolString.trim().length() == 0) {
                return true;
            }
            int val = 0;
            val = protocolString.startsWith("0x") || protocolString.startsWith("0X") ? Integer.parseInt(protocolString.substring(2, protocolString.length()), 16) : Integer.parseInt(protocolString);
            if (val < 0 || val > 65535) {
                String message = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.error.ProtocolNumberOutOfRange"), protocolString);
                JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.title.InvalidProtocol"), 0);
                return false;
            }
        } else {
            valid = PortNumberFactory.isValidProtocolString(protocolString, valueHolder, 255);
        }
        if (!valid) {
            String invalidToken = valueHolder.toString();
            String message = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.error.ProtocolNumberOutOfRange255"), invalidToken);
            JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "EthernetProtocolPanel.title.InvalidProtocol"), 0);
            return false;
        }
        return true;
    }
}

