/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.acl.AdminACLUtils;
import com.sygate.scm.common.acl.PrivilegeContext;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FwNetworkInterfaceObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.util.DataobjectManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class CustomAdapterDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static final String[] TYPES = new String[]{FwNetworkInterfaceObject.ALL, FwNetworkInterfaceObject.VPN, FwNetworkInterfaceObject.DIAL_UP, FwNetworkInterfaceObject.ETHERNET, FwNetworkInterfaceObject.WIRELESS};
    private JComboBox<String> jCmbType = new JComboBox<String>(TYPES);
    private JTextField jTFName = new JTextField(30);
    private JTextField jTFId = new JTextField(30);
    private List<String> nameIdArray;
    private boolean isNameEnabled = true;
    private FwNetworkInterfaceObject niObj;

    public CustomAdapterDialog(FwNetworkInterfaceObject niObj, List<String> nameArray, boolean isNameEnabled) {
        this(niObj, nameArray, isNameEnabled, false);
    }

    public CustomAdapterDialog(FwNetworkInterfaceObject niObj, List<String> nameArray, boolean isNameEnabled, boolean isCheckPolicyEnforcement) {
        super(Manager.getFrame(), "", true);
        this.isNameEnabled = isNameEnabled;
        this.setTitle(this.createTitle(isCheckPolicyEnforcement));
        this.initialize(isCheckPolicyEnforcement);
        this.setData(niObj, nameArray, isNameEnabled);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public FwNetworkInterfaceObject getNetworkInterfaceObject() {
        return this.niObj;
    }

    @Override
    protected boolean isValidate() {
        String name = this.jTFName.getText().trim();
        String id = this.jTFId.getText().trim();
        if (this.jTFName.isEnabled() && name.length() == 0) {
            JOptionPane.showMessageDialog(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.error.AdapterNameEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.title.AdapterName"), 0);
            return false;
        }
        if (this.jTFId.isEnabled() && id.length() == 0) {
            JOptionPane.showMessageDialog(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.error.AdapterIdNameEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.title.AdapterId"), 0);
            return false;
        }
        if (this.jTFName.isEnabled() && (this.nameIdArray.contains(name) || "All Adapters".equals(name))) {
            JOptionPane.showMessageDialog(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.error.AdapterNameAlreadyExists"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.title.AdapterName"), 0);
            return false;
        }
        if (!this.jTFName.isEnabled() && this.nameIdArray.contains(id)) {
            JOptionPane.showMessageDialog(null, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.error.AdapterIdAlreadyExists"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.title.AdapterId"), 0);
            return false;
        }
        return true;
    }

    @Override
    protected void commit() {
        this.niObj.setOptName(this.jTFName.getText().trim());
        this.niObj.setOptNetworkInterfaceDescString(this.jTFId.getText().trim());
        this.niObj.setOptNetworkInterfaceType(FwNetworkInterfaceObject.getAdpaterTypeFromDescription((String)this.jCmbType.getSelectedItem()));
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_network_adapters_add_network_adapter";
    }

    private void initialize(boolean isCheckPolicyEnforcement) {
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getInnerPanel(), "Center");
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (isCheckPolicyEnforcement && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.jCmbType.setEnabled(false);
            this.jTFName.setEnabled(false);
            this.jTFId.setEnabled(false);
            this.jBOk.setEnabled(false);
        }
        this.pack();
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.label.AdapterType")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        panel.add(this.jCmbType, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 5), 0, 0));
        if (this.isNameEnabled) {
            panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.label.AdapterName")), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
            panel.add((Component)this.jTFName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 5), 0, 0));
        }
        panel.add((Component)new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.label.AdapterId")), new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 5, 0, 0), 0, 0));
        panel.add((Component)this.jTFId, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 5), 0, 0));
        panel.add((Component)this.getButtonPanel(), new GridBagConstraints(0, 3, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 0, 0, 0), 0, 0));
        return panel;
    }

    private void setData(FwNetworkInterfaceObject niObj, List<String> nameArray, boolean isNameEnabled) {
        String desc;
        String name;
        this.niObj = niObj;
        this.nameIdArray = nameArray;
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (!AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            this.jTFName.setEnabled(isNameEnabled);
        }
        if ((name = niObj.getOptName()) != null) {
            this.jTFName.setText(name);
            if (isNameEnabled) {
                this.nameIdArray.remove(name);
            }
        }
        if ((desc = niObj.getOptNetworkInterfaceDescString()) != null) {
            this.jTFId.setText(desc);
            if (!isNameEnabled) {
                this.nameIdArray.remove(desc);
            }
        }
        this.jCmbType.setSelectedItem(FwNetworkInterfaceObject.getAdapterTypeDescriptionFromType(niObj.getOptNetworkInterfaceType()));
        if (this.jCmbType.getSelectedIndex() < 0) {
            this.jCmbType.setSelectedIndex(0);
        }
    }

    private String createTitle(boolean isCheckPolicyEnforcement) {
        PrivilegeContext context = DataobjectManager.getInstance().getCurrentPrivilegeContext();
        if (isCheckPolicyEnforcement && AdminACLUtils.isSharedPolicyReadOnly((PrivilegeContext)context)) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.readOnlyTitle");
        }
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CustomAdapterDialog.title");
    }
}

