/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.ConfigureRuleLoggingPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.FirewallRuleHandler;
import com.sygate.scm.console.ui.policy.firewall.dialog.RuleWizardWelcomePanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.SelectRuleActionPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.SelectRuleApplicationPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.SelectRuleHostPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.SelectRuleNetworkServicePanel;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FirewallRuleObject;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.RootPaneContainer;
import javax.swing.border.Border;

public class CreateRuleWizardDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    JPanel leftPane;
    private WizardPanel currentOne;
    private JPanel mainPnl = null;
    private JPanel centerPnl = null;
    private JButton backBtn;
    private JPanel bottomPnl = null;
    JButton[] buttons = null;
    private JSplitPane sPane = null;
    private FirewallRuleObject ruleObject = null;
    boolean isCancel = true;
    boolean listenerAdded = false;
    RuleWizardWelcomePanel ruleWelcomePanel = null;
    boolean addmore = false;
    private boolean isMacRulePanel = false;
    private LicenseObject licenseObject = LicenseObject.getInstance();

    public CreateRuleWizardDialog(FirewallRuleObject ruleObject, boolean isMacRulePanel) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CreateRuleWizardDialog.title.CreateRuleFirewallPolicy"), true);
        this.ruleObject = ruleObject;
        this.isMacRulePanel = isMacRulePanel;
        this.init();
    }

    public CreateRuleWizardDialog() {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "CreateRuleWizardDialog.title.CreateRuleFirewallPolicy"), true);
        this.init();
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        JPanel centralPanel = new JPanel(new BorderLayout());
        centralPanel.add((Component)this.getCentralPane(), "Center");
        centralPanel.add((Component)this.getBottomPane(), "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)centralPanel, "Center");
        this.pack();
        this.backBtn.setEnabled(false);
        UiUtilities.centerComponent((Component)this);
    }

    private JComponent getCentralPane() {
        this.centerPnl = new JPanel(new BorderLayout());
        this.sPane = new JSplitPane();
        this.leftPane = this.getLeftPane();
        this.sPane.add((Component)this.leftPane, "left");
        this.sPane.add((Component)this.getMainPanel(), "right");
        this.sPane.setDividerLocation(175);
        this.sPane.setDividerSize(0);
        Border outer = BorderFactory.createEtchedBorder();
        this.sPane.setBorder(outer);
        this.centerPnl.add((Component)this.sPane, "Center");
        return this.centerPnl;
    }

    private JPanel getLeftPane() {
        LeftPanel leftPnl = new LeftPanel();
        return leftPnl;
    }

    private JPanel getMainPanel() {
        this.mainPnl = new JPanel(new BorderLayout());
        this.ruleWelcomePanel = this.getRuleWizardWelcomePanel();
        this.mainPnl.add((Component)this.ruleWelcomePanel, "North");
        this.currentOne = this.ruleWelcomePanel;
        Border outer = BorderFactory.createEtchedBorder();
        this.mainPnl.setBorder(outer);
        return this.mainPnl;
    }

    private RuleWizardWelcomePanel getRuleWizardWelcomePanel() {
        if (this.ruleWelcomePanel != null) {
            return this.ruleWelcomePanel;
        }
        FirewallRuleHandler.getInstance().setFireWallRuleName(this.getObject().getName());
        this.ruleWelcomePanel = new RuleWizardWelcomePanel(this.isMacRulePanel);
        this.ruleWelcomePanel.setPreferredSize(this.ruleWelcomePanel.getWizardPreferredSize());
        return this.ruleWelcomePanel;
    }

    private JComponent getBottomPane() {
        AbstractAction back = new AbstractAction(UIText.get(256)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                CreateRuleWizardDialog.this.this_backAction(ev);
            }
        };
        AbstractAction next = new AbstractAction(UIText.get(3328)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                CreateRuleWizardDialog.this.this_nextAction(ev);
            }
        };
        AbstractAction cancel = new AbstractAction(UIText.get(512)){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent ev) {
                CreateRuleWizardDialog.this.this_cancelAction(ev);
            }
        };
        this.buttons = new JButton[3];
        this.buttons[0] = new JButton(back);
        this.buttons[1] = new JButton(next);
        this.buttons[2] = new JButton(cancel);
        this.backBtn = this.buttons[0];
        this.bottomPnl = this.getWizardButtonPanel(this.buttons);
        UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.buttons[1]);
        return this.bottomPnl;
    }

    private JPanel getWizardButtonPanel(JButton[] buttons) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 5));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttons[0]);
        buttonPanel.add(Box.createHorizontalStrut(2));
        buttonPanel.add(buttons[1]);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(buttons[2]);
        return buttonPanel;
    }

    protected void this_backAction(ActionEvent ev) {
        this.backAction();
    }

    void backAction() {
        WizardPanel prePane = this.currentOne.getPreviousPanel();
        if (prePane != null && prePane instanceof JPanel) {
            JPanel panel = (JPanel)((Object)prePane);
            this.mainPnl.removeAll();
            this.mainPnl.add((Component)panel, "Center");
            this.centerPnl.removeAll();
            if (this.currentOne instanceof SelectRuleActionPanel) {
                this.sPane.removeAll();
                this.sPane.add((Component)this.leftPane, "left");
                this.sPane.add((Component)this.mainPnl, "right");
                this.sPane.updateUI();
                this.centerPnl.add((Component)this.sPane, "Center");
                this.centerPnl.updateUI();
            } else {
                this.centerPnl.add((Component)this.mainPnl, "Center");
            }
            boolean backEnable = prePane.getPreviousPanel() != null;
            this.backBtn.setEnabled(backEnable);
            this.currentOne = prePane;
            if (this.currentOne.getNextPanel() == null) {
                this.buttons[1].setText(UIText.get(1281));
                this.bottomPnl.updateUI();
            } else {
                this.buttons[1].setText(UIText.get(3328));
                this.bottomPnl.updateUI();
            }
            this.mainPnl.updateUI();
        }
    }

    void this_nextAction(ActionEvent ev) {
        this.nextAction();
    }

    private void nextAction() {
        if (this.currentOne instanceof RuleWizardWelcomePanel) {
            if (!((RuleWizardWelcomePanel)this.currentOne).isValidData()) {
                return;
            }
            ((RuleWizardWelcomePanel)this.currentOne).addData();
        } else if (this.currentOne instanceof SelectRuleActionPanel) {
            ((SelectRuleActionPanel)this.currentOne).addData();
        } else if (this.currentOne instanceof SelectRuleApplicationPanel) {
            if (!((SelectRuleApplicationPanel)this.currentOne).isValidData()) {
                return;
            }
            ((SelectRuleApplicationPanel)this.currentOne).addData();
        } else if (this.currentOne instanceof SelectRuleHostPanel) {
            if (!((SelectRuleHostPanel)this.currentOne).isValidData()) {
                return;
            }
            ((SelectRuleHostPanel)this.currentOne).addData();
        } else if (this.currentOne instanceof SelectRuleNetworkServicePanel) {
            if (!((SelectRuleNetworkServicePanel)this.currentOne).isValidData()) {
                return;
            }
            ((SelectRuleNetworkServicePanel)this.currentOne).addData();
        } else if (this.currentOne instanceof ConfigureRuleLoggingPanel) {
            ((ConfigureRuleLoggingPanel)this.currentOne).addData();
        }
        WizardPanel nextPane = this.currentOne.getNextPanel();
        if (nextPane != null) {
            if (nextPane instanceof JPanel) {
                JPanel panel = (JPanel)((Object)nextPane);
                this.mainPnl.removeAll();
                this.mainPnl.add((Component)panel, "Center");
                this.centerPnl.removeAll();
                this.centerPnl.add((Component)this.mainPnl, "Center");
                boolean backEnable = nextPane.getPreviousPanel() != null;
                this.backBtn.setEnabled(backEnable);
                this.currentOne = nextPane;
                if (this.currentOne.getNextPanel() == null) {
                    this.buttons[1].setText(UIText.get(1281));
                    this.bottomPnl.updateUI();
                } else {
                    this.buttons[1].setText(UIText.get(3328));
                    this.bottomPnl.updateUI();
                }
                if (nextPane instanceof SelectRuleHostPanel) {
                    ((SelectRuleHostPanel)nextPane).refresh();
                }
                this.mainPnl.updateUI();
            }
        } else {
            System.out.println("Finished");
            this.createRuleObject();
            this.isCancel = false;
            this.dispose();
        }
    }

    void this_cancelAction(ActionEvent ev) {
        this.isCancel = true;
        this.dispose();
    }

    private void createRuleObject() {
        this.ruleObject.setName(FirewallRuleHandler.getInstance().getFireWallRuleName());
        this.setRuleActionSettings();
        if (!this.licenseObject.isSBProduct()) {
            this.setRuleApplicationSettings();
        }
        this.setRuleHostSettings();
        this.setRuleNetworkServicesSettings();
        this.setRuleLoggingSettings();
    }

    private void setRuleActionSettings() {
        String actionString = FirewallRuleHandler.getInstance().getRuleAction() == 1 ? "Allow" : (FirewallRuleHandler.getInstance().getRuleAction() == 2 ? "Block" : "Ask");
        this.ruleObject.setAction(actionString);
    }

    private void setRuleApplicationSettings() {
        FirewallRuleHandler firewallRuleHandler = FirewallRuleHandler.getInstance();
        if (firewallRuleHandler.isApplyToSelectedApplications() && firewallRuleHandler.getApplicationObjects().size() > 0) {
            this.ruleObject.setApplicationTrigger(firewallRuleHandler.getApplicationTrigger());
            this.ruleObject.setApplications(firewallRuleHandler.getApplicationObjects());
        }
    }

    private void setRuleHostSettings() {
        FirewallRuleHandler firewallRuleHandler = FirewallRuleHandler.getInstance();
        if (firewallRuleHandler.isApplyToSelectedHosts() && firewallRuleHandler.getHostObjects().size() > 0) {
            this.ruleObject.setHostTrigger(firewallRuleHandler.getHostTrigger());
            this.ruleObject.setHosts(firewallRuleHandler.getHostObjects());
        }
    }

    private void setRuleNetworkServicesSettings() {
        FirewallRuleHandler firewallRuleHandler = FirewallRuleHandler.getInstance();
        int serviceSelectionIndex = firewallRuleHandler.getServiceSelectionIndex();
        if ((serviceSelectionIndex == 2 || serviceSelectionIndex == 3) && firewallRuleHandler.getProtocolContainers().size() > 0) {
            this.ruleObject.setServiceTrigger(firewallRuleHandler.getServiceTrigger());
            this.ruleObject.setProtocolContainers(firewallRuleHandler.getProtocolContainers());
        }
    }

    private void setRuleLoggingSettings() {
        FirewallRuleHandler firewallRuleHandler = FirewallRuleHandler.getInstance();
        if (firewallRuleHandler.isLoggingEnabled()) {
            this.ruleObject.getAction().setTrafficLog(true);
        } else {
            this.ruleObject.getAction().setTrafficLog(false);
        }
        this.ruleObject.getAction().setPacketLog(false);
    }

    public FirewallRuleObject getObject() {
        return this.ruleObject;
    }

    public boolean isCancelled() {
        return this.isCancel;
    }

    static class LeftPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private static ImageIcon leftImage = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("side.jpg")));

        public LeftPanel() {
            this.setLayout(null);
            this.setOpaque(false);
        }

        @Override
        public void paint(Graphics graphics) {
            graphics.drawImage(leftImage.getImage(), 0, 0, this.getWidth(), this.getHeight(), this);
            super.paint(graphics);
        }
    }
}

