/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.dialog.WizardListener;
import com.sygate.scm.console.ui.policy.dialog.WizardPanel;
import com.sygate.scm.console.ui.policy.firewall.dialog.FirewallRuleHandler;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

class ConfigureRuleLoggingPanel
extends JPanel
implements WizardPanel {
    private static final long serialVersionUID = 1L;
    private WizardPanel previousPanel = null;
    private ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton allowLogging = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ConfigureRuleLoggingPanel.radio.AllowLogging"));
    private JRadioButton disableLogging = new JRadioButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ConfigureRuleLoggingPanel.radio.DisableLogging"));
    private JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ConfigureRuleLoggingPanel.label.DoYouWantToAllowOrDisable"));
    private JLabel clickOnFinishLabel = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ConfigureRuleLoggingPanel.label.ClickOnFinish"));

    public ConfigureRuleLoggingPanel() {
        this.initialize();
    }

    private void initialize() {
        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ConfigureRuleLoggingPanel.title.ConfigureRuleLogging");
        String content = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ConfigureRuleLoggingPanel.description.ConfigureRuleLoggingDesc");
        JPanel headPanel = UIUtilities.getTopBannerWithLogo(title, content);
        this.setLayout(new GridBagLayout());
        this.add((Component)headPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        this.disableLogging.setSelected(true);
        this.buttonGroup.add(this.allowLogging);
        this.buttonGroup.add(this.disableLogging);
        panel.add((Component)this.label, this.getGridBagConstaint(0, 0));
        panel.add((Component)this.allowLogging, this.getGridBagConstaint(0, 1));
        panel.add((Component)this.disableLogging, this.getGridBagConstaint(0, 2));
        panel.add((Component)this.clickOnFinishLabel, this.getGridBagConstaint(0, 3));
        panel.add(Box.createGlue(), this.getGridBagConstaint(0, 4));
        this.add((Component)panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(40, 40, 0, 40), 0, 0));
    }

    private GridBagConstraints getGridBagConstaint(int x, int y) {
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = x;
        cons.gridy = y;
        cons.anchor = 17;
        cons.fill = 2;
        cons.weightx = 1.0;
        int left = 2;
        int right = 2;
        int top = 2;
        int bottom = 2;
        switch (y) {
            case 0: {
                bottom = 10;
                break;
            }
            case 3: {
                top = 20;
                break;
            }
            case 4: {
                cons.weighty = 1.0;
                cons.fill = 1;
                break;
            }
            default: {
                left += 10;
            }
        }
        cons.insets = new Insets(top, left, bottom, right);
        return cons;
    }

    @Override
    public WizardPanel getNextPanel() {
        return null;
    }

    @Override
    public WizardPanel getPreviousPanel() {
        return this.previousPanel;
    }

    @Override
    public void setPreviousPanel(WizardPanel panel) {
        this.previousPanel = panel;
    }

    @Override
    public void addListener(WizardListener listener) {
    }

    @Override
    public void removeListener(WizardListener listener) {
    }

    @Override
    public Dimension getWizardPreferredSize() {
        return UIUtilities.getMaxDimension(this.getPreferredSize(), null);
    }

    public void addData() {
        FirewallRuleHandler.getInstance().setLoggingEnabled(this.allowLogging.isSelected());
    }
}

