/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.common.configobject.schema.FwApplicationTrigger;
import com.sygate.scm.common.configobject.schema.SoApplicationContainer;
import com.sygate.scm.common.configobject.table.SemApplication;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.common.util.Cast;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.LearnedApplicationObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.policy.common.ButtonPane;
import com.sygate.scm.console.ui.policy.common.LearnedAppTakerInt;
import com.sygate.scm.console.ui.policy.dialog.FindApplicationDlg;
import com.sygate.scm.console.ui.policy.firewall.dialog.ApplicationDialog;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ApplicationObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;

public class ApplicationListDialog
extends DialogBase
implements LearnedAppTakerInt {
    private static final long serialVersionUID = 1L;
    private static final String[] columnNames = new String[]{MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.column.Name"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.columnDescription"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.column.Size"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.column.LastModified"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.column.Fingerprint")};
    private String strYear = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.common.common", "FileLastModifiedPanel.Label.year");
    private String strMonth = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.common.common", "FileLastModifiedPanel.Label.month");
    private String strDay = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.common.common", "FileLastModifiedPanel.Label.day");
    private static final int[] columnMappings = new int[]{1, 2, 3, 4, 5};
    private JTable applicationTable;
    private SortableTableModel model;
    private transient ListSelectionListener tableSelectionListener;
    private transient MouseListener tableMouseListener;
    private JPopupMenu applicationPopup;
    private JScrollPane scrollPane;
    private Action addAction;
    private Action addFromAction;
    private Action deleteAction;
    private Action editAction;
    private JButton addButton;
    private JButton addFromButton;
    private JButton deleteButton;
    private JButton editButton;
    private JPanel appButtonPanel;
    private JPanel applicationListPanel;
    private Vector<TableRow> applicationObjects;
    private FwApplicationTrigger applicationTrigger;
    private SoApplicationContainer appContainer;

    public ApplicationListDialog(FwApplicationTrigger appTrigger) {
        super(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.title.AppList"), true);
        this.applicationTrigger = appTrigger;
        this.init();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_rules_application";
    }

    private void init() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.getApplicationListPanel(), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.setSize(new Dimension(720, 300));
        this.setDefaultCloseOperation(2);
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private Vector<ApplicationObject> getApplications() {
        if (this.applicationObjects == null) {
            Vector apps;
            this.appContainer = this.applicationTrigger.getSoApplicationContainer();
            if (this.appContainer == null) {
                this.appContainer = new SoApplicationContainer();
                this.applicationTrigger.setSoApplicationContainer(this.appContainer);
            }
            if ((apps = this.appContainer.getExecutable()) != null) {
                this.applicationObjects = new Vector();
                for (Executable exec : apps) {
                    this.applicationObjects.add(new ApplicationObject(exec));
                }
            }
        }
        return (Vector)Cast.cast(this.applicationObjects);
    }

    private JPanel getApplicationListPanel() {
        if (this.applicationListPanel == null) {
            this.applicationListPanel = new JPanel();
            this.applicationListPanel.setLayout(new BorderLayout());
            this.applicationListPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            JLabel label = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.label.AppsThatTriggerRule"), 2);
            label.setBorder(BorderFactory.createEmptyBorder(10, 1, 0, 0));
            this.applicationListPanel.add((Component)label, "North");
            this.applicationListPanel.add((Component)this.getScrollPane(), "Center");
            this.applicationListPanel.add((Component)this.getApplicationButtonPanel(), "South");
            this.applicationListPanel.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        }
        return this.applicationListPanel;
    }

    private JScrollPane getScrollPane() {
        if (this.scrollPane == null) {
            this.scrollPane = new JScrollPane();
            this.scrollPane.getViewport().add(this.getApplicationTable());
            this.scrollPane.getViewport().addMouseListener(this.getTableMouseListener());
        }
        return this.scrollPane;
    }

    private JTable getApplicationTable() {
        if (this.applicationTable == null) {
            this.applicationTable = new StripesTable();
            this.applicationTable.setAutoResizeMode(4);
            this.applicationTable.setModel(this.getTableModel());
            this.applicationTable.getSelectionModel().setSelectionMode(2);
            this.applicationTable.getSelectionModel().addListSelectionListener(this.getTableSelectionListener());
            this.getTableModel().addMouseListenerToHeaderInTable(this.applicationTable);
            this.applicationTable.addMouseListener(this.getTableMouseListener());
            float[] colSizes = new float[]{0.2f, 0.2f, 0.2f, 0.2f, 0.2f};
            int width = this.getScrollPane().getWidth();
            if (width == 0) {
                width = 485;
            }
            this.applicationTable.getColumn(this.applicationTable.getColumnName(3)).setCellRenderer(new DefaultTableCellRenderer(){
                private static final long serialVersionUID = 1853199725422977849L;

                @Override
                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Component comp = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    if (comp instanceof JLabel && value != null && !value.equals("")) {
                        ((JLabel)comp).setText(ApplicationListDialog.this.localizeTimeFormat(value.toString()));
                    }
                    return comp;
                }
            });
            UIUtilities.resizeColumns(this.applicationTable, colSizes, width);
        }
        return this.applicationTable;
    }

    private String localizeTimeFormat(String timeStr) {
        String localStr = "";
        if (timeStr.contains("*")) {
            return this.localizeTimeMatchAllFormat(timeStr);
        }
        String REGEX = "\\d{1,2}/\\d{1,2}/\\d{2,4}";
        Pattern p = Pattern.compile("\\d{1,2}/\\d{1,2}/\\d{2,4}");
        Matcher m = p.matcher(timeStr);
        if (!m.matches()) {
            return localStr;
        }
        int year = 0;
        int month = 0;
        int day = 0;
        StringTokenizer st = new StringTokenizer(timeStr, "/");
        if (st.hasMoreTokens()) {
            month = Integer.parseInt(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            day = Integer.parseInt(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            year = Integer.parseInt(st.nextToken());
        }
        DateFormat defaultFormat = DateFormat.getDateInstance(1, Locale.getDefault());
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        cal.set(5, day);
        localStr = UIUtilities.formatDate(cal.getTime(), (Format)defaultFormat);
        return localStr;
    }

    private String localizeTimeMatchAllFormat(String timeStr) {
        StringBuffer yearStrBuf = new StringBuffer();
        StringBuffer monthStrBuf = new StringBuffer();
        StringBuffer dayStrBuf = new StringBuffer();
        StringTokenizer st = new StringTokenizer(timeStr, "/");
        if (st.hasMoreTokens()) {
            monthStrBuf.append(this.strMonth).append(st.nextToken()).append("  ");
        }
        if (st.hasMoreTokens()) {
            dayStrBuf.append(this.strDay).append(st.nextToken());
        }
        if (st.hasMoreTokens()) {
            yearStrBuf.append(this.strYear).append(st.nextToken()).append("  ");
        }
        return yearStrBuf.append(monthStrBuf.toString()).append(dayStrBuf.toString()).toString();
    }

    private SortableTableModel getTableModel() {
        if (this.model == null) {
            this.model = new SortableTableModel();
            this.model.setColumnNames(columnNames);
            this.model.setColumnMapping(columnMappings);
            this.model.setDataVector((Vector)Cast.cast(this.getApplications()));
        }
        return this.model;
    }

    private ListSelectionListener getTableSelectionListener() {
        if (this.tableSelectionListener == null) {
            this.tableSelectionListener = new ListSelectionListener(){
                int m_curSelectedRow = -1;

                @Override
                public void valueChanged(ListSelectionEvent e) {
                    if (e.getValueIsAdjusting()) {
                        ApplicationListDialog.this.editButton.setEnabled(false);
                    }
                    if (!AjaxSwingCommonUtil.isAjaxSwingRunning() && ApplicationListDialog.this.applicationTable.getSelectedRow() == this.m_curSelectedRow) {
                        return;
                    }
                    this.m_curSelectedRow = ApplicationListDialog.this.applicationTable.getSelectedRow();
                    int count = ApplicationListDialog.this.applicationTable.getSelectedRowCount();
                    ApplicationListDialog.this.deleteButton.setEnabled(count > 0);
                    ApplicationListDialog.this.editButton.setEnabled(count == 1);
                }
            };
        }
        return this.tableSelectionListener;
    }

    private MouseListener getTableMouseListener() {
        if (this.tableMouseListener == null) {
            this.tableMouseListener = new MouseAdapter(){

                private void ShowPopup(MouseEvent e) {
                    int count = ApplicationListDialog.this.applicationTable.getSelectedRowCount();
                    ApplicationListDialog.this.deleteAction.setEnabled(count > 0);
                    ApplicationListDialog.this.editAction.setEnabled(count == 1);
                    ApplicationListDialog.this.getApplicationPopup().show(e.getComponent(), e.getX(), e.getY());
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (e.getModifiers() == 4) {
                        this.ShowPopup(e);
                    } else if (e.getSource() instanceof JTable && e.getClickCount() == 2) {
                        ApplicationListDialog.this.editApplication();
                    }
                }
            };
        }
        return this.tableMouseListener;
    }

    private JPopupMenu getApplicationPopup() {
        if (this.applicationPopup == null) {
            this.applicationPopup = new JPopupMenu();
            this.applicationPopup.add(this.addAction);
            if (!LicenseObject.getInstance().isSBProduct()) {
                this.applicationPopup.add(this.addFromAction);
            }
            this.applicationPopup.add(this.deleteAction);
            this.applicationPopup.add(this.editAction);
        }
        return this.applicationPopup;
    }

    private void addApplication() {
        ApplicationDialog dialog = new ApplicationDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.addApplicationDlgTitle"), true, null, false);
        ApplicationObject newObject = new ApplicationObject();
        dialog.setObject(newObject);
        dialog.setVisible(true);
        if (dialog.isOk()) {
            if (this.appExists(newObject, this.appContainer)) {
                return;
            }
            this.getTableModel().addRow(newObject);
            Executable newExecutable = newObject.getExecutable();
            this.appContainer.addExecutable(newExecutable);
        }
    }

    public boolean appExists(ApplicationObject obj, SoApplicationContainer appContainer) {
        Executable exe = obj.getExecutable();
        for (Executable exe2 : appContainer.getExecutable()) {
            if (!PolicyHandler.compareTwoExecutableObj(exe2, exe)) continue;
            JOptionPane.showMessageDialog(this, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.error.AppAlreadyExists"), obj.getName()), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.title.Error"), 0);
            return true;
        }
        return false;
    }

    private void addApplicationFrom() {
        FindApplicationDlg dialog = new FindApplicationDlg(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.title.LearnedAppList"), true);
        dialog.setLearnedAppTaker(this);
        dialog.setVisible(true);
    }

    private void deleteApplication() {
        int result;
        int[] rows = this.applicationTable.getSelectedRows();
        if (rows == null || rows.length == 0) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.SelectOneLineBeforeEditApp"));
            return;
        }
        String message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.ConfirmDeleteAppTrigger");
        if (rows.length > 1) {
            message = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.ConfirmDeleteMultiAppTrigger");
        }
        if ((result = UIUtilities.confirmYesNoOptionDialog(message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.title.DeleteApp"))) == 0) {
            for (int row : rows) {
                ApplicationObject appObj = (ApplicationObject)this.getTableModel().getRow(row);
                Executable exec = appObj.getExecutable();
                this.appContainer.removeExecutable(exec);
            }
            this.refreshTable();
            this.editButton.setEnabled(this.applicationTable.getSelectedRowCount() == 1);
        }
    }

    private void refreshTable() {
        int len = this.model.getRowCount();
        for (int i = len - 1; i >= 0; --i) {
            this.model.removeRow(i);
        }
        Vector apps = this.appContainer.getExecutable();
        if (apps != null) {
            this.applicationObjects = new Vector();
            for (Executable exec : apps) {
                this.applicationObjects.add(new ApplicationObject(exec));
            }
            this.model.setDataVector(new Vector<TableRow>(this.applicationObjects));
        }
        this.model.sortTable(-1);
        if (this.applicationTable.getRowCount() > 0) {
            this.applicationTable.setRowSelectionInterval(0, 0);
        }
    }

    private void editApplication() {
        block5: {
            int index = this.getApplicationTable().getSelectedRow();
            if (index == -1) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.SelectOneLineBeforeEditApp"));
                return;
            }
            ApplicationObject appObj = (ApplicationObject)this.getTableModel().getRow(index);
            try {
                ApplicationObject appObjCopy = appObj.getClone();
                ApplicationDialog dialog = new ApplicationDialog(appObj, true);
                dialog.setObject(appObjCopy);
                dialog.setVisible(true);
                if (dialog.isOk()) {
                    if (PolicyHandler.compareTwoExecutableObj(appObjCopy.getExecutable(), appObj.getExecutable()) || this.appExists(appObjCopy, this.appContainer)) {
                        return;
                    }
                    Executable exec = appObjCopy.getExecutable();
                    int tempIndex = this.appContainer.getExecutable().indexOf(appObj.getExecutable());
                    this.appContainer.setExecutable(tempIndex, exec);
                    this.getTableModel().setRow(index, appObjCopy);
                }
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationListDialog.title.ConsoleError"), 0);
                if (!ex.needRelogin()) break block5;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    private JPanel getApplicationButtonPanel() {
        if (this.appButtonPanel == null) {
            this.addAction = new AbstractAction(UIText.get(5)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationListDialog.this.addApplication();
                }
            };
            this.addFromAction = new AbstractAction(UIText.get(6)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationListDialog.this.addApplicationFrom();
                }
            };
            this.deleteAction = new AbstractAction(UIText.get(769)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationListDialog.this.deleteApplication();
                }
            };
            this.editAction = new AbstractAction(UIText.get(1024)){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationListDialog.this.editApplication();
                }
            };
            this.addButton = new JButton(this.addAction);
            this.addFromButton = new JButton(this.addFromAction);
            this.deleteButton = new JButton(this.deleteAction);
            this.deleteButton.setEnabled(false);
            this.editButton = new JButton(this.editAction);
            this.editButton.setEnabled(false);
            JButton[] buttons = new JButton[]{this.addButton, this.addFromButton, this.editButton, this.deleteButton};
            JButton[] sbbuttons = new JButton[]{this.addButton, this.editButton, this.deleteButton};
            this.appButtonPanel = new ButtonPane(LicenseObject.getInstance().isSBProduct() ? sbbuttons : buttons, 4);
        }
        return this.appButtonPanel;
    }

    public boolean isCancel() {
        return !this.isOk;
    }

    public ArrayList<ApplicationObject> getNewApplications() {
        if (this.getTableModel().getDataVector().size() > 0) {
            return new ArrayList<ApplicationObject>((Collection)Cast.cast(this.getTableModel().getDataVector()));
        }
        return null;
    }

    @Override
    public int addLearnedApplication(LearnedApplicationObject[] allApps) {
        int addedApps = 0;
        System.out.println("Inside add Learned app");
        for (LearnedApplicationObject lappObject : allApps) {
            ApplicationObject appObject;
            SemApplication semApp = lappObject.getSemApplication();
            Executable executable = new Executable();
            String name = semApp.getApplicationName();
            Object path = semApp.getOptApplicationPath().replace('/', File.separatorChar);
            if (path != null && ((String)path).length() > 0) {
                if (!((String)path).endsWith(Character.toString(File.separatorChar))) {
                    path = (String)path + File.separatorChar;
                }
                executable.setOptFileName((String)path + name);
            } else {
                executable.setOptFileName(name);
            }
            String checksum = semApp.getChecksum();
            executable.setOptFileMd5Checksum(checksum);
            String checksumSha256 = semApp.getOptSHA2();
            executable.setOptFileSHA256Checksum(checksumSha256);
            String desc = semApp.getOptAppDescription();
            executable.setOptFileDescription(desc);
            executable.setOptFileSize(semApp.getOptFileSize());
            executable.setOptVersion(semApp.getOptVersion());
            if (semApp.getOptLastModifyTime() != null) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("MM/dd/yyyy");
                dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                executable.setOptFileLastModifiedDate(UIUtilities.formatDate(semApp.getOptLastModifyTime(), (Format)dateFormat));
            }
            if (this.appExists(appObject = new ApplicationObject(executable), this.appContainer)) continue;
            this.getTableModel().addRow(appObject);
            this.appContainer.addExecutable(executable);
            ++addedApps;
        }
        return addedApps;
    }
}

