/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.dialog;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.ui.policy.common.FileLastModifiedPanel;
import com.sygate.scm.console.ui.policy.common.GUICheckException;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ApplicationObject;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class ApplicationDialog
extends DialogBase {
    private static final long serialVersionUID = 1L;
    private static JFileChooser fileChooser;
    private ApplicationObject appObj;
    private JPanel jContentPane = null;
    private JPanel jPanel = null;
    private JLabel jLabel = null;
    private JLabel jLabel1 = null;
    private JLabel jCommonNoteLabel = null;
    private JLabel jLabel3 = null;
    private JLabel jLabel4 = null;
    private JLabel jLabel5 = null;
    private JTextField nameField = null;
    private JTextField descriptionField = null;
    private JTextField sizeField = null;
    private FileLastModifiedPanel lastModifyPanel = null;
    private JTextField md5ChecksumField = null;
    private JTextField shaChecksumField = null;
    private JLabel jLabel7 = null;
    private JLabel jLabelSHA256 = null;
    private JLabel jLabelRBMD5 = null;
    private JButton browseButton = new JButton(UIText.get(257));
    private boolean isEdit = false;

    public ApplicationDialog() {
        this(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.title.App"), true, null, false);
    }

    public ApplicationDialog(ApplicationObject appObject, boolean isEdit) {
        this(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.title.App"), true, appObject, isEdit);
    }

    public ApplicationDialog(JFrame parent, String title, boolean modal, ApplicationObject appObject, boolean isEdit) {
        super(parent, title, modal);
        this.appObj = appObject;
        this.isEdit = isEdit;
        this.initialize();
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_rules_application_add";
    }

    @Override
    protected boolean isValidate() {
        try {
            this.lastModifyPanel.checkLastModifiedDate();
            int checksumLen = this.getMD5ChecksumField().getText().trim().length();
            if (checksumLen > 0 && checksumLen != 32) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.ErrorFingerprintIsHex"), this.getMD5ChecksumField());
            }
            int shaChecksumLen = this.getSHAChecksumField().getText().trim().length();
            if (shaChecksumLen > 0 && shaChecksumLen != 64) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.ErrorFingerprintIsHex.SHA256"), this.getSHAChecksumField());
            }
            if (StringUtilities.isEmpty((String)this.nameField.getText())) {
                throw new GUICheckException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.ValidationEmptyFileName"), this.nameField);
            }
        }
        catch (GUICheckException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.title.Error"), 0);
            ex.getErrorComponent().requestFocus();
            return false;
        }
        return this.validateFileName(this.nameField.getText());
    }

    @Override
    protected void commit() {
        this.appObj.setName(this.nameField.getText().trim());
        this.appObj.setDescription(this.descriptionField.getText());
        Long size = null;
        String strSize = this.sizeField.getText().trim();
        if (strSize.length() > 0) {
            size = Long.valueOf(strSize);
        }
        this.appObj.setSize(size);
        this.appObj.setLastModified(this.lastModifyPanel.getLastModifiedDate());
        this.appObj.setSHACheckSum(this.getSHAChecksumField().getText());
        this.appObj.setCheckSum(this.getMD5ChecksumField().getText());
    }

    protected void getFileName() {
        try {
            JFileChooser fc = this.getFileChooser();
            fc.setDialogTitle(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.browseDialogTitle"));
            int ret = fc.showDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.browseDialogButtonText"));
            if (ret == 0) {
                File file = fc.getSelectedFile();
                if (file != null && file.getName().compareTo("") != 0) {
                    this.nameField.setText(file.getAbsolutePath());
                }
            } else {
                this.nameField.setText("");
            }
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void initialize() {
        this.setContentPane(this.getJContentPane());
        this.pack();
        UiUtilities.centerComponent((Component)this);
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new BorderLayout());
            this.jContentPane.add((Component)this.getJPanel(), "Center");
            this.jContentPane.add((Component)this.getButtonPanel(), "South");
        }
        return this.jContentPane;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            this.jPanel = new JPanel();
            this.jPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getCommonNoteLabel(), new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 20, 2), 0, 0));
            this.jPanel.add((Component)this.getJLabel7(), new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.jPanel.add((Component)this.getJLabel(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.jPanel.add((Component)this.getNameField(), new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> this.jPanel.add((Component)this.browseButton, new GridBagConstraints(2, 2, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0)));
            this.jPanel.add((Component)this.getSampleLabel(), new GridBagConstraints(1, 3, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.jPanel.add((Component)this.getJLabel1(), new GridBagConstraints(0, 4, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.jPanel.add((Component)this.getDescriptionField(), new GridBagConstraints(1, 4, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.jPanel.add((Component)this.getJLabel3(), new GridBagConstraints(0, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.jPanel.add((Component)this.getSizeField(), new GridBagConstraints(1, 5, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.jPanel.add((Component)this.getJLabel4(), new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 15, 2), 0, 0));
            this.jPanel.add((Component)this.getLastModifyPanel(), new GridBagConstraints(1, 6, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 15, 2), 0, 0));
            this.jPanel.add((Component)this.getJLabel5(), new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.jPanel.add((Component)this.getJLabelSHA256(), new GridBagConstraints(0, 8, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.jPanel.add((Component)this.getSHAChecksumField(), new GridBagConstraints(1, 8, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.jPanel.add((Component)this.getLabelRBMD5(), new GridBagConstraints(0, 9, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
            this.jPanel.add((Component)this.getMD5ChecksumField(), new GridBagConstraints(1, 9, 1, 1, 1.0, 1.0, 17, 2, new Insets(2, 2, 2, 2), 0, 0));
        }
        AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ApplicationDialog.this.getFileName();
            }
        }));
        return this.jPanel;
    }

    private JLabel getJLabel() {
        if (this.jLabel == null) {
            this.jLabel = new JLabel();
            this.jLabel.setBounds(8, 44, 96, 21);
            this.jLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.label.FileName"));
            this.jLabel.setHorizontalAlignment(2);
        }
        return this.jLabel;
    }

    private JLabel getCommonNoteLabel() {
        if (this.jCommonNoteLabel == null) {
            this.jCommonNoteLabel = new JLabel();
            this.jCommonNoteLabel.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.label.CommonNote"));
            this.jCommonNoteLabel.setHorizontalAlignment(2);
        }
        return this.jCommonNoteLabel;
    }

    private JLabel getSampleLabel() {
        JLabel label = new JLabel();
        label.setBounds(123, 73, 250, 21);
        label.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.label.SampleAppName"));
        label.setHorizontalAlignment(2);
        return label;
    }

    private JLabel getJLabel1() {
        if (this.jLabel1 == null) {
            this.jLabel1 = new JLabel();
            this.jLabel1.setBounds(8, 93, 96, 21);
            this.jLabel1.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.label.Description"));
            this.jLabel1.setHorizontalAlignment(2);
        }
        return this.jLabel1;
    }

    private JLabel getJLabel3() {
        if (this.jLabel3 == null) {
            this.jLabel3 = new JLabel();
            this.jLabel3.setBounds(8, 126, 96, 21);
            this.jLabel3.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.label.Size"));
            this.jLabel3.setHorizontalAlignment(2);
        }
        return this.jLabel3;
    }

    private JLabel getJLabel4() {
        if (this.jLabel4 == null) {
            this.jLabel4 = new JLabel();
            this.jLabel4.setBounds(8, 174, 96, 21);
            this.jLabel4.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.label.Modified"));
            this.jLabel4.setHorizontalAlignment(2);
        }
        return this.jLabel4;
    }

    private JLabel getJLabel5() {
        if (this.jLabel5 == null) {
            this.jLabel5 = new JLabel();
            this.jLabel5.setBounds(8, 203, 96, 21);
            this.jLabel5.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.label.Fingerprint"));
            this.jLabel5.setHorizontalAlignment(2);
        }
        return this.jLabel5;
    }

    private JTextField getNameField() {
        if (this.nameField == null) {
            this.nameField = new JTextField();
            this.nameField.setBounds(123, 43, 264, 21);
            this.nameField.setText("");
            RestrictedPlainDocument doc = new RestrictedPlainDocument(260);
            doc.setValidator("\"<>|", false);
            this.nameField.setDocument(doc);
        }
        return this.nameField;
    }

    private JTextField getDescriptionField() {
        if (this.descriptionField == null) {
            this.descriptionField = new JTextField();
            this.descriptionField.setBounds(123, 94, 264, 21);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1024);
            this.descriptionField.setDocument(doc);
        }
        return this.descriptionField;
    }

    private JTextField getSizeField() {
        if (this.sizeField == null) {
            this.sizeField = new JTextField();
            this.sizeField.setBounds(123, 126, 264, 21);
            NumberPlainDocument doc = new NumberPlainDocument();
            this.sizeField.setDocument(doc);
        }
        return this.sizeField;
    }

    private JPanel getLastModifyPanel() {
        if (this.lastModifyPanel == null) {
            this.lastModifyPanel = new FileLastModifiedPanel();
        }
        return this.lastModifyPanel;
    }

    private JTextField getMD5ChecksumField() {
        if (this.md5ChecksumField == null) {
            this.md5ChecksumField = new JTextField();
            this.md5ChecksumField.setBounds(123, 202, 264, 21);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(32);
            doc.setValidator("1234567890ABCDEFabcdef", true);
            this.md5ChecksumField.setDocument(doc);
        }
        return this.md5ChecksumField;
    }

    private JTextField getSHAChecksumField() {
        if (this.shaChecksumField == null) {
            this.shaChecksumField = new JTextField();
            this.shaChecksumField.setBounds(123, 202, 264, 21);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(64);
            doc.setValidator("1234567890ABCDEFabcdef", true);
            this.shaChecksumField.setDocument(doc);
        }
        return this.shaChecksumField;
    }

    private JLabel getJLabel7() {
        if (this.jLabel7 == null) {
            this.jLabel7 = new JLabel();
            this.jLabel7.setBounds(123, 18, 330, 21);
            this.jLabel7.setText(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.label.SampleAppPath"));
        }
        return this.jLabel7;
    }

    private void updatePanel() {
        String modTime;
        this.nameField.setText(this.appObj.getName());
        this.descriptionField.setText(this.appObj.getDescription());
        Long size = this.appObj.getSize();
        if (size != null) {
            this.sizeField.setText(String.valueOf(size));
        }
        String str = modTime = this.appObj.getLastModified();
        if (modTime != null && modTime.trim().length() > 10) {
            str = modTime.substring(0, 10);
        }
        this.lastModifyPanel.setLastModifiedDate(str);
        if (this.isEdit) {
            this.getMD5ChecksumField().setText(this.appObj.getCheckSumForEdit());
            this.getSHAChecksumField().setText(this.appObj.getSHACheckSumForEdit());
        } else {
            this.getMD5ChecksumField().setText(this.appObj.getCheckSum());
            this.getSHAChecksumField().setText(this.appObj.getSHACheckSum());
        }
    }

    private JLabel getLabelRBMD5() {
        if (this.jLabelRBMD5 == null) {
            this.jLabelRBMD5 = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.label.Fingerprint.md5"));
        }
        return this.jLabelRBMD5;
    }

    private JLabel getJLabelSHA256() {
        if (this.jLabelSHA256 == null) {
            this.jLabelSHA256 = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.label.Fingerprint.sha"));
        }
        return this.jLabelSHA256;
    }

    private boolean validateFileName(String fileName) {
        if (fileName.trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.ValidationEmptyFileName"));
            this.nameField.requestFocus();
            return false;
        }
        return true;
    }

    private JFileChooser getFileChooser() {
        if (fileChooser == null) {
            fileChooser = new JFileChooser(){
                private static final long serialVersionUID = 1L;

                @Override
                public void approveSelection() {
                    int ret;
                    File curFile;
                    if (this.getApproveButtonText().equals(UIText.get(257)) && (curFile = this.getSelectedFile()).exists() && (ret = JOptionPane.showConfirmDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.doYouWantToOverwrite"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.overwrite"), 0)) != 0) {
                        return;
                    }
                    super.approveSelection();
                }
            };
            fileChooser.addChoosableFileFilter(new AcpFileFilter());
            fileChooser.setAcceptAllFileFilterUsed(true);
        }
        return fileChooser;
    }

    public void setObject(ApplicationObject appObj) {
        this.appObj = appObj;
        this.updatePanel();
    }

    static class AcpFileFilter
    extends FileFilter {
        static final String ACPFILE = "exe";

        AcpFileFilter() {
        }

        @Override
        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = PolicyHandler.getFileExtension(f.getName());
            return extension != null && extension.equals(ACPFILE);
        }

        @Override
        public String getDescription() {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.dialog.firewalldialog", "ApplicationDialog.browseFilter");
        }
    }
}

