/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.configobject.schema.SecuritySetting;
import com.sygate.scm.common.configobject.schema.WindowsIntegration;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.HtmlEnabledJLabel;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class WindowsSettingPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static String NO_ACTION = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.NO_ACTION");
    private static String DISABLE_ONCE_ONLY = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.DISABLE_ONCE_ONLY");
    private static String DISABLE_ALWAYS = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.DISABLE_ALWAYS");
    private static String RESTORE_IF_DISABLED = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.RESTORE_IF_DISABLED");
    private static String DISABLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.DISABLE");
    private static String ENABLE = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.ENABLE");
    private static String NO_ACTION_DES = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.NO_ACTION_DES");
    private static String DISABLE_ONCE_ONLY_DES = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.DISABLE_ONCE_ONLY_DES");
    private static String DISABLE_ALWAYS_DES = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.DISABLE_ALWAYS_DES");
    private static String RESTORE_IF_DISABLED_DES = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.RESTORE_IF_DISABLED_DES");
    private static String DISABLE_DES = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.DISABLE_DES");
    private static String ENABLE_DES = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.ENABLE_DES");
    private Map<String, Object> selections;
    private Map<String, String> descriptions;
    private WindowsIntegration settings;
    private SecuritySetting securitySetting;
    private JComboBox<String> fw;
    private DescriptionTextArea fwDes;
    private JComboBox<String> fwMsg;
    private DescriptionTextArea fwMsgDes;

    public WindowsSettingPanel() {
        this.initSelections();
        this.initUI();
        this.initActions();
    }

    private void initActions() {
        this.fw.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WindowsSettingPanel.this.fwChanged();
                }
            }
        });
        this.fwMsg.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    WindowsSettingPanel.this.fwMsgChanged();
                }
            }
        });
    }

    private void fwChanged() {
        this.fwDes.setText(this.descriptions.get(this.fw.getSelectedItem()));
    }

    private void fwMsgChanged() {
        this.fwMsgDes.setText(this.descriptions.get(this.fwMsg.getSelectedItem()));
    }

    public void setSecuritySetting(SecuritySetting securitySetting) {
        this.securitySetting = securitySetting;
        this.settings = securitySetting.getOptWindowsIntegration();
        this.setValues();
    }

    private void setValues() {
        Integer sFw;
        if (this.settings == null) {
            this.settings = new WindowsIntegration();
        }
        sFw = (sFw = this.settings.getOptDisableWindowsFW()) != null ? sFw : this.settings.getDefDisableWindowsFW();
        Boolean sFwMsg = this.settings.getOptWindowsFWDisabledMessage();
        sFwMsg = sFwMsg != null ? sFwMsg : this.settings.getDefWindowsFWDisabledMessage();
        int count = 0;
        Set<Map.Entry<String, Object>> entrySet = this.selections.entrySet();
        for (Map.Entry<String, Object> entry : entrySet) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value.equals(sFw)) {
                this.fw.setSelectedItem(key);
                ++count;
            }
            if (value.equals(sFwMsg)) {
                this.fwMsg.setSelectedItem(key);
                ++count;
            }
            if (count != 2) continue;
            break;
        }
    }

    private void initUI() {
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 0));
        this.add(this.getFirewallPanel());
    }

    private void initSelections() {
        this.selections = new HashMap<String, Object>();
        this.selections.put(NO_ACTION, WindowsIntegration.NO_ACTION);
        this.selections.put(DISABLE_ONCE_ONLY, WindowsIntegration.DISABLE_ONCE_ONLY);
        this.selections.put(DISABLE_ALWAYS, WindowsIntegration.DISABLE_ALWAYS);
        this.selections.put(RESTORE_IF_DISABLED, WindowsIntegration.RESTORE_IF_DISABLED);
        this.selections.put(ENABLE, true);
        this.selections.put(DISABLE, false);
        this.descriptions = new HashMap<String, String>();
        this.descriptions.put(NO_ACTION, NO_ACTION_DES);
        this.descriptions.put(DISABLE_ONCE_ONLY, DISABLE_ONCE_ONLY_DES);
        this.descriptions.put(DISABLE_ALWAYS, DISABLE_ALWAYS_DES);
        this.descriptions.put(RESTORE_IF_DISABLED, RESTORE_IF_DISABLED_DES);
        this.descriptions.put(ENABLE, ENABLE_DES);
        this.descriptions.put(DISABLE, DISABLE_DES);
    }

    private JPanel getFirewallPanel() {
        JPanel firewallPanel = new JPanel(new GridBagLayout());
        firewallPanel.add((Component)new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.firewall"), null, false), new GridBagConstraints(0, 0, 3, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
        HtmlEnabledJLabel label = new HtmlEnabledJLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.DETAILED_DESCRIPTION"));
        firewallPanel.add((Component)label, new GridBagConstraints(0, 1, 3, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 20, 0), 0, 0));
        String[] sfw = new String[]{NO_ACTION, DISABLE_ONCE_ONLY, DISABLE_ALWAYS, RESTORE_IF_DISABLED};
        label = new HtmlEnabledJLabel("<html><b>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.firewall_disable") + ":</b></html>");
        this.fw = new JComboBox<String>(sfw);
        this.fwDes = new DescriptionTextArea(NO_ACTION_DES, 2, 40);
        firewallPanel.add((Component)label, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 20, 0, 0), 0, 0));
        firewallPanel.add(this.fw, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 0, 0, 20), 0, 0));
        firewallPanel.add((Component)this.fwDes, new GridBagConstraints(0, 4, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        String[] sfwMsg = new String[]{ENABLE, DISABLE};
        label = new HtmlEnabledJLabel("<html><b>" + MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "WindowsSettingPanel.firewall_disable_msg") + ":</b></html>");
        this.fwMsg = new JComboBox<String>(sfwMsg);
        this.fwMsgDes = new DescriptionTextArea(ENABLE_DES, 2, 40);
        firewallPanel.add((Component)label, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(15, 20, 0, 0), 0, 0));
        firewallPanel.add(this.fwMsg, new GridBagConstraints(1, 5, 1, 1, 0.0, 0.0, 17, 1, new Insets(15, 0, 0, 20), 0, 0));
        firewallPanel.add((Component)this.fwMsgDes, new GridBagConstraints(0, 6, 3, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        return firewallPanel;
    }

    public void updateSettings() {
        if (this.settings == null) {
            this.settings = new WindowsIntegration();
        }
        this.settings.setOptDisableWindowsFW((Integer)this.selections.get(this.fw.getSelectedItem()));
        this.settings.setOptWindowsFWDisabledMessage((Boolean)this.selections.get(this.fwMsg.getSelectedItem()));
        if (!LicenseObject.getInstance().isSBProduct()) {
            this.securitySetting.setOptWindowsIntegration(this.settings);
        }
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_windows_settings";
    }
}

