/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.configobject.schema.FwNetbiosProtection;
import com.sygate.scm.common.configobject.schema.FwReverseDNS;
import com.sygate.scm.common.configobject.schema.FwSmartArp;
import com.sygate.scm.common.configobject.schema.FwSmartDhcp;
import com.sygate.scm.common.configobject.schema.FwSmartDns;
import com.sygate.scm.common.configobject.schema.FwSmartSmcTraffic;
import com.sygate.scm.common.configobject.schema.FwSmartWins;
import com.sygate.scm.common.configobject.schema.FwTokenRingTraffic;
import com.sygate.scm.common.configobject.schema.SecuritySetting;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.ActionConfirmationDlg;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SmartTrafficFilterPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JCheckBox jCbxDhcp = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.checkbox.EnableSmartDHCP"));
    private JCheckBox jCbxDns = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.checkbox.EnableSmartDNS"));
    private JCheckBox jCbxArp = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.checkbox.EnableSmartARP"));
    private JCheckBox jCbxWins = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.checkbox.EnableSmartWINS"));
    private JLabel jLArp = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.label.Caution"));
    private JCheckBox jCbxNetBios = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.checkbox.EnableNetbiosProtection"));
    private JCheckBox jCbxTokenRing = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.checkbox.AllowTokenRingPackets"), true);
    private JCheckBox jCbxDnsLook = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.checkbox.EnableDNSReverseLookup"));
    private SecuritySetting securitySetting;
    private FwSmartDhcp fwSamrtDhcp;
    private FwSmartDns fwSmartDns;
    private FwSmartArp fwSmartArp;
    private FwSmartWins fwSmartWins;
    private FwSmartSmcTraffic fwSmartSmcTraffic;
    private FwNetbiosProtection fwNetbios;
    private FwReverseDNS reverseDns;
    private FwTokenRingTraffic fwTokenRingTraffic;

    public SmartTrafficFilterPanel() {
        this.initialize();
    }

    public void updateSecuritySettings() {
        if (this.fwSamrtDhcp == null) {
            this.fwSamrtDhcp = new FwSmartDhcp();
        }
        this.fwSamrtDhcp.setOptEnable(Boolean.valueOf(this.jCbxDhcp.isSelected()));
        this.securitySetting.setOptFwSmartDhcp(this.fwSamrtDhcp);
        if (this.fwSmartDns == null) {
            this.fwSmartDns = new FwSmartDns();
        }
        this.fwSmartDns.setOptEnable(Boolean.valueOf(this.jCbxDns.isSelected()));
        this.securitySetting.setOptFwSmartDns(this.fwSmartDns);
        if (this.fwSmartArp == null) {
            this.fwSmartArp = new FwSmartArp();
        }
        this.fwSmartArp.setOptEnable(Boolean.valueOf(this.jCbxArp.isSelected()));
        this.securitySetting.setOptFwSmartArp(this.fwSmartArp);
        if (this.fwSmartWins == null) {
            this.fwSmartWins = new FwSmartWins();
        }
        this.fwSmartWins.setOptEnable(Boolean.valueOf(this.jCbxWins.isSelected()));
        this.securitySetting.setOptFwSmartWins(this.fwSmartWins);
        if (this.fwSmartSmcTraffic == null) {
            this.fwSmartSmcTraffic = new FwSmartSmcTraffic();
        }
        this.fwSmartSmcTraffic.setOptEnable(Boolean.valueOf(true));
        this.securitySetting.setOptFwSmartSmcTraffic(this.fwSmartSmcTraffic);
        if (this.fwNetbios == null) {
            this.fwNetbios = new FwNetbiosProtection();
        }
        this.securitySetting.setOptFwNetbiosProtection(this.fwNetbios);
        this.fwNetbios.setOptEnable(Boolean.valueOf(this.jCbxNetBios.isSelected()));
        if (this.reverseDns == null) {
            this.reverseDns = new FwReverseDNS();
        }
        this.securitySetting.setOptFwReverseDNS(this.reverseDns);
        this.reverseDns.setOptEnable(Boolean.valueOf(this.jCbxDnsLook.isSelected()));
        this.fwTokenRingTraffic = new FwTokenRingTraffic();
        this.fwTokenRingTraffic.setAction(FwTokenRingTraffic.PASS);
        this.fwTokenRingTraffic.setOptEnable(Boolean.valueOf(this.jCbxTokenRing.isSelected()));
        this.securitySetting.setOptFwTokenRingTraffic(this.fwTokenRingTraffic);
    }

    private void initialize() {
        UIFontUtilities.setBoldFont((JComponent)this.jCbxDhcp);
        UIFontUtilities.setBoldFont((JComponent)this.jCbxDns);
        UIFontUtilities.setBoldFont((JComponent)this.jCbxArp);
        UIFontUtilities.setBoldFont((JComponent)this.jCbxWins);
        UIFontUtilities.setBoldFont((JComponent)this.jCbxNetBios);
        UIFontUtilities.setBoldFont((JComponent)this.jCbxTokenRing);
        UIFontUtilities.setBoldFont((JComponent)this.jCbxDnsLook);
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(0, 25, 5, 0));
        this.add(this.getInnerPanel());
        this.add(this.getOtherSettingPanel());
    }

    private JPanel getInnerPanel() {
        this.jLArp.setForeground(Color.RED);
        this.jLArp.setFont(UIFontUtilities.SUBTITLE_FONT);
        this.jCbxArp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SmartTrafficFilterPanel.this.arpChanged();
            }
        });
        String dnsInfo = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.DNSDescription");
        String winDescription = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.WINSDescription");
        String tokenRingInfo = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.InfoTokenRing");
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.title.AllowedTrafficProtocols"), null, false), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxDhcp, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.DHCPDescription"), 2, 40), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        panel.add((Component)this.jCbxDns, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)new DescriptionTextArea(dnsInfo, 2, 40), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        panel.add((Component)this.jCbxWins, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)new DescriptionTextArea(winDescription, 2, 40), new GridBagConstraints(0, 6, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        panel.add((Component)this.jCbxTokenRing, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)new DescriptionTextArea(tokenRingInfo, 2, 40), new GridBagConstraints(0, 8, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        return panel;
    }

    private JPanel getOtherSettingPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        String netBiosInfo = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.InfoAgentNetbios");
        String dnsLokokUpInfo = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.InfoDisableDNSLookup");
        panel.add((Component)new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.title.OtherSettings"), null, false), new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxNetBios, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 20), 0, 0));
        panel.add((Component)new DescriptionTextArea(netBiosInfo, 2, 40), new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        panel.add((Component)this.jCbxDnsLook, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 20, 0, 20), 0, 0));
        panel.add((Component)new DescriptionTextArea(dnsLokokUpInfo, 1, 40), new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        return panel;
    }

    private void setValues() {
        this.fwSamrtDhcp = this.securitySetting.getOptFwSmartDhcp();
        this.fwSmartDns = this.securitySetting.getOptFwSmartDns();
        this.fwSmartArp = this.securitySetting.getOptFwSmartArp();
        this.fwSmartWins = this.securitySetting.getOptFwSmartWins();
        this.fwSmartSmcTraffic = this.securitySetting.getOptFwSmartSmcTraffic();
        this.fwNetbios = this.securitySetting.getOptFwNetbiosProtection();
        this.reverseDns = this.securitySetting.getOptFwReverseDNS();
        this.fwTokenRingTraffic = this.securitySetting.getOptFwTokenRingTraffic();
        this.jCbxDhcp.setSelected(this.fwSamrtDhcp == null ? false : (this.fwSamrtDhcp.getOptEnable() == null ? this.fwSamrtDhcp.getDefEnable().booleanValue() : this.fwSamrtDhcp.getOptEnable().booleanValue()));
        this.jCbxDns.setSelected(this.fwSmartDns == null ? false : (this.fwSmartDns.getOptEnable() == null ? this.fwSmartDns.getDefEnable().booleanValue() : this.fwSmartDns.getOptEnable().booleanValue()));
        this.jCbxArp.setSelected(this.fwSmartArp == null ? false : (this.fwSmartArp.getOptEnable() == null ? this.fwSmartArp.getDefEnable().booleanValue() : this.fwSmartArp.getOptEnable().booleanValue()));
        this.jCbxWins.setSelected(this.fwSmartWins == null ? false : (this.fwSmartWins.getOptEnable() == null ? this.fwSmartWins.getDefEnable().booleanValue() : this.fwSmartWins.getOptEnable().booleanValue()));
        this.jCbxTokenRing.setSelected(this.fwTokenRingTraffic == null ? false : (this.fwTokenRingTraffic.getOptEnable() == null ? this.fwTokenRingTraffic.getDefEnable().booleanValue() : this.fwTokenRingTraffic.getOptEnable().booleanValue()));
        this.jCbxDnsLook.setSelected(this.reverseDns == null ? false : (this.reverseDns.getOptEnable() == null ? this.reverseDns.getDefEnable().booleanValue() : this.reverseDns.getOptEnable().booleanValue()));
        this.jCbxNetBios.setSelected(this.fwNetbios == null ? false : (this.fwNetbios.getOptEnable() == null ? this.fwNetbios.getDefEnable().booleanValue() : this.fwNetbios.getOptEnable().booleanValue()));
    }

    private void arpChanged() {
        ActionConfirmationDlg dlg;
        if (!this.jCbxArp.isSelected() && !(dlg = new ActionConfirmationDlg(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.ConfirmDisableSmartARP"), "", 2)).isOk()) {
            this.jCbxArp.setSelected(true);
        }
    }

    public void setSecuritySetting(SecuritySetting securitySetting) {
        this.securitySetting = securitySetting;
        this.setValues();
    }

    public void setReadOnly() {
        this.jCbxDhcp.setEnabled(false);
        this.jCbxDns.setEnabled(false);
        this.jCbxWins.setEnabled(false);
        this.jCbxArp.setEnabled(false);
        this.jCbxNetBios.setEnabled(false);
        this.jCbxTokenRing.setEnabled(false);
        this.jCbxDnsLook.setEnabled(false);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_smart_traffic_filter";
    }
}

