/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulesTableModel;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class RuleNameCellEditor
extends DefaultCellEditor
implements TableCellEditor {
    private static final long serialVersionUID = 1L;
    private JTable currentTable;
    private int currentRow;
    private FirewallRulesTableModel currentModel;

    public RuleNameCellEditor(JTextField ruleNameTextField) {
        super(ruleNameTextField);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentRow = row;
        this.currentTable = table;
        this.currentModel = (FirewallRulesTableModel)table.getModel();
        JComponent component = (JComponent)super.getTableCellEditorComponent(table, value, isSelected, row, column);
        component.setBorder(BorderFactory.createEmptyBorder());
        return component;
    }

    @Override
    public boolean stopCellEditing() {
        if (((String)this.getCellEditorValue()).trim().length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "RuleNameCellEditor.ErrorRuleNameEmpty"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "RuleNameCellEditor.title.Warning"), 2);
            return false;
        }
        if (this.isRuleNameExists((String)this.getCellEditorValue())) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "RuleNameCellEditor.ErrorRuleNameAlreadyInUse"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "RuleNameCellEditor.title.Warning"), 2);
            return false;
        }
        return super.stopCellEditing();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        if (!(anEvent instanceof MouseEvent)) {
            return false;
        }
        return super.isCellEditable(anEvent);
    }

    private boolean isRuleNameExists(String name) {
        return this.currentTable == null ? false : this.currentModel.isNameExisting(name, this.currentRow);
    }
}

