/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.firewall.Port;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.util.BadFormatException;
import com.sygate.scm.util.IntegerRange;
import com.sygate.scm.util.LoggerUtilities;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;

public class PortNumberFactory {
    static Pattern PROTOCOL_PATTERN1 = Pattern.compile("(\\d{1,3})");
    static Pattern PROTOCOL_PATTERN2 = Pattern.compile("\\\"(\\d{1,3})\\\"");
    static Pattern PROTOCOL_PATTERN3 = Pattern.compile("(\\d{1,3})\\-(\\d{1,3})");
    static Pattern PROTOCOL_PATTERN4 = Pattern.compile("\\\"(\\d{1,3})\\-(\\d{1,3})\\\"");
    static Pattern PROTOCOL_PATTERN5 = Pattern.compile("(\\d{1,3})\\,(\\d{1,3})");
    static Pattern PORT_NUMBER_PATTERN1 = Pattern.compile("(\\d{1,100})");
    static Pattern PORT_NUMBER_PATTERN2 = Pattern.compile("\\\"(\\d{1,100})\\\"");
    static Pattern PORT_NUMBER_PATTERN3 = Pattern.compile("(\\d{1,100})\\-(\\d{1,100})");
    static Pattern PORT_NUMBER_PATTERN4 = Pattern.compile("\\\"(\\d{1,100})\\-(\\d{1,100})\\\"");
    static Pattern PORT_NUMBER_PATTERN5 = Pattern.compile("(\\d{1,100})\\,(\\d{1,100})");

    private PortNumberFactory() {
    }

    public static Vector<Port> getUDPPorts() {
        return PortNumberFactory.convertToPortlist(PortConstants.ALL_UDP_PORTS);
    }

    public static Vector<Port> getTCPPorts() {
        return PortNumberFactory.convertToPortlist(PortConstants.ALL_TCP_PORTS);
    }

    public static Vector<Port> getIPPorts() {
        return PortNumberFactory.convertToPortlist(PortConstants.ALL_IP_PORTS);
    }

    public static Vector<Port> getEthernetPorts() {
        return PortNumberFactory.convertToPortlist(PortConstants.ALL_ETHERNET_PORTS);
    }

    public static Vector<Port> getICMPTypes() throws IOException {
        return PortNumberFactory.convertToPortlist(PortConstants.ALL_ICMP_PORTS);
    }

    public static Vector<Port> getICMPv6Types() throws IOException {
        return PortNumberFactory.convertToPortlist(PortConstants.ALL_ICMPv6_PORTS);
    }

    private static Vector<Port> convertToPortlist(Map<String, String> list) {
        Vector<Port> vec = new Vector<Port>();
        if (list != null) {
            list.entrySet().forEach(e -> {
                String key = (String)e.getKey();
                String value = (String)e.getValue();
                Port port = new Port(key, PortNumberFactory.formatPortName(value, key));
                vec.add(port);
            });
        }
        return vec;
    }

    public static String getPortSelectionString(Vector<Port> ports) {
        TreeSet<Port> set = new TreeSet<Port>();
        for (int i = 0; i < ports.size(); ++i) {
            set.add(ports.get(i));
        }
        for (Port port : set) {
            System.out.println(port.getNumber());
        }
        return null;
    }

    public static Vector<Port> getPortsForString(String portsString) {
        Vector<Port> ports = new Vector<Port>();
        if (portsString == null) {
            return ports;
        }
        StringTokenizer st = new StringTokenizer(portsString, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (token.contains("-")) continue;
            Port port = new Port(token, PortNumberFactory.formatPortName(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PortNumberFactory.NamePrefixForUserDefinedCustomPort"), token));
            ports.add(port);
        }
        return ports;
    }

    public static boolean isValidProtocolString(String ipProtocol, StringBuilder valueHolder, int maxValue) {
        if (ipProtocol == null || ipProtocol.trim().length() == 0) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(ipProtocol, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (PortNumberFactory.isValidProtocolToken(token, valueHolder, maxValue)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidProtocolToken(String token, StringBuilder valueHolder, int maxValue) {
        valueHolder.delete(0, valueHolder.length()).append(token);
        if (PROTOCOL_PATTERN1.matcher(token).matches()) {
            return PortNumberFactory.isValidToken(Integer.parseInt(token), maxValue);
        }
        if (PROTOCOL_PATTERN2.matcher(token).matches()) {
            String newToken = token.replaceAll("\"", "");
            return PortNumberFactory.isValidToken(Integer.parseInt(newToken), maxValue);
        }
        if (PROTOCOL_PATTERN3.matcher(token).matches()) {
            return PortNumberFactory.isValidMultiToken(token, "-", maxValue);
        }
        if (PROTOCOL_PATTERN4.matcher(token).matches()) {
            String newToken = token.replaceAll("\"", "");
            return PortNumberFactory.isValidMultiToken(newToken, "-", maxValue);
        }
        if (PROTOCOL_PATTERN5.matcher(token).matches()) {
            return PortNumberFactory.isValidMultiToken(token, ",", maxValue);
        }
        return false;
    }

    private static boolean isValidMultiToken(String protocol, String delimiter, int maxValue) {
        StringTokenizer st = new StringTokenizer(protocol, delimiter);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (PortNumberFactory.isValidToken(Integer.parseInt(token), maxValue)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidToken(int tokenValue, int maxValue) {
        return tokenValue >= 0 && tokenValue <= maxValue;
    }

    public static boolean isValidPortString(String portString) throws BadFormatException {
        StringTokenizer st = new StringTokenizer(portString, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            PortNumberFactory.isValidPortToken(token);
        }
        return true;
    }

    private static boolean isValidPortToken(String token) throws BadFormatException {
        IntegerRange item = IntegerRange.parseRange((String)token, (int)10);
        if (item == null || item.getMin() > 65535 || item.getMax() > 65535 || item.getMax() < 0) {
            throw new BadFormatException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PortNumberFactory.ErrorUserChoseInvalidPortNumber"));
        }
        if (item.getMin() != item.getMax()) {
            int index = token.indexOf("-");
            String min = token.substring(0, index).trim();
            String max = token.substring(index + "-".length()).trim();
            try {
                int iMin = Integer.parseInt(min);
                int iMax = Integer.parseInt(max);
                if (iMin > iMax) {
                    throw new BadFormatException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PortNumberFactory.PortNameFormat.ErrorUserInputInvalidPortRange"));
                }
            }
            catch (NumberFormatException e) {
                LoggerUtilities.logException((Throwable)e);
            }
        }
        return true;
    }

    private static String formatPortName(String value, String key) {
        Object name = null;
        try {
            name = MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PortNumberFactory.PortNameFormat.NameAndNumber"), value, key);
        }
        catch (Exception ex) {
            System.out.println("Error creating port name: " + ex.getMessage());
            name = value + " (" + key + ")";
        }
        return name;
    }

    private static class PortConstants {
        static final Map<String, String> ALL_UDP_PORTS = Map.ofEntries(Map.entry("15", "NETSTAT"), Map.entry("53", "DOMAIN"), Map.entry("69", "TFTP"), Map.entry("137", "NETBIOS-NS"), Map.entry("138", "NETBIOS-DGM"), Map.entry("161", "SNMP"));
        static final Map<String, String> ALL_TCP_PORTS = Map.ofEntries(Map.entry("7", "ECHO "), Map.entry("18", "Message Send Protocol (MSP) "), Map.entry("20", "FTP -- Data"), Map.entry("21", "FTP -- Control"), Map.entry("22", "SSH Remote Login Protocol"), Map.entry("23", "Telnet"), Map.entry("25", "Simple Mail Transfer Protocol (SMTP)"), Map.entry("29", "MSG ICP"), Map.entry("37", "Time"), Map.entry("42", "Host Name Server (Namesrv)"), Map.entry("43", "WhoIs"), Map.entry("49", "Login Host Protocol (Login)"), Map.entry("53", "Domain Name System (DNS)"), Map.entry("69", "Trivial File Transfer Protocol (TFTP)"), Map.entry("70", "Gopher Services"), Map.entry("79", "Finger"), Map.entry("80", "HTTP"), Map.entry("103", "X.400 Standard"), Map.entry("108", "SNA Gateway Access Server"), Map.entry("109", "POP2"), Map.entry("110", "POP3"), Map.entry("115", "Simple File Transfer Protocol (SFTP)"), Map.entry("118", "SQL Services"), Map.entry("119", "Newsgroup (NNTP)"), Map.entry("137", "NetBIOS Name Service"), Map.entry("139", "NetBIOS Datagram Service"), Map.entry("143", "Interim Mail Access Protocol"), Map.entry("150", "NetBIOS Session Service"), Map.entry("156", "SQL Server"), Map.entry("161", "SNMP"), Map.entry("179", "Border Gateway Protocol (BGP)"), Map.entry("190", "Gateway Access Control Protocol (GACP)"), Map.entry("194", "Internet Relay Chat (IRC)"), Map.entry("197", "Directory Location Service (DLS)"), Map.entry("389", "Lightweight Directory Access Protocol (LDAP)"), Map.entry("396", "Novell Netware over IP"), Map.entry("443", "HTTPS"), Map.entry("444", "Simple Network Paging Protocol (SNPP)"), Map.entry("445", "Microsoft-DS"), Map.entry("458", "Apple QuickTime"), Map.entry("546", "DHCP Client"), Map.entry("547", "DHCP Server"), Map.entry("563", "SNEWS"), Map.entry("569", "MSN"), Map.entry("1080", "Socks"));
        static final Map<String, String> ALL_IP_PORTS = Map.ofEntries(Map.entry("0", "HOPOPT "), Map.entry("1", "ICMP "), Map.entry("2", "IGMP "), Map.entry("3", "GGP "), Map.entry("4", "IP "), Map.entry("5", "ST "), Map.entry("6", "TCP "), Map.entry("7", "CBT "), Map.entry("8", "EGP "), Map.entry("9", "IGP "), Map.entry("10", "BBN-RCC-MON "), Map.entry("11", "NVP-II "), Map.entry("12", "PUP "), Map.entry("13", "ARGUS "), Map.entry("14", "EMCON "), Map.entry("15", "XNET "), Map.entry("16", "CHAOS "), Map.entry("17", "UDP "), Map.entry("18", "MUX "), Map.entry("19", "DCN-MEAS "), Map.entry("20", "HMP  "), Map.entry("21", "PRM "), Map.entry("22", "XNS-IDP "), Map.entry("23", "TRUNK-1 "), Map.entry("24", "TRUNK-2 "), Map.entry("25", "LEAF-1 "), Map.entry("26", "LEAF-2 "), Map.entry("27", "RDP "), Map.entry("28", "IRTP "), Map.entry("29", "ISO-TP4 "), Map.entry("30", "NETBLT "), Map.entry("31", "MFE-NSP "), Map.entry("32", "MERIT-INP "), Map.entry("33", "SEP "), Map.entry("34", "3PC "), Map.entry("35", "IDPR "), Map.entry("36", "XTP "), Map.entry("37", "DDP "), Map.entry("38", "IDPR-CMTP "), Map.entry("39", "TP++ "), Map.entry("40", "IL "), Map.entry("41", "IPv6 "), Map.entry("42", "SDRP "), Map.entry("43", "IPv6-Route "), Map.entry("44", "IPv6-Frag "), Map.entry("45", "IDRP "), Map.entry("46", "RSVP "), Map.entry("47", "GRE "), Map.entry("48", "MHRP "), Map.entry("49", "BNA "), Map.entry("50", "ESP "), Map.entry("51", "AH "), Map.entry("52", "I-NLSP "), Map.entry("53", "SWIPE "), Map.entry("54", "NARP "), Map.entry("55", "MOBILE "), Map.entry("56", "TLSP "), Map.entry("57", "SKIP "), Map.entry("58", "IPv6-ICMP "), Map.entry("59", "IPv6-NoNxt "), Map.entry("60", "IPv6-Opts "), Map.entry("62", "CFTP "), Map.entry("64", "SAT-EXPAK "), Map.entry("65", "KRYPTOLAN "), Map.entry("66", "RVD "), Map.entry("67", "IPPC "), Map.entry("69", "SAT-MON "), Map.entry("70", "VISA "), Map.entry("71", "IPCV "), Map.entry("72", "CPNX "), Map.entry("73", "CPHB "), Map.entry("74", "WSN "), Map.entry("75", "PVP "), Map.entry("76", "BR-SAT-MON "), Map.entry("77", "SUN-ND "), Map.entry("78", "WB-MON "), Map.entry("79", "WB-EXPAK "), Map.entry("80", "ISO-IP "), Map.entry("81", "VMTP "), Map.entry("82", "SECURE-VMTP "), Map.entry("83", "VINES "), Map.entry("84", "TTP "), Map.entry("85", "NSFNET-IGP "), Map.entry("86", "DGP "), Map.entry("87", "TCF "), Map.entry("88", "EIGRP "), Map.entry("89", "OSPFIGP "), Map.entry("90", "Sprite-RPC "), Map.entry("91", "LARP "), Map.entry("92", "MTP "), Map.entry("93", "AX.25 "), Map.entry("94", "IPIP "), Map.entry("95", "MICP "), Map.entry("96", "SCC-SP "), Map.entry("97", "ETHERIP "), Map.entry("98", "ENCAP "), Map.entry("100", "GMTP "), Map.entry("101", "IFMP "), Map.entry("102", "PNNI "), Map.entry("103", "PIM "), Map.entry("104", "ARIS "), Map.entry("105", "SCPS "), Map.entry("106", "QNX "), Map.entry("107", "A/N "), Map.entry("108", "IPComp "), Map.entry("109", "SNP "), Map.entry("110", "Compaq-Peer "), Map.entry("111", "IPX-in-IP "), Map.entry("112", "VRRP "), Map.entry("113", "PG "), Map.entry("115", "L2TP "), Map.entry("116", "DDX "), Map.entry("117", "IATP "), Map.entry("118", "STP "), Map.entry("119", "SRP "), Map.entry("120", "UTI "), Map.entry("121", "SMP "), Map.entry("122", "SM "), Map.entry("123", "PTP "), Map.entry("124", "ISIS "), Map.entry("125", "FIRE "), Map.entry("126", "CRTP "), Map.entry("127", "CRUDP "), Map.entry("128", "SSCOPMCE "), Map.entry("129", "IPLT "), Map.entry("130", "SPS "), Map.entry("131", "PIPE "), Map.entry("132", "SCTP "), Map.entry("133", "FC"), Map.entry("134", "RSVP-E2E-IGNORE"), Map.entry("135", "Mobility Header"), Map.entry("136", "UDPLite"));
        static final Map<String, String> ALL_ICMP_PORTS = Map.ofEntries(Map.entry("0", "Echo Reply "), Map.entry("3", "Destination Unreachable "), Map.entry("4", "Source Quench "), Map.entry("5", "Redirect "), Map.entry("6", "Alternate Host Address"), Map.entry("8", "Echo Request "), Map.entry("9", "Router Advertisement "), Map.entry("10", "Router Selection "), Map.entry("11", "Time Exceeded for Datagram "), Map.entry("12", "Parameter Problem on Datagram "), Map.entry("13", "Timestamp Request "), Map.entry("14", "Timestamp Reply "), Map.entry("15", "Information Request "), Map.entry("16", "Information Reply "), Map.entry("17", "Address Mask Request "), Map.entry("18", "Address Mask Reply"), Map.entry("30", "Traceroute"), Map.entry("31", "Datagram Conversion Error"), Map.entry("32", "Mobile Host Redirect"), Map.entry("33", "IPv6 Where-Are-You"), Map.entry("34", "IPv6 I-Am-Here"), Map.entry("35", "Mobile Registration Request"), Map.entry("36", "Mobile Registration Reply"), Map.entry("37", "Domain Name Request"), Map.entry("38", "Domain Name Reply"), Map.entry("39", "SKIP"), Map.entry("40", "Photuris"));
        static final Map<String, String> ALL_ICMPv6_PORTS = Map.ofEntries(Map.entry("1", "Destination Unreachable "), Map.entry("2", "Packet Too Big "), Map.entry("3", "Time Exceeded "), Map.entry("4", "Parameter Problem "), Map.entry("128", "Echo Request "), Map.entry("129", "Echo Reply "), Map.entry("130", "Multicast Listener Query "), Map.entry("131", "Multicast Listener Report "), Map.entry("132", "Multicast Listener Done "), Map.entry("141", "Inverse Neighbor Discovery Solicitation Message "), Map.entry("142", "Inverse Neighbor Discovery Advertisement Message "), Map.entry("143", "Multicast Listener Discovery (MLDv2) reports "), Map.entry("151", "Multicast Router Advertisement (MRD) "), Map.entry("152", "Multicast Router Solicitation (MRD)) "), Map.entry("153", "Multicast Router Termination (MRD) "));
        static final Map<String, String> ALL_ETHERNET_PORTS = Map.ofEntries(Map.entry("0x0842", "Wake-on-LAN Magic Packet, as used by ether-wake and Sleep Proxy Service "), Map.entry("0x1337", "SYN-3 heartbeat protocol (SYNdog) "), Map.entry("0x22F3", "IETF TRILL Protocol "), Map.entry("0x6003", "DECnet Phase IV "), Map.entry("0x6559", "Raw Frame Relay "), Map.entry("0x800", "Internet IP (IPv4) "), Map.entry("0x8035", "Reverse ARP "), Map.entry("0x805", "X.25 Level 3 "), Map.entry("0x806", "ARP "), Map.entry("0x808", "Frame Relay ARP "), Map.entry("0x809B", "AppleTalk "), Map.entry("0x80F3", "AppleTalk ARP "), Map.entry("0x8100", "VLAN-tagged frame (IEEE 802.1Q) & Shortest Path Bridging IEEE 802.1aq[3] "), Map.entry("0x8137", "IPX, Internet Packet eXchange (Novell) "), Map.entry("0x8138", "IPX, Internet Packet eXchange (Novell) "), Map.entry("0x814C", "Simple Network Management Protocol (SNMP)[4] "), Map.entry("0x8204", "QNX Qnet "), Map.entry("0x86dd", "IPv6 "), Map.entry("0x8808", "Ethernet flow control "), Map.entry("0x8809", "Slow Protocols (IEEE 802.3) "), Map.entry("0x880B", "PPP "), Map.entry("0x8819", "CobraNet "), Map.entry("0x8847", "MPLS unicast "), Map.entry("0x8848", "MPLS multicast "), Map.entry("0x8863", "PPPoE Discovery Stage "), Map.entry("0x8864", "PPPoE Session Stage "), Map.entry("0x886F", "Microsoft NLB heartbeat [5] "), Map.entry("0x8870", "Jumbo Frames "), Map.entry("0x887B", "HomePlug 1.0 MME "), Map.entry("0x888E", "EAPOL "), Map.entry("0x8892", "PROFINET Protocol "), Map.entry("0x889A", "HyperSCSI (SCSI over Ethernet) "), Map.entry("0x88A2", "ATA over Ethernet "), Map.entry("0x88A4", "EtherCAT Protocol "), Map.entry("0x88A8", "Provider Bridging (IEEE 802.1ad) & Shortest Path Bridging IEEE 802.1aq[6] "), Map.entry("0x88AB", "Ethernet Powerlink "), Map.entry("0x88CC", "LLDP "), Map.entry("0x88CD", "sercos III "), Map.entry("0x88D8", "Circuit Emulation Services over Ethernet (MEF-8) "), Map.entry("0x88E1", "HomePlug AV MME "), Map.entry("0x88E3", "Media Redundancy Protocol (IEC62439-2) "), Map.entry("0x88E5", "MAC security (IEEE 802.1AE) "), Map.entry("0x88F7", "Precision Time Protocol (IEEE 1588) "), Map.entry("0x8902", "IEEE 802.1ag Connectivity Fault Management (CFM) Protocol / ITU-T Recommendation Y.1731 (OAM) "), Map.entry("0x8906", "Fibre Channel over Ethernet "), Map.entry("0x8914", "FCoE Initialization Protocol "), Map.entry("0x9000", "Configuration Test Protocol (Loop)[7] "), Map.entry("0x9100", "Q-in-Q "), Map.entry("0xCAFE", "Veritas Low Latency Transport (LLT)[8] "), Map.entry("0xF0F0", "NetBEUI "), Map.entry("0xFF", "IPX 802.3 "));

        private PortConstants() {
        }
    }
}

