/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.configobject.ConfigObject;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.FwUnregulatedHosts;
import com.sygate.scm.common.configobject.schema.P2P;
import com.sygate.scm.common.configobject.schema.P2PAuthParameter;
import com.sygate.scm.common.configobject.schema.P2PExceptionList;
import com.sygate.scm.common.configobject.schema.SecuritySetting;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.policy.firewall.dialog.HostGroupDialog;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class PeerToPeerSettingPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private static final String P2PConnection = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.InfoP2PConnectionDescription");
    private static final int MIN_RETRIES = 1;
    private static final int MAX_RETRIES = 10;
    private static final int DEF_RETRIES = 3;
    private static final int MIN_RETRY_INTERVAL = 1;
    private static final int MAX_RETRY_INTERVAL = 10;
    private static final int DEF_RETRY_INTERVAL = 3;
    private static final int MIN_REJECT_TIME = 10;
    private static final int MAX_REJECT_TIME = 300;
    private static final int DEF_REJECT_TIME = 30;
    private static final int MIN_ALLOW_TIME = 10;
    private static final int MAX_ALLOW_TIME = 300;
    private static final int DEF_ALLOW_TIME = 30;
    private static final int MIN_TIMEOUT = 30;
    private static final int MAX_TIMEOUT = 3600;
    private static final int DEF_TIMEOUT = 40;
    private JCheckBox jCbxEnable = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.checkbox.EnableP2PConnection"));
    private JLabel lblAllowTime = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.label.AllowTime"));
    private JLabel lbRejectTime = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.label.BlockTime"));
    private JLabel lblRetry = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.label.NumberofRetries"));
    private JLabel lblRetryInterval = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.label.RetryInterval"));
    private DescriptionTextArea jTATimeOut = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.label.TimeOut"), 1, 2);
    private JTextField jTFRetries = new JTextField(new NumberPlainDocument(10L), "3", 5);
    private JTextField jTFRetryInterval = new JTextField(new NumberPlainDocument(10L), "3", 5);
    private JTextField jTFTimeRejectClient = new JTextField(new NumberPlainDocument(300L), "30", 5);
    private JTextField jTFTimeAllowClient = new JTextField(new NumberPlainDocument(300L), "30", 5);
    private JTextField jTFTimeOut = new JTextField(new NumberPlainDocument(3600L), "40", 5);
    private JCheckBox jCbxExclusiveHosts = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.checkbox.EnableExcludedHosts"));
    private JButton jBExclusiveHosts = new JButton(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.button.ExcludedHosts"));
    private DescriptionTextArea jLExclusiveHosts = new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.ExcludedHostsDescription"), 1, 50);
    private SecuritySetting securitySetting;
    private FwUnregulatedHosts fwUnregulatedHosts;
    private P2PExceptionList p2pExceptionList;

    public PeerToPeerSettingPanel() {
        this.initialize();
    }

    public void updateSecuritySettings() {
        P2P p2p = this.securitySetting.getOptP2P();
        if (p2p == null) {
            p2p = new P2P();
        }
        p2p.setEnableAuthentication(Boolean.valueOf(this.jCbxEnable.isSelected()));
        if (this.jCbxEnable.isSelected()) {
            P2PAuthParameter p2pAuthParameter = p2p.getOptP2PAuthParameter();
            if (p2pAuthParameter == null) {
                p2pAuthParameter = new P2PAuthParameter();
            }
            if (this.jTFTimeAllowClient.getText() != null && this.jTFTimeAllowClient.getText().trim().length() > 0) {
                p2pAuthParameter.setAllowTime(Integer.valueOf(this.jTFTimeAllowClient.getText()));
            }
            if (this.jTFRetries.getText() != null && this.jTFRetries.getText().trim().length() > 0) {
                p2pAuthParameter.setAuthPacket(Integer.valueOf(this.jTFRetries.getText()));
            }
            if (this.jTFRetryInterval.getText() != null && this.jTFRetryInterval.getText().trim().length() > 0) {
                p2pAuthParameter.setPacketInterval(Integer.valueOf(this.jTFRetryInterval.getText()));
            }
            if (this.jTFTimeRejectClient.getText() != null && this.jTFTimeRejectClient.getText().trim().length() > 0) {
                p2pAuthParameter.setRejectTime(Integer.valueOf(this.jTFTimeRejectClient.getText()));
            }
            p2p.setOptP2PAuthParameter(p2pAuthParameter);
            if (this.jTFTimeOut.getText() != null && this.jTFTimeOut.getText().trim().length() > 0) {
                p2p.setOptSessionTimeout(Integer.valueOf(this.jTFTimeOut.getText()));
            }
            if (this.fwUnregulatedHosts != null) {
                this.fwUnregulatedHosts.setOptEnable(Boolean.valueOf(this.jCbxExclusiveHosts.isSelected()));
            }
            if (this.p2pExceptionList != null) {
                p2p.setOptP2PExceptionList(this.p2pExceptionList);
            }
        }
        this.securitySetting.setOptP2P(p2p);
    }

    protected void exclusiveHostChanged() {
        this.jBExclusiveHosts.setEnabled(this.jCbxExclusiveHosts.isEnabled() && this.jCbxExclusiveHosts.isSelected());
    }

    protected void showExclusiveHosts() {
        try {
            FwUnregulatedHosts newHosts;
            FwHostContainer hostContainer;
            if (this.fwUnregulatedHosts == null) {
                this.fwUnregulatedHosts = new FwUnregulatedHosts();
                this.fwUnregulatedHosts.setOptEnable(Boolean.TRUE);
                if (this.p2pExceptionList == null) {
                    this.p2pExceptionList = new P2PExceptionList();
                }
                this.p2pExceptionList.setOptFwUnregulatedHosts(this.fwUnregulatedHosts);
            }
            if ((hostContainer = (newHosts = (FwUnregulatedHosts)PolicyHandler.getCopyOfObj((ConfigObject)this.fwUnregulatedHosts)).getOptFwHostContainer()) == null) {
                hostContainer = new FwHostContainer();
                newHosts.setOptFwHostContainer(hostContainer);
            }
            HostGroupDialog hDialog = new HostGroupDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.title.ExcludedHosts"), true, newHosts, 5);
            hDialog.setVisible(true);
            if (hDialog.isOk()) {
                this.fwUnregulatedHosts = hDialog.getUnregulatedHosts();
                this.p2pExceptionList.setOptFwUnregulatedHosts(this.fwUnregulatedHosts);
            }
        }
        catch (ConsoleException e) {
            LoggerUtilities.logException((Throwable)e);
            JOptionPane.showMessageDialog(Manager.getFrame(), e.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.title.Error"), 0);
            Manager.getFrame().showLoginPanel();
        }
    }

    private void initialize() {
        UIFontUtilities.setBoldFont((JComponent)this.jCbxExclusiveHosts);
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 0));
        this.add((Component)this.getInnerPanel(), "North");
    }

    private JPanel getInnerPanel() {
        this.jTFRetries.setHorizontalAlignment(4);
        this.jTFRetryInterval.setHorizontalAlignment(4);
        this.jTFTimeRejectClient.setHorizontalAlignment(4);
        this.jTFTimeAllowClient.setHorizontalAlignment(4);
        this.jTFTimeOut.setHorizontalAlignment(4);
        Object[] obj1 = new Object[]{1, 10};
        String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.msg.range");
        String fm = MessageFormat.format(str, obj1);
        this.jTFRetries.setToolTipText(fm);
        Object[] obj2 = new Object[]{1, 10};
        fm = MessageFormat.format(str, obj2);
        this.jTFRetryInterval.setToolTipText(fm);
        Object[] obj3 = new Object[]{10, 300};
        fm = MessageFormat.format(str, obj3);
        this.jTFTimeRejectClient.setToolTipText(fm);
        Object[] obj4 = new Object[]{10, 300};
        fm = MessageFormat.format(str, obj4);
        this.jTFTimeAllowClient.setToolTipText(fm);
        Object[] obj5 = new Object[]{30, 3600};
        fm = MessageFormat.format(str, obj5);
        this.jTFTimeOut.setToolTipText(fm);
        this.jCbxEnable.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeerToPeerSettingPanel.this.enableAppropriate();
            }
        });
        this.jCbxExclusiveHosts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeerToPeerSettingPanel.this.exclusiveHostChanged();
            }
        });
        this.jBExclusiveHosts.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PeerToPeerSettingPanel.this.showExclusiveHosts();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        int col = 0;
        panel.add((Component)new DescriptionTextArea(P2PConnection, 2, 40), new GridBagConstraints(0, ++col, 2, 1, 1.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
        panel.add((Component)this.jCbxEnable, new GridBagConstraints(0, ++col, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        panel.add((Component)new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.title.AuthenticationSettings"), null, false), new GridBagConstraints(0, ++col, 2, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.lblRetry, new GridBagConstraints(0, ++col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)this.jTFRetries, new GridBagConstraints(1, col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.lblRetryInterval, new GridBagConstraints(0, ++col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)this.jTFRetryInterval, new GridBagConstraints(1, col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.lblAllowTime, new GridBagConstraints(0, ++col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)this.jTFTimeAllowClient, new GridBagConstraints(1, col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.lbRejectTime, new GridBagConstraints(0, ++col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)this.jTFTimeRejectClient, new GridBagConstraints(1, col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.jTATimeOut, new GridBagConstraints(0, ++col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)this.jTFTimeOut, new GridBagConstraints(1, col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.jCbxExclusiveHosts, new GridBagConstraints(0, ++col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
        panel.add((Component)this.jBExclusiveHosts, new GridBagConstraints(1, col, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
        panel.add((Component)this.jLExclusiveHosts, new GridBagConstraints(0, ++col, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 75), 0, 0));
        ++col;
        this.enableAppropriate();
        return panel;
    }

    private void enableAppropriate() {
        boolean allEnable = this.jCbxEnable.isSelected();
        this.lblAllowTime.setEnabled(allEnable);
        this.jTFTimeAllowClient.setEnabled(allEnable);
        this.lbRejectTime.setEnabled(allEnable);
        this.jTFTimeRejectClient.setEnabled(allEnable);
        this.lblRetry.setEnabled(allEnable);
        this.jTFRetries.setEnabled(allEnable);
        this.lblRetryInterval.setEnabled(allEnable);
        this.jTFRetryInterval.setEnabled(allEnable);
        this.jTATimeOut.setEnabled(allEnable);
        this.jTFTimeOut.setEnabled(allEnable);
        this.jCbxExclusiveHosts.setEnabled(allEnable);
        this.jBExclusiveHosts.setEnabled(allEnable);
        this.jLExclusiveHosts.setEnabled(allEnable);
        this.exclusiveHostChanged();
    }

    private boolean valueInRange(String value, int min, int max) {
        boolean inRange = true;
        int realValue = 0;
        inRange = value == null || value.trim().length() == 0 ? false : (realValue = Integer.parseInt(value)) <= max && realValue >= min;
        return inRange;
    }

    private void setValues() {
        Integer sessionTimeout;
        String tmp = null;
        P2P p2p = this.securitySetting.getOptP2P();
        if (p2p == null) {
            return;
        }
        Boolean enable = p2p.getEnableAuthentication();
        this.jCbxEnable.setSelected(enable);
        P2PAuthParameter p2pAuthParameter = p2p.getOptP2PAuthParameter();
        if (p2pAuthParameter != null) {
            tmp = p2pAuthParameter.getAuthPacket().toString();
            if (this.valueInRange(tmp, 1, 10)) {
                this.jTFRetries.setText(tmp);
            }
            if (this.valueInRange(tmp = p2pAuthParameter.getPacketInterval().toString(), 1, 10)) {
                this.jTFRetryInterval.setText(tmp);
            }
            if (this.valueInRange(tmp = p2pAuthParameter.getRejectTime().toString(), 10, 300)) {
                this.jTFTimeRejectClient.setText(tmp);
            }
            if (this.valueInRange(tmp = p2pAuthParameter.getAllowTime().toString(), 10, 300)) {
                this.jTFTimeAllowClient.setText(tmp);
            }
        }
        if ((sessionTimeout = p2p.getOptSessionTimeout()) == null) {
            sessionTimeout = p2p.getDefSessionTimeout();
        }
        if (this.valueInRange(tmp = sessionTimeout.toString(), 30, 3600)) {
            this.jTFTimeOut.setText(tmp);
        }
        this.p2pExceptionList = p2p.getOptP2PExceptionList();
        if (this.p2pExceptionList != null) {
            this.fwUnregulatedHosts = this.p2pExceptionList.getOptFwUnregulatedHosts();
        }
        this.jCbxExclusiveHosts.setSelected(this.fwUnregulatedHosts != null && !Boolean.FALSE.equals(this.fwUnregulatedHosts.getOptEnable()));
        this.enableAppropriate();
    }

    public void setSecuritySetting(SecuritySetting securitySetting) {
        this.securitySetting = securitySetting;
        this.setValues();
    }

    public void setReadOnly() {
        boolean allEnable = false;
        this.jCbxEnable.setEnabled(allEnable);
        this.lblAllowTime.setEnabled(allEnable);
        this.jTFTimeAllowClient.setEnabled(allEnable);
        this.lbRejectTime.setEnabled(allEnable);
        this.jTFTimeRejectClient.setEnabled(allEnable);
        this.lblRetry.setEnabled(allEnable);
        this.jTFRetries.setEnabled(allEnable);
        this.lblRetryInterval.setEnabled(allEnable);
        this.jTFRetryInterval.setEnabled(allEnable);
        this.jTATimeOut.setEnabled(allEnable);
        this.jTFTimeOut.setEnabled(allEnable);
        this.jCbxExclusiveHosts.setEnabled(allEnable);
        this.jBExclusiveHosts.setEnabled(allEnable);
        this.jLExclusiveHosts.setEnabled(allEnable);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_p2p_settings";
    }

    public boolean isValidate() {
        boolean isValid = true;
        if (this.jCbxEnable.isSelected()) {
            String fm;
            String str;
            Object[] obj;
            if (isValid && !this.valueInRange(this.jTFRetries.getText(), 1, 10)) {
                obj = new Object[]{1, 10};
                str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.msg.MaximumNumberOfPackets");
                fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.msg.error"), 0);
                this.jTFRetries.requestFocusInWindow();
                isValid = false;
            }
            if (isValid && !this.valueInRange(this.jTFRetryInterval.getText(), 1, 10)) {
                obj = new Object[]{1, 10};
                str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.msg.TimeBetweenPacketsInAuthentication");
                fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.msg.error"), 0);
                this.jTFRetryInterval.requestFocusInWindow();
                isValid = false;
            }
            if (isValid && !this.valueInRange(this.jTFTimeRejectClient.getText(), 10, 300)) {
                obj = new Object[]{10, 300};
                str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.msg.TimeRejectedClientWillBeBlocked");
                fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.msg.error"), 0);
                this.jTFTimeRejectClient.requestFocusInWindow();
                isValid = false;
            }
            if (isValid && !this.valueInRange(this.jTFTimeAllowClient.getText(), 10, 300)) {
                obj = new Object[]{10, 300};
                str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.msg.TimeAuthenticatedClient");
                fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.msg.error"), 0);
                this.jTFTimeAllowClient.requestFocusInWindow();
                isValid = false;
            }
            if (isValid && !this.valueInRange(this.jTFTimeOut.getText(), 30, 3600)) {
                obj = new Object[]{30, 3600};
                str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.msg.SessionTimeOut");
                fm = MessageFormat.format(str, obj);
                JOptionPane.showMessageDialog(Manager.getFrame(), fm, MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "PeerToPeerSettingPanel.msg.error"), 0);
                this.jTFTimeOut.requestFocusInWindow();
                isValid = false;
            }
        }
        return isValid;
    }
}

