/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfacePool;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.RecycleBin;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SuspendedItem;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.policy.firewall.logicobject.NetworkInterfaceGroupObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;

public class NetworkInterfaceHandler {
    private static final NetworkInterfaceHandler instance = new NetworkInterfaceHandler();
    private static final String CISCO_AIRONET_DEPRECATED_NT4 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "CiscoAironet340,Windows9x&NT4");
    private static final String CISCO_AIRONET_DEPRECATED_2000 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "CiscoAironet340,Windows2000");
    private static final String NORTEL_CONTIVITY_DEPRECATED_95 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "NortelContivityVPNv3&v4(Windows95)");
    private static final String NORTEL_CONTIVITY_DEPRECATED_2000 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.logicobject.firewalllogicobject", "NortelContivityVPNv3&v4(Windows95,98,ME,NT4,2000)");
    private static final List<String> ALL_DEPRECATED_ADAPTERS = new ArrayList<String>(Arrays.asList(CISCO_AIRONET_DEPRECATED_NT4, CISCO_AIRONET_DEPRECATED_2000, NORTEL_CONTIVITY_DEPRECATED_95, NORTEL_CONTIVITY_DEPRECATED_2000));
    private HashMap<String, NetworkInterfaceGroupObject> existingGroups = new HashMap();
    private HashMap<String, NetworkInterfaceGroupObject> newGroups = new HashMap();
    private HashMap<String, NetworkInterfaceGroupObject> deletedGroups = new HashMap();
    private SemDomain currentDomain;

    private NetworkInterfaceHandler() {
    }

    public void addGroup(NetworkInterfaceGroupObject groupObject) {
        FwNetworkInterfaceGroup group = groupObject.getFwInterfaceGroup();
        this.newGroups.put(group.getId(), groupObject);
    }

    public void deleteGroup(NetworkInterfaceGroupObject groupObject) {
        FwNetworkInterfaceGroup group = groupObject.getFwInterfaceGroup();
        this.existingGroups.remove(group.getId());
        this.newGroups.remove(group.getId());
        this.deletedGroups.put(group.getId(), groupObject);
    }

    public void saveGroups() throws ConsoleException {
        DataobjectManager.UpdateObjectEntry entry;
        ArrayList<DataobjectManager.UpdateObjectEntry> updateList = new ArrayList<DataobjectManager.UpdateObjectEntry>();
        FwNetworkInterfacePool interfacePool = this.currentDomain.getObjectPool().getOptFwNetworkInterfacePool();
        if (interfacePool == null) {
            interfacePool = new FwNetworkInterfacePool();
            this.currentDomain.getObjectPool().setOptFwNetworkInterfacePool(interfacePool);
        }
        for (NetworkInterfaceGroupObject groupObject : this.existingGroups.values()) {
            FwNetworkInterfaceGroup group = groupObject.getFwInterfaceGroup();
            if (!groupObject.isDirty() && !group.isDirty()) continue;
            System.out.println("Updating Groups " + group.getName());
            entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)group, 0);
            updateList.add(entry);
        }
        for (NetworkInterfaceGroupObject groupObject : this.newGroups.values()) {
            FwNetworkInterfaceGroup group = groupObject.getFwInterfaceGroup();
            ObjReference reference = new ObjReference();
            reference.setName(group.getName());
            reference.setTargetId(group.getId());
            reference.setTargetType(group.getObjectTypeName());
            interfacePool.addObjReference(reference);
            System.out.println("Adding Groups " + group.getName());
            DataobjectManager.UpdateObjectEntry entry2 = new DataobjectManager.UpdateObjectEntry((TopLevelObject)group, 1);
            updateList.add(entry2);
        }
        for (NetworkInterfaceGroupObject groupObject : this.deletedGroups.values()) {
            FwNetworkInterfaceGroup group = groupObject.getFwInterfaceGroup();
            Vector allRefereces = interfacePool.getObjReference();
            for (int i = 0; i < allRefereces.size(); ++i) {
                ObjReference ref = (ObjReference)allRefereces.get(i);
                if (ref.getTargetId().equals(group.getId())) {
                    interfacePool.removeObjReference(ref);
                }
                ObjReference objRef = new ObjReference();
                objRef.setTargetId(group.getId());
                objRef.setTargetType(group.getObjectTypeName());
                objRef.setName(group.getName());
                RecycleBin bin = this.currentDomain.getObjectPool().getRecycleBin();
                SuspendedItem suspended = new SuspendedItem();
                suspended.setDeletedTime(Long.valueOf(new Date().getTime()));
                suspended.setOptWhoDeletedIt(DataobjectManager.getInstance().getCurrentAdministrator().getId());
                suspended.setObjReference(objRef);
                bin.addSuspendedItem(suspended);
                updateList.add(new DataobjectManager.UpdateObjectEntry((TopLevelObject)group, 2));
            }
        }
        entry = new DataobjectManager.UpdateObjectEntry((TopLevelObject)this.currentDomain, 0);
        updateList.add(entry);
        if (updateList.size() > 0) {
            DataobjectManager.getInstance().updateObject("Merge", updateList);
        }
        this.newGroups.clear();
        this.existingGroups.clear();
        this.deletedGroups.clear();
    }

    public static NetworkInterfaceHandler getInstance() {
        return instance;
    }

    public ArrayList<NetworkInterfaceGroupObject> getInterfaceGroups() {
        ArrayList<NetworkInterfaceGroupObject> groupsFromDatabase = new ArrayList<NetworkInterfaceGroupObject>();
        try {
            Vector interfaceGroups;
            DataobjectManager data = DataobjectManager.getInstance();
            String domainId = data.getLoginInformation().getOptDomainGUID();
            this.currentDomain = (SemDomain)data.getObjectByGUID("SemDomain", domainId);
            FwNetworkInterfacePool interfacePool = this.currentDomain.getObjectPool().getOptFwNetworkInterfacePool();
            if (interfacePool != null && (interfaceGroups = interfacePool.getObjReference()) != null) {
                int count = interfaceGroups.size();
                for (int i = 0; i < count; ++i) {
                    ObjReference reference = (ObjReference)interfaceGroups.get(i);
                    String targetId = reference.getTargetId();
                    String targetType = reference.getTargetType();
                    TopLevelObject group = DataobjectManager.getInstance().getObjectByGUID(targetType, targetId);
                    NetworkInterfaceGroupObject groupObject = new NetworkInterfaceGroupObject((FwNetworkInterfaceGroup)group);
                    if (ALL_DEPRECATED_ADAPTERS.contains(groupObject.getName())) continue;
                    groupsFromDatabase.add(groupObject);
                    this.existingGroups.put(targetId, groupObject);
                }
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return groupsFromDatabase;
    }

    public ArrayList<NetworkInterfaceGroupObject> getVPNGroups() {
        ArrayList<NetworkInterfaceGroupObject> groupsFromDatabase = new ArrayList<NetworkInterfaceGroupObject>();
        try {
            Vector interfaceGroups;
            DataobjectManager data = DataobjectManager.getInstance();
            String domainId = data.getLoginInformation().getOptDomainGUID();
            this.currentDomain = (SemDomain)data.getObjectByGUID("SemDomain", domainId);
            FwNetworkInterfacePool interfacePool = this.currentDomain.getObjectPool().getOptFwNetworkInterfacePool();
            if (interfacePool != null && (interfaceGroups = interfacePool.getObjReference()) != null) {
                int count = interfaceGroups.size();
                for (int i = 0; i < count; ++i) {
                    NetworkInterfaceGroupObject groupObject;
                    ObjReference reference = (ObjReference)interfaceGroups.get(i);
                    String targetId = reference.getTargetId();
                    String targetType = reference.getTargetType();
                    TopLevelObject group = DataobjectManager.getInstance().getObjectByGUID(targetType, targetId);
                    FwNetworkInterfaceGroup fwNICGroup = (FwNetworkInterfaceGroup)group;
                    Long objAttr = fwNICGroup.getOptObjAttributes();
                    if (objAttr != null && objAttr == 1L || ALL_DEPRECATED_ADAPTERS.contains((groupObject = new NetworkInterfaceGroupObject((FwNetworkInterfaceGroup)group)).getName())) continue;
                    groupsFromDatabase.add(groupObject);
                    this.existingGroups.put(targetId, groupObject);
                }
            }
        }
        catch (ConsoleException ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return groupsFromDatabase;
    }
}

