/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.configobject.schema.FwSmartDhcp;
import com.sygate.scm.common.configobject.schema.FwSmartDns;
import com.sygate.scm.common.configobject.schema.SecuritySetting;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.ui.policy.av.common.AvTemplatePane;
import com.sygate.scm.console.ui.util.DescriptionTextArea;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MacSmartTrafficFilterPanel
extends JPanel
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = 1L;
    private JCheckBox jcbxDhcp = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.checkbox.EnableSmartDHCP"));
    private JCheckBox jcbxDns = new JCheckBox(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.checkbox.EnableSmartDNS"));
    private SecuritySetting securitySetting;
    private FwSmartDhcp fwSamrtDhcp;
    private FwSmartDns fwSmartDns;

    public MacSmartTrafficFilterPanel() {
        this.initialize();
    }

    private void initialize() {
        UIFontUtilities.setBoldFont((JComponent)this.jcbxDhcp);
        UIFontUtilities.setBoldFont((JComponent)this.jcbxDns);
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(0, 25, 5, 0));
        this.add(this.getInnerPanel());
    }

    private JPanel getInnerPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add((Component)new AvTemplatePane(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.title.AllowedTrafficProtocols"), null, false), new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 17, 2, new Insets(15, 0, 0, 0), 0, 0));
        panel.add((Component)this.jcbxDhcp, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 20, 0, 0), 0, 0));
        panel.add((Component)new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.DHCPDescription"), 2, 40), new GridBagConstraints(0, 2, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        panel.add((Component)this.jcbxDns, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 0, 0), 0, 0));
        panel.add((Component)new DescriptionTextArea(MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "SmartTrafficFilterPanel.DNSDescription"), 2, 40), new GridBagConstraints(0, 4, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 42, 0, 20), 0, 0));
        return panel;
    }

    public void setSecuritySetting(SecuritySetting securitySetting) {
        this.securitySetting = securitySetting;
        this.setValues();
    }

    private void setValues() {
        this.fwSamrtDhcp = this.securitySetting.getOptFwSmartDhcp();
        this.fwSmartDns = this.securitySetting.getOptFwSmartDns();
        this.jcbxDhcp.setSelected(this.fwSamrtDhcp == null ? false : (this.fwSamrtDhcp.getOptEnable() == null ? this.fwSamrtDhcp.getDefEnable().booleanValue() : this.fwSamrtDhcp.getOptEnable().booleanValue()));
        this.jcbxDns.setSelected(this.fwSmartDns == null ? false : (this.fwSmartDns.getOptEnable() == null ? this.fwSmartDns.getDefEnable().booleanValue() : this.fwSmartDns.getOptEnable().booleanValue()));
    }

    public void setReadOnly() {
        this.jcbxDhcp.setEnabled(false);
        this.jcbxDns.setEnabled(false);
    }

    public void updateSecuritySettings() {
        if (this.fwSamrtDhcp == null) {
            this.fwSamrtDhcp = new FwSmartDhcp();
        }
        this.fwSamrtDhcp.setOptEnable(Boolean.valueOf(this.jcbxDhcp.isSelected()));
        this.securitySetting.setOptFwSmartDhcp(this.fwSamrtDhcp);
        if (this.fwSmartDns == null) {
            this.fwSmartDns = new FwSmartDns();
        }
        this.fwSmartDns.setOptEnable(Boolean.valueOf(this.jcbxDns.isSelected()));
        this.securitySetting.setOptFwSmartDns(this.fwSmartDns);
    }

    @Override
    public String getContentSensitiveHelpToken() {
        return "sesm_policies_dialog_fw_rules_smart_traffic_filter";
    }
}

