/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.MacFwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.SecuritySetting;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.ui.policy.firewall.FirewallRulePanel;
import com.sygate.scm.console.ui.policy.firewall.Handler.FirewallPolicyHandler;

public class MacFirewallRulePanel
extends FirewallRulePanel {
    private static final long serialVersionUID = 1L;
    private static final float[] enterpriseColSizes = new float[]{0.02f, 0.03f, 0.15f, 0.06f, 0.07f, 0.06f, 0.07f, 0.11f, 0.06f, 0.09f};

    public MacFirewallRulePanel(GroupPolicyObject groupPolicyObject, String locationName) {
        this(groupPolicyObject, locationName, false);
    }

    public MacFirewallRulePanel(GroupPolicyObject groupPolicyObject, String locationName, boolean isViewMode) {
        super(groupPolicyObject, locationName, enterpriseColSizes, isViewMode);
    }

    @Override
    protected int getOperatingSystemPlatform() {
        return 2;
    }

    @Override
    public FirewallRuleSystem getFirewallRuleSystem() {
        return this.getFirewallRuleSystem(this.firewallPolicy);
    }

    @Override
    public FirewallRuleSystem getFirewallRuleSystem(FwFirewallPolicy firewallPolicy) {
        if (firewallPolicy.getOptMacFwFirewallPolicy() == null) {
            return null;
        }
        return firewallPolicy.getOptMacFwFirewallPolicy().getOptFirewallRuleSystem();
    }

    @Override
    protected void setFirewallRuleSystem(FwFirewallPolicy fwFirewallPolicy, FirewallRuleSystem fwRuleSystem) {
        FirewallPolicyHandler.getMacFwFirewallPolicy(fwFirewallPolicy).setOptFirewallRuleSystem(fwRuleSystem);
    }

    @Override
    protected void setSecurtySetting(FwFirewallPolicy fwFirewallPolicy) {
        fwFirewallPolicy.setSecuritySetting(this.firewallPolicy.getSecuritySetting());
        SecuritySetting securitySetting = FirewallPolicyHandler.getMacFwFirewallPolicy(this.firewallPolicy).getSecuritySetting();
        FirewallPolicyHandler.getMacFwFirewallPolicy(fwFirewallPolicy).setSecuritySetting(securitySetting);
    }

    public static MacFwFirewallPolicy getMacFwFirewallPolicy(FwFirewallPolicy fwFirewallPolicy) {
        MacFwFirewallPolicy macFwFirewallPolicy = fwFirewallPolicy.getOptMacFwFirewallPolicy();
        if (macFwFirewallPolicy == null) {
            macFwFirewallPolicy = new MacFwFirewallPolicy();
            fwFirewallPolicy.setOptMacFwFirewallPolicy(macFwFirewallPolicy);
        }
        return macFwFirewallPolicy;
    }

    @Override
    protected String getAllRuleRemoveConfirmMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.AllRuleRemoveConfirmMac");
    }

    @Override
    protected String getPastePlatformErrorMessage() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.firewall.firewall", "FirewallRulePanel.PasteMacRuleError");
    }
}

