/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall;

import com.sygate.scm.common.configobject.schema.FwActiveResponse;
import com.sygate.scm.common.configobject.schema.FwAntiMacSpoofing;
import com.sygate.scm.common.configobject.schema.FwDosProtection;
import com.sygate.scm.common.configobject.schema.FwPortScan;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.console.ui.policy.firewall.AdvancedSettingPanel;
import com.sygate.scm.console.ui.util.VerticalFlowLayout;
import com.sygate.scm.util.StringUtilities;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class MacAdvancedSettingPanel
extends AdvancedSettingPanel {
    private static final long serialVersionUID = 1L;

    @Override
    protected void initialize() {
        UIFontUtilities.setBoldFont((JComponent)this.jcbxPortScan);
        UIFontUtilities.setBoldFont((JComponent)this.jcbxDenOfServ);
        UIFontUtilities.setBoldFont((JComponent)this.jcbxAntiMac);
        UIFontUtilities.setBoldFont((JComponent)this.jcbxAutoBlock);
        this.setLayout(new VerticalFlowLayout(0, 0));
        this.setBorder(BorderFactory.createEmptyBorder(5, 25, 5, 0));
        this.add(this.getTrafficSettingPanel());
    }

    @Override
    protected void setValues() {
        FwPortScan fwPortScan = this.securitySetting.getOptFwPortScan();
        boolean portScan = false;
        if (fwPortScan != null) {
            portScan = !Boolean.FALSE.equals(fwPortScan.getOptEnable());
        }
        this.jcbxPortScan.setSelected(portScan);
        FwDosProtection fwDosProtection = this.securitySetting.getOptFwDosProtection();
        boolean denialOfServices = false;
        if (fwDosProtection != null) {
            denialOfServices = !Boolean.FALSE.equals(fwDosProtection.getOptEnable());
        }
        this.jcbxDenOfServ.setSelected(denialOfServices);
        FwAntiMacSpoofing fwAntiMacSpoofing = this.securitySetting.getOptFwAntiMacSpoofing();
        boolean allowAntiMac = false;
        if (fwAntiMacSpoofing != null) {
            allowAntiMac = fwAntiMacSpoofing.getOptEnable();
        }
        this.jcbxAntiMac.setSelected(allowAntiMac);
        FwActiveResponse fwActiveResponse = this.securitySetting.getOptFwActiveResponse();
        if (fwActiveResponse == null) {
            fwActiveResponse = new FwActiveResponse();
            fwActiveResponse.setOptEnable(fwActiveResponse.getDefEnable());
            fwActiveResponse.setOptDefaultAbusePeriod(fwActiveResponse.getDefDefaultAbusePeriod());
            this.securitySetting.setOptFwActiveResponse(fwActiveResponse);
        }
        boolean allowAutoBlock = fwActiveResponse.getOptEnable();
        this.jcbxAutoBlock.setSelected(allowAutoBlock);
        Long blockTime = Math.abs(fwActiveResponse.getOptDefaultAbusePeriod() == null ? fwActiveResponse.getDefDefaultAbusePeriod() : fwActiveResponse.getOptDefaultAbusePeriod());
        if (blockTime == 0L || blockTime > 0xFFFFFFFFL) {
            System.out.print("\nFirewall has block time period set as:" + blockTime.toString() + " seconds, ");
            blockTime = blockTime == 0L ? 1L : 0xFFFFFFFFL;
            System.out.println(" floored to: " + blockTime.toString() + " seconds.");
        }
        this.jTFBlockTime.setText(blockTime.toString());
        this.autoBlockChanged();
    }

    @Override
    public void updateSecuritySettings() {
        this.updatePortScanSetting();
        this.updateDenOfSerSetting();
        this.updateAntiMacSpoofingSetting();
        this.updateActiveResponseSetting();
    }

    private void updatePortScanSetting() {
        FwPortScan fwPortScan = this.securitySetting.getOptFwPortScan();
        if (fwPortScan == null) {
            fwPortScan = new FwPortScan();
            this.securitySetting.setOptFwPortScan(fwPortScan);
        }
        fwPortScan.setOptEnable(Boolean.valueOf(this.jcbxPortScan.isSelected()));
    }

    private void updateDenOfSerSetting() {
        FwDosProtection fwDosProtection = this.securitySetting.getOptFwDosProtection();
        if (fwDosProtection == null) {
            fwDosProtection = new FwDosProtection();
            this.securitySetting.setOptFwDosProtection(fwDosProtection);
        }
        fwDosProtection.setOptEnable(Boolean.valueOf(this.jcbxDenOfServ.isSelected()));
    }

    private void updateAntiMacSpoofingSetting() {
        FwAntiMacSpoofing macSpoofing = this.securitySetting.getOptFwAntiMacSpoofing();
        if (macSpoofing == null) {
            macSpoofing = new FwAntiMacSpoofing();
            this.securitySetting.setOptFwAntiMacSpoofing(macSpoofing);
        }
        macSpoofing.setOptEnable(Boolean.valueOf(this.jcbxAntiMac.isSelected()));
    }

    private void updateActiveResponseSetting() {
        FwActiveResponse fwActiveResponse = this.securitySetting.getOptFwActiveResponse();
        if (fwActiveResponse == null) {
            fwActiveResponse = new FwActiveResponse();
            this.securitySetting.setOptFwActiveResponse(fwActiveResponse);
        }
        if (this.jcbxAutoBlock.isSelected()) {
            fwActiveResponse.setOptEnable(Boolean.TRUE);
        } else {
            fwActiveResponse.setOptEnable(Boolean.FALSE);
        }
        String seconds = this.jTFBlockTime.getText();
        if (!StringUtilities.isEmpty((String)seconds)) {
            fwActiveResponse.setOptDefaultAbusePeriod(Long.valueOf(seconds));
        } else {
            fwActiveResponse.setOptDefaultAbusePeriod(fwActiveResponse.getDefDefaultAbusePeriod());
        }
    }

    @Override
    public void setReadOnly() {
        this.jcbxDenOfServ.setEnabled(false);
        this.jcbxPortScan.setEnabled(false);
        this.jcbxAntiMac.setEnabled(false);
        this.jcbxAutoBlock.setEnabled(false);
        this.jTFBlockTime.setEnabled(false);
    }
}

