/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.policy.firewall.Handler;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.BaselineFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.DestinationHostTrigger;
import com.sygate.scm.common.configobject.schema.EnforcedFirewallRuleArray;
import com.sygate.scm.common.configobject.schema.Executable;
import com.sygate.scm.common.configobject.schema.FirewallRule;
import com.sygate.scm.common.configobject.schema.FirewallRuleSystem;
import com.sygate.scm.common.configobject.schema.FwApplicationTrigger;
import com.sygate.scm.common.configobject.schema.FwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.FwHostContainer;
import com.sygate.scm.common.configobject.schema.FwHostTrigger;
import com.sygate.scm.common.configobject.schema.FwNetworkHostGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceGroup;
import com.sygate.scm.common.configobject.schema.FwNetworkInterfaceTrigger;
import com.sygate.scm.common.configobject.schema.FwNetworkServiceGroup;
import com.sygate.scm.common.configobject.schema.FwProtocolContainer;
import com.sygate.scm.common.configobject.schema.FwServiceTrigger;
import com.sygate.scm.common.configobject.schema.FwTimeTrigger;
import com.sygate.scm.common.configobject.schema.Guid;
import com.sygate.scm.common.configobject.schema.IgnoredParentFirewallRuleIdArray;
import com.sygate.scm.common.configobject.schema.LocalHostTrigger;
import com.sygate.scm.common.configobject.schema.MacFwFirewallPolicy;
import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.RemoteHostTrigger;
import com.sygate.scm.common.configobject.schema.SoApplicationContainer;
import com.sygate.scm.common.configobject.schema.SoTime;
import com.sygate.scm.common.configobject.schema.SoTimeContainer;
import com.sygate.scm.common.configobject.schema.SourceHostTrigger;
import com.sygate.scm.console.handler.AbstractHandler;
import com.sygate.scm.console.handler.PolicyHandler;
import com.sygate.scm.console.logicobject.AppliedPolicyObject;
import com.sygate.scm.console.logicobject.FirewallPolicyObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.logicobject.GroupPolicyObject;
import com.sygate.scm.console.logicobject.LocationObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ApplicationObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.FirewallRuleObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostContainerObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostEnableObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.HostObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.NetworkInterfaceGroupObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ProtocolContainerObject;
import com.sygate.scm.console.ui.policy.firewall.logicobject.ScheduleObject;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class FirewallPolicyHandler
extends AbstractHandler {
    public static List<List<FirewallRuleObject>> getInheritedRules(GroupObject curGrpObj, String locName, int osType) throws ConsoleException {
        ArrayList<List<FirewallRuleObject>> returnValue = new ArrayList<List<FirewallRuleObject>>(2);
        returnValue.add(0, new ArrayList());
        returnValue.add(1, new ArrayList());
        if (curGrpObj == null || locName == null) {
            return returnValue;
        }
        GroupObject parent = FirewallPolicyHandler.getNextValidParent(curGrpObj);
        if (parent == null) {
            return returnValue;
        }
        GroupPolicyObject groupPolicy = PolicyHandler.getGroupPolicyByGroup(parent);
        List<LocationObject> locations = groupPolicy.getLocations();
        for (LocationObject locObj : locations) {
            Boolean hasParent;
            BaselineFirewallRuleArray baseline;
            FwFirewallPolicy fw;
            FirewallRuleSystem fwSystem;
            FirewallPolicyObject fwObj;
            if (!locObj.getName().equals(locName)) continue;
            AppliedPolicyObject applied = locObj.getAppliedPolicyObject();
            ObjReference appliedFw = applied.getAppliedReferenceOfPolicy(fwObj = new FirewallPolicyObject());
            if (appliedFw == null || (fwSystem = FirewallPolicyHandler.getFirewallRuleSystem(fw = (FwFirewallPolicy)PolicyHandler.getObject(appliedFw.getTargetType(), appliedFw.getTargetId()), osType)) == null) break;
            EnforcedFirewallRuleArray enforce = fwSystem.getOptEnforcedFirewallRuleArray();
            Vector allRule = null;
            if (enforce != null) {
                allRule = enforce.getFirewallRule();
                FirewallPolicyHandler.getEnabledRules(allRule, (List)returnValue.get(0), true, parent.getName());
            }
            if ((baseline = fwSystem.getOptBaselineFirewallRuleArray()) != null) {
                allRule = baseline.getFirewallRule();
                FirewallPolicyHandler.getEnabledRules(allRule, (List)returnValue.get(1), false, parent.getName());
            }
            if ((hasParent = fwSystem.getOptMergeLocalAndParentRules()) != null && !hasParent.booleanValue()) break;
            List<List<FirewallRuleObject>> parentRules = FirewallPolicyHandler.getInheritedRules(parent, locName, osType);
            IgnoredParentFirewallRuleIdArray ignoreArray = fwSystem.getOptIgnoredParentFirewallRuleIdArray();
            if (ignoreArray != null) {
                Map<String, Guid> ignoreList = FirewallPolicyHandler.getIgnoreList(ignoreArray);
                FirewallPolicyHandler.takeOutIgnoreRule(parentRules.get(0), ignoreList);
                FirewallPolicyHandler.takeOutIgnoreRule(parentRules.get(1), ignoreList);
            }
            FirewallPolicyHandler.getEnabledRules(parentRules.get(0), (List)returnValue.get(0), true);
            FirewallPolicyHandler.getEnabledRules(parentRules.get(1), (List)returnValue.get(1), false);
            break;
        }
        return returnValue;
    }

    private static FirewallRuleSystem getFirewallRuleSystem(FwFirewallPolicy firewallPolicy, int osPlatform) {
        FirewallRuleSystem fwRuleSystem = null;
        if (osPlatform == 2) {
            if (firewallPolicy.getOptMacFwFirewallPolicy() != null) {
                fwRuleSystem = FirewallPolicyHandler.getMacFwFirewallPolicy(firewallPolicy, false).getOptFirewallRuleSystem();
            }
        } else {
            fwRuleSystem = firewallPolicy.getOptFirewallRuleSystem();
        }
        return fwRuleSystem;
    }

    public static MacFwFirewallPolicy getMacFwFirewallPolicy(FwFirewallPolicy fwFirewallPolicy) {
        return FirewallPolicyHandler.getMacFwFirewallPolicy(fwFirewallPolicy, true);
    }

    public static MacFwFirewallPolicy getMacFwFirewallPolicy(FwFirewallPolicy fwFirewallPolicy, boolean createNew) {
        MacFwFirewallPolicy macFwFirewallPolicy = fwFirewallPolicy.getOptMacFwFirewallPolicy();
        if (macFwFirewallPolicy == null && createNew) {
            macFwFirewallPolicy = new MacFwFirewallPolicy();
            fwFirewallPolicy.setOptMacFwFirewallPolicy(macFwFirewallPolicy);
        }
        return macFwFirewallPolicy;
    }

    private static GroupObject getNextValidParent(GroupObject thisGrp) throws ConsoleException {
        GroupPolicyObject gpObj = PolicyHandler.getGroupPolicyByGroup(thisGrp);
        GroupObject nextParent = thisGrp.getParentGroup();
        if (gpObj.isInherit()) {
            return FirewallPolicyHandler.getNextValidParent(nextParent);
        }
        return nextParent;
    }

    private static void takeOutIgnoreRule(List<FirewallRuleObject> list, Map<String, Guid> ignoreList) {
        Iterator<FirewallRuleObject> it = list.iterator();
        while (it.hasNext()) {
            FirewallRuleObject fRuleObj = it.next();
            FirewallRule fRule = fRuleObj.getFirewallRule();
            if (ignoreList.get(fRule.getId()) == null) continue;
            it.remove();
        }
    }

    private static Map<String, Guid> getIgnoreList(IgnoredParentFirewallRuleIdArray ignoreArray) {
        HashMap<String, Guid> list = new HashMap<String, Guid>();
        Vector guidArray = ignoreArray.getGuid();
        for (Guid id : guidArray) {
            list.put(id.getContent(), id);
        }
        return list;
    }

    private static void getEnabledRules(List<FirewallRule> from, List<FirewallRuleObject> to, boolean front, String grpName) {
        ArrayList<FirewallRuleObject> temp = new ArrayList<FirewallRuleObject>();
        for (FirewallRule fwRule : from) {
            Boolean enable = fwRule.getOptEnable();
            if (enable != null && !enable.booleanValue()) continue;
            FirewallRuleObject fwObj = new FirewallRuleObject(fwRule, grpName);
            temp.add(fwObj);
        }
        if (front) {
            to.addAll(0, temp);
        } else {
            to.addAll(temp);
        }
    }

    private static void getEnabledRules(List<FirewallRuleObject> from, List<FirewallRuleObject> to, boolean front) {
        ArrayList<FirewallRuleObject> temp = new ArrayList<FirewallRuleObject>();
        for (FirewallRuleObject fwRuleObj : from) {
            Boolean enable = fwRuleObj.getFirewallRule().getOptEnable();
            if (enable != null && !enable.booleanValue()) continue;
            temp.add(fwRuleObj);
        }
        if (front) {
            to.addAll(0, temp);
        } else {
            to.addAll(temp);
        }
    }

    public static ArrayList<ProtocolContainerObject> getProtocolContainerObjects(FwServiceTrigger serviceTrigger) throws ConsoleException {
        return FirewallPolicyHandler.getProtocolContainerObjects(serviceTrigger, true);
    }

    public static ArrayList<ProtocolContainerObject> getProtocolContainerObjects(FwServiceTrigger serviceTrigger, boolean filterDisabled) throws ConsoleException {
        ArrayList<ProtocolContainerObject> protocolContainerObjects = new ArrayList<ProtocolContainerObject>();
        if (serviceTrigger != null) {
            Vector objReferences;
            int count;
            Vector protocolContainers = serviceTrigger.getFwProtocolContainer();
            if (protocolContainers != null) {
                for (FwProtocolContainer protocolContainer : protocolContainers) {
                    ProtocolContainerObject containerObject = new ProtocolContainerObject(protocolContainer);
                    if (filterDisabled && !containerObject.getSelected()) continue;
                    protocolContainerObjects.add(containerObject);
                }
            }
            if ((count = (objReferences = serviceTrigger.getObjReference()).size()) > 0) {
                ArrayList<String> idList = new ArrayList<String>(count);
                for (int i = 0; i < count; ++i) {
                    ObjReference objReference = (ObjReference)objReferences.get(i);
                    idList.add(objReference.getTargetId());
                }
                List<TopLevelObject> retList = DataobjectManager.getInstance().getMutipleObjectById(idList, true);
                for (TopLevelObject obj : retList) {
                    FwNetworkServiceGroup serviceGroup;
                    FwProtocolContainer protocolContainer;
                    if (obj == null || (protocolContainer = (serviceGroup = (FwNetworkServiceGroup)obj).getFwProtocolContainer()) == null) continue;
                    protocolContainer.setOptContainerName(serviceGroup.getOptDisplayName() == null ? serviceGroup.getName() : serviceGroup.getOptDisplayName());
                    ProtocolContainerObject containerObject = new ProtocolContainerObject(protocolContainer, serviceGroup);
                    containerObject.setReadOnly(true);
                    protocolContainerObjects.add(containerObject);
                }
            }
        }
        return protocolContainerObjects;
    }

    public static ArrayList<NetworkInterfaceGroupObject> getInterfaceObjects(FwNetworkInterfaceTrigger interfaceTrigger) throws ConsoleException {
        ArrayList<NetworkInterfaceGroupObject> interfaceObjects = new ArrayList<NetworkInterfaceGroupObject>();
        if (interfaceTrigger != null) {
            Vector groupReferences = interfaceTrigger.getObjReference();
            for (int i = 0; i < groupReferences.size(); ++i) {
                ObjReference ref = (ObjReference)groupReferences.get(i);
                String targetId = ref.getTargetId();
                String targetType = ref.getTargetType();
                TopLevelObject group = DataobjectManager.getInstance().getObjectByGUID(targetType, targetId);
                NetworkInterfaceGroupObject groupObject = new NetworkInterfaceGroupObject((FwNetworkInterfaceGroup)group);
                interfaceObjects.add(groupObject);
            }
        }
        return interfaceObjects;
    }

    public static ArrayList<ApplicationObject> getApplicaitonObjects(FwApplicationTrigger applicationTrigger) {
        Vector apps;
        SoApplicationContainer appContainer;
        ArrayList<ApplicationObject> applicationObjects = new ArrayList<ApplicationObject>();
        if (applicationTrigger != null && (appContainer = applicationTrigger.getSoApplicationContainer()) != null && (apps = appContainer.getExecutable()) != null) {
            for (int i = 0; i < apps.size(); ++i) {
                Executable exec = (Executable)apps.get(i);
                applicationObjects.add(new ApplicationObject(exec));
            }
        }
        return applicationObjects;
    }

    public static ArrayList<ScheduleObject> getScheduleObjects(FwTimeTrigger timeTrigger) {
        Vector soTimes;
        SoTimeContainer timeContainer;
        ArrayList<ScheduleObject> scheduleObjects = new ArrayList<ScheduleObject>();
        if (timeTrigger != null && (timeContainer = timeTrigger.getSoTimeContainer()) != null && (soTimes = timeContainer.getSoTime()) != null) {
            for (int j = 0; j < soTimes.size(); ++j) {
                SoTime time = (SoTime)soTimes.get(j);
                ScheduleObject scheduleObject = new ScheduleObject(time);
                scheduleObjects.add(scheduleObject);
            }
        }
        return scheduleObjects;
    }

    public static ArrayList<HostContainerObject> getHostContainerObjects(FwHostTrigger hostTrigger) {
        ArrayList<HostContainerObject> hostContainerObjects = new ArrayList<HostContainerObject>();
        if (hostTrigger != null) {
            RemoteHostTrigger remoteTrigger;
            LocalHostTrigger localTrigger;
            SourceHostTrigger sourceTrigger;
            System.out.println("Creating Host Container Objects");
            hostContainerObjects = new ArrayList();
            DestinationHostTrigger destTrigger = hostTrigger.getOptDestinationHostTrigger();
            if (destTrigger != null) {
                int iDest = destTrigger.getFwHostContainerCount();
                for (int i = 0; i < iDest; ++i) {
                    hostContainerObjects.add(new HostContainerObject(destTrigger.getFwHostContainer(i), 1));
                }
            }
            if ((sourceTrigger = hostTrigger.getOptSourceHostTrigger()) != null) {
                int iSource = sourceTrigger.getFwHostContainerCount();
                for (int i = 0; i < iSource; ++i) {
                    hostContainerObjects.add(new HostContainerObject(sourceTrigger.getFwHostContainer(i), 0));
                }
            }
            if ((localTrigger = hostTrigger.getOptLocalHostTrigger()) != null) {
                int iLocal = localTrigger.getFwHostContainerCount();
                for (int i = 0; i < iLocal; ++i) {
                    hostContainerObjects.add(new HostContainerObject(localTrigger.getFwHostContainer(i), 2));
                }
            }
            if ((remoteTrigger = hostTrigger.getOptRemoteHostTrigger()) != null) {
                int iRemote = remoteTrigger.getFwHostContainerCount();
                for (int i = 0; i < iRemote; ++i) {
                    hostContainerObjects.add(new HostContainerObject(remoteTrigger.getFwHostContainer(i), 3));
                }
            }
        }
        return hostContainerObjects;
    }

    public static ArrayList<HostObject> getHostObjects(FwHostTrigger hostTrigger) {
        if (hostTrigger == null) {
            return null;
        }
        ArrayList<HostObject> hostObjects = new ArrayList<HostObject>();
        System.out.println("Creating Host Objects");
        Vector anyContainer = new Vector();
        LocalHostTrigger lTrigger = hostTrigger.getOptLocalHostTrigger();
        FwHostContainer container = null;
        ObjReference objRef = null;
        if (lTrigger != null) {
            anyContainer = lTrigger.getChildren();
        }
        for (AbstractSchema obj : anyContainer) {
            if (obj instanceof FwHostContainer) {
                container = (FwHostContainer)obj;
                objRef = null;
            } else {
                objRef = (ObjReference)obj;
                container = null;
            }
            if (container != null && container.getChildren() != null) {
                ArrayList<HostObject> listOfHostObj = FirewallPolicyHandler.createHostObjects(container, 2);
                hostObjects.addAll(listOfHostObj);
            }
            if (objRef == null) continue;
            hostObjects.add(FirewallPolicyHandler.createHostObjects(objRef, 2));
        }
        anyContainer.clear();
        RemoteHostTrigger rTrigger = hostTrigger.getOptRemoteHostTrigger();
        if (rTrigger != null) {
            anyContainer = rTrigger.getChildren();
        }
        for (int i = 0; i < anyContainer.size(); ++i) {
            Object obj = anyContainer.get(i);
            if (obj instanceof FwHostContainer) {
                container = (FwHostContainer)obj;
                objRef = null;
            } else {
                objRef = (ObjReference)obj;
                container = null;
            }
            if (container != null && container.getChildren() != null && container.getChildren() != null) {
                ArrayList<HostObject> listOgHostObj = FirewallPolicyHandler.createHostObjects(container, 3);
                hostObjects.addAll(listOgHostObj);
            }
            if (objRef == null) continue;
            hostObjects.add(FirewallPolicyHandler.createHostObjects(objRef, 3));
        }
        anyContainer.clear();
        SourceHostTrigger sTrigger = hostTrigger.getOptSourceHostTrigger();
        if (sTrigger != null) {
            anyContainer = sTrigger.getChildren();
        }
        for (int i = 0; i < anyContainer.size(); ++i) {
            Object obj = anyContainer.get(i);
            if (obj instanceof FwHostContainer) {
                container = (FwHostContainer)obj;
                objRef = null;
            } else {
                objRef = (ObjReference)obj;
                container = null;
            }
            if (container != null && container.getChildren() != null && container.getChildren() != null) {
                ArrayList<HostObject> listOgHostObj = FirewallPolicyHandler.createHostObjects(container, 0);
                hostObjects.addAll(listOgHostObj);
            }
            if (objRef == null) continue;
            hostObjects.add(FirewallPolicyHandler.createHostObjects(objRef, 0));
        }
        anyContainer.clear();
        DestinationHostTrigger dTrigger = hostTrigger.getOptDestinationHostTrigger();
        if (dTrigger != null) {
            anyContainer = dTrigger.getChildren();
        }
        for (int i = 0; i < anyContainer.size(); ++i) {
            Object obj = anyContainer.get(i);
            if (obj instanceof FwHostContainer) {
                container = (FwHostContainer)obj;
                objRef = null;
            } else {
                objRef = (ObjReference)obj;
                container = null;
            }
            if (container != null && container.getChildren() != null && container.getChildren() != null) {
                ArrayList<HostObject> listOgHostObj = FirewallPolicyHandler.createHostObjects(container, 1);
                hostObjects.addAll(listOgHostObj);
            }
            if (objRef == null) continue;
            hostObjects.add(FirewallPolicyHandler.createHostObjects(objRef, 1));
        }
        return hostObjects;
    }

    private static ArrayList<HostObject> createHostObjects(FwHostContainer container, int direction) {
        int i;
        boolean enable = false;
        if (container.getOptEnable() != null) {
            enable = container.getOptEnable();
        }
        HostObject obj = null;
        ArrayList<HostObject> objList = new ArrayList<HostObject>();
        if (container.getMacAddress() != null && container.getMacAddress().size() > 0) {
            for (i = 0; i < container.getMacAddress().size(); ++i) {
                obj = new HostObject(enable, container.getMacAddress().get(i), HostObject.getTypeByIndex(0), HostEnableObject.getDirectionDesc(direction));
                objList.add(obj);
            }
        }
        if (container.getIpAddress() != null && container.getIpAddress().size() > 0) {
            for (i = 0; i < container.getIpAddress().size(); ++i) {
                obj = new HostObject(enable, container.getIpAddress().get(i), HostObject.getTypeByIndex(1), HostEnableObject.getDirectionDesc(direction));
                objList.add(obj);
            }
        }
        if (container.getIpRange() != null && container.getIpRange().size() > 0) {
            for (i = 0; i < container.getIpRange().size(); ++i) {
                obj = new HostObject(enable, container.getIpRange().get(i), HostObject.getTypeByIndex(2), HostEnableObject.getDirectionDesc(direction));
                objList.add(obj);
            }
        }
        if (container.getSubNet() != null && container.getSubNet().size() > 0) {
            for (i = 0; i < container.getSubNet().size(); ++i) {
                obj = new HostObject(enable, container.getSubNet().get(i), HostObject.getTypeByIndex(3), HostEnableObject.getDirectionDesc(direction));
                objList.add(obj);
            }
        }
        if (container.getDnsHost() != null && container.getDnsHost().size() > 0) {
            for (i = 0; i < container.getDnsHost().size(); ++i) {
                obj = new HostObject(enable, container.getDnsHost().get(i), HostObject.getTypeByIndex(4), HostEnableObject.getDirectionDesc(direction));
                objList.add(obj);
            }
        }
        if (container.getDnsDomain() != null && container.getDnsDomain().size() > 0) {
            for (i = 0; i < container.getDnsDomain().size(); ++i) {
                obj = new HostObject(enable, container.getDnsDomain().get(i), HostObject.getTypeByIndex(5), HostEnableObject.getDirectionDesc(direction));
                objList.add(obj);
            }
        }
        if (container.getOptLocalSubnet() != null) {
            obj = new HostObject(enable, container.getOptLocalSubnet(), HostObject.getTypeByIndex(7), HostEnableObject.getDirectionDesc(direction));
            objList.add(obj);
        }
        if (container.getIpv6Address() != null && container.getIpv6Address().size() > 0) {
            for (i = 0; i < container.getIpv6Address().size(); ++i) {
                obj = new HostObject(enable, container.getIpv6Address().get(i), HostObject.getTypeByIndex(8), HostEnableObject.getDirectionDesc(direction));
                objList.add(obj);
            }
        }
        if (container.getIpv6Range() != null && container.getIpv6Range().size() > 0) {
            for (i = 0; i < container.getIpv6Range().size(); ++i) {
                obj = new HostObject(enable, container.getIpv6Range().get(i), HostObject.getTypeByIndex(9), HostEnableObject.getDirectionDesc(direction));
                objList.add(obj);
            }
        }
        if (container.getIpv6SubNet() != null && container.getIpv6SubNet().size() > 0) {
            for (i = 0; i < container.getIpv6SubNet().size(); ++i) {
                obj = new HostObject(enable, container.getIpv6SubNet().get(i), HostObject.getTypeByIndex(10), HostEnableObject.getDirectionDesc(direction));
                objList.add(obj);
            }
        }
        return objList;
    }

    private static HostObject createHostObjects(ObjReference objRef, int direction) {
        HostObject obj = null;
        obj = new HostObject(true, " ", HostObject.getTypeByIndex(6), HostEnableObject.getDirectionDesc(direction));
        try {
            FwNetworkHostGroup group = (FwNetworkHostGroup)PolicyHandler.getObject(objRef.getTargetType(), objRef.getTargetId());
            obj.setName(group.getName());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return obj;
    }
}

